/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Code stub for static loading
||@(#)   System : SLOADER
||@(#) Filename : static.c
||@(#)  Version : 2.6
\*@(#)====================================================*/
/*}}}*/

/*{{{  includes*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include <channel.h>
#include <host.h>

#include "net.h"
#include "topology.h"
/*}}}*/

#ifdef UPR_RD
  /*{{{  reduced node*/
  #define offset 0
  PUBLIC NETWORK *network=NULL ;
  /*}}}*/
#else
  /*{{{  full node*/
  #define offset 2
  
  PUBLIC char switch_char ;
  PUBLIC char slash_char ;
  
  #include "static.h"
  
  PRIVATE NETWORK network_info ;
  PUBLIC NETWORK *network=&network_info ;
  
  PUBLIC char text_tpg [first_tpg+num_tpg][8] = { "unknown","grid","hpr" } ;
  
  /*{{{  PRIVATE show_network (NETWORK *network)*/
  PRIVATE show_network (NETWORK *network)
  {
    int i ;
  
    printf("Topology name is %s\n",network->name) ;
    printf("NCF file name is %s\n",network->ncf) ;
  
    printf("Topology type is %s\n",text_tpg[network->topology.tpg]) ;
  
    switch(network->topology.tpg)
    {
      case grid_tpg :
        printf("grid has %d dimensions, first id is %d\n",
               network->topology.grid.ndims, network->topology.grid.first) ;
        for (i=0;i<network->topology.grid.ndims;i++)
          printf("%d (%s), ", network->topology.grid.dims[i],
            network->topology.grid.wraps[i] ? "wrapped" : "open") ;
        printf("\n") ;
        break ;
      case hpr_tpg :
        printf("hpr has first id of %d\n", network->topology.hpr.first) ;
    }
    
    for (i=0;i<network->num_edges;i++)
      printf("Processor %d to processor %d\n",network->edge[i][0],network->edge[i][1]) ;
  
    for (i=0;i<network->num_vertices;i++)
    {
      int proc = network->vertex[i].son ;
  
      printf("Processor %d ", i) ;
      
      if (proc != NOT_PROC)
      {
        printf("boots up ") ;
  
        do
        {
          printf("%d ", proc) ;
          proc = network->vertex[proc].sibling ;
        } while (proc != NOT_PROC) ;
      }
      printf("\n") ;
    }
  }
  /*}}}*/
  /*{{{  PRIVATE void init_network_info(NETWORK *net)*/
  PRIVATE void init_network_info(NETWORK *net)
  {
    net->topology.tpg = NETWORK_TPG ;
  
    #if (NETWORK_TPG == grid_tpg)
    net->topology.grid.ndims = grid_ndims ;
    net->topology.grid.dims  = grid_dims ;
    net->topology.grid.wraps = grid_wraps ;
    net->topology.grid.first = grid_first ;
    #elif (NETWORK_TPG == hpr_tpg)
    net->topology.hpr.first = hpr_first ;
    #endif
  
    net->num_vertices = network_num_vertices ;
    net->vertex = network_vertex ;
    net->num_edges = network_num_edges ;
    net->edge = network_edge ;
  }
  /*}}}*/
  /*{{{  PRIVATE void get_switch_and_slash_chars()*/
  PRIVATE void get_switch_and_slash_chars()
  {
    int host, os, board;
  
    host_info(&host, &os, &board);
    switch(os)
      {
        case _IMS_OS_DOS:
        case _IMS_OS_VMS:
        case _IMS_OS_CMS:
          switch_char = '/';
          slash_char = '\\';
          break;
        case _IMS_OS_HELIOS:
        case _IMS_OS_SUNOS:
        default:
          switch_char = '-';
          slash_char = '/';
          break;
      }
  }
  
  /*}}}*/
  /*}}}*/
#endif

PUBLIC int  proc_memory ;

int main (int argc, char *argv[])
{
  int id, num_nodes ;
  Channel *lout[5] = {LINK0OUT, LINK1OUT, LINK2OUT, LINK3OUT, NULL} ;
  Channel *lin[5] = {LINK0IN,  LINK1IN,  LINK2IN,  LINK3IN,  NULL} ;
  Channel *cfs_lin;
  Channel *cfs_lout;
  LINK_TYPES *link_type ; 
  BYTE (*routing);
  int i;
  int params = 2 ;
  BOOL debug = FALSE ;

  /*{{{  decode parameters*/
  id        =  *((int *) get_param(1+offset)) ;
  num_nodes = *((int *) get_param(2+offset)) ;
  cfs_lin   = (Channel *) get_param(3+offset);    /* unused */
  cfs_lout  = (Channel *) get_param(4+offset);    /* unused */
  
  link_type = (LINK_TYPES *) get_param(5+offset);
  routing   =  (BYTE *) get_param(6+offset);
  
  proc_memory = *((int *) get_param(7+offset)) ;
  /*}}}*/

  #ifndef UPR_RD
  init_network_info(network) ;
  /*{{{  check for network loader options*/
  {
    int p;
    get_switch_and_slash_chars();
  
    for (p=params;p<argc;p++)
    {
      if (argv[p][0] == switch_char)
        if ((argv[p][1] == 'l') || (argv[p][1] == 'L'))
        {
          if ((argv[p][2] == 'd') || (argv[p][1] == 'D'))
          {
            int q;
            for (q=p;q>params;q--)
              argv[q] = argv[q-1];
            params++;
            debug = TRUE ;
          }
          else
          {
            fprintf(stderr,"Fatal-netloader-%s(%0d) Unknown command-line option to network loader\n",__FILE__,__LINE__) ;
            exit_terminate( EXIT_FAILURE );
          }          
        }
    }
    params-- ;
  }
  /*}}}*/
  /*{{{  get and publish topology and ncf name*/
  {
    char *str = strrchr (argv[1], slash_char) ;
    char *end ;
    int len ;
  
    if (str == NULL)
      str = argv[1] ;
    else
      str++ ;
  
    end = strchr (str, '.') ;
  
    if (end == NULL)
      len = strlen(str) ;
    else
      len = end-str ;
  
    if ((network->name=malloc(len+1)) == NULL)
    {
      fprintf(stderr,"Fatal-netloader-%s(%0d) Out of heap space - allocating topology name\n",__FILE__,__LINE__) ;
      exit_terminate( EXIT_FAILURE );
    }          
  
    strncpy (network->name, str, len) ;
    network->name[len] = 0 ;
  
    network->ncf = argv[1] ;
  }    
    
  /*}}}*/
  /*{{{  dump info if debugging*/
  if (debug)
  {
    printf("Processor : %d of %d\n",id,num_nodes);
    show_network(network) ;
    printf("ChanIns   : %08x %08x %08x %08x \n",(int) lin[0], (int) lin[1], (int) lin[2], (int) lin[3]);
    printf("ChanOuts  : %08x %08x %08x %08x \n",(int) lout[0], (int) lout[1], (int) lout[2], (int) lout[3]);
    printf("Link types: %8d %8d %8d %8d \n", (int) link_type[0], (int) link_type[1], (int) link_type[2], (int) link_type[3]);
    printf("Routing   : ");
    for (i=0;i<(2*num_nodes);i+=2)
      printf("{%d,%d} ",(int) routing[i+0], (int) routing[i+1]);
    printf("\n");
  }
  /*}}}*/
  #endif

  #ifdef UPR_KERNEL_AT_HI_PRI
  ProcToHI() ;
  #endif

  UPR_Kernel(argc-params,argv+params,id,num_nodes,lin,lout,link_type,routing );
}

