/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Control port functions
||@(#)   System : UPR
||@(#) Filename : uprctrl.c
||@(#)  Version : 2.3
\*@(#)====================================================*/
/*}}}*/

#include <stdlib.h>

#include "router.h"
#include "except.h"

static char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC void UPR_CtrlPreAction (PORT *port, int length)*/
PUBLIC void UPR_CtrlPreAction (PORT *port, int length)
{
  UPR_CTRL_PKT *ctrl_state = (UPR_CTRL_PKT *) port->state ;
  int i ;

  for (i=0;i<num_ctrl_pkts;i++)
    if (ctrl_state[i].tag == empty_ctrl) break ;

  if (i == num_ctrl_pkts)
    Exception(UPR_error, _FILE_, __LINE__, "Cannot service control packet - no state") ;

  ctrl_state[i].tag = ~empty_ctrl ;
  
  port->buffer = (BYTE *) &ctrl_state[i] ;
  port->space  = sizeof (UPR_CTRL_PKT) ;
}
/*}}}*/
/*{{{  PUBLIC void UPR_CtrlPostAction (PORT *port, int length, BYTE *buffer)*/
PUBLIC void UPR_CtrlPostAction (PORT *port, int length, BYTE *buffer)
{
  UPR_CTRL_PKT *ctrl_pkt = (UPR_CTRL_PKT *) buffer ;

  if (length == 0)
    Exception(UPR_error, _FILE_, __LINE__, "UPR control packet of zero length") ;
  
  switch (ctrl_pkt->tag)
  {
    case empty_ctrl :
      Exception(UPR_error, _FILE_, __LINE__, "Cannot service empty control packet") ;

    case error :
      QueueError  (&ctrl_pkt->p.error) ;
      break ;

    default :
    {
      Exception(UPR_error, _FILE_, __LINE__, "Unknown control packet type") ;
      break ;
    }
  }

  ctrl_pkt->tag = empty_ctrl ;
}
/*}}}*/
/*{{{  PUBLIC void UPR_CtrlPortAlloc ()*/
PUBLIC void UPR_CtrlPortAlloc ()
{
  PORT *ctrl_port ;
  UPR_CTRL_PKT *ctrl_state ;
  int i ;

  if ((ctrl_port = (PORT *) malloc (sizeof(PORT))) == NULL)
    Exception (UPR_fatal, _FILE_, __LINE__, "Out of heap space whilst allocating port") ;

  if ((ctrl_state = (UPR_CTRL_PKT *) malloc (sizeof(UPR_CTRL_PKT)*num_ctrl_pkts)) == NULL)
    Exception (UPR_fatal, _FILE_, __LINE__, "Out of heap space whilst allocating control handler state") ;

  for (i=0;i<num_ctrl_pkts;i++)
    ctrl_state[i].tag = empty_ctrl ;    

  if (PortGrab(ctrl_port) < 0)  
    Exception(UPR_fatal,_FILE_,__LINE__,"Cannot allocate UPR control port") ;

  PortInit (ctrl_port, UPR_CtrlPreAction, TRUE,
            UPR_CtrlPostAction, TRUE, (void *) ctrl_state) ;

  upr_globals.upr_ctrl_port_id = ctrl_port->id ;
}
/*}}}*/
  
