/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Transport Layer Selection Procedures
||@(#)   System : UPR and up
||@(#) Filename : transprt.c
||@(#)  Version : 1.1
||@(#)     Date : 4/2/92
\*@(#)====================================================*/
/*}}}*/

#include <string.h>

#include "router.h"

PRIVATE char *vcrswitch = "vcr";
EXTERN void InitVirtualChannelRouter(int proc_id, int num_nodes, int argc, char *argv[]);
EXTERN int VirtualChannelRouter(int argc, char *argv[]);

PRIVATE char *vpiswitch = "vpi";
EXTERN void InitVirtualProcessorInterface(int proc_id, int num_nodes, int argc, char *argv[]);
EXTERN int VirtualProcessorInterface(int argc, char *argv[]);

/*{{{  PUBLIC void InitTransportLayer (int proc_id, int num_nodes, int argc, char *argv[])*/
PUBLIC void InitTransportLayer (int proc_id, int num_nodes, int argc, char *argv[])
{
  #ifdef CALLOTHERS
  char *opt = &argv[1][1];

  if ((argc>1)&&(strcmp(opt,vpiswitch)==0))
  {
    InitVirtualChannelRouter(proc_id,num_nodes,argc-1,argv+1);
    InitVirtualProcessorInterface(proc_id,num_nodes,argc-1,argv+1);
  }
  else if ((argc>1)&&(strcmp(opt,vcrswitch)==0))
    InitVirtualChannelRouter(proc_id,num_nodes,argc-1,argv+1);
  else
    InitVirtualChannelRouter(proc_id,num_nodes,argc,argv) ;
  #else
  InitVirtualChannelRouter(proc_id,num_nodes,argc,argv) ;
  #endif
}

/*}}}*/
/*{{{  PUBLIC int TransportLayer (int argc, char *argv[])*/
PUBLIC int TransportLayer (int argc, char *argv[])
{
  #ifdef CALLOTHERS
  char *opt = &argv[1][1];

  if ((argc>1)&&(strcmp(opt,vpiswitch)==0))
    return(VirtualProcessorInterface(argc-1,argv+1));
  else if ((argc>1)&&(strcmp(opt,vcrswitch)==0))
    return(VirtualChannelRouter(argc-1,argv+1)) ;
  else
    return(VirtualChannelRouter(argc,argv)) ;
  #else
  return(VirtualChannelRouter(argc,argv)) ;
  #endif
}
/*}}}*/
  
