/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Show data structures functions
||@(#)   System : UPR
||@(#) Filename : show.c
||@(#)  Version : 2.1
\*@(#)====================================================*/
/*}}}*/


#include <stdio.h>
#include <stdlib.h>

#include "router.h"
#include "show.h"

/*{{{  PUBLIC void ViewProcess(Process *p)*/
PUBLIC void ViewProcess(Process *p)
{
  printf(" PROCESS at %x\n", (int) p) ;
  printf("  link    = %x\n", (int) p->link) ;
  printf("  wsret   = %x\n", p->wsret) ;
  printf("  wbase   = %x\n", (int) p->wbase) ;
  printf("  wp      = %x\n", (int) p->wp) ;
  printf("  psize   = %d\n", p->psize) ;
  printf("  func    = %x\n", (int) p->func) ;
  printf("------------------------------------\n") ;
}
/*}}}*/

/*{{{  PUBLIC void ViewHdr( HEADER *h )*/
PUBLIC void ViewHdr( HEADER *h )
{
  printf("[DPL: %3d %3d %3d]", HdrDestn(h), HdrPort(h), HdrLength(h) );
}
/*}}}*/

/*{{{  PUBLIC void ViewVlink( VLINK *vlink )*/
PUBLIC void ViewVlink( VLINK *vlink )
{
  printf("[%0d:%0d]", (*vlink)[ll], (*vlink)[vl]) ;
}

/*}}}*/
/*{{{  PUBLIC void ViewORB( ORB *orb )*/
PUBLIC void ViewORB( ORB *orb )
{
  printf("ORB address : %08x\n",(int) orb) ;
  printf("       link : %08x\n",(int) orb->list) ;
  printf("     source : "); ViewVlink(&(orb->src)) ; printf("\n") ; 
  printf("     buffer : %08x\n",(int) orb->bffr) ;
  printf("     header : "); ViewHdr(&(orb->header)); printf("\n");
  printf("      wdesc : %08x\n\n",(int) orb->wdesc) ;
}
/*}}}*/
/*{{{  PUBLIC void ViewOQB( OQB *oqb )*/
PUBLIC void ViewOQB( OQB *oqb )
{
  ORB *orb;
  int count;
  
  printf("OQB [addr head tail] : %08x %08x %08x \n",(int) oqb, (int) oqb->h, (int) oqb->t) ;
  
  if (oqb->h == NULL)
    if (oqb->t == NULL)
      printf("**** QUEUE EMPTY ****\n");
    else
      printf("** OQB Error : H is MINT/ T is not **");
  else
  {
    count= 0 ;
    orb = oqb->h ;
    while (orb != NULL)
    {
      printf("*** QUEUE ENTRY %1d ***\n",count) ;
      ViewORB(orb) ;
      count++ ;
      orb = orb->list ;
    }
    printf("***** QUEUE END *****\n");
  }
}
/*}}}*/
/*{{{  PUBLIC void ViewOLB( OLB *olb )*/
PUBLIC void ViewOLB( OLB *olb )
{
  int i ;
  
  printf("---------------------------------------\n");
  printf("OLB address : %08x\n", (int) olb);
  printf("  pkt limit : %1d\n",olb->pkt_limit);
  printf("  srv_limit : %1d\n",olb->srv_limit);
  printf("  no vlinks : %1d\n",olb->num_vlinks);
  printf("  ***** lack_OQB *****\n");
  ViewOQB(&(olb->lack_OQB)); 
  printf("  *** lack_OQB end ***\n");
  printf("     active : %s\n",ViewBool(olb->active));
  printf("       used : %s\n",ViewBool(olb->used));
  printf("      wdesc : %08x\n", (int) olb->wdesc);
  for (i=0;i<(olb->num_vlinks);i++)
  {
    printf("  ****** VOLB %d ******\n", i);
    printf("  pkt count : %1d\n",(olb->volb)[i].pkt_count);
    ViewOQB(&((olb->volb)[i].oqb));
    printf("  **** VOLB %d end ****\n", i);
  }
  printf("---------------------------------------\n");
}  
/*}}}*/
/*{{{  PUBLIC void ViewILB( ILB *ilb )*/
PUBLIC void ViewILB( ILB *ilb )
{
  int i ;
  
  printf("---------------------------------------\n");
  printf("ILB address : %08x\n", (int) ilb);
  printf("  pkt limit : %1d\n",ilb->pkt_limit);
  printf("  srv_limit : %1d\n",ilb->srv_limit);
  printf("  no vlinks : %1d\n",ilb->num_vlinks);
  printf("       used : %s\n",ViewBool(ilb->used));
  for (i=0;i<(ilb->num_vlinks);i++)
  {
    printf("  ****** VILB %d ******\n", i);
    printf("  pkt count : %1d\n",(ilb->vilb)[i].pkt_count);
    printf("  srv count : %1d\n",(ilb->vilb)[i].srv_count);
    ViewORB(&((ilb->vilb)[i].lack_ORB));
    printf("  **** VILB %d end ****\n", i);
  }
  printf("---------------------------------------\n");
}  
/*}}}*/
     
/*{{{  PUBLIC void ViewPort(PORT *port)*/
PUBLIC void ViewPort(PORT *port)
{
  printf("Port : address     is %x\n", (int) port) ;
  printf("     : id          is %d\n", port->id) ;
  printf("     : pre-action  at %x (%s)\n",(int) port->pre_action, ViewBool(port->do_pre)) ;
  printf("     : post-action at %x (%s)\n",(int) port->post_action, ViewBool(port->do_post)) ;
  printf("     : state       at %x\n",(int) port->state) ;
  printf("     : buffer      at %x\n", (int) port->buffer) ;
  printf("     : space       is %d bytes\n",port->space) ;
} 
/*}}}*/
