/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Router functions
||@(#)   System : UPR
||@(#) Filename : router.c
||@(#)  Version : 2.4
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "router.h"

static char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC void ProcMove(Process *p, int *from, int *to, int size)*/
PUBLIC void ProcMove(Process *p, int *from, int *to, int size)
{
  int offset = from - to ;
    
  AsmMove (from, to, size*sizeof(int)) ;

  p->wbase -= offset ;
  p->wp    -= offset ;
}  
/*}}}*/

/*{{{  PUBLIC int ProcGuardedAltList (Channel **clist, BOOL *guard)*/
PUBLIC int ProcGuardedAltList (Channel **clist, BOOL *guard)
{
  /*{{{  locals*/
  struct
  {
    int slot_zero_is_reserved ;
    int i ;
    int result ;
    int selected ;
  } local ;
  /*}}}*/

  if (clist[0] == NULL)
    local.result = -1 ;
  else
    {
      ProcAltStart() ;
      local.i=0 ;
      while (clist[local.i] != NULL)
      {
        ProcEnbChan (clist[local.i], guard[local.i]) ;
        (local.i)++ ;
      }

      ProcAltWait() ;

      local.i=0;
      while (clist[local.i] != NULL)
      {
        ProcDisChan (clist[local.i], guard[local.i], &local.selected) ;
        if (local.selected != 0) local.result = local.i ;
        (local.i)++ ;
      }
      ProcAltEnd() ;
    }
  return(local.result) ;
}  
/*}}}*/
/*{{{  COMMENT PUBLIC int ProcGuardedAltList (Channel **clist, BOOL *guard)*/
/* This version uses the Inmos routine ProcAltList with the array
   of channels repacked according to their guard booleans         */

/*   
PUBLIC int ProcGuardedAltList (Channel **clist, BOOL *guard)
{
  Channel *active[UPR_num_links+1] ;
  int     mapping[UPR_num_links] ;
  int     i=0, count=0, result ;

  if (clist[0] == NULL)
    result = -1 ;
  else
    {
      while (clist[i] != NULL)
      {
        if (guard[i])
        {
          active[count] = clist[i] ;
          mapping[count++] = i ;

          if (count > UPR_num_links)
            Exception(UPR_fatal, _FILE_, __LINE__, "ProcGuardedAltList is too wide") ;
        }
        i++ ;
      }
      active[count] = NULL ;

      result = mapping[ProcAltList (active)] ;
    }        
  return(result) ;
}  
*/
/*}}}*/

/*{{{  PUBLIC int UPR_ThroCount ()*/
PUBLIC int UPR_ThroCount ()
{
  UPR_GLOBALS *g = &upr_globals ;
  
  return(g->thro_count) ;
}  
/*}}}*/
/*{{{  PUBLIC BOOL UPR_AdjacentNode (int id)*/
PUBLIC BOOL UPR_AdjacentNode (int id)
{
  UPR_GLOBALS *g = &upr_globals ;
  LINK ll_out ;

  if ((id>=g->num_nodes) || (id==g->proc_id))
    Exception(UPR_error, _FILE_, __LINE__,"Invalid processor id") ;

  ll_out = g->out_link[id][ll] ;
  
  return(g->in_vlink[id][ll_out] == UPR_LACK) ;
}
/*}}}*/

