/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||
||@(#)    Title : Port functions
||@(#)   System :  UPR
||@(#) Filename : port.c
||@(#)  Version : 2.9
\*@(#)====================================================*/

/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "router.h"
#include "except.h"

/* #define LIBRAFY */

static char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC int PortGrab (PORT *port)*/
PUBLIC int PortGrab (PORT *port)
{
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif

  int *np = &g->next_port ;
  int priority ;
  int id ;
  
  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW) ProcToHI() ;

  /*{{{  allocate a port number*/
  {
    int c ;
  
    for (c=0;c<UPR_MAX_NUM_PORTS;c++)
    {
      if (g->ports[*np] == NULL)
      {
        g->ports[*np] = port ;
        id = *np ;
        *np = (++(*np)) % UPR_MAX_NUM_PORTS ;
        break ;
      }
      *np = (++(*np)) % UPR_MAX_NUM_PORTS ;
    }
    
    if (c==UPR_MAX_NUM_PORTS)
      id = -1 ;
  }
  /*}}}*/

  if (priority==PROC_LOW) ProcToLO() ;

  port->id = id ;
  return(id) ;
}
/*}}}*/
/*{{{  PUBLIC void PortRelease (PORT *port)*/
PUBLIC void PortRelease (PORT *port)
{
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif

  g->ports[port->id] = NULL ;
}  
/*}}}*/
  
/*{{{  PUBLIC int MultiplePortGrab (PORT *ports, int num_ports)*/
PUBLIC int MultiplePortGrab (PORT *ports, int num_ports)
{
  if (num_ports==0)
    return (-1);
  else
  {
    int priority ;
    int base ;
    
    ProcGetPRI(&priority) ;
    if (priority==PROC_LOW) ProcToHI() ;
  
    /*{{{  allocate a port number*/
    {
      #ifdef LIBRAFY
      UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
      #else
      UPR_GLOBALS *g = &upr_globals ;
      #endif
    
      int *np = &g->next_port ;
      int c,size ;
    
      size = 0;
      for (c=0;c<UPR_MAX_NUM_PORTS;c++)
      {
        if (g->ports[*np] == NULL)
        {
          if (size==0) base = *np ;
          size++;
        }
        else
          size=0 ;
        *np = (++(*np)) % UPR_MAX_NUM_PORTS ;
        if (size==num_ports) break;
      }
      
      if (c==UPR_MAX_NUM_PORTS)
        base = -1 ;
      else
      {
        for (c=0;c<num_ports;c++)
        {
          g->ports[(c+base) % UPR_MAX_NUM_PORTS] = &ports[c] ;
          ports[c].id = c+base ;
        }
      }
    }
    /*}}}*/
  
    if (priority==PROC_LOW) ProcToLO() ;
  
    return(base) ;
  }
}
/*}}}*/
/*{{{  PUBLIC void MultiplePortRelease (PORT *ports, int num_ports)*/
PUBLIC void MultiplePortRelease (PORT *ports, int num_ports)
{
  int i ;
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif

  for (i=0;i<num_ports;i++)
    g->ports[ports[i].id] = NULL ;
}  
/*}}}*/
  
/*{{{  PUBLIC void PortInit ( PORT *port, void (*pre_action)(), BOOL do_pre,*/
PUBLIC void PortInit ( PORT *port, void (*pre_action)(), BOOL do_pre,
                       void (*post_action)(), BOOL do_post, void *state)
{
  void *gsb = *(void **) (&port-1) ;
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif

  if (g->ports[port->id] != port)
    Exception(UPR_error,_FILE_,__LINE__,"Attempted to initialise unallocated port number") ;

  port->pre_action  = pre_action ;
  port->post_action = post_action ;
  port->do_pre      = do_pre ;
  port->do_post     = do_post ;
  port->state       = state ;
  port->buffer      = NotPointer_p ;
  port->space       = 0 ;

  if (gsb == g->gsb)
    port->gsb = NULL ;  /* Indicates port used in kernel static space */
  else
    /*{{{  called from non-kernel C run-time*/
    {
      int priority ;
      ProcGetPRI(&priority) ;
      if (priority==PROC_LOW) ProcToHI() ;
      
      /*{{{  install new gsb in list*/
      {  
        LACT **lact = &g->lact ;
        int *state ;
        int i ;
      
        port->gsb = gsb ;
        
        while (*lact != NULL)
          if ((*lact)->gsb == gsb)
            break ;
          else
            lact = &(*lact)->next ;
      
        if ((*lact)->gsb != gsb)
          /*{{{  install new gsb pointer in list*/
          {
            if ((*lact = malloc (sizeof(LACT) + UPR_num_links * LIB_STATE_WORDS * sizeof(int))) == NULL)
              Exception(UPR_error,_FILE_,__LINE__,"Out of heap allocating library action state") ;
          
            (*lact)->next = NULL ;
            (*lact)->gsb = gsb ;
            state = (int *) (*lact + 1) ;
          
            for (i=0;i<UPR_num_links;i++)
            {
              (*lact)->state[i] = state ;
              state += LIB_STATE_WORDS ;
            }
          }
          /*}}}*/
      }
      /*}}}*/
    
      if (priority==PROC_LOW) ProcToLO() ;
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC PORT *PortAlloc ( void (*pre_action)(), BOOL do_pre,*/
PUBLIC PORT *PortAlloc ( void (*pre_action)(), BOOL do_pre,
                         void (*post_action)(), BOOL do_post, void *state)
{
  PORT *port ;
  int id ;

  if ((port = (PORT *) malloc (sizeof(PORT))) == NULL)
    Exception (UPR_error, _FILE_, __LINE__, "Out of heap space whilst allocating port") ;

  if ((id=PortGrab(port)) < 0)
    Exception (UPR_error, _FILE_, __LINE__, "Out of ports") ;
  
  PortInit (port, pre_action, do_pre, post_action, do_post, state) ;
  return (port) ;
}
/*}}}*/
/*{{{  PUBLIC void PortFree ( PORT *port ) */
PUBLIC void PortFree ( PORT *port ) 
{
  PortRelease(port) ;
  free(port) ;
}  
/*}}}*/

/*{{{  PUBLIC PORT *PortPtr( int id )*/
PUBLIC PORT *PortPtr( int id )
{
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif
  return ( g->ports[id] ) ;
}
/*}}}*/

