/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Packet output functions
||@(#)   System : UPR
||@(#) Filename : pktio.c
||@(#)  Version : 2.4
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "router.h"
#include "pktio.h"
#include "except.h"

/*#define LIBRAFY*/

static char *_FILE_ = __FILE__ ;

/*{{{  PRIVATE void sub_enqueue (ORB *orb)*/
PRIVATE void sub_enqueue (ORB *orb)
{
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif
  OQB   *oqb ;
  VLINK *vlink ;
  OLB   *olb ;
  int   destn = HdrDestn(&(orb->header)) ;

  if ((destn>=g->num_nodes) || (destn==g->proc_id))
    Exception(UPR_error, _FILE_, __LINE__,"Invalid packet destination") ;

  orb->list    = (ORB *) NULL;
  orb->src[ll] = UPR_USER ;
  orb->src[vl] = UPR_USER ;
    
  vlink = &g->out_link[destn] ;
  olb = &(g->olbs[(*vlink)[ll]]) ;
  oqb = &(olb->volb[(*vlink)[vl]].oqb) ;

  if (oqb->h == (ORB *) NULL)
  {
    if (oqb->t == (ORB *) NULL)
      /*{{{  make first entry*/
      {
        oqb->h = orb ;
        oqb->t = orb ;
      }
      /*}}}*/
    else
      Exception(UPR_fatal, _FILE_, __LINE__, "Invalid QQB State") ;
  }
  else
    /*{{{  add new entry*/
    {
      oqb->t->list = orb ;
      oqb->t = orb ;
    }
    /*}}}*/

  if (olb->active == FALSE)
    /*{{{  run output handler*/
    {
      olb->active = TRUE ;
      ProcAwaken( olb->wdesc ) ;
    }
    /*}}}*/
}

/* Must be called at high priority. On entry header contains correct
   length of first packet. ORB contains total length of buffer to send.
*/
/*}}}*/

/*{{{  PUBLIC void UPR_Enqueue_BK (ORB *orb)*/
PUBLIC void UPR_Enqueue_BK (ORB *orb)
{
  int priority ;

  orb->bffrlen = HdrLength(&orb->header) ;
  ProcDesc(&(orb->wdesc)) ;

  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW) ProcToHI() ;
  sub_enqueue(orb) ;
  ProcSleep() ;
}
/*}}}*/
/*{{{  PUBLIC void UPR_Enqueue_NBK(ORB *orb)*/
PUBLIC void UPR_Enqueue_NBK(ORB *orb)
{
  int priority ;

  orb->bffrlen = HdrLength(&orb->header) ;
  orb->wdesc = NULL ;

  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW)
  {
    ProcToHI() ;
    sub_enqueue(orb) ;
    ProcToLO() ;
  }
  else
    sub_enqueue(orb) ;
}
/*}}}*/

/*{{{  PUBLIC void UPR_MultipleEnqueue_BK (ORB *orb, int length)*/
PUBLIC void UPR_MultipleEnqueue_BK (ORB *orb, int length)
{
  int priority ;

  orb->bffrlen = length ;
  HdrModLength (min(length,UPR_MAX_PKT_SIZE),&orb->header) ;
  
  ProcDesc(&(orb->wdesc)) ;

  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW) ProcToHI() ;
  sub_enqueue(orb) ;
  ProcSleep() ;
}
/*}}}*/
/*{{{  PUBLIC void UPR_MultipleEnqueue_NBK(ORB *orb, int length)*/
PUBLIC void UPR_MultipleEnqueue_NBK(ORB *orb, int length)
{
  int priority ;

  orb->bffrlen = length ;
  HdrModLength (min(length,UPR_MAX_PKT_SIZE),&orb->header) ;
  orb->wdesc = NULL ;

  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW)
  {
    ProcToHI() ;
    sub_enqueue(orb) ;
    ProcToLO() ;
  }
  else
    sub_enqueue(orb) ;
}
/*}}}*/

/*{{{  PUBLIC BOOL UPR_ORB_Serviced ( ORB *orb )*/
PUBLIC BOOL UPR_ORB_Serviced ( ORB *orb )
{
  return(orb->list == InputServiced_p) ;
}  
/*}}}*/
/*{{{  PUBLIC void UPR_ORB_BK ( ORB *orb )*/
PUBLIC void UPR_ORB_BK ( ORB *orb )
{
  int priority ;

  ProcGetPRI(&priority) ;
  if (priority==PROC_LOW) ProcToHI() ;

  /*{{{  critical code*/
  if (!UPR_ORB_Serviced(orb))
  {
    ProcDesc(&orb->wdesc) ;
    ProcSleep() ;
  }
  /*}}}*/

  if (priority==PROC_LOW) ProcToLO() ;
}  
/*}}}*/

/*{{{  PUBLIC NETWORK *UPR_GetNetworkInfo (void)*/
PUBLIC NETWORK *UPR_GetNetworkInfo (void)
{
  #ifdef LIBRAFY
  UPR_GLOBALS *g = (UPR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->upr_gp ;
  #else
  UPR_GLOBALS *g = &upr_globals ;
  #endif

  return(g->network) ;
}
/*}}}*/
