/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Output handler
||@(#)   System : UPR
||@(#) Filename : output.c
||@(#)  Version : 2.7
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "router.h"
#include "except.h"
#include "pktio.h"

/*  The output handler must RUN at HI priority.
    If UPR_SC is not defined then code must make no relative
    references => procedure call by function pointer and no strings */

#ifdef UPR_SC
static char *_FILE_ = __FILE__ ;
#endif

#if   (defined UPR_SC) && (!(defined DFL))
void UPR_SecureOutputHandler(Process *p, Channel *out_chan, OLB *olb, LINK ll_out)
#elif (!(defined UPR_SC)) && (!(defined DFL))
void UPR_OutputHandler(Process *p, Channel *out_chan, OLB *olb, LINK ll_out)
#elif (defined UPR_SC) && (defined DFL)
void DFL_SecureOutputHandler(Process *p, Channel *out_chan, OLB *olb, LINK ll_out)
#elif (!(defined UPR_SC)) && (defined DFL)
void DFL_OutputHandler(Process *p, Channel *out_chan, OLB *olb, LINK ll_out)
#endif
{
  UPR_GLOBALS *g = &upr_globals ;
  int sleep_count ;
  int index ;
  int num_vlinks = olb->num_vlinks ;
  ORB *orb;
  VOLB *volb ;
  p=p ;

  ProcDesc( &(olb->wdesc) );

  #ifdef DFL
  volb = &(olb->volb[0]) ;
  #else
  index = 0;
  #endif
  
  while (TRUE)
  {
    #ifndef DFL
    while ((orb = olb->lack_OQB.h) != NULL)
      /*{{{  service local ack*/
      {
        #if (UPR_HISTORY != 0)
        UPR_Record (output_thread, ll_out, output_send_LACK, (int) *((int *) &orb->header)) ;
        #endif
      
        /*{{{  send ack*/
        RawChanOut( out_chan, &(orb->header), HdrSize );
        /*}}}*/
      
        olb->lack_OQB.h = orb->list ;
      
        if (orb->list == NULL)
          olb->lack_OQB.t = NULL ;
      
        orb->list = InputServiced_p ;
      
        #ifdef UPR_SC
        if (orb->wdesc != NULL)
          Exception(UPR_error,_FILE_,__LINE__,"Process descheduled on lack ORB") ;
        #endif
      }
      /*}}}*/

    sleep_count = num_vlinks;

    while (sleep_count > 0)
    #endif
      /*{{{  check for packets*/
      {
        #ifndef DFL
        volb = &(olb->volb[index]) ;
      
        index++ ;
        if (index == num_vlinks) index=0 ;
        #endif
        
        orb = volb->oqb.h ;
      
        #ifdef UPR_SC
        if ((num_vlinks==0) && (orb!=NULL))
          Exception(UPR_error,_FILE_,__LINE__, "Packet queued on lack-only OLB") ;
        #endif
          
        if (orb == NULL)
          #ifdef DFL
            /*{{{  deschedule*/
            {
              #if (UPR_HISTORY != 0)
              UPR_Record (output_thread, ll_out, output_sleep, 0) ;
              #endif
              
              olb->active = FALSE ;
              ProcSleep() ;
            }
            /*}}}*/
          #else
            sleep_count-- ;
          #endif
        else
        {
          #ifndef DFL 
          BOOL adjacent = (g->in_vlink[HdrDestn(&orb->header)][ll_out] == UPR_LACK) ;
          
          if (!adjacent && (volb->pkt_count >= olb->pkt_limit))
            sleep_count-- ;
          else
          #endif 
            /*{{{  service packet*/
            {
              int size = min (orb->bffrlen,UPR_MAX_PKT_SIZE) ;
              orb->bffrlen -= size ;
            
              /*{{{  send header*/
              #if (UPR_HISTORY != 0)
              UPR_Record (output_thread, ll_out, output_send_hdr, (int) *((int *) &orb->header)) ;
              #endif
              
              RawChanOut( out_chan, &(orb->header), HdrSize );
              /*}}}*/
              /*{{{  send data body if non-empty*/
              if (size != 0)
              {
                #if (UPR_HISTORY != 0)
                UPR_Record (output_thread, ll_out, output_send_bdy,size) ;
                #endif
                
                RawChanOut( out_chan, orb->bffr, size );
              }
              /*}}}*/
            
              #ifndef DFL
              if (!adjacent)
                volb->pkt_count++;
              #endif
            
              if (orb->src[vl]!=UPR_USER)
              {
                if (orb->src[vl]!=UPR_FROM_DFL)
                  /*{{{  perform virtual link manipulations*/
                  {
                    /*{{{  abbreviate appropriate ilb and vilb*/
                    ILB *ilb;
                    VILB *vilb;
                    
                    ilb = &(g->ilbs[orb->src[ll]]);
                    vilb = &((ilb->vilb)[orb->src[vl]]);
                    /*}}}*/
                    
                    vilb->pkt_count--;
                    vilb->srv_count++;
                  
                    if (vilb->srv_count==ilb->srv_limit)
                      /*{{{  send local acknowledgement*/
                      {
                        OLB *other_olb = &g->olbs[orb->src[ll]];
                        
                        #ifdef UPR_SC
                        if (vilb->lack_ORB.list != (ORB *) InputServiced_p)
                          Exception(UPR_error,_FILE_,__LINE__, "Attempted lack on busy lack_ORB") ;
                        #endif
                      
                        vilb->lack_ORB.list = (ORB *) NULL;
                      
                        UPR_Enqueue( &(vilb->lack_ORB), &(other_olb->lack_OQB)) ; 
                        
                        if (other_olb->active == FALSE)
                          /*{{{  run output handler*/
                          {
                            other_olb->active = TRUE;
                            ProcAwaken( other_olb->wdesc );
                          }
                          /*}}}*/
                      
                        vilb->srv_count = 0;   
                      }
                      /*}}}*/
                  }  
                  /*}}}*/
                else
                  /*{{{  DFL handler manipulate*/
                  g->ilbs[orb->src[ll]].vilb[0].pkt_count--;
                  /*}}}*/
              }
                      
            
              if (orb->bffrlen == 0)
              {
                /*{{{  remove orb from queue*/
                volb->oqb.h = orb->list ;
                
                if (orb->list == NULL)
                  volb->oqb.t = NULL ;
                /*}}}*/
                orb->list = InputServiced_p ;
                if (orb->wdesc != NULL)
                {
                  ProcAwaken (orb->wdesc) ;
                  orb->wdesc = NULL ;
                }
              }
              else
                /*{{{  update ORB*/
                {
                  orb->bffr += size ;
                
                  if (orb->bffrlen < UPR_MAX_PKT_SIZE)
                    HdrModLength(orb->bffrlen,&orb->header) ;
                }
                /*}}}*/
              
              #ifndef DFL
              break;
              #endif
            }
            /*}}}*/
        }
      }
      /*}}}*/
      
    #ifndef DFL
    if (sleep_count == 0)
      /*{{{  deschedule*/
      {
        #if (UPR_HISTORY != 0)
        UPR_Record (output_thread, ll_out, output_sleep, 0) ;
        #endif
        
        olb->active = FALSE ;
        ProcSleep() ;
      }
      /*}}}*/
    #endif
  } 
}
