/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Input handler
||@(#)   System : UPR
||@(#) Filename : input.c
||@(#)  Version : 2.8
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "router.h"
#include "except.h"
#include "pktio.h"

/*  The input handler must RUN at HI priority.
    If UPR_SC is not defined then code must make no relative
    references => procedure call by function pointer and no strings */

#ifdef UPR_SC
static char *_FILE_ = __FILE__ ;
#endif


#if   (defined UPR_SC) && (!(defined DFL))
void UPR_SecureInputHandler( Process *p, Channel *in_chan, ILB *ilb, LINK ll_in)
#elif (!(defined UPR_SC)) && (!(defined DFL))
void UPR_InputHandler( Process *p, Channel *in_chan, ILB *ilb, LINK ll_in)
#elif (defined UPR_SC) && (defined DFL)
void DFL_SecureInputHandler( Process *p, Channel *in_chan, ILB *ilb, LINK ll_in)
#elif (!(defined UPR_SC)) && (defined DFL)
void DFL_InputHandler( Process *p, Channel *in_chan, ILB *ilb, LINK ll_in)
#endif
{
/*  void **gsb = (void **) (&p-1) ;  */
  UPR_GLOBALS *g = &upr_globals ;
  #ifdef UPR_SC
  int full_count = 0;
  #endif
  p=p;

  while (TRUE)
  {
    if (g->trbb->orb.list == (ORB *) InputServiced_p)
      /*{{{  read next packet*/
      {
        int destn, port_id, length;
        int vl_in;
        VILB *vilb ;
        TRBB *my_trbb;
      
        #ifdef UPR_SC  
        full_count=0;
        #endif
        
        /*{{{  grab and reserve trbb before communication*/
        my_trbb = g->trbb;
        my_trbb->orb.list = (ORB *) NULL;
        g->trbb = my_trbb->next;
        /*}}}*/
        /*{{{  accept header*/
        #if (UPR_HISTORY != 0)
        UPR_Record (input_thread, (int) ll_in, input_read_hdr,(int) my_trbb) ;
        #endif
        
        RawChanIn(in_chan, &(my_trbb->orb.header), HdrSize);
        HdrAddr(&destn,&port_id,&(my_trbb->orb.header));
        length = HdrLength(&(my_trbb->orb.header));
        
        #ifdef UPR_SC
        if (length > UPR_MAX_PKT_SIZE)
          Exception(UPR_error,_FILE_,__LINE__,"Oversize packet received") ;
        #endif
        /*}}}*/
        /*{{{  record virtual link on which packet arrives*/
        vl_in = g->in_vlink[destn][ll_in];
        /*}}}*/
      
        if (destn != g->proc_id)
          /*{{{  packet for elsewhere*/
          {
            /*{{{  check for invalid packet source*/
            #ifdef UPR_SC
            if (vl_in == UPR_INVALID_SRC)
            {
              HEADER *h = &my_trbb->orb.header ;
              char *s ;
            
              if ((s=malloc(100)) == NULL)
                Exception (UPR_error,_FILE_,__LINE__,"Out of heap space") ;
              else
              {
                sprintf(s,"Bad pkt on LK%d for D%02d-P%02d-L%02d",ll_in,HdrDestn(h),HdrPort(h),HdrLength(h));
                Exception(UPR_error,_FILE_,__LINE__,s);
              }
            }
            #endif
            /*}}}*/
          
            if (vl_in != UPR_LACK)
              /*{{{  through route*/
              {
                VLINK *l_out;
                OLB   *olb ;
              
                vilb = &((ilb->vilb)[vl_in]); 
               
                #ifdef UPR_SC
                if (destn>=g->num_nodes)
                  Exception(UPR_error, _FILE_, __LINE__,"Invalid destination") ;
                #endif
              
                l_out = &g->out_link[destn] ;
              
                (g->thro_count)++ ;
                vilb->pkt_count++;
              
                #if (defined UPR_SC) && (!(defined DFL))
                if (vilb->pkt_count > ilb->pkt_limit)
                  Exception(UPR_error,_FILE_,__LINE__,"Packet limit exceeded by virtual link");
                #endif
              
              
                if (length!=0)
                {
                  #if (UPR_HISTORY != 0)
                  UPR_Record (input_thread, (int) ll_in, input_read_thro_bdy,(int) *((int *) &my_trbb->orb.header)) ;
                  #endif
                
                  RawChanIn(in_chan,my_trbb->buffer,length);
                }
              
                my_trbb->orb.bffrlen = length ;  
                my_trbb->orb.src[ll] = ll_in ;
                #ifdef DFL
                my_trbb->orb.src[vl] = UPR_FROM_DFL  ;
                #else
                my_trbb->orb.src[vl] = vl_in  ;
                #endif
              
                olb = &(g->olbs[(*l_out)[ll]]) ;
              
                UPR_Enqueue( &(my_trbb->orb), &((olb->volb)[(*l_out)[vl]].oqb));
              
                if (olb->active == FALSE)
                  /*{{{  run output handler*/
                  {
                    olb->active = TRUE;
                    ProcAwaken( olb->wdesc );
                  }
                  /*}}}*/
              
                #ifdef DFL
                if (vilb->pkt_count == ilb->pkt_limit)
                {
                  ProcDesc(&my_trbb->orb.wdesc);
                  ProcSleep();
                }
                #endif
              }   
          /*}}}*/
            else
              #if (defined DFL) && (!(defined UPR_SC))
              {};
              #elif (defined DFL) && (defined UPR_SC)
              Exception(UPR_error,_FILE_,__LINE__,"Received LACK on deadlock-free link");
              #else
              /*{{{  service received local acknowledge*/
              {
                OLB *olb = &(g->olbs[ll_in]) ;
                
                /*{{{  release buffer*/
                my_trbb->orb.list = (ORB *) InputServiced_p;
                /*}}}*/
              
                #if (UPR_HISTORY != 0)
                UPR_Record (input_thread, (int) ll_in, input_read_LACK, (int) port_id) ;
                #endif
                
                #ifdef UPR_SC
                if (length!=0)
                  Exception(UPR_error,_FILE_,__LINE__,"Proc sent message to itself") ;
                #endif
              
                (olb->volb)[port_id].pkt_count -= olb->srv_limit;
              
                if (olb->active == FALSE)
                  /*{{{  run output handler*/
                  {
                    olb->active = TRUE;
                    ProcAwaken( olb->wdesc );
                  }
                  /*}}}*/
              }
              /*}}}*/
              #endif
          }
          
        /*}}}*/
        else
          /*{{{  packet for here*/
          {
            PORT *port = g->ports[port_id] ;
            BYTE *buffer ;
          
            /*{{{  check for null port and invalid source*/
            #ifdef UPR_SC
            if (port == NULL)
            {
              char *s ;
            
              if ((s=malloc(100)) == NULL)
                Exception (UPR_error,_FILE_,__LINE__,"Out of heap space") ;
              else
              {   
                sprintf(s,"Errant pkt D%0d-P%0d-L%0d",destn,port_id,length);
                Exception(UPR_warning,_FILE_,__LINE__,s);
                Exception(UPR_error,_FILE_,__LINE__,"Received header on non-allocated port") ;
              }
            }
            if (vl_in==UPR_INVALID_SRC)
              Exception(UPR_error,_FILE_,__LINE__,"Invalid virtual link at destn");
            #endif
            /*}}}*/
              
            /*{{{  pre_action*/
            if ((port->space < length) || (port->do_pre))
            {
              #if (UPR_HISTORY != 0)
              UPR_Record (input_thread, (int) ll_in, input_call_pre,port->id) ;
              #endif 
             
              #ifdef UPR_SC
              if (port->pre_action == (void (*)()) NULL)
                Exception(UPR_error, _FILE_, __LINE__,"No pre-action bound to active port") ;
              #endif
            
              if (port->gsb == NULL)
                port->pre_action (port, length) ;
              else
                /*{{{  call to different C run-time*/
                {
                  LACT *lact = g->lact ;
                  int *stack ;
                
                  #ifdef UPR_DEBUG
                  {
                    char s[80] ;
                    sprintf(s,"Switch from %x to %x",(int)g->gsb,(int)port->gsb) ;
                    Exception(UPR_warning,_FILE_,__LINE__,s) ;
                  }
                  #endif
                  
                  while (1)
                  {
                    #ifdef UPR_SC
                    if (lact == NULL)
                      Exception(UPR_error,_FILE_,__LINE__,"No entry for library gsb") ;
                    #endif
                    if (lact->gsb == port->gsb)
                      break ;
                    else
                      lact = lact->next ;
                  }
                
                  stack = &lact->state[ll_in][LIB_STATE_WORDS]-5 ;
                
                  stack[1] = (int) port->gsb ;
                  stack[2] = (int) port ;
                  stack[3] = length ;
                
                  __asm
                  {
                              ldlabeldiff preret-prehere ;
                              ldpi ;
                    prehere:  st     stack[0] ;
                              ld     port->pre_action ;
                              ld     stack ;
                              gajw ;
                              stl    4 ;
                              gcall ;
                    preret:   ldl    0 ;
                              gajw ;
                  }
                }
                /*}}}*/
            }  
            
            #ifdef UPR_SC
            if (port->space < length)
              Exception(UPR_error, _FILE_, __LINE__,"Out of protocol packet") ;
            #endif
            /*}}}*/
            /*{{{  read packet*/
            buffer = port->buffer ;
            
            if (length != 0)
            {
              port->buffer += length ;
              port->space  -= length ;
            
              #if (UPR_HISTORY != 0)
              UPR_Record (input_thread, (int) ll_in, input_read_bdy, (int) *((int *) &my_trbb->orb.header)) ;
              #endif
            
              #ifdef UPR_SC
              if (buffer == NotPointer_p)
                Exception(UPR_error,_FILE_,__LINE__,"Invalid buffer pointer for pkt body") ;
              #endif
              
              RawChanIn (in_chan, buffer, length) ;
            
            }
            /*}}}*/
            /*{{{  post_action*/
            if ((port->space == 0) || (port->do_post))
            {
              #if (UPR_HISTORY != 0)
              UPR_Record (input_thread, (int) ll_in, input_call_post, port->id) ;
              #endif
            
              #ifdef UPR_SC
              if (port->post_action == (void (*)()) NULL)
                Exception(UPR_error, _FILE_, __LINE__,"No post-action bound to active port") ;
              #endif
            
              if (port->gsb == NULL)
                port->post_action (port, length, buffer) ;
              else
                /*{{{  call to different C run-time*/
                {
                  LACT *lact = g->lact ;
                  int *stack ;
                
                  #ifdef UPR_DEBUG
                  {
                    char s[80] ;
                    sprintf(s,"Switch from %x to %x",(int)g->gsb,(int)port->gsb) ;
                    Exception(UPR_warning,_FILE_,__LINE__,s) ;
                  }
                  #endif
                  
                  while (1)
                  {
                    #ifdef UPR_SC
                    if (lact == NULL)
                      Exception(UPR_error,_FILE_,__LINE__,"No entry for library gsb") ;
                    #endif
                    if (lact->gsb == port->gsb)
                      break ;
                    else
                      lact = lact->next ;
                  }
                
                  stack = &lact->state[ll_in][LIB_STATE_WORDS]-6 ;
                
                  stack[1] = (int) port->gsb ;
                  stack[2] = (int) port ;
                  stack[3] = length ;
                  stack[4] = (int) buffer ;
                
                  __asm
                  {
                              ldlabeldiff postret-posthere ;
                              ldpi ;
                    posthere: st     stack[0] ;
                              ld     port->post_action ;
                              ld     stack ;
                              gajw ;
                              stl    5 ;
                              gcall ;
                    postret:  ldl    1 ;
                              gajw ;
                  }
                }
                /*}}}*/
            }  
            /*}}}*/
          
            /*{{{  release buffer */
            my_trbb->orb.list = (ORB *) InputServiced_p;
            /*}}}*/
          }
          /*}}}*/
      }
      /*}}}*/
    else
      /*{{{  count used buffers*/
      {
        g->trbb = g->trbb->next ;
      
        #ifdef UPR_SC
        full_count++;
        if (full_count==g->num_buffers)
          Exception(UPR_error,_FILE_,__LINE__,"Ran out of routing buffers") ;
        #endif
      }
      /*}}}*/
  } 
}   
    
    
        
