/* stat.h for MSDOS & LATTICE */

#if MSDOS
#define	dev_t	short
#define	ino_t	short
#define	ushort	short
#define	off_t	long
#ifndef time_t
#define	time_t	long
#endif

struct	stat
{
	dev_t	st_dev;		/* ID of device, always 0 */
	ino_t	st_ino;		/* inode of device, always 0 */
	ushort 	st_mode;	/* file mode, dir or regular */
	short  	st_nlink;	/* number of links, always 0 */
	ushort 	st_uid;		/* user id of owner, always 1 */
	ushort 	st_gid;		/* group id, always 1 */
	dev_t	st_rdev;	/* same as st_dev, always 0 */
	off_t	st_size;	/* file size in bytes */
	time_t	st_atime;	/* see ctime */
	time_t	st_mtime;	/* see ctime */
	time_t	st_ctime;	/* creation time in seconds since 1980 */
};

#define	S_IFMT	0170000		/* type of file */
#define		S_IFDIR	0040000	/* directory */
#define		S_IFCHR	0020000	/* character special */
#define		S_IFBLK	0060000	/* block special */
#define		S_IFREG	0100000	/* regular */
#define		S_IFIFO	0010000	/* fifo */
#define	S_ISUID	04000		/* set user id on execution */
#define	S_ISGID	02000		/* set group id on execution */
#define	S_ISVTX	01000		/* save swapped text even after use */
#define	S_IREAD	00400		/* read permission, owner */
#define	S_IWRITE	00200		/* write permission, owner */
#define	S_IEXEC	00100		/* execute/search permission, owner */
#endif


