	/***************************************************************\
	*								*
	*  PDMAKE, Atari ST version					*
	*								*
	*  Adapted from mod.sources Vol 7 Issue 71, 1986-12-03.		*
	*								*
	*  This port makes extensive use of the original net.sources	*
	*  port by Jwahar Bammi.					*
	*								*
	*      Ton van Overbeek						*
	*      Email: TPC862@ESTEC.BITNET				*
	*             TPC862%ESTEC.BITNET@WISCVM.WISC.EDU    (ARPA)	*
	*             ...!mcvax!tpc862%estec.bitnet   (UUCP Europe)	*
	*             ...!ucbvax!tpc862%estec.bitnet  (UUCP U.S.A.)	*
	*             71450,3537  (CompuServe)				*
	*								*
	\***************************************************************/

/*
 *    Do the actual making for make
 */

#include <stdio.h>
#include <ctype.h>

#ifdef MSDOS
#include	"stat.h"
#endif
#ifdef ZTC
#include <process.h>
#endif
#ifdef unix
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>
#endif
#ifdef eon
#include <sys/stat.h>
#include <sys/err.h>
#endif
#ifdef os9
#include <time.h>
#include <os9.h>
#include <modes.h>
#include <direct.h>
#include <errno.h>
#endif
#ifdef ATARIST
#include "astat.h"
#endif

#include "h.h"

static char *ECHO_MACRO = "ECHO.MACRO" ;

#ifdef MSDOS
static char *commshell = "command /c " ;
static char *internals[] = { "chdir", "cd", "cls", "copy","ctty","date",
                             "del","echo", "erase","dir","mkdir","md",
                             "path", "rem", "ren","rename", "rmdir","rd",
                             "set", "time", "type", ""} ;
#endif

#ifdef MSDOS
int strncasecmp (s1, s2, n)
char *s1, *s2 ;
int n ;
{
  int result = 0 ;
  int i = 0 ;

  while (i < n)
  {
    char c1, c2 ;

    if (strlen(s1) == i)
      if (strlen(s2) == i)
        return 0 ;
      else
        return -1 ;
    else
      if (strlen(s2) == i)
        return 1 ;

    if (isupper(s1[i]))
      c1 = tolower(s1[i]) ;
    else
      c1 = s1[i] ;
 
    if (isupper(s2[i]))
      c2 = tolower(s2[i]) ;
    else
      c2 = s2[i] ;
 
    if (c1 > c2) return 1 ;
    if (c1 < c2) return -1 ;

    i++ ;
  }

  return 0 ;
}  
#endif



/*
 *    Exec a shell that returns exit status correctly (/bin/esh).
 *    The standard EON shell returns the process number of the last
 *    async command, used by the debugger (ugg).
 *    [exec on eon is like a fork+exec on unix]
 */
int
dosh(string, shell)
char *	string;
char *	shell;
{
    int	number;

    while (isspace(*string)) string ++ ;
   
    if (strncmp(string,ECHO_MACRO,strlen(ECHO_MACRO)) == 0)
    {
       char *to = index (string, '>') ;
       FILE *out ;

       string += strlen (ECHO_MACRO) ;
       
       if (to==NULL)
         fatal ("ECHO.MACRO needs to be redirected to file") ;

       to++ ;
       while (isspace(*to)) to++ ;
         
       if ((out=fopen(to,"w")) == NULL)
         fatal ("Unable to open %s", to) ;

       while (*string != '>')
       {
          char *end ;

          while (isspace(*string)) string++ ;
          end = string ;
          while ((*end != '>') && !isspace(*end)) end++ ;

          if (string != end)
            fprintf(out, "%.*s\n", end-string, string) ;

          string = end ;
       }

       fclose (out) ;
       return 0 ;
    }
#ifdef MSDOS
    {
      int i=0 ;

      while (internals[i][0] != 0)
      {
        if (strncasecmp (string, internals[i], strlen(internals[i])) == 0)
        {
          int len = strlen(commshell) + strlen(string) - strlen(internals[i]) + 1 ;
          char *s = malloc (len) ;
          if (s==NULL)
            fatal("Out of heap") ;
          strcpy(s,commshell) ;
          strcat(s,string+strlen(internals[i])) ;
          return system(string);
        }
        i++ ;
      }
    }
#endif      
    {
#ifdef MSDOS
    if (strlen(string) > MAX_DOS_CL)
        fatal("Command line too long for MSDOS") ;
    else
#ifdef ZTC
       {
          char *end = (char *) index (string, ' ') ;
          int len, res ;
          char *command ;

          if (end != NULL)
            len = end-string ;
          else
            len = strlen(string) ;

          if ((command = malloc (len+1)) == NULL)
             fatal("No memory for command");

          strncpy(command, string, len) ;
          command[len] = 0 ;

          res = spawnlp (0, command, command, &string[len], NULL) ;

          free (command) ;
          return res ;
       }
#else
       return system(string);
#endif
#endif
#ifdef unix
    return system(string);
#endif
#ifdef ATARIST
    return system(string);
#endif
#ifdef eon
    return ((number = execl(shell, shell,"-c", string, 0)) == -1) ?
        -1:    /* couldn't start the shell */
        wait(number);    /* return its exit status */
#endif
#ifdef os9
    int	status, pid;

    strcat(string, "\n");
    if ((number = os9fork(shell, strlen(string), string, 0, 0, 0)) == -1)
        return -1;        /* Couldn't start a shell */
    do
    {
        if ((pid = wait(&status)) == -1)
            return -1;    /* child already died!?!? */
    } while (pid != number);

    return status;
#endif
    }
}


/*
 *    Do commands to make a target
 */
void
docmds1(np, lp)
struct name *        np;
struct line *        lp;
{
    bool            ssilent;
    bool            signore;
    int            estat;
    register char *        q;
    register char *        p;
    char *            shell;
    register struct cmd *    cp;


    if (*(shell = getmacro("SHELL")) == '\0')
#ifdef eon
        shell = ":bin/esh";
#endif
#ifdef MSDOS
	shell = "\\COMMAND.COM";
#endif
#ifdef unix
        shell = "/bin/sh";
#endif
#ifdef os9
        shell = "shell";
#endif

    for (cp = lp->l_cmd; cp; cp = cp->c_next)
    {
        strcpy(str1, cp->c_cmd);
        expand(str1);
        q = str1;
        ssilent = silent;
        signore = ignore;
        while ((*q == '@') || (*q == '-'))
        {
            if (*q == '@')       /*  Specific silent  */
                ssilent = TRUE;
            else           /*  Specific ignore  */
                signore = TRUE;
            q++;           /*  Not part of the command  */
        }

        if (!domake)
            ssilent = 0;

        if (!ssilent)
            fputs("    ", stdout);

        for (p=q; *p; p++)
        {
            if (*p == '\n' && p[1] != '\0')
            {
                *p = ' ';
                if (!ssilent)
                    fputs("\\\n", stdout);
            }
            else if (!ssilent)
                putchar(*p);
        }
        if (!ssilent)
            putchar('\n');

        if (domake)
        {            /*  Get the shell to execute it  */
            if ((estat = dosh(q, shell)) != 0)
            {
                if (estat == -1)
#if ((defined ATARIST) || (defined MSDOS))
                    fatal("Couldn't execute %s", q);
#else
                    fatal("Couldn't execute %s", shell);
#endif
                else
                {
                    printf("%s: Error code %d", myname, estat);
                    if (signore)
                        fputs(" (Ignored)\n", stdout);
                    else
                    {
                        putchar('\n');
                        if (!(np->n_flag & N_PREC))
                            if (unlink(np->n_name) == 0)
                                printf("%s: '%s' removed.\n", myname,
                                       np->n_name);
                        exit(estat);
                    }
                }
            }
        }
    }
}


docmds(np)
struct name *	np;
{
    register struct line *	lp;


    for (lp = np->n_line; lp; lp = lp->l_next)
        docmds1(np, lp);
}

#ifdef MSDOS
extern time_t time();
#endif

#ifdef os9
/*
 *    Some stuffing around to get the modified time of a file
 *    in an os9 file system
 */
getmdate(fd, tbp)
struct sgtbuf *        tbp;
{
    struct registers    regs;
    static struct fildes    fdbuf;


    regs.rg_a = fd;
    regs.rg_b = SS_FD;
    regs.rg_x = &fdbuf;
    regs.rg_y = sizeof (fdbuf);

    if (_os9(I_GETSTT, &regs) == -1)
    {
        errno = regs.rg_b & 0xff;
        return -1;
    }
    if (tbp)
    {
        _strass(tbp, fdbuf.fd_date, sizeof (fdbuf.fd_date));
        tbp->t_second = 0;    /* Files are only acurate to mins */
    }
    return 0;
}


/*
 *    Kludge routine to return an aproximation of how many
 *    seconds since 1980.  Dates will be in order, but will not
 *    be linear
 */
time_t
cnvtime(tbp)
struct sgtbuf        *tbp;
{
    long            acc;


    acc = tbp->t_year - 80;        /* Baseyear is 1980 */
    acc = acc * 12 + tbp->t_month;
    acc = acc * 31 + tbp->t_day;
    acc = acc * 24 + tbp->t_hour;
    acc = acc * 60 + tbp->t_minute;
    acc = acc * 60 + tbp->t_second;

    return acc;
}


/*
 *    Get the current time in the internal format
 */
time(tp)
time_t *        tp;
{
    struct sgtbuf        tbuf;


    if (getime(&tbuf) < 0)
        return -1;

    if (tp)
        *tp = cnvtime(&tbuf);

    return 0;
}
#endif

#ifdef ATARIST
/*
 *    Get the current time in the internal format
 */
time(tp)
time_t *        tp;
{
    if (tp)
        *tp = Gettime();

    return 0;
}
#endif

/*
 *    Get the modification time of a file.  If the first
 *    doesn't exist, it's modtime is set to 0.
 */
void
modtime(np)
struct name *	np;
{
#ifdef MSDOS
	extern long mtime();
	np->n_time = mtime(np->n_name);
#endif
#ifdef unix
    struct stat		info;
    int			fd;


    if (stat(np->n_name, &info) < 0)
    {
        if (errno != ENOENT)
            fatal("Can't open %s; error %d", np->n_name, errno);

        np->n_time = 0L;
    }
    else
        np->n_time = info.st_mtime;
#endif
#ifdef eon
    struct stat		info;
    int			fd;


    if ((fd = open(np->n_name, 0)) < 0)
    {
        if (errno != ER_NOTF)
            fatal("Can't open %s; error %02x", np->n_name, errno);

        np->n_time = 0L;
    }
    else if (getstat(fd, &info) < 0)
        fatal("Can't getstat %s; error %02x", np->n_name, errno);
    else
        np->n_time = info.st_mod;

    close(fd);
#endif
#ifdef os9
    struct sgtbuf	info;
    int			fd;


    if ((fd = open(np->n_name, 0)) < 0)
    {
        if (errno != E_PNNF)
            fatal("Can't open %s; error %02x", np->n_name, errno);

        np->n_time = 0L;
    }
    else if (getmdate(fd, &info) < 0)
        fatal("Can't getstat %s; error %02x", np->n_name, errno);
    else
        np->n_time = cnvtime(&info);

    close(fd);
#endif
#ifdef ATARIST
    struct stat		info;
    extern int		getstat();		/*  in ststuff.c  */
    extern void		FlipWords();		/*  in ststuff.c  */

    if (getstat(np->n_name, &info) < 0)
        np->n_time = 0L;
    else
    {
        FlipWords(&info.st_mod);
        np->n_time = info.st_mod;
    }
#endif
}


/*
 *    Update the mod time of a file to now.
 */
void
touch(np)
struct name *	np;
{
    char	c;
    int		fd;


    if (!domake || !silent)
        printf("    touch(%s)\n", np->n_name);

    if (domake)
    {
#ifdef MSDOS
        if ((fd = open(np->n_name, 0)) < 0)
            printf("%s: '%s' not touched - non-existant\n",
                    myname, np->n_name);
        else
        {
		mstouch(np->n_name);
        }
        close(fd);
#endif
#ifdef unix
        long	a[2];

        a[0] = a[1] = time(0);
        if (utime(np->n_name, &a[0]) < 0)
            printf("%s: '%s' not touched - non-existant\n",
                    myname, np->n_name);
#endif
#ifdef eon
        if ((fd = open(np->n_name, 0)) < 0)
            printf("%s: '%s' not touched - non-existant\n",
                    myname, np->n_name);
        else
        {
            uread(fd, &c, 1, 0);
            uwrite(fd, &c, 1);
        }
        close(fd);
#endif
#ifdef os9
        /*
         *    Strange that something almost as totally useless
         *    as this is easy to do in os9!
         */
        if ((fd = open(np->n_name, S_IWRITE)) < 0)
            printf("%s: '%s' not touched - non-existant\n",
                    myname, np->n_name);
        close(fd);
#endif
#ifdef ATARIST
        if ((fd = Fopen(np->n_name, 0)) < 0)
            printf("%s: '%s' not touched - non-existant\n",
                    myname, np->n_name);
        else
        {
            long tim;

            tim = Gettime();
            FlipWords(&tim);
            if (Fdatime( &tim, fd, 1) < 0)
                printf("%s: '%s' not touched - disk protected ?\n",
                        myname, np->n_name);
            Fclose(fd);
        }
#endif
    }
}


/*
 *    Recursive routine to make a target.
 */
int
make(np, level)
struct name *	np;
int		level;
{
    register struct depend *	dp;
    register struct line *	lp;
    register struct depend *	qdp;
    time_t			dtime;
    int				didsomething;

    dtime = 1L;
    didsomething = 0;

    if (np->n_flag & N_DONE)
        return 0;

    if (!np->n_time)
        modtime(np);			/*  Gets modtime of this file  */

    if (rules)
    {
        for (lp = np->n_line; lp; lp = lp->l_next)
            if (lp->l_cmd)
                break;
        if (!lp)
            dyndep(np);
    }

    if (!(np->n_flag & N_TARG) && np->n_time == 0L)
        fatal("Don't know how to make %s", np->n_name);

    for (qdp = (struct depend *)0, lp = np->n_line; lp; lp = lp->l_next)
    {
        for (dp = lp->l_dep; dp; dp = dp->d_next)
        {
            make(dp->d_name, level+1);
            if (np->n_time < dp->d_name->n_time)
                qdp = newdep(dp->d_name, qdp);
            dtime = max(dtime, dp->d_name->n_time);
        }
        if (!quest && (np->n_flag & N_DOUBLE) && (np->n_time < dtime))
        {
            make1(np, lp, qdp);			/* free()'s qdp */
            dtime = 1;
            qdp = (struct depend *)0;
            didsomething++;
        }
    }

    np->n_flag |= N_DONE;

    if (quest)
    {
        long        t;

        t = np->n_time;
        modtime (np) ; /* was time(&np->n_time); */
        return t < dtime;
    }
    else if (np->n_time < dtime && !(np->n_flag & N_DOUBLE))
    {
        make1(np, (struct line *)0, qdp);	/* free()'s qdp */
        modtime (np) ; /* was time(&np->n_time); */
    }
/*    else if (level == 0 && !didsomething) */
      else if (level == 0 && (didsomething == 0))
        printf("%s: '%s' is up to date\n", myname, np->n_name);
    return 0;
}


make1(np, lp, qdp)
register struct depend *	qdp;
struct line *	lp;
struct name *	np;
{
    register struct depend *	dp;


    if (dotouch)
        touch(np);
    else
    {
        strcpy(str1, "");
        for (dp = qdp; dp; dp = qdp)
        {
            if (strlen(str1))
                strcat(str1, " ");
            strcat(str1, dp->d_name->n_name);
            qdp = dp->d_next;
            free(dp);
        }
        setmacro("?", str1, LOWP);
        setmacro("@", np->n_name, LOWP);
        if (lp)					/* lp set if doing a :: rule */
            docmds1(np, lp);
        else
            docmds(np);
    }
}

