/* ibmstuff.c to provide msdos routines missing for make.c */
/* HFVR 6-may-1987 */

#ifdef MSDOS

#include	<dos.h>
#include	<stdio.h>

#ifdef ZTC
#define byte unsigned char
#endif

/* define directory entry types */
#define	FREADONLY	0x1
#define	FHIDDEN		0x2
#define FSYSTEM		0x4
#define FLABEL		0x8
#define FDIR		0x10
#define	FARCHIVE	0x20

#define	CARRY	1
#ifdef min
#undef min
#endif
static union REGS rg;
static int	flags;
static char	ar[256];
static byte	hi;
static	byte	lo;

/* touch the file with the current date and time */
struct	TIME { int day;
	       int wkday;
	       int month;
	       int year;
	       int hour;
	       int minute;
	       int sec;
	    };

static  doit(name,day,month,year,hour,minute,sec)
char	name[];
int	day,month,year,hour,minute,sec;
{	int	handle;
	byte	hi,lo;

	/* check date */
	year = year - 1980;
	sec = 0;
	if ( (year < 0) || (year > 199)) goto error;
	if ( (month< 0) || (month> 12 )) goto error;
	if ( (day  < 0) || (day  > 31 )) goto error;
	if ( (hour < 0) || (hour > 23 )) goto error;
	if ( (minute  < 0) || (minute  > 59 )) goto error;
	goto okay;
error:
	fprintf(stderr,"touch : ERROR : illegal date\n");
	return(1);
okay:
	strcpy(ar,name);

	/* Open file Handle pg:7-120 */
	rg.h.ah = 0x3d;		/* open file handle */
	rg.h.al = 0;		/* open for read */
	rg.x.dx = (unsigned short) &(ar[0]);	/* pointer to pathname */
	flags = intdos(&rg, &rg);
	handle = rg.x.ax;

	if ( (flags & CARRY) != 0) {
		switch (handle) {
			case 2  :	fprintf(stderr,"%s not found\n",name); break;
			case 4  :	fprintf(stderr,"Too many open files\n"); break;
			case 5  :	fprintf(stderr,"Access denied on %s\n",name); break;
			case 12 :	fprintf(stderr,"Invalid access on %s\n",name); break;
			default :	fprintf(stderr,"Unknown error on %s\n",name); break;
		}
		return(1);
	}

	/* compute values for DX */
	lo = month & 7 ; /* take 3 right most bits */
	lo = lo << 5;
	lo = lo | day;
	hi = year & 0x7f;
	hi = hi << 1;
	hi = hi | ( (month>>3) & 0xff);
	rg.h.dl = lo;
	rg.h.dh = hi;

	lo = minute & 7;
	lo = lo << 5;
	lo = lo | sec;
	hi = hour & 31;
	hi = hi << 3;
	hi = hi | ( (minute>>3) & 0xff);
	rg.h.cl = lo;
	rg.h.ch = hi;

	/* set date and time */
	rg.h.ah = 0x57;		/* get/set date/time of file */
	rg.h.al = 1;		/* set time/date */
	rg.x.bx = handle;
	flags = intdos(&rg, &rg);
	if ( (flags & CARRY) != 0 ) {
		fprintf(stderr,"Cannot touch %s\n",name);
	}
	/* close file handle */
	rg.h.ah = 0x3e;		/* close file */
	rg.x.bx = handle;
	intdos(&rg, &rg);
}/*doit*/

static gettime(ptr)
struct TIME	*ptr;
{
	rg.h.ah = 0x2a;		/* get date */
	intdos(&rg, &rg);
	ptr->year = rg.x.cx;
	ptr->month= rg.h.dh;
	ptr->day = rg.h.dl;
	ptr->wkday= rg.h.al;

	rg.h.ah = 0x2c;		/* get time */
	intdos(&rg, &rg);
	ptr->hour = rg.h.ch;
	ptr->minute = rg.h.cl;
	ptr->sec = rg.h.dh;
}/*gettime*/

mstouch(name)
char	name[];
{	struct TIME	t;

	gettime(&t);
	doit(name,t.day,t.month,t.year,t.hour,t.minute,t.sec);
}/*mstouch*/

#ifdef min
#undef min
#endif

#ifdef USE_CLOCK_TIME
long time(tp)
long	*tp;
{	long year,month,day,hour,min,sec;
	long res;

	rg.h.ah = 0x2a;		/* get date */
	intdos(&rg, &rg);
	year = (long)rg.x.cx;
	month= (long)rg.h.dh;
	day = (long)rg.h.dl;

	rg.h.ah = (long)0x2c;		/* get time */
	intdos(&rg, &rg);
	hour = (long)rg.h.ch;
	min = (long)rg.h.cl;
	sec = (long)rg.h.dh;

	res = sec + min  * 60L
	          + hour * 3600L
		  + day  * 86400L
		  + month* 2678400L
		  + year * 980294400L;
        if (tp) *tp = res;
	return(res);
}/*time*/
#endif

struct DTA {
	char	reserved[21];
	char	attribute;
	int	time;
	int	date;
	unsigned int	lowsize;
	unsigned int	highsize;
	char	name[13];
	char	padding;
};
static struct DTA dta;		/* copy for Disk transfer address */

struct INFO {
	char	name[13];
	char	attribute;
	int	time;
	int	date;
	int	lowsize;
	int	highsize;
};

static struct INFO file;

long	mtime(name)
char	name[];
{	long year,month,day,hour,min,sec;
	long res;

	strcpy(ar,name);

	/* set DTA */
	rg.h.ah = 0x1a;		/* set DTA */
	rg.x.dx = (unsigned short) &(dta);
	intdos(&rg, &rg);
	
	/* start search through direc */
	rg.h.ah = 0x4e;		/* find match file */
	rg.x.cx = 0xffff;	/* all bits on */
	rg.x.dx = (unsigned short) &(ar[0]);	/* pointer to path name */
	intdos(&rg, &rg);


	if ( (rg.x.ax == 2) || ( rg.x.ax == 18 ) ) {
		return(0L);	/* no such file */
	}

	/* do not look at labels */
	if ( (dta.attribute & FLABEL) != 0) {
		return(0L);
	}

	hi = (byte)(dta.date >> 8);
	lo = (byte)(dta.date & 0xff);
	day = (long) (lo&31);
	month = (long) ( (hi&1)*8+(lo>>5) );
	year = (long) ( (hi>>1) );

	/* MD 2-9-92,  This was year = (long) ( (hi>>1)+1980 );
	   Relative year ok since only need time differences */
	
	hi = (byte)(dta.time >> 8);
	lo = (byte)(dta.time & 0xff);
	hour = (long) (hi>>3);
	min  = (long) ( (hi&7)*8+(lo>>5) );
	sec  = (long) (lo&31);

	res =       sec  * 2L
	 	  + min  * 60L
	          + hour * 3600L
		  + day  * 86400L
		  + month* 2678400L
		  + year * 32140800L ;
		  
	/* MD 2-9-92, This was + year * 980294400L;
	   but this was wrong since there are 12 months in a year not 366! */

	/* printf("%ld/%ld/%ld %ld:%ld:%ld   -> %ld\n",day,month,year+1980L,hour,min,sec*2L,res) ; */

	return(res);
}/*mtime*/
#else
static	dummy() {};
#endif


