#{{{  File banner
# @(#)=====================================================
# @(#)  Project : PUMA ESPRIT P2701
# @(#)  Authors : Mark Debbage and Mark Hill
# @(#)            University of Southampton
#  
# @(#)    Title : Makefile for vhostio.lib
# @(#)   System : VCR
# @(#) Filename : vhostio.mak
# @(#)  Version : 1.3
# @(#)     Date : 7/1/91
# @(#)====================================================
#}}}
#############################################################################
#
#           Make file for the occam2 toolset library hostio.lib
#
#                             25-Oct-90 SRH
#
# Modified by MD for Virtual Channel Router Version 2.0, 26-6-91
#   - no y option required
#   - no t2 support (any T2 rules are vestigial)
#   - works using pdmake on a PC
#############################################################################

# For MSDOS
O=/
S=\ # slash
VCR=\vcr

# For UNIX
#O=-
#S=/
#VCR=/home/cougar/md/parc/upr

# tools and global options
LIBRARIAN=ilibr
LIBOPT=
OCCEXTRAS=
OCCAM=oc
# times.t2_ requires INT32DIV and INT32REM from the compiler libraries
OCCOPT=$(O)d $(OCCEXTRAS)


# filename extensions
2H=.t2h
2X=.t2x
AH=.tah
AX=.tax
8H=.t8h
8X=.t8x

# TA class modules
HOSTTA=	open$(AH) close$(AH) spread$(AH) soread$(AH) spwrite$(AH) sowrite$(AH) gets$(AH) puts$(AH) \
	flush$(AH) seek$(AH) tell$(AH) eof$(AH) ferror$(AH) remove$(AH) rename$(AH) \
	getkey$(AH) pollkey$(AH) getenv$(AH) time$(AH) system$(AH) exit$(AH) \
	command$(AH) core$(AH) version$(AH) buffer$(AH) mux$(AH) ovbuffer$(AH) \
	ovmux$(AH) packet$(AH) opentemp$(AH) exists$(AH) popen$(AH) parse$(AH) \
	wstring$(AH) wint$(AH) whint$(AH) wint64$(AH) whint64$(AH) wreal32$(AH) \
	fwstring$(AH) wreal64$(AH) readline$(AH) echoline$(AH) times$(AH) \
	ask$(AH) reint$(AH) rehint$(AH) reaint$(AH) reint64$(AH) rehint64$(AH) \
	rereal32$(AH) rereal64$(AH) wint32$(AH) whint32$(AH) reint32$(AH) \
	rehint32$(AH) primux$(AH) ovprimux$(AH) \
	open$(AX) close$(AX) spread$(AX) soread$(AX) spwrite$(AX) sowrite$(AX) gets$(AX) puts$(AX) \
	flush$(AX) seek$(AX) tell$(AX) eof$(AX) ferror$(AX) remove$(AX) rename$(AX) \
	getkey$(AX) pollkey$(AX) getenv$(AX) time$(AX) system$(AX) exit$(AX) \
	command$(AX) core$(AX) version$(AX) buffer$(AX) mux$(AX) ovbuffer$(AX) \
	ovmux$(AX) packet$(AX) opentemp$(AX) exists$(AX) popen$(AX) parse$(AX) \
	wstring$(AX) wint$(AX) whint$(AX) wint64$(AX) whint64$(AX) wreal32$(AX) \
	fwstring$(AX) wreal64$(AX) readline$(AX) echoline$(AX) times$(AX) \
	ask$(AX) reint$(AX) rehint$(AX) reaint$(AX) reint64$(AX) rehint64$(AX) \
	rereal32$(AX) rereal64$(AX) wint32$(AX) whint32$(AX) reint32$(AX) \
        rehint32$(AX) primux$(AX) ovprimux$(AX)

# T8 class modules
HOSTT8=	open$(8H) close$(8H) spread$(8H) soread$(8H) spwrite$(8H) sowrite$(8H) gets$(8H) puts$(8H) \
	flush$(8H) seek$(8H) tell$(8H) eof$(8H) ferror$(8H) remove$(8H) rename$(8H) \
	getkey$(8H) pollkey$(8H) getenv$(8H) time$(8H) system$(8H) exit$(8H) \
	command$(8H) core$(8H) version$(8H) buffer$(8H) mux$(8H) ovbuffer$(8H) \
	ovmux$(8H) packet$(8H) opentemp$(8H) exists$(8H) popen$(8H) parse$(8H) \
	wstring$(8H) wint$(8H) whint$(8H) wint64$(8H) whint64$(8H) wreal32$(8H) \
        wreal64$(8H) readline$(8H) echoline$(8H) times$(8H) \
	fwstring$(8H) ask$(8H) reint$(8H) rehint$(8H) reaint$(8H) reint64$(8H) rehint64$(8H) \
	rereal32$(8H) rereal64$(8H) wint32$(8H) whint32$(8H) reint32$(8H) \
        rehint32$(8H) primux$(8H) ovprimux$(8H) \
	open$(8X) close$(8X) spread$(8X) soread$(8X) spwrite$(8X) sowrite$(8X) gets$(8X) puts$(8X) \
	flush$(8X) seek$(8X) tell$(8X) eof$(8X) ferror$(8X) remove$(8X) rename$(8X) \
	getkey$(8X) pollkey$(8X) getenv$(8X) time$(8X) system$(8X) exit$(8X) \
	command$(8X) core$(8X) version$(8X) buffer$(8X) mux$(8X) ovbuffer$(8X) \
	ovmux$(8X) packet$(8X) opentemp$(8X) exists$(8X) popen$(8X) parse$(8X) \
	wstring$(8X) wint$(8X) whint$(8X) wint64$(8X) whint64$(8X) wreal32$(8X) \
	fwstring$(8X) wreal64$(8X) readline$(8X) echoline$(8X) times$(8X) \
	ask$(8X) reint$(8X) rehint$(8X) reaint$(8X) reint64$(8X) rehint64$(8X) \
	rereal32$(8X) rereal64$(8X) wint32$(8X) whint32$(8X) reint32$(8X) \
        rehint32$(8X) primux$(8X) ovprimux$(8X)


#
############################## target and rules ##############################
#
$(VCR)$(S)libs$(S)vhostio.lib: hostta hostt8
	$(LIBRARIAN) $(O)f vhostio.lbb $(LIBOPT) $(O)o $(VCR)$(S)libs$(S)vhostio.lib

hostta: $(HOSTTA)
	echo hostta up to date stamp >hostta

hostt8: $(HOSTT8)
	echo hostt8 up to date stamp >hostt8

# pattern matching rules (too complicated for pdmake!)
# an explicit rule is chosen before a pattern matching rule
# $< is a dynamic macro which means the current dependency file
# $* is a dynamic macro which means the base name of the current target
# actually, many of the hostio routines depend on hostio.inc
#%$(2H): %.occ
#	$(OCCAM) $< $(O)h $(O)t2 $(O)e $(OCCOPT) $(O)o $*$(2H)

#%$(2X): %.occ
#	$(OCCAM) $< $(O)x $(O)t2 $(O)e $(OCCOPT) $(O)o $*$(2X)

#%$(AH): %.occ
#	$(OCCAM) $< $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o $*$(AH)

#%$(AX): %.occ
#	$(OCCAM) $< $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o $*$(AX)

#%$(8H): %.occ
#	$(OCCAM) $< $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o $*$(8H)

#%$(8X): %.occ
#	$(OCCAM) $< $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o $*$(8X)


# Build the library readwrit.lib so that so.read and so.write can be compiled.
READWRIT=spread$(AH) spread$(AX) spread$(8H) spread$(8X) \
	 spwrite$(AH) spwrite$(AX) spwrite$(8H) spwrite$(8X)

readwrit.lib:	$(READWRIT)
	$(LIBRARIAN) $(O)f readwrit.lbb $(O)o readwrit.lib $(LIBOPT)
	
soread$(AH): soread.occ readwrit.lib hostio.inc
	$(OCCAM) soread $(O)ta $(O)h $(O)o soread$(AH) $(O)e $(OCCOPT)

soread$(AX): soread.occ readwrit.lib hostio.inc
	$(OCCAM) soread $(O)ta $(O)x $(O)o soread$(AX) $(O)e $(OCCOPT)

soread$(8H): soread.occ readwrit.lib hostio.inc
	$(OCCAM) soread $(O)t8 $(O)h $(O)o soread$(8H) $(O)e $(OCCOPT)

soread$(8X): soread.occ readwrit.lib hostio.inc
	$(OCCAM) soread $(O)t8 $(O)x $(O)o soread$(8X) $(O)e $(OCCOPT)

sowrite$(AH): sowrite.occ readwrit.lib hostio.inc
	$(OCCAM) sowrite $(O)ta $(O)h $(O)o sowrite$(AH) $(O)e $(OCCOPT)

sowrite$(AX): sowrite.occ readwrit.lib hostio.inc
	$(OCCAM) sowrite $(O)ta $(O)x $(O)o sowrite$(AX) $(O)e $(OCCOPT)

sowrite$(8H): sowrite.occ readwrit.lib hostio.inc
	$(OCCAM) sowrite $(O)t8 $(O)h $(O)o sowrite$(8H) $(O)e $(OCCOPT)

sowrite$(8X): sowrite.occ readwrit.lib hostio.inc
	$(OCCAM) sowrite $(O)t8 $(O)x $(O)o sowrite$(8X) $(O)e $(OCCOPT)



splib.lib:	splib.lbb \
	open$(AH) close$(AH) spread$(AH) soread$(AH) spwrite$(AH) sowrite$(AH) gets$(AH) puts$(AH) \
	flush$(AH) seek$(AH) tell$(AH) eof$(AH) ferror$(AH) remove$(AH) \
	rename$(AH) getkey$(AH) pollkey$(AH) getenv$(AH) time$(AH) system$(AH) \
	exit$(AH) command$(AH) core$(AH) version$(AH) buffer$(AH) mux$(AH) \
	ovbuffer$(AH) ovmux$(AH) packet$(AH) \
	\
	open$(AX) close$(AX) spread$(AX) soread$(AX) spwrite$(AX) sowrite$(AX) gets$(AX) puts$(AX) \
	flush$(AX) seek$(AX) tell$(AX) eof$(AX) ferror$(AX) remove$(AX) \
	rename$(AX) getkey$(AX) pollkey$(AX) getenv$(AX) time$(AX) system$(AX) \
	exit$(AX) command$(AX) core$(AX) version$(AX) buffer$(AX) mux$(AX) \
	ovbuffer$(AX) ovmux$(AX) packet$(AX) \
	\
	open$(8H) close$(8H) spread$(8H) soread$(8H) spwrite$(8H) sowrite$(8H) gets$(8H) puts$(8H) \
	flush$(8H) seek$(8H) tell$(8H) eof$(8H) ferror$(8H) remove$(8H) \
	rename$(8H) getkey$(8H) pollkey$(8H) getenv$(8H) time$(8H) system$(8H) \
	exit$(8H) command$(8H) core$(8H) version$(8H) buffer$(8H) mux$(8H) \
	ovbuffer$(8H) ovmux$(8H) packet$(8H) \
	\
	open$(8X) close$(8X) spread$(8X) soread$(8X) spwrite$(8X) sowrite$(8X) gets$(8X) puts$(8X) \
	flush$(8X) seek$(8X) tell$(8X) eof$(8X) ferror$(8X) remove$(8X) \
	rename$(8X) getkey$(8X) pollkey$(8X) getenv$(8X) time$(8X) system$(8X) \
	exit$(8X) command$(8X) core$(8X) version$(8X) buffer$(8X) mux$(8X) \
	ovbuffer$(8X) ovmux$(8X) packet$(8X)
	$(LIBRARIAN) $(O)f splib.lbb $(O)o splib.lib $(LIBOPT)

# h mode
# ta class
opentemp$(AH):	opentemp.occ hostio.inc splib.lib 
	$(OCCAM) opentemp $(O)ta $(O)h $(O)o opentemp$(AH) $(O)e $(OCCOPT)

exists$(AH):	exists.occ hostio.inc splib.lib 
	$(OCCAM) exists $(O)ta $(O)h $(O)o exists$(AH) $(O)e $(OCCOPT)

popen$(AH):	popen.occ hostio.inc splib.lib 
	$(OCCAM) popen $(O)ta $(O)h $(O)o popen$(AH) $(O)e $(OCCOPT)

parse$(AH):	parse.occ hostio.inc splib.lib 
	$(OCCAM) parse $(O)ta $(O)h $(O)o parse$(AH) $(O)e $(OCCOPT)

wstring$(AH):	wstring.occ hostio.inc splib.lib 
	$(OCCAM) wstring $(O)ta $(O)h $(O)o wstring$(AH) $(O)e $(OCCOPT)

fwstring$(AH):	fwstring.occ hostio.inc splib.lib 
	$(OCCAM) fwstring $(O)ta $(O)h $(O)o fwstring$(AH) $(O)e $(OCCOPT)

wint$(AH):	wint.occ hostio.inc splib.lib  
	$(OCCAM) wint $(O)ta $(O)h $(O)o wint$(AH) $(O)e $(OCCOPT)

whint$(AH):	whint.occ hostio.inc splib.lib  
	$(OCCAM) whint $(O)ta $(O)h $(O)o whint$(AH) $(O)e $(OCCOPT)

wint32$(AH):	wint32.occ hostio.inc splib.lib  
	$(OCCAM) wint32 $(O)ta $(O)h $(O)o wint32$(AH) $(O)e $(OCCOPT)

whint32$(AH):	whint32.occ hostio.inc splib.lib  
	$(OCCAM) whint32 $(O)ta $(O)h $(O)o whint32$(AH) $(O)e $(OCCOPT)

wint64$(AH):	wint64.occ hostio.inc splib.lib  
	$(OCCAM) wint64 $(O)ta $(O)h $(O)o wint64$(AH) $(O)e $(OCCOPT)

whint64$(AH):	whint64.occ hostio.inc splib.lib  
	$(OCCAM) whint64 $(O)ta $(O)h $(O)o whint64$(AH) $(O)e $(OCCOPT)

wreal32$(AH):	wreal32.occ hostio.inc splib.lib  
	$(OCCAM) wreal32 $(O)ta $(O)h $(O)o wreal32$(AH) $(O)e $(OCCOPT)

wreal64$(AH):	wreal64.occ hostio.inc splib.lib  
	$(OCCAM) wreal64 $(O)ta $(O)h $(O)o wreal64$(AH) $(O)e $(OCCOPT)

readline$(AH):	readline.occ hostio.inc splib.lib 
	$(OCCAM) readline $(O)ta $(O)h $(O)o readline$(AH) $(O)e $(OCCOPT)

echoline$(AH):	echoline.occ hostio.inc splib.lib 
	$(OCCAM) echoline $(O)ta $(O)h $(O)o echoline$(AH) $(O)e $(OCCOPT)

times$(AH):	times.occ hostio.inc splib.lib 
	$(OCCAM) times $(O)ta $(O)h $(O)o times$(AH) $(O)e $(OCCOPT)

# t8 class
opentemp$(8H):	opentemp.occ hostio.inc splib.lib 
	$(OCCAM) opentemp $(O)t8 $(O)h $(O)o opentemp$(8H) $(O)e $(OCCOPT)

exists$(8H):	exists.occ hostio.inc splib.lib 
	$(OCCAM) exists $(O)t8 $(O)h $(O)o exists$(8H) $(O)e $(OCCOPT)

popen$(8H):	popen.occ hostio.inc splib.lib 
	$(OCCAM) popen $(O)t8 $(O)h $(O)o popen$(8H) $(O)e $(OCCOPT)

parse$(8H):	parse.occ hostio.inc splib.lib 
	$(OCCAM) parse $(O)t8 $(O)h $(O)o parse$(8H) $(O)e $(OCCOPT)

wstring$(8H):	wstring.occ hostio.inc splib.lib 
	$(OCCAM) wstring $(O)t8 $(O)h $(O)o wstring$(8H) $(O)e $(OCCOPT)

fwstring$(8H):	fwstring.occ hostio.inc splib.lib 
	$(OCCAM) fwstring $(O)t8 $(O)h $(O)o fwstring$(8H) $(O)e $(OCCOPT)

wint$(8H):	wint.occ hostio.inc splib.lib  
	$(OCCAM) wint $(O)t8 $(O)h $(O)o wint$(8H) $(O)e $(OCCOPT)

whint$(8H):	whint.occ hostio.inc splib.lib  
	$(OCCAM) whint $(O)t8 $(O)h $(O)o whint$(8H) $(O)e $(OCCOPT)

wint32$(8H):	wint32.occ hostio.inc splib.lib  
	$(OCCAM) wint32 $(O)t8 $(O)h $(O)o wint32$(8H) $(O)e $(OCCOPT)

whint32$(8H):	whint32.occ hostio.inc splib.lib  
	$(OCCAM) whint32 $(O)t8 $(O)h $(O)o whint32$(8H) $(O)e $(OCCOPT)

wint64$(8H):	wint64.occ hostio.inc splib.lib  
	$(OCCAM) wint64 $(O)t8 $(O)h $(O)o wint64$(8H) $(O)e $(OCCOPT)

whint64$(8H):	whint64.occ hostio.inc splib.lib  
	$(OCCAM) whint64 $(O)t8 $(O)h $(O)o whint64$(8H) $(O)e $(OCCOPT)

wreal32$(8H):	wreal32.occ hostio.inc splib.lib  
	$(OCCAM) wreal32 $(O)t8 $(O)h $(O)o wreal32$(8H) $(O)e $(OCCOPT)

wreal64$(8H):	wreal64.occ hostio.inc splib.lib  
	$(OCCAM) wreal64 $(O)t8 $(O)h $(O)o wreal64$(8H) $(O)e $(OCCOPT)

readline$(8H):	readline.occ hostio.inc splib.lib 
	$(OCCAM) readline $(O)t8 $(O)h $(O)o readline$(8H) $(O)e $(OCCOPT)

echoline$(8H):	echoline.occ hostio.inc splib.lib 
	$(OCCAM) echoline $(O)t8 $(O)h $(O)o echoline$(8H) $(O)e $(OCCOPT)

times$(8H):	times.occ hostio.inc splib.lib 
	$(OCCAM) times $(O)t8 $(O)h $(O)o times$(8H) $(O)e $(OCCOPT)


# x mode
# ta class
opentemp$(AX):	opentemp.occ hostio.inc splib.lib 
	$(OCCAM) opentemp $(O)ta $(O)x $(O)o opentemp$(AX) $(O)e $(OCCOPT)

exists$(AX):	exists.occ hostio.inc splib.lib 
	$(OCCAM) exists $(O)ta $(O)x $(O)o exists$(AX) $(O)e $(OCCOPT)

popen$(AX):	popen.occ hostio.inc splib.lib 
	$(OCCAM) popen $(O)ta $(O)x $(O)o popen$(AX) $(O)e $(OCCOPT)

parse$(AX):	parse.occ hostio.inc splib.lib 
	$(OCCAM) parse $(O)ta $(O)x $(O)o parse$(AX) $(O)e $(OCCOPT)

wstring$(AX):	wstring.occ hostio.inc splib.lib 
	$(OCCAM) wstring $(O)ta $(O)x $(O)o wstring$(AX) $(O)e $(OCCOPT)

fwstring$(AX):	fwstring.occ hostio.inc splib.lib 
	$(OCCAM) fwstring $(O)ta $(O)x $(O)o fwstring$(AX) $(O)e $(OCCOPT)

wint$(AX):	wint.occ hostio.inc splib.lib  
	$(OCCAM) wint $(O)ta $(O)x $(O)o wint$(AX) $(O)e $(OCCOPT)

whint$(AX):	whint.occ hostio.inc splib.lib  
	$(OCCAM) whint $(O)ta $(O)x $(O)o whint$(AX) $(O)e $(OCCOPT)

wint32$(AX):	wint32.occ hostio.inc splib.lib  
	$(OCCAM) wint32 $(O)ta $(O)x $(O)o wint32$(AX) $(O)e $(OCCOPT)

whint32$(AX):	whint32.occ hostio.inc splib.lib  
	$(OCCAM) whint32 $(O)ta $(O)x $(O)o whint32$(AX) $(O)e $(OCCOPT)

wint64$(AX):	wint64.occ hostio.inc splib.lib  
	$(OCCAM) wint64 $(O)ta $(O)x $(O)o wint64$(AX) $(O)e $(OCCOPT)

whint64$(AX):	whint64.occ hostio.inc splib.lib  
	$(OCCAM) whint64 $(O)ta $(O)x $(O)o whint64$(AX) $(O)e $(OCCOPT)

wreal32$(AX):	wreal32.occ hostio.inc splib.lib  
	$(OCCAM) wreal32 $(O)ta $(O)x $(O)o wreal32$(AX) $(O)e $(OCCOPT)

wreal64$(AX):	wreal64.occ hostio.inc splib.lib  
	$(OCCAM) wreal64 $(O)ta $(O)x $(O)o wreal64$(AX) $(O)e $(OCCOPT)

readline$(AX):	readline.occ hostio.inc splib.lib 
	$(OCCAM) readline $(O)ta $(O)x $(O)o readline$(AX) $(O)e $(OCCOPT)

echoline$(AX):	echoline.occ hostio.inc splib.lib 
	$(OCCAM) echoline $(O)ta $(O)x $(O)o echoline$(AX) $(O)e $(OCCOPT)

times$(AX):	times.occ hostio.inc splib.lib 
	$(OCCAM) times $(O)ta $(O)x $(O)o times$(AX) $(O)e $(OCCOPT)

# t8 class
opentemp$(8X):	opentemp.occ hostio.inc splib.lib 
	$(OCCAM) opentemp $(O)t8 $(O)x $(O)o opentemp$(8X) $(O)e $(OCCOPT)

exists$(8X):	exists.occ hostio.inc splib.lib 
	$(OCCAM) exists $(O)t8 $(O)x $(O)o exists$(8X) $(O)e $(OCCOPT)

popen$(8X):	popen.occ hostio.inc splib.lib 
	$(OCCAM) popen $(O)t8 $(O)x $(O)o popen$(8X) $(O)e $(OCCOPT)

parse$(8X):	parse.occ hostio.inc splib.lib 
	$(OCCAM) parse $(O)t8 $(O)x $(O)o parse$(8X) $(O)e $(OCCOPT)

wstring$(8X):	wstring.occ hostio.inc splib.lib 
	$(OCCAM) wstring $(O)t8 $(O)x $(O)o wstring$(8X) $(O)e $(OCCOPT)

fwstring$(8X):	fwstring.occ hostio.inc splib.lib 
	$(OCCAM) fwstring $(O)t8 $(O)x $(O)o fwstring$(8X) $(O)e $(OCCOPT)

wint$(8X):	wint.occ hostio.inc splib.lib  
	$(OCCAM) wint $(O)t8 $(O)x $(O)o wint$(8X) $(O)e $(OCCOPT)

whint$(8X):	whint.occ hostio.inc splib.lib  
	$(OCCAM) whint $(O)t8 $(O)x $(O)o whint$(8X) $(O)e $(OCCOPT)

wint32$(8X):	wint32.occ hostio.inc splib.lib  
	$(OCCAM) wint32 $(O)t8 $(O)x $(O)o wint32$(8X) $(O)e $(OCCOPT)

whint32$(8X):	whint32.occ hostio.inc splib.lib  
	$(OCCAM) whint32 $(O)t8 $(O)x $(O)o whint32$(8X) $(O)e $(OCCOPT)

wint64$(8X):	wint64.occ hostio.inc splib.lib  
	$(OCCAM) wint64 $(O)t8 $(O)x $(O)o wint64$(8X) $(O)e $(OCCOPT)

whint64$(8X):	whint64.occ hostio.inc splib.lib  
	$(OCCAM) whint64 $(O)t8 $(O)x $(O)o whint64$(8X) $(O)e $(OCCOPT)

wreal32$(8X):	wreal32.occ hostio.inc splib.lib  
	$(OCCAM) wreal32 $(O)t8 $(O)x $(O)o wreal32$(8X) $(O)e $(OCCOPT)

wreal64$(8X):	wreal64.occ hostio.inc splib.lib  
	$(OCCAM) wreal64 $(O)t8 $(O)x $(O)o wreal64$(8X) $(O)e $(OCCOPT)

readline$(8X):	readline.occ hostio.inc splib.lib 
	$(OCCAM) readline $(O)t8 $(O)x $(O)o readline$(8X) $(O)e $(OCCOPT)

echoline$(8X):	echoline.occ hostio.inc splib.lib 
	$(OCCAM) echoline $(O)t8 $(O)x $(O)o echoline$(8X) $(O)e $(OCCOPT)

times$(8X):	times.occ hostio.inc splib.lib 
	$(OCCAM) times $(O)t8 $(O)x $(O)o times$(8X) $(O)e $(OCCOPT)



solib.lib:	solib.lbb \
	opentemp$(AH) exists$(AH) popen$(AH) parse$(AH) wstring$(AH) wint$(AH) \
	whint$(AH) wint64$(AH) whint64$(AH) wreal32$(AH) wreal64$(AH) readline$(AH) \
	echoline$(AH) times$(AH) fwstring$(AH) \
	\
	opentemp$(AX) exists$(AX) popen$(AX) parse$(AX) wstring$(AX) wint$(AX) \
	whint$(AX) wint64$(AX) whint64$(AX) wreal32$(AX) wreal64$(AX) readline$(AX) \
	echoline$(AX) times$(AX) fwstring$(AX) \
	\
	\
	opentemp$(8H) exists$(8H) popen$(8H) parse$(8H) wstring$(8H) wint$(8H) \
	whint$(8H) wint64$(8H) whint64$(8H) wreal32$(8H) wreal64$(8H) readline$(8H) \
	echoline$(8H) times$(8H) fwstring$(8H) \
	\
	opentemp$(8X) exists$(8X) popen$(8X) parse$(8X) wstring$(8X) wint$(8X) \
	whint$(8X) wint64$(8X) whint64$(8X) wreal32$(8X) wreal64$(8X) readline$(8X) \
	echoline$(8X) times$(8X) fwstring$(8X)
	$(LIBRARIAN) $(O)f solib.lbb $(O)o solib.lib $(LIBOPT)

# h mode
# ta class
ask$(AH):	ask.occ hostio.inc splib.lib solib.lib 
	$(OCCAM) ask $(O)ta $(O)h $(O)o ask$(AH) $(O)e $(OCCOPT)

reint$(AH):	reint.occ hostio.inc solib.lib  
	$(OCCAM) reint $(O)ta $(O)h $(O)o reint$(AH) $(O)e $(OCCOPT)

rehint$(AH):	rehint.occ hostio.inc solib.lib  
	$(OCCAM) rehint $(O)ta $(O)h $(O)o rehint$(AH) $(O)e $(OCCOPT)

reaint$(AH):	reaint.occ hostio.inc solib.lib  
	$(OCCAM) reaint $(O)ta $(O)h $(O)o reaint$(AH) $(O)e $(OCCOPT)

reint32$(AH):	reint32.occ hostio.inc solib.lib  
	$(OCCAM) reint32 $(O)ta $(O)h $(O)o reint32$(AH) $(O)e $(OCCOPT)

rehint32$(AH):	rehint32.occ hostio.inc solib.lib  
	$(OCCAM) rehint32 $(O)ta $(O)h $(O)o rehint32$(AH) $(O)e $(OCCOPT)

reint64$(AH):	reint64.occ hostio.inc solib.lib  
	$(OCCAM) reint64 $(O)ta $(O)h $(O)o reint64$(AH) $(O)e $(OCCOPT)

rehint64$(AH):	rehint64.occ hostio.inc solib.lib  
	$(OCCAM) rehint64 $(O)ta $(O)h $(O)o rehint64$(AH) $(O)e $(OCCOPT)

rereal32$(AH):	rereal32.occ hostio.inc solib.lib  
	$(OCCAM) rereal32 $(O)ta $(O)h $(O)o rereal32$(AH) $(O)e $(OCCOPT)

rereal64$(AH):	rereal64.occ hostio.inc solib.lib  
	$(OCCAM) rereal64 $(O)ta $(O)h $(O)o rereal64$(AH) $(O)e $(OCCOPT)


# t8 class
ask$(8H):	ask.occ hostio.inc splib.lib solib.lib 
	$(OCCAM) ask $(O)t8 $(O)h $(O)o ask$(8H) $(O)e $(OCCOPT)

reint$(8H):	reint.occ hostio.inc solib.lib  
	$(OCCAM) reint $(O)t8 $(O)h $(O)o reint$(8H) $(O)e $(OCCOPT)

rehint$(8H):	rehint.occ hostio.inc solib.lib  
	$(OCCAM) rehint $(O)t8 $(O)h $(O)o rehint$(8H) $(O)e $(OCCOPT)

reaint$(8H):	reaint.occ hostio.inc solib.lib  
	$(OCCAM) reaint $(O)t8 $(O)h $(O)o reaint$(8H) $(O)e $(OCCOPT)

reint32$(8H):	reint32.occ hostio.inc solib.lib  
	$(OCCAM) reint32 $(O)t8 $(O)h $(O)o reint32$(8H) $(O)e $(OCCOPT)

rehint32$(8H):	rehint32.occ hostio.inc solib.lib  
	$(OCCAM) rehint32 $(O)t8 $(O)h $(O)o rehint32$(8H) $(O)e $(OCCOPT)

reint64$(8H):	reint64.occ hostio.inc solib.lib  
	$(OCCAM) reint64 $(O)t8 $(O)h $(O)o reint64$(8H) $(O)e $(OCCOPT)

rehint64$(8H):	rehint64.occ hostio.inc solib.lib  
	$(OCCAM) rehint64 $(O)t8 $(O)h $(O)o rehint64$(8H) $(O)e $(OCCOPT)

rereal32$(8H):	rereal32.occ hostio.inc solib.lib  
	$(OCCAM) rereal32 $(O)t8 $(O)h $(O)o rereal32$(8H) $(O)e $(OCCOPT)

rereal64$(8H):	rereal64.occ hostio.inc solib.lib  
	$(OCCAM) rereal64 $(O)t8 $(O)h $(O)o rereal64$(8H) $(O)e $(OCCOPT)


# x mode
# ta class
ask$(AX):	ask.occ hostio.inc splib.lib solib.lib 
	$(OCCAM) ask $(O)ta $(O)x $(O)o ask$(AX) $(O)e $(OCCOPT)

reint$(AX):	reint.occ hostio.inc solib.lib  
	$(OCCAM) reint $(O)ta $(O)x $(O)o reint$(AX) $(O)e $(OCCOPT)

rehint$(AX):	rehint.occ hostio.inc solib.lib  
	$(OCCAM) rehint $(O)ta $(O)x $(O)o rehint$(AX) $(O)e $(OCCOPT)

reaint$(AX):	reaint.occ hostio.inc solib.lib  
	$(OCCAM) reaint $(O)ta $(O)x $(O)o reaint$(AX) $(O)e $(OCCOPT)

reint32$(AX):	reint32.occ hostio.inc solib.lib  
	$(OCCAM) reint32 $(O)ta $(O)x $(O)o reint32$(AX) $(O)e $(OCCOPT)

rehint32$(AX):	rehint32.occ hostio.inc solib.lib  
	$(OCCAM) rehint32 $(O)ta $(O)x $(O)o rehint32$(AX) $(O)e $(OCCOPT)

reint64$(AX):	reint64.occ hostio.inc solib.lib  
	$(OCCAM) reint64 $(O)ta $(O)x $(O)o reint64$(AX) $(O)e $(OCCOPT)

rehint64$(AX):	rehint64.occ hostio.inc solib.lib  
	$(OCCAM) rehint64 $(O)ta $(O)x $(O)o rehint64$(AX) $(O)e $(OCCOPT)

rereal32$(AX):	rereal32.occ hostio.inc solib.lib  
	$(OCCAM) rereal32 $(O)ta $(O)x $(O)o rereal32$(AX) $(O)e $(OCCOPT)

rereal64$(AX):	rereal64.occ hostio.inc solib.lib  
	$(OCCAM) rereal64 $(O)ta $(O)x $(O)o rereal64$(AX) $(O)e $(OCCOPT)


# t8 class
ask$(8X):	ask.occ hostio.inc splib.lib solib.lib 
	$(OCCAM) ask $(O)t8 $(O)x $(O)o ask$(8X) $(O)e $(OCCOPT)

reint$(8X):	reint.occ hostio.inc solib.lib  
	$(OCCAM) reint $(O)t8 $(O)x $(O)o reint$(8X) $(O)e $(OCCOPT)

rehint$(8X):	rehint.occ hostio.inc solib.lib  
	$(OCCAM) rehint $(O)t8 $(O)x $(O)o rehint$(8X) $(O)e $(OCCOPT)

reaint$(8X):	reaint.occ hostio.inc solib.lib  
	$(OCCAM) reaint $(O)t8 $(O)x $(O)o reaint$(8X) $(O)e $(OCCOPT)

reint32$(8X):	reint32.occ hostio.inc solib.lib  
	$(OCCAM) reint32 $(O)t8 $(O)x $(O)o reint32$(8X) $(O)e $(OCCOPT)

rehint32$(8X):	rehint32.occ hostio.inc solib.lib  
	$(OCCAM) rehint32 $(O)t8 $(O)x $(O)o rehint32$(8X) $(O)e $(OCCOPT)

reint64$(8X):	reint64.occ hostio.inc solib.lib  
	$(OCCAM) reint64 $(O)t8 $(O)x $(O)o reint64$(8X) $(O)e $(OCCOPT)

rehint64$(8X):	rehint64.occ hostio.inc solib.lib  
	$(OCCAM) rehint64 $(O)t8 $(O)x $(O)o rehint64$(8X) $(O)e $(OCCOPT)

rereal32$(8X):	rereal32.occ hostio.inc solib.lib  
	$(OCCAM) rereal32 $(O)t8 $(O)x $(O)o rereal32$(8X) $(O)e $(OCCOPT)

rereal64$(8X):	rereal64.occ hostio.inc solib.lib  
	$(OCCAM) rereal64 $(O)t8 $(O)x $(O)o rereal64$(8X) $(O)e $(OCCOPT)


# Extra rules normally achieved by pattern matching

buffer$(AH): buffer.occ
	$(OCCAM) buffer  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o buffer$(AH)

buffer$(AX): buffer.occ
	$(OCCAM) buffer  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o buffer$(AX)

buffer$(8H): buffer.occ
	$(OCCAM) buffer  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o buffer$(8H)

buffer$(8X): buffer.occ
	$(OCCAM) buffer  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o buffer$(8X)

close$(AH): close.occ
	$(OCCAM) close  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o close$(AH)

close$(AX): close.occ
	$(OCCAM) close  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o close$(AX)

close$(8H): close.occ
	$(OCCAM) close  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o close$(8H)

close$(8X): close.occ
	$(OCCAM) close  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o close$(8X)

command$(AH): command.occ
	$(OCCAM) command  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o command$(AH)

command$(AX): command.occ
	$(OCCAM) command  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o command$(AX)

command$(8H): command.occ
	$(OCCAM) command  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o command$(8H)

command$(8X): command.occ
	$(OCCAM) command  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o command$(8X)

core$(AH): core.occ
	$(OCCAM) core  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o core$(AH)

core$(AX): core.occ
	$(OCCAM) core  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o core$(AX)

core$(8H): core.occ
	$(OCCAM) core  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o core$(8H)

core$(8X): core.occ
	$(OCCAM) core  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o core$(8X)

eof$(AH): eof.occ
	$(OCCAM) eof  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o eof$(AH)

eof$(AX): eof.occ
	$(OCCAM) eof  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o eof$(AX)

eof$(8H): eof.occ
	$(OCCAM) eof  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o eof$(8H)

eof$(8X): eof.occ
	$(OCCAM) eof  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o eof$(8X)

exit$(AH): exit.occ
	$(OCCAM) exit  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o exit$(AH)

exit$(AX): exit.occ
	$(OCCAM) exit  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o exit$(AX)

exit$(8H): exit.occ
	$(OCCAM) exit  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o exit$(8H)

exit$(8X): exit.occ
	$(OCCAM) exit  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o exit$(8X)

ferror$(AH): ferror.occ
	$(OCCAM) ferror  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o ferror$(AH)

ferror$(AX): ferror.occ
	$(OCCAM) ferror  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o ferror$(AX)

ferror$(8H): ferror.occ
	$(OCCAM) ferror  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o ferror$(8H)

ferror$(8X): ferror.occ
	$(OCCAM) ferror  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o ferror$(8X)

flush$(AH): flush.occ
	$(OCCAM) flush  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o flush$(AH)

flush$(AX): flush.occ
	$(OCCAM) flush  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o flush$(AX)

flush$(8H): flush.occ
	$(OCCAM) flush  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o flush$(8H)

flush$(8X): flush.occ
	$(OCCAM) flush  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o flush$(8X)

getenv$(AH): getenv.occ
	$(OCCAM) getenv  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o getenv$(AH)

getenv$(AX): getenv.occ
	$(OCCAM) getenv  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o getenv$(AX)

getenv$(8H): getenv.occ
	$(OCCAM) getenv  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o getenv$(8H)

getenv$(8X): getenv.occ
	$(OCCAM) getenv  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o getenv$(8X)

getkey$(AH): getkey.occ
	$(OCCAM) getkey  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o getkey$(AH)

getkey$(AX): getkey.occ
	$(OCCAM) getkey  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o getkey$(AX)

getkey$(8H): getkey.occ
	$(OCCAM) getkey  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o getkey$(8H)

getkey$(8X): getkey.occ
	$(OCCAM) getkey  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o getkey$(8X)

gets$(AH): gets.occ
	$(OCCAM) gets  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o gets$(AH)

gets$(AX): gets.occ
	$(OCCAM) gets  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o gets$(AX)

gets$(8H): gets.occ
	$(OCCAM) gets  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o gets$(8H)

gets$(8X): gets.occ
	$(OCCAM) gets  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o gets$(8X)

mux$(AH): mux.occ
	$(OCCAM) mux  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o mux$(AH)

mux$(AX): mux.occ
	$(OCCAM) mux  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o mux$(AX)

mux$(8H): mux.occ
	$(OCCAM) mux  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o mux$(8H)

mux$(8X): mux.occ
	$(OCCAM) mux  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o mux$(8X)

open$(AH): open.occ
	$(OCCAM) open  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o open$(AH)

open$(AX): open.occ
	$(OCCAM) open  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o open$(AX)

open$(8H): open.occ
	$(OCCAM) open  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o open$(8H)

open$(8X): open.occ
	$(OCCAM) open  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o open$(8X)

ovbuffer$(AH): ovbuffer.occ
	$(OCCAM) ovbuffer  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o ovbuffer$(AH)

ovbuffer$(AX): ovbuffer.occ
	$(OCCAM) ovbuffer  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o ovbuffer$(AX)

ovbuffer$(8H): ovbuffer.occ
	$(OCCAM) ovbuffer  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o ovbuffer$(8H)

ovbuffer$(8X): ovbuffer.occ
	$(OCCAM) ovbuffer  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o ovbuffer$(8X)

ovmux$(AH): ovmux.occ
	$(OCCAM) ovmux  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o ovmux$(AH)

ovmux$(AX): ovmux.occ
	$(OCCAM) ovmux  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o ovmux$(AX)

ovmux$(8H): ovmux.occ
	$(OCCAM) ovmux  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o ovmux$(8H)

ovmux$(8X): ovmux.occ
	$(OCCAM) ovmux  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o ovmux$(8X)

ovprimux$(AH): ovprimux.occ
	$(OCCAM) ovprimux  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o ovprimux$(AH)

ovprimux$(AX): ovprimux.occ
	$(OCCAM) ovprimux  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o ovprimux$(AX)

ovprimux$(8H): ovprimux.occ
	$(OCCAM) ovprimux  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o ovprimux$(8H)

ovprimux$(8X): ovprimux.occ
	$(OCCAM) ovprimux  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o ovprimux$(8X)

packet$(AH): packet.occ
	$(OCCAM) packet  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o packet$(AH)

packet$(AX): packet.occ
	$(OCCAM) packet  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o packet$(AX)

packet$(8H): packet.occ
	$(OCCAM) packet  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o packet$(8H)

packet$(8X): packet.occ
	$(OCCAM) packet  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o packet$(8X)

pollkey$(AH): pollkey.occ
	$(OCCAM) pollkey  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o pollkey$(AH)

pollkey$(AX): pollkey.occ
	$(OCCAM) pollkey  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o pollkey$(AX)

pollkey$(8H): pollkey.occ
	$(OCCAM) pollkey  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o pollkey$(8H)

pollkey$(8X): pollkey.occ
	$(OCCAM) pollkey  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o pollkey$(8X)

primux$(AH): primux.occ
	$(OCCAM) primux  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o primux$(AH)

primux$(AX): primux.occ
	$(OCCAM) primux  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o primux$(AX)

primux$(8H): primux.occ
	$(OCCAM) primux  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o primux$(8H)

primux$(8X): primux.occ
	$(OCCAM) primux  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o primux$(8X)

puts$(AH): puts.occ
	$(OCCAM) puts  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o puts$(AH)

puts$(AX): puts.occ
	$(OCCAM) puts  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o puts$(AX)

puts$(8H): puts.occ
	$(OCCAM) puts  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o puts$(8H)

puts$(8X): puts.occ
	$(OCCAM) puts  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o puts$(8X)

remove$(AH): remove.occ
	$(OCCAM) remove  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o remove$(AH)

remove$(AX): remove.occ
	$(OCCAM) remove  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o remove$(AX)

remove$(8H): remove.occ
	$(OCCAM) remove  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o remove$(8H)

remove$(8X): remove.occ
	$(OCCAM) remove  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o remove$(8X)

rename$(AH): rename.occ
	$(OCCAM) rename  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o rename$(AH)

rename$(AX): rename.occ
	$(OCCAM) rename  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o rename$(AX)

rename$(8H): rename.occ
	$(OCCAM) rename  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o rename$(8H)

rename$(8X): rename.occ
	$(OCCAM) rename  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o rename$(8X)

seek$(AH): seek.occ
	$(OCCAM) seek  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o seek$(AH)

seek$(AX): seek.occ
	$(OCCAM) seek  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o seek$(AX)

seek$(8H): seek.occ
	$(OCCAM) seek  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o seek$(8H)

seek$(8X): seek.occ
	$(OCCAM) seek  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o seek$(8X)

spread$(AH): spread.occ
	$(OCCAM) spread  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o spread$(AH)

spread$(AX): spread.occ
	$(OCCAM) spread  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o spread$(AX)

spread$(8H): spread.occ
	$(OCCAM) spread  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o spread$(8H)

spread$(8X): spread.occ
	$(OCCAM) spread  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o spread$(8X)

spwrite$(AH): spwrite.occ
	$(OCCAM) spwrite  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o spwrite$(AH)

spwrite$(AX): spwrite.occ
	$(OCCAM) spwrite  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o spwrite$(AX)

spwrite$(8H): spwrite.occ
	$(OCCAM) spwrite  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o spwrite$(8H)

spwrite$(8X): spwrite.occ
	$(OCCAM) spwrite  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o spwrite$(8X)

system$(AH): system.occ
	$(OCCAM) system  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o system$(AH)

system$(AX): system.occ
	$(OCCAM) system  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o system$(AX)

system$(8H): system.occ
	$(OCCAM) system  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o system$(8H)

system$(8X): system.occ
	$(OCCAM) system  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o system$(8X)

tell$(AH): tell.occ
	$(OCCAM) tell  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o tell$(AH)

tell$(AX): tell.occ
	$(OCCAM) tell  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o tell$(AX)

tell$(8H): tell.occ
	$(OCCAM) tell  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o tell$(8H)

tell$(8X): tell.occ
	$(OCCAM) tell  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o tell$(8X)

time$(AH): time.occ
	$(OCCAM) time  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o time$(AH)

time$(AX): time.occ
	$(OCCAM) time  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o time$(AX)

time$(8H): time.occ
	$(OCCAM) time  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o time$(8H)

time$(8X): time.occ
	$(OCCAM) time  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o time$(8X)

version$(AH): version.occ
	$(OCCAM) version  $(O)h $(O)ta $(O)e $(OCCOPT) $(O)o version$(AH)

version$(AX): version.occ
	$(OCCAM) version  $(O)x $(O)ta $(O)e $(OCCOPT) $(O)o version$(AX)

version$(8H): version.occ
	$(OCCAM) version  $(O)h $(O)t8 $(O)e $(OCCOPT) $(O)o version$(8H)

version$(8X): version.occ
	$(OCCAM) version  $(O)x $(O)t8 $(O)e $(OCCOPT) $(O)o version$(8X)


