/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Network loader functions
||@(#)   System : DLOADER
||@(#) Filename : netload.c
||@(#)  Version : 2.1
\*@(#)====================================================*/
/*}}}*/


#include <stdlib.h>
#include <stdio.h>

#include "net.h"
#include "neterr.h"

static char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC  void ResetNode*/
PUBLIC void ResetNode(NODE *node, int id)
{
  int f ;

  node->id = id ;
  for (f=0;f<UPR_num_links;f++)
  {
    node->son[f] = dangling ;
    node->link_type[f] = invalid ;
  }    
  node->proc_type = 0 ;
  node->mem_size=0 ;
}
/*}}}*/
/*{{{  PUBLIC  int  NodeInTree*/
PUBLIC int NodeInTree(NODE **nodes, NODE *node, int id)
{
  int result = -1 ;
  int s ;

  for (s=0;s<UPR_num_links;s++)
    if (node->son[s] != dangling)
    {
      if (nodes[node->son[s]]->id == id)
      {
        result = s ;
        break ;
      }
      else
      {
        result = NodeInTree(nodes, nodes[node->son[s]], id) ;
        if (result != -1)
        {
          result = s ;
          break ;
        }
      }
    }

  return(result) ;
}  
/*}}}*/

/*{{{  PRIVATE void SendNodeTree*/
PRIVATE void SendNodeTree(Channel *to_node, NODE **nodes, NODE *node)
{
  int  s ;

  ChanOutInt (to_node, tree_node) ;
  ChanOut    (to_node, node, sizeof(NODE)) ;
  
  for (s=0;s<UPR_num_links;s++)
    if (node->son[s] != dangling)
    {
      #ifdef UPR_DEBUG
      printf("Sending node %d : parent %d, link %d\n", nodes[node->son[s]]->id, node->id, s) ;
      #endif

      SendNodeTree(to_node, nodes, nodes[node->son[s]]) ;
    }
}    
/*}}}*/
/*{{{  PRIVATE void NodeLoader*/
PRIVATE void NodeLoader (Process *p, Channel *to_node, Channel *from_node,
                         NODE **nodes, NODE *node, int num_nodes,
                         int kernel_size, BYTE *kernel_buffer)

{
  int sync ;
  p=p ;

  #ifdef UPR_DEBUG
  printf("Sending program\n") ;
  #endif
  ChanOut(to_node, kernel_buffer, kernel_size) ;

  #ifdef UPR_DEBUG
  printf("Sending info\n") ;
  #endif

  ChanOutInt(to_node, num_nodes) ;
  ChanOutInt(to_node, kernel_size) ;

  SendNodeTree(to_node, nodes, node) ;

  ChanOutInt(to_node, tree_done) ;           /* Terminator */

  /*{{{  send kernel if not barren*/
  {
    BOOL barren = TRUE ;
    int s ;
  
    for (s=0;s<UPR_num_links;s++)
      if (node->son[s] != dangling) barren = FALSE ;
  
    if (!barren)
    {      
      #ifdef UPR_DEBUG
      printf("Sending kernel\n") ;
      #endif
      ChanOut(to_node, kernel_buffer, kernel_size) ;
    }
  }
  /*}}}*/
  
  #ifdef UPR_DEBUG
  printf("Syncing\n") ;
  #endif
  sync = ChanInInt (from_node) ;
}
/*}}}*/
/*{{{  PUBLIC  void NetworkLoader*/
PUBLIC void NetworkLoader (Channel **raw_out, Channel **raw_in, NODE **nodes, NODE *node,
                           int num_nodes, int kernel_size, BYTE *kernel_buffer)
{
  int f ;
  int pcount = 0;
  Process *p[5] ;
  
  for (f=0;f<UPR_num_links;f++)
    if (node->son[f] != dangling)
    {
      if ((p[pcount++] = ProcAlloc(NodeLoader, 0, 7, raw_out[f], raw_in[f], nodes, nodes[node->son[f]],
                                   num_nodes, kernel_size, kernel_buffer)) == NULL)
        LoadError (_FILE_, __LINE__, "Out of heap space") ;
    }

  if (pcount != 0)
  {
    p[pcount] = NULL ;
    ProcParList(p) ;
  }

  for (f=pcount-1;f>=0;f--)
    ProcAllocClean(p[f]) ;
}
/*}}}*/

