/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Network loader error function
||@(#)   System : NET
||@(#) Filename : neterr.c
||@(#)  Version : 2.1
||@(#)     Date : 6/19/91
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>

#include "net.h"

/************************************/
/* Error Handler for Network Loader */
/************************************/

/*{{{  PUBLIC void LoadError( char file[], int line, char msg[] )*/
PUBLIC void LoadError( char file[], int line, char msg[] )
{
  #ifdef UPR_RD
  ProcSetError();
  #else
  fprintf(stderr,"Fatal-netloader-%s(%0d) %s\n",file,line,msg);
  exit_terminate( EXIT_FAILURE );
  #endif
  ProcSleep();
}
/*}}}*/
  

