/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual processor interface
||@(#)   System : VPI
||@(#) Filename : vpi.h
||@(#)  Version : 1.11
||@(#)     Date : 6/16/92
\*@(#)====================================================*/
/*}}}*/

/*{{{  defines*/
#ifndef PRIVATE
#define PRIVATE static
#define PUBLIC
#define EXTERN extern
#endif
/*}}}*/

#ifndef __vpi_h
#define __vpi_h

EXTERN void Error (char file[], int line, char msg[]) ;

#include "threads.h"

EXTERN int  NumProcs (void) ;
EXTERN int  ProcId   (void) ;

EXTERN int  GrantService(void);
EXTERN int  ServerIn    (void *message, int length);
EXTERN void ServerOut   (void *message, int length);
EXTERN void EndService  (void);

EXTERN void ClaimChannel  (int target);
EXTERN void ClientOut     (int target, void *message, int length);
EXTERN int  ClientIn      (int target, void *message, int length);
EXTERN void ReleaseChannel(int target);

typedef void *VC ;

typedef struct
{
  int  proc ;
  int  port_in ;
  int  port_out ;
  VC   vc ;
} VCE ;

EXTERN int  NewVCE     (VCE *vce) ;
EXTERN void ConnectVCE (VCE *source, VCE *destn) ;
EXTERN VC   GetVC      (VCE *vce) ;
EXTERN void FreeVC     (VC vc) ;

EXTERN void Send (VC vc, void *message, int length) ;
EXTERN int  Recv (VC vc, void *message, int length) ;

EXTERN int *Children(void) ;
EXTERN int  Parent  (void) ;
#endif
