/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual channel interface
||@(#)   System : VCR
||@(#) Filename : virtual.h
||@(#)  Version : 2.2
\*@(#)====================================================*/
/*}}}*/

/*{{{  COMMENT*/
/* This header file defines the interface between VCR and dynamically
   loaded applications code. Note that some function names are
   overloaded and invoke different calls within VCR and within
   applications; in the latter case an extra layer of procedure call
   is necessary to correct the global statics pointer.

   All routines referenced here should be valid when called from both
   LO and HI priorities. */  
/*}}}*/

/*{{{  Module visibility predefines*/
#ifndef PUBLIC
#define PUBLIC
#define PRIVATE static
#define EXTERN  extern
#endif
/*}}}*/

/*{{{  Structure prototypes*/
typedef struct VCB VCB ;
typedef struct SCDB SCDB ;
typedef struct PBLOCK PBLOCK ;
/*}}}*/
   
/*{{{  Virtual channels library calls*/
EXTERN void VChanIn      (VCB *c, void *message, int length) ;
EXTERN char VChanInChar  (VCB *c) ;
EXTERN int  VChanInInt   (VCB *c) ;

EXTERN void VChanOut     (VCB *c, void *message, int length) ;
EXTERN void VChanOutChar (VCB *c, char ch) ;
EXTERN void VChanOutInt  (VCB *c, int i) ;
/*}}}*/

/*{{{  Miscellaneous system calls*/
EXTERN void HostHook  (VCB *fs, VCB *ts, VCB *stopper) ;

#define UPR_warning (0)
#define UPR_error   (1)
#define UPR_fatal   (2)
EXTERN void Exception (int severity, char file[], int line, char msg[]) ;

EXTERN void *Malloc (int size) ;
EXTERN void Free (void *pointer) ;

EXTERN char *DeviceInfo(int id) ;
/*}}}*/

/*{{{  RPC library calls*/
EXTERN SCDB* RPC_FindCode    (char *filename) ;
EXTERN SCDB* RPC_LoadCode    (char *filename) ;

EXTERN PBLOCK *RPC_InitCall  (int target, int num_chans, int num_ptrs, int num_vals, int data_size) ;
EXTERN void RPC_PlacedRun    (PBLOCK *pb, char *filename) ;
EXTERN void RPC_DoneCall     (PBLOCK *pb) ;

EXTERN void RPC_NewChannel     (VCB **local_out, VCB **local_in) ;
EXTERN void RPC_DisposeChannel (VCB *local_out,  VCB *local_in) ;

EXTERN int  RPC_ProcId (void) ;
EXTERN int  RPC_NumProcs (void) ;
EXTERN int  RPC_RandomProc(void) ;
EXTERN void RPC_PassByValue  (PBLOCK *pb, int value) ;
EXTERN void RPC_PassValByRef (PBLOCK *pb, char *pointer, int num_bytes) ;
EXTERN void RPC_PassVarByRef (PBLOCK *pb, char *pointer, int num_bytes) ;
EXTERN void RPC_PassChannel  (PBLOCK *pblock, VCB *channel) ;
EXTERN void RPC_PassChannelArray (PBLOCK *pblock, VCB **channel, int num_chans) ;
EXTERN void RPC_Target (PBLOCK *pblock, int target) ;
/*}}}*/

/*{{{  Low-level calls to DVC routines*/
EXTERN VCB *DVC_MoveChannel (int target, VCB *c) ;
EXTERN void DVC_ReturnChannel     (VCB *c) ;
EXTERN void DVC_CreateChannelOut  (VCB **local_out, VCB **remote_in, int remote);
EXTERN void DVC_CreateChannelIn   (VCB **local_in, VCB **remote_out, int remote);
EXTERN void DVC_DestroyChannelEnd (VCB *c);
/*}}}*/

/*{{{  VCR 1.8 RPC interface calls retained for compatability*/
EXTERN void RPC_MoveChannel  (PBLOCK *pblock, VCB *local_chan, VCB **remote_chan) ;
EXTERN void RPC_ReturnData   (PBLOCK *pb, char *pointer, int num_bytes) ;
EXTERN void RPC_SkipData     (PBLOCK *pb, int num_bytes) ;
/*}}}*/
