/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual channel systems definitions
||@(#)   System : VCR
||@(#) Filename : vcr.h
||@(#)  Version : 2.14
\*@(#)====================================================*/
/*}}}*/


/*******************/
/* VCR Header File */
/*******************/

#include <process.h>
#include <channel.h>
#include <semaphor.h>

#include "upri.h"
#include "virtual.h"

#define min(a,b)        ((a<b) ? a : b )
#define max(a,b)        ((a>b) ? a : b )

#define virtual_bit 1
#define virtual_mask (-2)

/*{{{  channel state flags*/
#define AckWaiting_p    (Channel)( -6)
#define InputWaiting_p  (Channel)( -5)
/*}}}*/

typedef struct DCB DCB ;

/*{{{  typedef struct VCB : Generic virtual channel block*/
struct VCB
{
  Channel id ;
  PORT    *port ;
  ORB     orb ;
  DCB     *dcb ;
  BYTE    *buffer ;
} ;
/*}}}*/

/*{{{  typedef struct OQB         : Output Queue Block*/
typedef struct 
{
  ORB *h ;
  ORB *t ;
}
OQB ;
       
/*}}}*/
/*{{{  typedef struct LOLB        : Local output link block*/
typedef struct
{
  OQB   oqb ;
  BOOL  active ;
  WDESC wdesc ;
}
LOLB ;
/*}}}*/
/*{{{  typedef struct PORT_ADDR   : Port address*/
typedef struct
{
  int proc ;
  int port ;
} PORT_ADDR ;
/*}}}*/
/*{{{  typedef struct DUPLEX_ID   : Port id pair*/
typedef struct
{
  int in ;
  int out ;
} DUPLEX_ID ;
/*}}}*/
/*{{{  typedef struct DUPLEX_VC   : Virtual channel pair*/
typedef struct
{
  VCB *in ;
  VCB *out ;
} DUPLEX_VC ;
/*}}}*/
/*{{{  typedef struct PCRB        : Process Collector request block*/
typedef struct PCRB PCRB ;
struct PCRB
{
  PCRB    *next ;
  Process *p ;
} ;
/*}}}*/
/*{{{  typedef struct PCQB        : Process Collector queue block*/
typedef struct
{
  PCRB   *h ;
  PCRB   *t ;
  WDESC  wdesc ;
} PCQB ;  
/*}}}*/
/*{{{  typedef struct PPROC       : Physical processor block*/
typedef struct
{
  int pproc_id ;                 /* physical processor id       */
  DUPLEX_VC vc ;                 /* virtual channel connection  */
  int depth ;                    /* depth of virtual processors */
  int count ;                    /* number of associated ports  */
  int base ;                     /* base of associated ports    */
  int max_ports ;                /* max virtual processor ports */
} PPROC ;
/*}}}*/
/*{{{  typedef struct VPROC       : Virtual processor block*/
typedef struct VPROC VPROC ;
struct VPROC
{
  VPROC *list ;                  /* list of virtual processors  */
  PPROC *pproc ;                 /* associated physical proc    */
  int vproc_id ;                 /* virtual processor id        */
  int num_in_chans ;             /* number of in channel ends   */
  int num_out_chans ;            /* number of out channel ends  */
  int base ;                     /* base of associated ports    */
} ;
/*}}}*/
/*{{{  typedef struct VFUNC       : Exposed C functions block*/
typedef struct
{
  void (*VirtualIn)() ;
  void (*VirtualOut)() ;
  void *(*malloc)() ;
  void (*free)() ;
  void (*HostHook)() ;
  void (*Exception)() ;
  void (*RPC_PlacedRun)() ;
  SCDB *(*RPC_FindCode)() ;
  SCDB *(*RPC_LoadCode)() ;
  VCB  *(*DVC_MoveChannel)() ;
  void (*DVC_ReturnChannel)() ;
  void (*DVC_CreateChannelOut)() ;
  void (*DVC_CreateChannelIn)() ;
  void (*DVC_DestroyChannelEnd)() ;
} VFUNC ;
/*}}}*/
/*{{{  typedef struct DEVICE      : VCR device details*/
typedef struct
{
  int user_id ;
  int physical_id ;
  BOOL wrap;
  char *info;
} DEVICE ;
/*}}}*/

/*{{{  parameter passing*/
#define min_params 3
#define couple 2

/* fields in the parameter block */
#define params_f   0
#define vardata_f  1
#define valdata_f  2
#define relocs_f   3
#define chans_f    4
#define varptrs_f  5
#define end_f      6
#define num_fields 7

#define FIELD_DIR(f) ((f==valdata_f) ? -1 : 1)

#define no_move 0
#define implicit_move 1
#define explicit_move 2

#define old_ret 0
#define new_ret 1

#define iptr_size 1    /* in words */

/*{{{  typedef struct FIELD*/
typedef struct
{
  int start ;
  int current ;
} FIELD ;
/*}}}*/
/*{{{  struct PBLOCK*/
struct PBLOCK
{
  int *pb ;
  int target ;
  BYTE move ;
  BYTE ret ;
  FIELD field[num_fields] ;
} ;
/*}}}*/
/*}}}*/
/*{{{  server and VCR control mechanism*/
/*{{{  server modes*/
typedef enum {svr_pproc, svr_rpc, load_code, svr_test} SVR_MODE ;
/*}}}*/

typedef enum {input_d, output_d, neuter_d} DIRECTION;

/*{{{  VCR control channel tags*/
typedef enum{empty_ctrl, svr_request, svr_reply, dvc_request, dvc_reply,
             dvc_offload, dvc_doneend, dvc_point, dvc_moved, dvc_dualmove, dvc_retryoffload } CTRL_TAG ;
/*}}}*/
/*{{{  define parameters for each tag*/
#define ctrl_pkt_ovrhd sizeof(CTRL_TAG)

typedef struct
{
  int       src_proc_id ;
  int       src_port_id ;
  DUPLEX_ID src ;
  SVR_MODE  svr_mode ;
} SVR_REQUEST ;

typedef struct
{
  DUPLEX_ID dst ;
} SVR_REPLY ;  

typedef struct
{
  DIRECTION way;
  int       port_id;
  int       proc_id;
} DVC_REQUEST ;

typedef struct
{
  int port_id;
  int src_port_id;
  VCB *vc_ptr;
} DVC_REPLY ;

typedef struct
{
  int    dst_c ;
  DIRECTION make_way ;
  int    src_p ;
  int    src_c ;
  int    other_p ;
  int    other_c ;
} DVC_OFFLOAD ;

typedef struct
{
  int    src_c ;
  int    dst_p ;
  int    dst_c ;
  VCB    *vcb ;
} DVC_DONEEND ;

typedef struct
{
  int     other_c ;
  int     dst_p ;
  int     dst_c ;
} DVC_POINT ;

typedef struct
{
  int     src_c ;
} DVC_MOVED ;

typedef struct
{
  int     dst_c ;
  int     newother_p ;
  int     newother_c ;
} DVC_DUALMOVE ;

typedef struct
{
  int     dst_c ;
  int     newother_p ;
  int     newother_c ;
} DVC_RETRYOFFLOAD ;

/*}}}*/
/*{{{  define VCR control packet*/
typedef union
{
  SVR_REQUEST svr_request ;
  SVR_REPLY   svr_reply ;
  DVC_REQUEST dvc_request;
  DVC_REPLY   dvc_reply;
  DVC_OFFLOAD dvc_offload;
  DVC_DONEEND dvc_doneend;
  DVC_POINT   dvc_point;
  DVC_MOVED   dvc_moved;
  DVC_DUALMOVE dvc_dualmove;
  DVC_RETRYOFFLOAD dvc_retryoffload;
} CTRL_PARAMS ;

typedef struct
{
  CTRL_TAG tag ;
  CTRL_PARAMS p ; 
} VCR_CTRL_PKT;

#define num_ctrl_pkts  (UPR_MAX_CONCURRENT_READS+1)
/*}}}*/


/*{{{  DVC descriptions*/
/*{{{  dynamic channel protocols*/
typedef union
{
  DVC_REQUEST dvc_request;
  DVC_REPLY   dvc_reply;
  DVC_OFFLOAD dvc_offload;
  DVC_DONEEND dvc_doneend;
  DVC_POINT   dvc_point;
  DVC_MOVED   dvc_moved;
  DVC_DUALMOVE dvc_dualmove;
  DVC_RETRYOFFLOAD dvc_retryoffload;
} DCP_PARAMS ;

typedef struct
{
  CTRL_TAG    tag;
  DCP_PARAMS  p;
} DCP ;

/*}}}*/

typedef enum {dvc_free,dvc_ready,dvc_finding,dvc_gone,dvc_retry,dvc_moving} DVC_STATE ;
#define NULL_HEAD_L 1
#define VALID_HEAD_L 0
/*{{{  typedef struct DCB : Dynamic channel block*/
struct DCB
{
  DVC_STATE state ;
  WDESC restart ;
  HEADER other ;
  HEADER parent ;
  HEADER child ;
  ORB orb ;
  DCP dcp ;
  ORB dm_orb ;
  DCP dm_dcp ;
} ;
/*}}}*/
/*}}}*/

/*{{{  typedef struct SVR_STATE*/
typedef struct
{
  WDESC        restart_id ;
  VCR_CTRL_PKT *ctrl_pkt ;
} SVR_STATE ;  
/*}}}*/
/*{{{  server operations*/
EXTERN void VCR_LaunchServer ( DUPLEX_VC *,    /* vc         */
                               int,            /* destn_proc */
                               SVR_MODE ) ;    /* svr_mode   */
/*}}}*/

#define SVR_wspace_size 2000
/*}}}*/
/*{{{  code parsing */
/*{{{  flags and constants*/
#define PARSE_FAILED (1)
#define PARSE_PROCEEDING (0)
#define PARSE_SUCCEEDED  (2)
#define PARSE_COMPLETED  (3)

/* Buffer sizes in bytes*/
#define INIT_CODE_BUFFER  100000
#define STATIC_CODE_BUFFER 10000
/*}}}*/

typedef enum {halt, stop, universal} ERR_MODE ;

/*{{{  typedef struct CBB   Code Buffer Block*/
typedef struct CBB CBB;
struct CBB
{
  char* base ;
  int index ;
  int size ;
};

/*}}}*/
/*{{{  typedef struct PDB   Patch Descriptor Block*/
typedef struct PDB PDB ;
struct PDB
{
  PDB* next ;
  char* symbol;
  char* filename;
  int   offset;
} ;
/*}}}*/
/*{{{  typedef struct SCDB  SC decriptor block*/
struct SCDB
{
  SCDB* next ;
  int   size;
  int   wsp_size;
  int   vsp_size;
  int   ep_offset;
  int   code_size;
  char* filename;
  char* code;
  PDB*  patch;
  char* symbol;
  ERR_MODE err_mode ;
  int   static_size ;
};
/*}}}*/
/*{{{  typedef struct CRB   Code Request BLOCK*/
typedef struct CRB CRB ;
struct CRB
{
  CRB*  next ;
  WDESC wdesc ;
  char* name;
  SCDB* scdb ;
};
/*}}}*/
/*{{{  typedef struct CQB   Code Queue Block*/
typedef struct 
{
  CRB* h;
  CRB* t;
  WDESC wdesc;
} CQB;    
/*}}}*/
/*}}}*/

/*{{{  typedef struct VTHREAD     : Virtual processor thread*/
typedef struct
{
  Process *p ;
  SCDB    *scdb ;
  Channel **chan_ins ;
  Channel **chan_outs ;
  int     *vecspace ;
} VTHREAD ;
/*}}}*/
/*{{{  typedef struct VCR_GLOBALS : VCR globals structure*/
typedef struct
{
  int  proc_id ;
  int  num_nodes ;
  int  dummy ;
  void *gsb ;
  VFUNC vfunc ;
  CQB  cqb ;
  SCDB *scdb_stack ;
  PCQB pcqb ;
  LOLB lolb ;
  int seed ;
  int num_devices ;
  int num_devices_wow ;
  DEVICE *devices ;
  ERR_MODE err_mode ;
  int    user_argc ;
  char **user_argv ;
  Semaphore iolock ;
  int  vcr_ctrl_port_id ;
} VCR_GLOBALS ;  
/*}}}*/

/*{{{  make VCR globals visible to all modules*/
EXTERN VCR_GLOBALS vcr_globals ;
/*}}}*/

/*{{{  miscellaneous function definitions*/
EXTERN int VCR_processor_mapping (int vproc_id) ;
EXTERN int shift_register (int *seed) ;
/*}}}*/

