/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Universal Packet Router Interface
||@(#)   System : UPR
||@(#) Filename : upri.h
||@(#)  Version : 2.9
\*@(#)====================================================*/
/*}}}*/

#include "upr.h"   
#include "header.h"
#include "topology.h"

#define UPR_MAX_PKT_SIZE 160
#define UPR_MAX_CONCURRENT_READS 4
#define UPR_MAX_NUM_PORTS  2500

/*{{{  check header implementation consistent*/
#if (UPR_MAX_PKT_SIZE > HDR_MAX_LENGTH)
  #error Header strategy fails to hold a full packet
#endif

#if (UPR_MAX_NUM_PORTS > HDR_MAX_PORT)
  #error Header strategy fails to hold a full packet
#endif
/*}}}*/

/*{{{  struct ORB      : Output Request Block*/
typedef struct ORB ORB ;
struct ORB
{
   ORB     *list;       /* List link for ORB queues */
   VLINK   src;         /* ORB source               */
   BYTE    *bffr;       /* Packet buffer pointer    */
   HEADER  header;      /* Packet Header            */
   WDESC   wdesc;       /* Work Descriptor Pointer  */
   int     bffrlen ;    /* Length of associated buffer */
} ;
/*}}}*/
/*{{{  ORB operations*/
EXTERN void UPR_Enqueue_BK   ( ORB *orb ) ;
EXTERN void UPR_Enqueue_NBK  ( ORB *orb ) ;

EXTERN void UPR_MultipleEnqueue_BK   ( ORB *orb, int length ) ;
EXTERN void UPR_MultipleEnqueue_NBK  ( ORB *orb, int length ) ;

EXTERN BOOL UPR_ORB_Serviced ( ORB *orb ) ;
EXTERN void UPR_ORB_BK       ( ORB *orb ) ;

/* For compatibility with earlier interface: */
#define UPR_Pkt_Serviced(o) UPR_ORB_Serviced(o)
#define UPR_Pkt_BK(o)       UPR_ORB_BK(o)
/*}}}*/

/*{{{  UPR constants*/
#define InputServiced_p ((ORB *) -4)
#define NotPointer_p    ((void *) (NotProcess_p))

/*}}}*/

/*{{{  struct PORT     : Network addressable object*/
typedef struct
{
  int   id ;
  void  (*pre_action)() ;
  void  (*post_action)() ;
  BOOL  do_pre ;
  BOOL  do_post ;
  void  *state ;
  BYTE  *buffer ;
  int   space ;
  void  *gsb ;
} PORT ;
/*}}}*/
/*{{{  PORT operations*/
EXTERN int  PortGrab    ( PORT * ) ;  /* port        */

EXTERN void PortRelease ( PORT * ) ;  /* port        */
                        
EXTERN int  MultiplePortGrab    ( PORT *, int ) ;  /* ports, num_ports */

EXTERN void MultiplePortRelease ( PORT *, int ) ;  /* ports, num_ports */
                        
EXTERN void PortInit    ( PORT *,     /* port        */
                          void (*)(), /* pre_action  */
                          BOOL,       /* do_pre      */
                          void (*)(), /* post_action */
                          BOOL,       /* do_post     */
                          void *) ;   /* state       */

EXTERN PORT *PortAlloc  ( void (*)(), /* pre_action  */
                          BOOL,       /* do_pre      */
                          void (*)(), /* post_action */
                          BOOL,       /* do_post     */
                          void *) ;   /* state       */

EXTERN void PortFree    ( PORT * ) ;  /* port        */

EXTERN PORT *PortPtr     ( int ) ;     /* port id */

/*}}}*/

/*{{{  exception handling*/
#define UPR_warning (0)
#define UPR_error   (1)
#define UPR_fatal   (2)

EXTERN void Exception ( int,        /* severity */
                        char [],    /* file */
                        int,        /* line */
                        char [] ) ; /* msg  */
/*}}}*/
/*{{{  history thread indices and positions*/
#if (UPR_HISTORY != 0)
/*{{{  kernel_thread 0*/
#define kernel_thread 0

#define kernel_done 0       /* Value is null */
/*}}}*/
/*{{{  input_thread  1*/
#define input_thread 1

#define input_read_hdr       0   /* value is trbb pointer */
#define input_read_bdy       1   /* value is header       */
#define input_read_thro_bdy  2   /* value is header       */
#define input_read_LACK      3   /* value is virtual link */
#define input_call_pre       4   /* value is port id      */
#define input_call_post      5   /* value is port id      */
/*}}}*/
/*{{{  output_thread 2*/
#define output_thread 2

#define output_send_hdr      0   /* Value is header       */
#define output_send_bdy      1   /* Value is length       */
#define output_send_LACK     2   /* Value is LACK header  */
#define output_sleep         3   /* Value is null         */
/*}}}*/
/*{{{  error_thread  3*/
#define error_thread  3

#define error_send  0   /* value is error header */
#define error_sleep 1   /* value is null         */
#define error_queue 2   /* value is msg pointer  */
/*}}}*/
/*{{{  vin_thread    4*/
#define vin_thread 4

#define vin_internal 0   /* Value is channel pointer */
#define vin_send_ack 1   /* Value is channel pointer */
#define vin_early    2   /* Value is channel pointer */
#define vin_late     3   /* Value is channel pointer */
#define vin_done     4   /* Value is channel pointer */
/*}}}*/
/*{{{  vout_thread   5*/
#define vout_thread 5

#define vout_internal   0   /* Value is channel pointer */
#define vout_send_first 1   /* Value is channel pointer */
#define vout_early      2   /* Value is channel pointer */
#define vout_send_next  3   /* Value is channel pointer */
#define vout_done       4   /* Value is channel pointer */
/*}}}*/
/*{{{  user_thread   6*/
#define user_thread 6

#define user_send_warn 0    /* Value is null */
/*}}}*/
#endif

EXTERN void UPR_Record ( int,    /* thread */
                         int,    /* index  */
                         int,    /* pos    */
                         int ) ; /* value  */
/*}}}*/

/*{{{  procedural access to router globals (for performance monitoring)*/
EXTERN int UPR_ThroCount (void) ;
/*}}}*/

/*{{{  globals declaration */
#ifndef NO_GLOBALS_PTR
  typedef struct
  {
    void *upr_gp ;
    void *vcr_gp ;
    void *bsp_gp ;
    void *usr_gp ;
    void *vpi_gp ;
    void *pqueue ;
  } GLOBALS ;  

  #define GLOBAL_PTR (0x80000080)   /* globals visible by pointer */
#endif
/*}}}*/

EXTERN NETWORK *UPR_GetNetworkInfo (void) ;

