/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Global systems definitions
||@(#)   System : UPR
||@(#) Filename : upr.h
||@(#)  Version : 2.8
\*@(#)====================================================*/
/*}}}*/

/*{{{  module visibility predefines*/
#ifndef PUBLIC
#define PUBLIC
#define PRIVATE static
#define EXTERN  extern
#endif
/*}}}*/
/*{{{  system-wide compile time switches*/
/* UPR_HISTORY is either 0 (off) or 1 (on) */
#define UPR_HISTORY 0 
/*}}}*/

/*{{{  basic data types*/
typedef unsigned char BYTE ;
typedef int           BOOL ;
typedef int           LINK ;
typedef int           *WDESC ;
/*}}}*/
/*{{{  basic constants*/
#define UPR_num_links 4

#define UPR_root 0

#define TRUE 1
#define FALSE 0

#undef  NotProcess_p
#define NotProcess_p    (Channel)( 0x80000000)
/*}}}*/
/*{{{  UPR link types*/
typedef enum {invalid, inactive, host, virtual, hprlink, hybrid} LINK_TYPES ;
/*}}}*/
/*{{{  virtual link data type*/
#define ll 0         /* Logical Link number */
#define vl 1         /* Virtual Link number */
typedef BYTE VLINK[2] ;
/*}}}*/
/*{{{  allow all modules to access some system statics*/
#ifndef UPR_RD
EXTERN char switch_char ;
EXTERN char slash_char ;
#endif

EXTERN int  proc_memory ;
/*}}}*/

/*{{{  assembler routines*/
/* Sometimes need this operation, but beware usage where l is complex */

#define RawMove(s,d,l)    { __asm{ ld (s) ; ld (d) ; ld (l) ;move ;}}

/* Note that assembler predefines CANNOT have arbitrarily complicated
   arguments due to evaluation stack overflow. This is most likely to
   occur with the following triadic operations, so we first evaluate
   the length into a temporary variable. */

#define RawChanIn(c,m,l)   { int len=(l) ; __asm{ ld (m) ; ld (c) ; ld (len) ; in ; }}
#define RawChanOut(c,m,l)  { int len=(l) ; __asm{ ld (m) ; ld (c) ; ld (len) ; out ;}}
#define AsmMove(s,d,l)    { int len=(l) ; __asm{ ld (s) ; ld (d) ; ld (len) ;move ;}}

/* These routines mend internal zero-length communications */

#define SoftChanIn(c,m,l)  { \
  if ((l)==0) \
    { __asm { ldlabeldiff p-h;ldpi;h: ld (c) ; ldc 1 ; in ; j e ; align; p: word 0; e: ;}} \
  else \
    { int len=(l) ; __asm{ ld (m) ; ld (c) ; ld (len) ; in ; }} ; }

#define SoftChanOut(c,m,l)  { \
  if ((l)==0) \
    { __asm { ldlabeldiff p-h;ldpi;h: ld (c) ; ldc 1 ; out ; j e ; align; p: word 0; e: ;}} \
  else \
    { int len=(l) ; __asm{ ld (m) ; ld (c) ; ld (len) ; out ; }} ; }

#define TpReset() __asm{ opr 0x1ff; }
#define ProcAwaken(w)  __asm{ ld w ; runp ; }
#define ProcSleep()    __asm{ stopp; }
#define ProcDesc(w)    __asm{ ldlp 0; ldpri; or; st *(w); }
#define ProcToLO()     __asm{ldlp 0;ldc 1;or;runp;stopp;}
#define ProcToHI()     __asm{ldlabeldiff c-a;ldpi;a: stl -1;ldlp 0;ldc -1;and;runp;ldlabeldiff c-b;ldpi;b: gajw;stopp;align;word 0;c: ;}
#define ProcGetPRI(p)  __asm{ ldpri; st *(p) ;}
#define ProcSetError() __asm{ sethalterr; seterr; }

#define ProcAltStart()     __asm{ alt; }
#define ProcEnbChan(c,g)   __asm{ ld c;ld g;enbc; }
#define ProcAltWait()      __asm{ altwt; }
#define ProcDisChan(c,g,r) __asm { ld c ; ld g ; ldc 0 ; disc ; st *(r); }
#define ProcAltEnd()       __asm{ altend; }

#define ProcInitFpu() __asm{ fptesterr; }

#define ProcRestartAlt(c) __asm{ldlp 0;runp;ld (c);ldc 1;out;}

#define SetHaltOnErr()  __asm{ sethalterr ;}
#define ClrHaltOnErr()  __asm{ clrhalterr ;}
/*}}}*/

