/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Topology structures
||@(#)   System : UPR
||@(#) Filename : topology.h
||@(#)  Version : 1.1
||@(#)     Date : 7/15/92
\*@(#)====================================================*/
/*}}}*/

#define unknown_tpg 0
#define grid_tpg    1
#define hpr_tpg     2
#define num_tpg     3
#define first_tpg   1

#define NOT_PROC (-1)

typedef int EDGE[2] ;

typedef struct
{
  int son ;
  int sibling ;
} VERTEX ;

typedef union
{
  int tpg ;

  struct
  {
    int   tpg ;
    int   ndims ;
    int  *dims ;
    BOOL *wraps ;
    int   first ;
  } grid ;

  struct
  {
    int   tpg  ;
    int   first ;
  } hpr ;
  
} TOPOLOGY ;

typedef struct
{
  char *name ;
  char *ncf  ;
  TOPOLOGY topology ;
  int num_vertices ;
  VERTEX *vertex ;
  int  num_edges ;
  EDGE *edge ;
} NETWORK ;

EXTERN NETWORK *network ;
EXTERN char text_tpg [first_tpg+num_tpg][8] ;
