/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Packet router system definitions
||@(#)   System : UPR
||@(#) Filename : router.h
||@(#)  Version : 2.10
\*@(#)====================================================*/
/*}}}*/

#include <process.h>
#include <channel.h>
#include <semaphor.h>

#include "upri.h"

#define min(a,b)        ((a<b) ? a : b )
#define max(a,b)        ((a>b) ? a : b )

/*{{{  UPR compile time switches*/
/*#define NO_GLOBALS_PTR*/
#define UPR_KERNEL_AT_HI_PRI
#define UPR_CTRL_PORT_ACTIVE
/*#define UPR_FIXED_MEMORY */
#define UPR_USE_FAST_RAM
/*}}}*/
/*{{{  UPR system constants*/
#define UPR_USER     (0xFF)
#define UPR_FROM_DFL (0xFE)

#define UPR_LACK        ((BYTE) -1)
#define UPR_INVALID_SRC ((BYTE) -2) 
#define UPR_INACTIVE    ((BYTE) -3)

#define UPR_error_depth (10)
#define UPR_no_errors   (-1)
/*}}}*/
/*{{{  UPR system parameters*/
#ifdef UPR_FIXED_MEMORY
  #define UPR_num_buffers 400
#else
  #define UPR_buffers_per_vlink 10
#endif

/* History size for UPR_HISTORY */
#define history_size 100
/*}}}*/

/*{{{  entry points to transport layer*/
EXTERN void InitTransportLayer ( int,            /* proc id   */
                                 int,            /* num_nodes */
                                 int,            /* argc */
                                 char *[] ) ;    /* argv */

EXTERN int TransportLayer      ( int,            /* argc      */
                                 char *[] ) ;    /* argv      */
/*}}}*/

/*{{{  struct OQB  : Output Queue Block*/
typedef struct 
{
  ORB *h ;
  ORB *t ;
}
OQB ;
       
/*}}}*/
/*{{{  struct VILB : Virtual Input Link Block*/
typedef struct VILB VILB ;
struct VILB
{
  int pkt_count;     /* Internal pkt count for this virtual link */
  int srv_count;     /* Unacknowledged serviced pkts count       */
  ORB lack_ORB;      /* ORB for local acknowledgments */
};
/*}}}*/
/*{{{  struct ILB  : Input Link Block*/
typedef struct  
{
  int  num_vlinks;     /* No of virtual links                      */
  int  pkt_limit;      /* No of packets available per virtual link */
  int  srv_limit;      /* No of packets at which LACK triggered    */
  BOOL used;
  VILB *vilb;          /* Array of virtual links */
}
ILB ;
/*}}}*/
/*{{{  struct VOLB : Virtual Output Link Block*/
typedef struct VOLB VOLB ;
struct VOLB 
{
  int pkt_count ;
  OQB oqb ;
} ;
/*}}}*/
/*{{{  struct OLB  : Output Link Block*/
typedef struct 
{
  int   pkt_limit ;
  int   srv_limit ;
  int   num_vlinks ;
  OQB   lack_OQB ;
  BOOL  active ;
  BOOL  used ;
  WDESC wdesc ;
  VOLB  *volb ;
}
OLB ;
/*}}}*/
/*{{{  struct TRBB : Through Routing Buffer Block*/
typedef struct TRBB TRBB;
struct TRBB
{
  TRBB *next;
  ORB orb;
  BYTE buffer[UPR_MAX_PKT_SIZE];
};
/*}}}*/

/*{{{  struct ERROR        : Error block*/
typedef enum{empty_ctrl, error} CTRL_TAG ;
#define ctrl_pkt_ovrhd sizeof(CTRL_TAG)

#define MAX_FILENAME (UPR_MAX_PKT_SIZE/3)
#define MAX_MESSAGE (UPR_MAX_PKT_SIZE-(4*sizeof(int))-MAX_FILENAME-ctrl_pkt_ovrhd)
#define LOST_MESSAGE        "Warning-upr- Losing errors\n"
#define LOST_LENGTH         sizeof(LOST_MESSAGE)
#define MAX_ERROR_MESSAGE   ( sizeof("Warning-upr-pXXX-(XXXX)-") +  MAX_MESSAGE + MAX_FILENAME + LOST_LENGTH )
                              
typedef struct
{
  int status;
  int line_no;
  int lost;
  int proc_no;
  char filename[MAX_FILENAME];
  char message[MAX_MESSAGE];
} ERROR ;
/*}}}*/
/*{{{  struct UPR_CTRL_PKT : UPR control protocol*/
typedef union
{
  ERROR error ;
} CTRL_PARAMS ;

typedef struct
{
  CTRL_TAG tag ;
  CTRL_PARAMS p ; 
} UPR_CTRL_PKT ;

#define num_ctrl_pkts UPR_num_links
/*}}}*/
/*{{{  struct EQB          : Error queue block*/
typedef struct
{
  int   head;
  int   tail;
  WDESC wdesc;
  Semaphore lock ; /* controls servicing of exceptions */
  ORB   orb ;
  UPR_CTRL_PKT *errs;
} EQB ;
/*}}}*/
/*{{{  struct HREC  : History record*/
typedef struct
{
  int thread ;
  int ref ;
  int value ;
  int time ;
} HREC ;
/*}}}*/

/*{{{  struct LACT : Reference to state for library actions*/
typedef struct LACT LACT ;

struct LACT
{
  LACT *next ;
  void *gsb ;
  int  *state[UPR_num_links] ;
} ;

#define LIB_STATE_WORDS 200
/*}}}*/
  
/*{{{  struct UPR_GLOBALS*/
typedef struct
{
  int      proc_id;
  int      num_nodes;
  int      thro_count ;
  void    *gsb ;
  int      num_buffers ;
  BYTE     *error_message;
  WDESC    error_wdesc ;
  TRBB     *trbb;
  VLINK    *out_link;
  BYTE     (*in_vlink)[UPR_num_links];
  PORT     **ports ;
  int      next_port ;
  int      hcount ;
  HREC     *history ;
  ILB      ilbs[UPR_num_links];
  OLB      olbs[UPR_num_links];
  EQB      eqb ;
  int      upr_ctrl_port_id ;
  LACT    *lact ;
  NETWORK *network ;
}
UPR_GLOBALS;
/*}}}*/

/*{{{  make UPR globals visible to all modules*/
EXTERN UPR_GLOBALS upr_globals ;
/*}}}*/

/*{{{  prototypes for functions in router.c*/
EXTERN  void  ProcMove(Process *, int *, int *, int) ;
EXTERN  int   ProcGuardedAltList ( Channel **, BOOL * ) ;
/*}}}*/

