/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Network loader system definitions
||@(#)   System : DLOADER
||@(#) Filename : net.h
||@(#)  Version : 2.3
\*@(#)====================================================*/
/*}}}*/


#include <process.h>
#include <channel.h>

#include "upr.h"

#define kilobyte 1024

#define dangling  (-1)
#define tree_node (-2)
#define tree_done (-3)

/*{{{  entry point to routing kernel*/
EXTERN void UPR_Kernel
(
int,                        /* argc */
char *[],                   /* argv */
int,                        /* proc_id   : processor id */
int,                        /* num_nodes : number of nodes in network */
Channel **,                 /* route_in  : incoming physical links & NULL */
Channel **,                 /* route_out : outgoing physical links & NULL */
LINK_TYPES [UPR_num_links], /* link_type : type of each physical link */
BYTE *                      /* routing_table */
) ;
/*}}}*/

/*{{{  allow access to Inmos heap manager*/
#pragma IMS_translate(init_heap, "init_heap%c")

extern void init_heap(int *, int, int) ;

extern int *_IMS_heap_base ;
extern int *_IMS_heap_front ;
/*}}}*/

/*{{{  typedef struct NODE*/
typedef struct NODE NODE ;

struct NODE
{ int        id ;
  int        son[UPR_num_links] ;
  LINK_TYPES link_type[UPR_num_links] ;
  int        proc_type ;
  int        mem_size ;
} ;
/*}}}*/

