/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Header format definition (one word version)
||@(#)   System : 
||@(#) Filename : header.h
||@(#)  Version : 1.4
\*@(#)====================================================*/
/*}}}*/

#include <limits.h>

typedef struct
{
  unsigned short port ;
  unsigned char  length ;
  unsigned char  destn ;
} HEADER ;

#define HdrModLength(l,h) ((h)->length = (l))
#define HdrLength(h)      ((h)->length)
#define HdrDestn(h)       ((h)->destn)
#define HdrPort(h)        ((h)->port)
#define HdrSize 4

#define HdrBuild(d,p,l,h) {(h)->length=(l);(h)->destn=(d);(h)->port=(p);}
#define HdrAddr(d,p,h)    {(*d)=(h)->destn;(*p)=(h)->port;}
#define HdrCopy(hs,hd)    {AsmMove((hs),(hd),HdrSize);}

#define HDR_MAX_PORT      USHRT_MAX
#define HDR_MAX_LENGTH    UCHAR_MAX
#define HDR_MAX_DESTN     UCHAR_MAX
