/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Header file for link protocol compatibility with Version 1.8
||@(#)   System : VCR
||@(#) Filename : head_1v8.h
||@(#)  Version : 2.1
||@(#)     Date : 6/19/91
\*@(#)====================================================*/
/*}}}*/

typedef int HEADER ;

#define destn_shf  8
#define destn_mask 0xfff
#define vchan_shf  20
#define vchan_mask 0xfff
#define len_mask   0xff

#define HdrLength(h)      ((*h) & len_mask)
#define HdrModLength(l,h) ((*h) = (*h)- HdrLength(h) + (l))
#define HdrDestn(h)       (((*h) >> destn_shf) & destn_mask)
#define HdrPort(h)        ((*h) >> vchan_shf)
#define HdrSize 4         

#define HdrBuild(d,p,l,h) (*h) = (((p << (vchan_shf-destn_shf)) + d)<< destn_shf) + l
#define HdrAddr(d,p,h)    {(*d)=((*h)>> destn_shf);(*p)=(*d)>>(vchan_shf-destn_shf);(*d)=(*d)&destn_mask;}
#define HdrCopy(hs,hd)    {AsmMove((hs),(hd),HdrSize);}
