#include <stdio.h>
#include <stdlib.h>
#include "rk.h"
#define DEFAULT_NRECTS 100

double accumulate(int count)
{
  double sum = 0.0;
  while (count-- > 0)
  {
    double* x =(double*) xrecvb();
    sum += *x;
    xfree((char*)x); 
  }
  return(sum);
}

int usermain(int my_id, int num_procs, int argc, char **argv)
{
  int num_rects = DEFAULT_NRECTS;
  int mystart, myfinish;
  int num_slices;
  double mypiece = 0.0;
  double slice_width;

  if (argc==2) num_rects = atoi(argv[1]);

  slice_width = 1.0/num_rects;
  num_slices = num_rects/num_procs;
  mystart = my_id*num_slices ;
  myfinish = mystart + num_slices ;

  {
    int i;
    for ( i = mystart ; i < myfinish ; i++)
    {
      double x;
      x = ((i + 0.5) * slice_width); 
      mypiece += (4.0/(1.0 + x*x));
    }
  }
  if (my_id==0)
  {
    double pi = (accumulate(num_procs-1)+mypiece) * slice_width;
    printf("Pi is %lf for %d slices over %d processors\n",pi,num_rects,num_procs);
  }
  else
  {
    double *f = (double*) xmalloc(sizeof(double));
    *f = mypiece;
    xsend((char*) f, 0);
  }
}
