/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#include <stdlib.h>
#include "toolkit.h"

/*{{{   PUBLIC long int lff_getl_test (fs, ok)   */
PUBLIC long int lff_getl_test (fs, ok)
FILE *fs;
int *ok;
{
  long int val;
  register int c;
  *ok = TRUE;
  val = 0L;
  if ((c = fgetc (fs)) == EOF) *ok = FALSE;
  if ((c & 0X40) == 0) val = 0L;
  else val = -1;
  while (((c & 0X80) != 0) && *ok)
  {
    val = (val << 7L) | (((long int) c) & 0X7FL);
    if ((c = fgetc (fs)) == EOF) *ok = FALSE;
  }
  val = (val << 7) | c;
  return (val);
}

/*}}}*/
/*{{{   PUBLIC char *lff_gets_test (fs, l, ok)   */
PUBLIC char *lff_gets_test (fs, l, ok)
FILE *fs;
long int *l;
int *ok;
{
  char *str, *res;
  int n, c, s;
  *ok = TRUE;
  *l = lff_getl_test (fs, ok);
  s = (int) *l;
  res = str = malloc_chk (1 + (s * sizeof (char)));
  for (n = 0; n < s; n++)
  {
    if ((c = fgetc (fs)) == EOF) *ok = FALSE;
    else *str++ = (char) c;
  }
  *str = '\0';
  return (res);
}

/*}}}*/
