/* Copyright 1990 INMOS Limited */

/******************************************************************************
*
*  24 JAN 90: pauls:  increased max column width from 4 to 8.
*  25 JAN 90: pauls:  added right hand character column to output.
*
*******************************************************************************/

#include <stdio.h>
#ifdef STD_C
#include <stdlib.h>
#endif
#include <string.h>
#include "toolkit.h"

#ifdef _MSC
#define switch(x) switch ((int)(x))
#endif

#define FIELDS   8
#define SPACES   (FIELDS * 3)
/*{{{   stuff   */
#define  j      0x0
#define  pfix   0x2
#define  nfix   0x6
#define  call   0x9
#define  cj     0xA
#define  opr    0xF
PRIVATE char *direct[16] =
{
  "j",   "ldlp", "pfix", "ldnl", "ldc", "ldnlp", "pfix", "ldl",
  "adc", "call", "cj",   "ajw",  "eqc", "stl",   "stnl", "opr"
};
#define MAX_OPR_FUNC 173
PRIVATE char *opr_funcs[MAX_OPR_FUNC] =
{
  /*{{{   vast quantity of initialisers   */
  "rev",            /*  0  */
  "lb",             /*  1  */
  "bsub",           /*  2  */
  "endp",           /*  3  */
  "diff",           /*  4  */
  "add",            /*  5  */
  "gcall",          /*  6  */
  "in",             /*  7  */
  "prod",           /*  8  */
  "gt",             /*  9  */
  "wsub",           /*  A  */
  "out",            /*  B  */
  "sub",            /*  C  */
  "startp",         /*  D  */
  "outbyte",        /*  E  */
  "outword",        /*  F  */
  "seterr",         /*  10  */
  "",               /*  11  */
  "resetch",        /*  12  */
  "csub0",          /*  13  */
  "",               /*  14  */
  "stopp",          /*  15  */
  "ladd",           /*  16  */
  "stlb",           /*  17  */
  "sthf",           /*  18  */
  "norm",           /*  19  */
  "ldiv",           /*  1A  */
  "ldpi",           /*  1B  */
  "stlf",           /*  1C  */
  "xdble",          /*  1D  */
  "ldpri",          /*  1E  */
  "rem",            /*  1F  */
  "ret",            /*  20  */
  "lend",           /*  21  */
  "ldtimer",        /*  22  */
  "",               /*  23  */
  "",               /*  24  */
  "",               /*  25  */
  "",               /*  26  */
  "",               /*  27  */
  "",               /*  28  */
  "testerr",        /*  29  */
  "testpranal",     /*  2A  */
  "tin",            /*  2B  */
  "div",            /*  2C  */
  "",               /*  2D  */
  "dist",           /*  2E  */
  "disc",           /*  2F  */
  "diss",           /*  30  */
  "lmul",           /*  31  */
  "not",            /*  32  */
  "xor",            /*  33  */
  "bcnt",           /*  34  */
  "lshr",           /*  35  */
  "lshl",           /*  36  */
  "lsum",           /*  37  */
  "lsub",           /*  38  */
  "runp",           /*  39  */
  "xword",          /*  3A  */
  "sb",             /*  3B  */
  "gajw",           /*  3C  */
  "savel",          /*  3D  */
  "saveh",          /*  3E  */
  "wcnt",           /*  3F  */
  "shr",            /*  40  */
  "shl",            /*  41  */
  "mint",           /*  42  */
  "alt",            /*  43  */
  "altw",           /*  44  */
  "altend",         /*  45  */
  "and",            /*  46  */
  "endbt",          /*  47  */
  "endbc",          /*  48  */
  "endbs",          /*  49  */
  "move",           /*  4A  */
  "or",             /*  4B  */
  "csngl",          /*  4C  */
  "ccnt1",          /*  4D  */
  "talt",           /*  4E  */
  "ldiff",          /*  4F  */
  "sthb",           /*  50  */
  "taltwt",         /*  51  */
  "sum",            /*  52  */
  "mul",            /*  53  */
  "sttimer",        /*  54  */
  "stoperr",        /*  55  */
  "cword",          /*  56  */
  "clrhalterr",     /*  57  */
  "sethalterr",     /*  58  */
  "testhalterr",    /*  59  */
  "dup",            /*  5A  */
  "move2dinit",     /*  5B  */
  "move2dall",      /*  5C  */
  "move2dnonzero",  /*  5D  */
  "move2dzero",     /*  5E  */
  "",               /*  5F  */
  "",               /*  60  */
  "",               /*  61  */
  "",               /*  62  */
  "unpacksn",       /*  63  */
  "",               /*  64  */
  "",               /*  65  */
  "",               /*  66  */
  "",               /*  67  */
  "",               /*  68  */
  "",               /*  69  */
  "",               /*  6A  */
  "",               /*  6B  */
  "postnormsn",     /*  6C  */
  "roundsn",        /*  6D  */
  "",               /*  6E  */
  "",               /*  6F  */
  "",               /*  70  */
  "ldinf",          /*  71  */
  "fmul",           /*  72  */
  "cflerr",         /*  73  */
  "crcword",        /*  74  */
  "crcbyte",        /*  75  */
  "bitcnt",         /*  76  */
  "bitrevword",     /*  77  */
  "bitnbits",       /*  78  */
  "",               /*  79  */
  "",               /*  7A  */
  "",               /*  7B  */
  "",               /*  7C  */
  "",               /*  7D  */
  "",               /*  7E  */
  "",               /*  7F  */
  "",               /*  80  */
  "wsubdb",         /*  81  */
  "fpldnlbi",       /*  82  */
  "fpchkerr",       /*  83  */
  "fpstnldb",       /*  84  */
  "",               /*  85  */
  "fpldnlsni",      /*  86  */
  "fpadd",          /*  87  */
  "fpstnlsn",       /*  88  */
  "fpsub",          /*  89  */
  "fpldnldb",       /*  8A  */
  "fpmul",          /*  8B  */
  "fpdiv",          /*  8C  */
  "",               /*  8D  */
  "fpldnlsn",       /*  8E  */
  "fpremfirst",     /*  8F  */
  "fpremstep",      /*  90  */
  "fpnan",          /*  91  */
  "fpordered",      /*  92  */
  "fpnotfinite",    /*  93  */
  "fpgt",           /*  94  */
  "fpeq",           /*  95  */
  "fpi32tor32",     /*  96  */
  "",               /*  97  */
  "fpi32tor64",     /*  98  */
  "",               /*  99  */
  "fpb32tor64",     /*  9A  */
  "",               /*  9B  */
  "fptesterr",      /*  9C  */
  "fprtoi32",       /*  9D  */
  "fpstnli32",      /*  9E  */
  "fpldzerosn",     /*  9F  */
  "fpldzerodb",     /*  A0  */
  "fpint",          /*  A1  */
  "",               /*  A2  */
  "fpdup",          /*  A3  */
  "fprev",          /*  A4  */
  "",               /*  A5  */
  "fpldnladddb",    /*  A6  */
  "",               /*  A7  */
  "fpldnlmuldb",    /*  A8  */
  "",               /*  A9  */
  "fpldnladdsn",    /*  AA  */
  "fpentry",        /*  AB  */
  "fpldnlmulsn",    /*  AC  */
  /*}}}*/
};
/*}}}*/
/*{{{   PUBLIC void disassemble (pos, fs, print_rel)   */
PUBLIC void disassemble (pos, fs, print_rel)
const long int pos;
FILE *fs;
int print_rel;
{
  /*{{{   setup   */
  int c, print_pos, space, cpos;
  char blanks[SPACES], chars[FIELDS + 1];
  long int i, Oreg, op, val, posn;
  print_pos = TRUE;
  posn = pos;
  space = SPACES;
  for (i = 0; i < SPACES; i++) blanks[i] = ' ';
  Oreg = 0L;
  cpos = 0;
  c = dis_get_char ();
  
  /*}}}*/
  while (c != EOF)
  {
    op = ((long int) c) >> 4L;
    val = ((long int) c) & 0xFL;
    /*{{{   fill Oreg   */
    switch (op)
    {
      case (nfix):   Oreg = (~(Oreg | (long int) val)) << 4;    break;
      case (pfix):   Oreg = (Oreg | (long int) val) << 4;       break;
      default:       Oreg = Oreg | (long int) val;              break;
    }
    /*}}}*/
    /*{{{   print field   */
    if ((print_pos) || (space == 0))
    {
      if (space == 0)
      {
        chars[cpos] = '\0';
        fprintf (fs, "                                 %s", chars);
        fprintf (fs, "\n%08lX ", posn);
        space = SPACES;
        cpos = 0;
      }
      else fprintf (fs, "%08lX ", posn); /* initial case */
    }
    if ((c >= ' ') && (c <= '~')) chars[cpos++] = c;
    else chars[cpos++] = '.';
    fprintf (fs, "%02X ", c);
    space = space - 3;
    /*}}}*/
    /*{{{   print op   */
    if (((op != pfix) && (op != nfix) && (op != opr)) ||
        ((op == pfix) && (val == 0L) && (Oreg == 0L)) ||
        ((op == opr) && (Oreg < MAX_OPR_FUNC) && (Oreg >= 0L) && (strlen (opr_funcs[Oreg]) != 0)))
    {
      blanks[space] = '\0';
      fputs (blanks, fs);
      switch (op)
      {
        case j:
        case cj:
        case call:
          if (print_rel) fprintf (fs, "%-7s%-14ld (%08lX) ", direct[op], Oreg, posn + Oreg + 1L);
          else fprintf (fs, "%-7s%-14ld            ", direct[op], Oreg);
          Oreg = 0L;
          break;
        case pfix:
          if (val == 0L) fprintf (fs, "%-7s%-14ld            ", direct[op], val);
          break;
        case opr:
          fprintf (fs, "%-7s                          ", opr_funcs[Oreg]);
          Oreg = 0L;
          break;
        default:
          fprintf (fs, "%-7s%-14ld            ", direct[op], Oreg);
          Oreg = 0L;
          break;
      }
      blanks[space] = ' ';
      space = SPACES;
      chars[cpos] = '\0';
      fprintf (fs, "%s\n", chars);
      cpos = 0;
      print_pos = TRUE;
    }
    else print_pos = FALSE; /* dont print next position */
    /*}}}*/
    posn++;
    c = dis_get_char ();
  }
}
/*}}}*/
