/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#include <string.h>
#ifdef STD_C
#include <stdlib.h>
#endif
#include <ctype.h>
#include "toolkit.h"

/*{{{   PUBLIC void env_to_option (ac, av, env)   */
PUBLIC void env_to_option (ac, av, env)
int *ac;
char const **av[];
char *env;
{
  int i, argc2, finished;
  char const **argv; 
  char *line, *str, *ptr;
  char const **argv2;
  argc2 = 0;
  argv = *av;
  line = (char *) getenv (env);
  if (line != NULL)
  {
    line = str_duplicate (line);
    argv2 = malloc_chk (++argc2 * sizeof (char *));
    argv2[0] = argv[0];
    /*{{{   copy in env line   */
    str = line;
    finished = FALSE;
    while (!finished)
    {
      while (isspace (*str)) str++;
      if (*str == '\0') finished = TRUE;
      else
      {
        ptr = str;
        while ((*ptr != '\0') && !isspace (*ptr)) ptr++;
        if (*ptr == '\0') finished = TRUE;
        else *ptr = '\0';
        argv2 = realloc_chk (argv2, (argc2 + 1) * sizeof (char *));
        argv2[argc2++] = str;
        str = ++ptr;
      }
    }
    /*}}}*/
    /*{{{   copy normal args   */
    i = 1;
    while (i < *ac)
    {
      argv2 = realloc_chk (argv2, (argc2 + 1) * sizeof (char *));
      argv2[argc2++] = argv[i++];
    }
    /*}}}*/
    *ac = argc2;
    *av = argv2;
  }
}
/*}}}*/
