#ifndef DEBUG_POINTERS
/* Copyright 1990 INMOS Limited */

#include <stdio.h>
#ifdef STD_C
#include <stdlib.h>
#endif
#include "toolkit.h"

/*{{{   PUBLIC void *malloc_chk (mem)   */
PUBLIC void *malloc_chk (mem)
size_t mem;
{
  void *res;
  res = (void *) malloc (mem);
  if (res == NULL)
  {
    fprintf (stderr, "out of memory\n");
    exit (EXIT_FAILURE);
  }
  return (res);
}
/*}}}*/
/*{{{   PUBLIC void *calloc_chk (n, size)   */
PUBLIC void *calloc_chk (n, size)
size_t n, size;
{
  void *res;
  res = (void *) calloc (n, size);
  if (res == NULL)
  {
    fprintf (stderr, "out of memory\n");
    exit (EXIT_FAILURE);
  }
  return (res);
}
/*}}}*/
/*{{{   PUBLIC void *realloc_chk (ptr, mem)   */
PUBLIC void *realloc_chk (ptr, mem)
void *ptr;
size_t mem;
{
  void *res;
#if (TARG == VAX) || (TARG == SUN)
  /* no ansi realloc on vax or sun */
  /* I would like to use #ifdef STD_C but life is not like that */
  if (ptr == NULL) res = (void *) malloc (mem);
  else res = (void *) realloc (ptr, mem);
#else
  res = (void *) realloc ((void *) ptr, mem);
#endif
  if (res == NULL)
  {
    fprintf (stderr, "out of memory\n");
    exit (EXIT_FAILURE);
  }
  return (res);
}
/*}}}*/
/*{{{  PUBLIC void free_chk (ptr) */
PUBLIC void free_chk (ptr)
void *ptr;
{
  if (ptr != NULL) free (ptr);
}
/*}}}*/
#endif
