/*****************************************************************************
 *
 * vti.h Occam 2 compiler in C virtual tree interface
 *
 *****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

/* ALL access to the parse tree should go through the virtual tree
   interface.
 */

/*{{{  tag and location*/
#define TagOf(T)    ((T)->tag)
#define SetTag(T,V) ((T)->tag = (V))

#define LocnOf(T)    ((T)->lcn)
#define SetLocn(T,V) ((T)->lcn = (V))
/*}}}*/
/*{{{  actionnode*/
#define LHSOf(T) ((T)->n_u.act_s.act_lhs)
#define RHSOf(T) ((T)->n_u.act_s.act_rhs)

#define SetLHS(T,V) ((T)->n_u.act_s.act_lhs = (V))
#define SetRHS(T,V) ((T)->n_u.act_s.act_rhs = (V))

#define LHSAddr(T) (&((T)->n_u.act_s.act_lhs))
#define RHSAddr(T) (&((T)->n_u.act_s.act_rhs))
/*}}}*/
/*{{{  altnode*/
#define AltGuardOf(T)   ((T)->n_u.alt_s.alt_guard)
#define AltInputOf(T)   ((T)->n_u.alt_s.alt_input)
#define AltBodyOf(T)    ((T)->n_u.alt_s.alt_body)
#define AltChanExpOf(T) ((T)->n_u.alt_s.alt_chanexp)
#define AltLabelOf(T)   ((T)->n_u.alt_s.alt_label)

#define SetAltGuard(T,V)   ((T)->n_u.alt_s.alt_guard = (V))
#define SetAltInput(T,V)   ((T)->n_u.alt_s.alt_input = (V))
#define SetAltBody(T,V)    ((T)->n_u.alt_s.alt_body = (V))
#define SetAltLabel(T,V)   ((T)->n_u.alt_s.alt_label = (V))
#define SetAltChanExp(T,V) ((T)->n_u.alt_s.alt_chanexp = (V))

#define AltGuardAddr(T)   (&((T)->n_u.alt_s.alt_guard))
#define AltInputAddr(T)   (&((T)->n_u.alt_s.alt_input))
#define AltBodyAddr(T)    (&((T)->n_u.alt_s.alt_body))
#define AltChanExpAddr(T) (&((T)->n_u.alt_s.alt_chanexp))
/*}}}*/
/*{{{  arraynode*/
#define ARDimLengthOf(T) ((T)->n_u.ar_s.ar_dimlength)
#define ARTypeOf(T)      ((T)->n_u.ar_s.ar_type)
#define ARDimOf(T)       ((T)->n_u.ar_s.ar_dim)

#define SetARDimLength(T,V) ((T)->n_u.ar_s.ar_dimlength = (V))
#define SetARType(T,V)      ((T)->n_u.ar_s.ar_type = (V))
#define SetARDim(T,V)       ((T)->n_u.ar_s.ar_dim = (V))

#define ARDimLengthAddr(T) (&((T)->n_u.ar_s.ar_dimlength))
#define ARTypeAddr(T)      (&((T)->n_u.ar_s.ar_type))
#define ARDimAddr(T)       (&((T)->n_u.ar_s.ar_dim))
/*}}}*/
/*{{{  arraysubnode*/
/* The following field names are used by both S_ARRAYSUB and S_ARRAYITEM */
#define ASBaseOf(T)        ((T)->n_u.as_s.as_base)
#define ASIndexOf(T)       ((T)->n_u.as_s.as_index)
#define ASExpOf(T)         ((T)->n_u.as_s.as_exp)    /* S_ARRAYITEM only */
#define ASOffsetOf(T)      ((T)->n_u.as_s.as_offset) /* S_ARRAYITEM only */
#define ASLengthOf(T)      ((T)->n_u.as_s.as_length) /* S_ARRAYITEM only */

#define SetASBase(T,V)     ((T)->n_u.as_s.as_base = (V))
#define SetASIndex(T,V)    ((T)->n_u.as_s.as_index = (V))
#define SetASExp(T,V)      ((T)->n_u.as_s.as_exp = (V))
#define SetASOffset(T,V)   ((T)->n_u.as_s.as_offset = (V))
#define SetASLength(T,V)   ((T)->n_u.as_s.as_length = (V))

#define ASBaseAddr(T)    (&((T)->n_u.as_s.as_base))
#define ASIndexAddr(T)   (&((T)->n_u.as_s.as_index))
#define ASExpAddr(T)     (&((T)->n_u.as_s.as_exp))
#define ASOffsetAddr(T)  (&((T)->n_u.as_s.as_offset))
#define ASLengthAddr(T)  (&((T)->n_u.as_s.as_length))

#ifdef SIC
#define ASTempOf(T)        ((T)->n_u.as_s.as_temp)
#define SetASTemp(T,V)     ((T)->n_u.as_s.as_temp = (V))
#define ASTempAddr(T)    (&((T)->n_u.as_s.as_temp))
#endif
/*}}}*/
/*{{{  channode*/
#define ProtocolOf(T)     ((T)->n_u.ch_s.ch_protptr)

#define SetProtocol(T,V)  ((T)->n_u.ch_s.ch_protptr = (V))

#define ProtocolAddr(T) (&((T)->n_u.ch_s.ch_protptr))
/*}}}*/
/*{{{  cnode*/
#define CBodyOf(T)      ((T)->n_u.c_s.c_body)
#define CTempOf(T)      ((T)->n_u.c_s.c_temp)

#define SetCBody(T,V)   ((T)->n_u.c_s.c_body = (V))
#define SetCTemp(T,V)   ((T)->n_u.c_s.c_temp = (V))

#define CBodyAddr(T)  (&((T)->n_u.c_s.c_body))
#define CTempAddr(T)  (&((T)->n_u.c_s.c_temp))
/*}}}*/
/*{{{  condnode*/
#define CondGuardOf(T)     ((T)->n_u.cnd_s.cnd_guard)
#define CondBodyOf(T)      ((T)->n_u.cnd_s.cnd_body)

#define SetCondGuard(T,V)  ((T)->n_u.cnd_s.cnd_guard = (V))
#define SetCondBody(T,V)   ((T)->n_u.cnd_s.cnd_body = (V))

#define CondGuardAddr(T) (&((T)->n_u.cnd_s.cnd_guard))
#define CondBodyAddr(T)  (&((T)->n_u.cnd_s.cnd_body))
/*}}}*/
#ifdef CONDEXP
/*{{{  condexpnode*/
#define CondExpGuardOf(T)    ((T)->n_u.cndexp_s.cndexp_guard)
#define CondExpTrueOf(T)     ((T)->n_u.cndexp_s.cndexp_true)
#define CondExpFalseOf(T)    ((T)->n_u.cndexp_s.cndexp_false)
#define CondExpTypeOf(T)     ((T)->n_u.cndexp_s.cndexp_type)

#define SetCondExpGuard(T,V)   ((T)->n_u.cndexp_s.cndexp_guard = (V))
#define SetCondExpTrue(T,V)    ((T)->n_u.cndexp_s.cndexp_true = (V))
#define SetCondExpFalse(T,V)   ((T)->n_u.cndexp_s.cndexp_false = (V))
#define SetCondExpType(T,V)    ((T)->n_u.cndexp_s.cndexp_type = (V))

#define CondExpGuardAddr(T) (&((T)->n_u.cndexp_s.cndexp_guard))
#define CondExpTrueAddr(T)  (&((T)->n_u.cndexp_s.cndexp_true))
#define CondExpFalseAddr(T) (&((T)->n_u.cndexp_s.cndexp_false))
#define CondExpTypeAddr(T)  (&((T)->n_u.cndexp_s.cndexp_type))
/*}}}*/
#endif
#ifdef CONFIG
/*{{{  confignode*/
#define ConnectFromEdgeOf(T)     ((T)->n_u.cnf_s.cnf_a)
#define ConnectToEdgeOf(T)       ((T)->n_u.cnf_s.cnf_b)
#define ConnectArcOf(T)          ((T)->n_u.cnf_s.cnf_c)

#define SetConnectFromEdge(T, V) ((T)->n_u.cnf_s.cnf_a = (V))
#define SetConnectToEdge(T, V)   ((T)->n_u.cnf_s.cnf_b = (V))
#define SetConnectArc(T, V)      ((T)->n_u.cnf_s.cnf_c = (V))

#define ConnectFromEdgeAddr(T) (&((T)->n_u.cnf_s.cnf_a))
#define ConnectToEdgeAddr(T)   (&((T)->n_u.cnf_s.cnf_b))
#define ConnectArcAddr(T)      (&((T)->n_u.cnf_s.cnf_c))

#define MapSourceOf(T)           ((T)->n_u.cnf_s.cnf_a)
#define MapDestOf(T)             ((T)->n_u.cnf_s.cnf_b)
#define MapPriOf(T)              ((T)->n_u.cnf_s.cnf_c)

#define SetMapSource(T,V)        ((T)->n_u.cnf_s.cnf_a = (V))
#define SetMapDest(T,V)          ((T)->n_u.cnf_s.cnf_b = (V))
#define SetMapPri(T,V)           ((T)->n_u.cnf_s.cnf_c = (V))

#define MapSourceAddr(T)       (&((T)->n_u.cnf_s.cnf_a))
#define MapDestAddr(T)         (&((T)->n_u.cnf_s.cnf_b))
#define MapPriAddr(T)          (&((T)->n_u.cnf_s.cnf_c))

#define STDevOf(T)               ((T)->n_u.cnf_s.cnf_a)
#define STAttrNameOf(T)          ((T)->n_u.cnf_s.cnf_b)
#define STAttrExpOf(T)           ((T)->n_u.cnf_s.cnf_c)

#define SetSTDev(T, V)           ((T)->n_u.cnf_s.cnf_a = (V))
#define SetSTAttrName(T, V)      ((T)->n_u.cnf_s.cnf_b = (V))
#define SetSTAttrExp(T, V)       ((T)->n_u.cnf_s.cnf_c = (V))

#define STDevAddr(T)           (&((T)->n_u.cnf_s.cnf_a))
#define STAttrNameAddr(T)      (&((T)->n_u.cnf_s.cnf_b))
#define STAttrExpAddr(T)       (&((T)->n_u.cnf_s.cnf_c))
/*}}}*/
#endif
/*{{{  constexpnode*/
#define CExpOf(T)     ((T)->n_u.ce_s.ce_exp)
#define HiValOf(T)    ((T)->n_u.ce_s.ce_vhi)
#define LoValOf(T)    ((T)->n_u.ce_s.ce_vlo)
#define CENextOf(T)   ((T)->n_u.ce_s.ce_next)
#define CEOffsetOf(T) ((T)->n_u.ce_s.ce_offset)

#define SetCExp(T,V)     ((T)->n_u.ce_s.ce_exp = (V))
#define SetHiVal(T,V)    ((T)->n_u.ce_s.ce_vhi = (V))
#define SetLoVal(T,V)    ((T)->n_u.ce_s.ce_vlo = (V))
#define SetCENext(T,V)   ((T)->n_u.ce_s.ce_next = (V))
#define SetCEOffset(T,V) ((T)->n_u.ce_s.ce_offset = (V))

#define CExpAddr(T) (&((T)->n_u.ce_s.ce_exp))
#define HiValAddr(T) (&((T)->n_u.ce_s.ce_vhi))
#define LoValAddr(T) (&((T)->n_u.ce_s.ce_vlo))
#define CENextAddr(T) (&((T)->n_u.ce_s.ce_next))
#define CEOffsetAddr(T) (&((T)->n_u.ce_s.ce_offset))
/*}}}*/
/*{{{  consttablenode*/
#define CTValOf(T)     ((T)->n_u.ct_s.ct_val)
#define CTExpOf(T)     ((T)->n_u.ct_s.ct_exp)
#define CTNextOf(T)    ((T)->n_u.ct_s.ct_next)
#define CTLabelOf(T)   ((T)->n_u.ct_s.ct_label)

#define SetCTVal(T,V)     ((T)->n_u.ct_s.ct_val = (V))
#define SetCTExp(T,V)     ((T)->n_u.ct_s.ct_exp = (V))
#define SetCTNext(T,V)    ((T)->n_u.ct_s.ct_next = (V))
#define SetCTLabel(T,V)   ((T)->n_u.ct_s.ct_label = (V))

#define CTValAddr(T) (&((T)->n_u.ct_s.ct_val))
#define CTExpAddr(T) (&((T)->n_u.ct_s.ct_exp))
#define CTNextAddr(T) (&((T)->n_u.ct_s.ct_next))
#define CTLabelAddr(T) (&((T)->n_u.ct_s.ct_label))
/*}}}*/
/*{{{  declnode*/
#define DNameOf(T)    ((T)->n_u.d_s.d_nameptr)
#define DValOf(T)     ((T)->n_u.d_s.d_v)
#define DBodyOf(T)    ((T)->n_u.d_s.d_body)

#define SetDName(T,V)    ((T)->n_u.d_s.d_nameptr = (V))
#define SetDVal(T,V)     ((T)->n_u.d_s.d_v = (V))
#define SetDBody(T,V)    ((T)->n_u.d_s.d_body = (V))

#define DNameAddr(T)  (&((T)->n_u.d_s.d_nameptr))
#define DValAddr(T)  (&((T)->n_u.d_s.d_v))
#define DBodyAddr(T)  (&((T)->n_u.d_s.d_body))

#define PlaceExpOf(T) ((T)->n_u.d_s.d_v)
#define SetPlaceExp(T,V) ((T)->n_u.d_s.d_v = (V))
#define PlaceExpAddr(T) (&((T)->n_u.d_s.d_v))
/*}}}*/
/*{{{  dopnode*/
#define LeftOpOf(T)     ((T)->n_u.dop_s.dop_leftop)
#define RightOpOf(T)    ((T)->n_u.dop_s.dop_rightop)
#define DOpTypeOf(T)    ((T)->n_u.dop_s.dop_type)

#define SetLeftOp(T,V)     ((T)->n_u.dop_s.dop_leftop = (V))
#define SetRightOp(T,V)    ((T)->n_u.dop_s.dop_rightop = (V))
#define SetDOpType(T,V)    ((T)->n_u.dop_s.dop_type = (V))

#define LeftOpAddr(T)   (&((T)->n_u.dop_s.dop_leftop))
#define RightOpAddr(T)  (&((T)->n_u.dop_s.dop_rightop))
#define DOpTypeAddr(T) (&((T)->n_u.dop_s.dop_type))

#ifdef SIC
#define DOpTempOf(T)      ((T)->n_u.dop_s.dop_temp)
#define SetDOpTemp(T,V)   ((T)->n_u.dop_s.dop_temp = (V))
#define DOpTempAddr(T)    (&((T)->n_u.dop_s.dop_temp))
#endif
/*}}}*/
/*{{{  fntypenode*/
#define FnTypeListOf(T)  ((T)->n_u.ls_s.ls_left)
#define FnParamsOf(T)    ((T)->n_u.ls_s.ls_right)

#define SetFnTypeList(T,V)  ((T)->n_u.ls_s.ls_left = (V))
#define SetFnParams(T,V)    ((T)->n_u.ls_s.ls_right = (V))

#define FnTypeListAddr(T) (&((T)->n_u.ls_s.ls_left))
#define FnParamsAddr(T) (&((T)->n_u.ls_s.ls_right))
/*}}}*/
/*{{{  hiddenparamnode*/
#define HExpOf(T)       ((T)->n_u.h_s.h_exp)
#define HDimensionOf(T) ((int)((T)->n_u.h_s.h_dimension))
/* When the hidden parameter is a function result pointer, this field
   contains the workspace offset of the parameter */
#define HOffsetOf(T)    ((T)->n_u.h_s.h_dimension)

#define SetHExp(T,V)       ((T)->n_u.h_s.h_exp = (V))
#define SetHDimension(T,V) ((T)->n_u.h_s.h_dimension = (BIT32)(V))
#define SetHOffset(T,V)    ((T)->n_u.h_s.h_dimension = (V))

#define HExpAddr(T)       (&((T)->n_u.h_s.h_exp))
#define HDimensionAddr(T) (&((T)->n_u.h_s.h_dimension))
#define HOffsetAddr(T) (&((T)->n_u.h_s.h_dimension))
/*}}}*/
/*{{{  instancenode*/
#define INameOf(T)      ((T)->n_u.i_s.i_nameptr)
#define IParamListOf(T) ((T)->n_u.i_s.i_paramlist)
#define ILoadSeqOf(T)   ((T)->n_u.i_s.i_loadseq)

#define SetIName(T,V)      ((T)->n_u.i_s.i_nameptr = (V))
#define SetIParamList(T,V) ((T)->n_u.i_s.i_paramlist = (V))
#define SetILoadSeq(T,V)   ((T)->n_u.i_s.i_loadseq = (V))

#define INameAddr(T) (&((T)->n_u.i_s.i_nameptr))
#define IParamListAddr(T) (&((T)->n_u.i_s.i_paramlist))
#define ILoadSeqAddr(T) (&((T)->n_u.i_s.i_loadseq))
/*}}}*/
/*{{{  listnode*/
#define LeftOf(T)       ((T)->n_u.ls_s.ls_left)
#define RightOf(T)      ((T)->n_u.ls_s.ls_right)

#define SetLeft(T,V)       ((T)->n_u.ls_s.ls_left = (V))
#define SetRight(T,V)      ((T)->n_u.ls_s.ls_right = (V))

#define LeftAddr(T)    (&((T)->n_u.ls_s.ls_left))
#define RightAddr(T)    (&((T)->n_u.ls_s.ls_right))
/*}}}*/
/*{{{  litnode*/
#define StringPtrOf(T)     ((T)->n_u.l_s.l_stringptr)

#define SetStringPtr(T,V)     ((T)->n_u.l_s.l_stringptr = (V))

#define StringPtrAddr(T) (&((T)->n_u.l_s.l_stringptr))
/*}}}*/
/*{{{  mopnode*/
#define OpOf(T)           ((T)->n_u.mop_s.mop_operand)
#define MOpTypeOf(T)      ((T)->n_u.mop_s.mop_type)

#define SetOp(T,V)        ((T)->n_u.mop_s.mop_operand = (V))
#define SetMOpType(T,V)   ((T)->n_u.mop_s.mop_type = (V))

#define OpAddr(T)       (&((T)->n_u.mop_s.mop_operand))
#define MOpTypeAddr(T)  (&((T)->n_u.mop_s.mop_type))

#ifdef SIC
#define MOpTempOf(T)      ((T)->n_u.mop_s.mop_temp)
#define SetMOpTemp(T,V)   ((T)->n_u.mop_s.mop_temp = (V))
#define MOpTempAddr(T)    (&((T)->n_u.mop_s.mop_temp))
#endif
/*}}}*/
#if 0 /* never used */
/*{{{  overlapnode*/
#define OBase1Of(T)            ((T)->n_u.o_s.o_base1)
#define OCount1Of(T)           ((T)->n_u.o_s.o_count1)
#define OBase2Of(T)            ((T)->n_u.o_s.o_base2)
#define OCount2Of(T)           ((T)->n_u.o_s.o_count2)

#define SetOBase1(T,V)         ((T)->n_u.o_s.o_base1 = (V))
#define SetOCount1(T,V)        ((T)->n_u.o_s.o_count1 = (V))
#define SetOBase2(T,V)         ((T)->n_u.o_s.o_base2 = (V))
#define SetOCount2(T,V)        ((T)->n_u.o_s.o_count2 = (V))

#define OBase1Addr(T)          (&((T)->n_u.o_s.o_base1))
#define OCount1Addr(T)         (&((T)->n_u.o_s.o_count1))
#define OBase2Addr(T)          (&((T)->n_u.o_s.o_base2))
#define OCount2Addr(T)         (&((T)->n_u.o_s.o_count2))
/*}}}*/
#endif
/*{{{  namenode*/

/* namenodes are defined in nameshdr.h */

/*}}}*/
/*{{{  processornode*/
#define ProcessorExpOf(T)      ((T)->n_u.p_s.p_exp)
#define ProcessorTypeOf(T)     ((T)->n_u.p_s.p_type)
#define ProcessorBodyOf(T)     ((T)->n_u.p_s.p_body)
#define ProcessorScopeOf(T)    ((T)->n_u.p_s.p_scope)

#define SetProcessorExp(T,V)   ((T)->n_u.p_s.p_exp = (V))
#define SetProcessorType(T,V)  ((T)->n_u.p_s.p_type = (V))
#define SetProcessorBody(T,V)  ((T)->n_u.p_s.p_body = (V))
#define SetProcessorScope(T,V) ((T)->n_u.p_s.p_scope = (V))

#define ProcessorExpAddr(T)  (&((T)->n_u.p_s.p_exp))
#define ProcessorTypeAddr(T) (&((T)->n_u.p_s.p_type))
#define ProcessorBodyAddr(T) (&((T)->n_u.p_s.p_body))
/*}}}*/
/*{{{  replcnode / arrayconstructor*/
#define ReplCNameOf(T)      ((T)->n_u.rc_s.rc_nameptr)
#define ReplCStartExpOf(T)  ((T)->n_u.rc_s.rc_startexp)
#define ReplCLengthExpOf(T) ((T)->n_u.rc_s.rc_lengthexp)
#define ReplCBodyOf(T)      ((T)->n_u.rc_s.rc_body)
#define ReplCTempOf(T)      ((T)->n_u.rc_s.rc_temp)

#define SetReplCName(T,V)      ((T)->n_u.rc_s.rc_nameptr = (V))
#define SetReplCStartExp(T,V)  ((T)->n_u.rc_s.rc_startexp = (V))
#define SetReplCLengthExp(T,V) ((T)->n_u.rc_s.rc_lengthexp = (V))
#define SetReplCBody(T,V)      ((T)->n_u.rc_s.rc_body = (V))
#define SetReplCTemp(T,V)      ((T)->n_u.rc_s.rc_temp = (V))

#define ReplCNameAddr(T)      (&((T)->n_u.rc_s.rc_nameptr))
#define ReplCStartExpAddr(T)  (&((T)->n_u.rc_s.rc_startexp))
#define ReplCLengthExpAddr(T) (&((T)->n_u.rc_s.rc_lengthexp))
#define ReplCBodyAddr(T)      (&((T)->n_u.rc_s.rc_body))
#define ReplCTempAddr(T)      (&((T)->n_u.rc_s.rc_temp))

/* These are the names for a array constructor node */

#define ACNameOf(T)      ((T)->n_u.rc_s.rc_nameptr)
#define ACStartExpOf(T)  ((T)->n_u.rc_s.rc_startexp)
#define ACLengthExpOf(T) ((T)->n_u.rc_s.rc_lengthexp)
#define ACValExpOf(T)    ((T)->n_u.rc_s.rc_body)

#define SetACName(T,V)      ((T)->n_u.rc_s.rc_nameptr = (V))
#define SetACStartExp(T,V)  ((T)->n_u.rc_s.rc_startexp = (V))
#define SetACLengthExp(T,V) ((T)->n_u.rc_s.rc_lengthexp = (V))
#define SetACValExp(T,V)    ((T)->n_u.rc_s.rc_body = (V))

#define ACNameAddr(T)      (&((T)->n_u.rc_s.rc_nameptr))
#define ACStartExpAddr(T)  (&((T)->n_u.rc_s.rc_startexp))
#define ACLengthExpAddr(T) (&((T)->n_u.rc_s.rc_lengthexp))
#define ACValExpAddr(T)    (&((T)->n_u.rc_s.rc_body))
/*}}}*/
/*{{{  segmentnode*/
#define SNameOf(T)            ((T)->n_u.s_s.s_nptr)
#define SStartExpOf(T)        ((T)->n_u.s_s.s_startexp)
#define SLengthExpOf(T)       ((T)->n_u.s_s.s_lengthexp)
#define SSubscriptExpOf(T)    ((T)->n_u.s_s.s_subscriptexp)
#define SCheckExpOf(T)        ((T)->n_u.s_s.s_checkexp)
#define SOffsetOf(T)          ((T)->n_u.s_s.s_offset)
#define SLengthOf(T)          ((T)->n_u.s_s.s_length)

#define SetSName(T,V)         ((T)->n_u.s_s.s_nptr = (V))
#define SetSStartExp(T,V)     ((T)->n_u.s_s.s_startexp = (V))
#define SetSLengthExp(T,V)    ((T)->n_u.s_s.s_lengthexp = (V))
#define SetSSubscriptExp(T,V) ((T)->n_u.s_s.s_subscriptexp = (V))
#define SetSCheckExp(T,V)     ((T)->n_u.s_s.s_checkexp = (V))
#define SetSOffset(T,V)       ((T)->n_u.s_s.s_offset = (V))
#define SetSLength(T,V)       ((T)->n_u.s_s.s_length = (V))

#define SNameAddr(T)          (&((T)->n_u.s_s.s_nptr))
#define SStartExpAddr(T)      (&((T)->n_u.s_s.s_startexp))
#define SLengthExpAddr(T)     (&((T)->n_u.s_s.s_lengthexp))
#define SSubscriptExpAddr(T)  (&((T)->n_u.s_s.s_subscriptexp))
#define SCheckExpAddr(T)      (&((T)->n_u.s_s.s_checkexp))
#define SOffsetAddr(T)        (&((T)->n_u.s_s.s_offset))
#define SLengthAddr(T)        (&((T)->n_u.s_s.s_length))
/*}}}*/
/*{{{  spacenode*/
/* The Namechain field is used by the workspace allocator, (either as a list
   of names declared in the process, or a list of constant tables in the
   process if the process is a  replicated PAR body)
   and reused by the code generator as a label. */
#define SpBodyOf(T)        ((T)->n_u.sp_s.sp_body)
#define SpMaxwspOf(T)      ((T)->n_u.sp_s.sp_maxwsp)
#define SpDatasizeOf(T)    ((T)->n_u.sp_s.sp_datasize)
#define SpVSUsageOf(T)     ((T)->n_u.sp_s.sp_vsusage)
#define SpNestedVSOf(T)    ((T)->n_u.sp_s.sp_nestedvs)
#define SpNamechainOf(T)   ((T)->n_u.sp_s.sp_namechain)
#define SpLabelOf(T)       ((int)(T)->n_u.sp_s.sp_namechain)
#define SpCPOffsetOf(T)    ((T)->n_u.sp_s.sp_cpoffset)

#define SetSpBody(T,V)        ((T)->n_u.sp_s.sp_body = (V))
#define SetSpMaxwsp(T,V)      ((T)->n_u.sp_s.sp_maxwsp = (V))
#define SetSpDatasize(T,V)    ((T)->n_u.sp_s.sp_datasize = (V))
#define SetSpVSUsage(T,V)     ((T)->n_u.sp_s.sp_vsusage = (V))
#define SetSpNestedVS(T,V)    ((T)->n_u.sp_s.sp_nestedvs = (V))
#define SetSpNamechain(T,V)   ((T)->n_u.sp_s.sp_namechain = (V))
#define SetSpLabel(T,V)       ((T)->n_u.sp_s.sp_namechain = (treenode *)(V))
#define SetSpCPOffset(T,V)    ((T)->n_u.sp_s.sp_cpoffset = (V))

#define SpBodyAddr(T)        (&((T)->n_u.sp_s.sp_body))
/*}}}*/
/*{{{  valofnode*/
#define VLBodyOf(T)       ((T)->n_u.vl_s.vl_body)
#define VLResultListOf(T) ((T)->n_u.vl_s.vl_resultlist)

#define SetVLBody(T,V)       ((T)->n_u.vl_s.vl_body = (V))
#define SetVLResultList(T,V) ((T)->n_u.vl_s.vl_resultlist = (V))

#define VLBodyAddr(T) (&((T)->n_u.vl_s.vl_body))
#define VLResultListAddr(T) (&((T)->n_u.vl_s.vl_resultlist))
/*}}}*/
/*{{{  variantnode*/
#define VRTaggedListOf(T) ((T)->n_u.vr_s.vr_taggedlist)
#define VRBodyOf(T)       ((T)->n_u.vr_s.vr_body)

#define SetVRTaggedList(T,V) ((T)->n_u.vr_s.vr_taggedlist = (V))
#define SetVRBody(T,V)       ((T)->n_u.vr_s.vr_body = (V))

#define VRTaggedListAddr(T) (&((T)->n_u.vr_s.vr_taggedlist))
#define VRBodyAddr(T) (&((T)->n_u.vr_s.vr_body))
/*}}}*/
/*{{{  wordnode*/
#define WTagOf(N)         ((N)->w_tag)
#define WNameOf(N)        ((N)->w_name)
#define WLengthOf(N)      ((N)->w_length)
#define WNextOf(N)        ((N)->w_next)

#define SetWTag(N,V)      ((N)->w_tag = (V))
#define SetWName(N,V)     ((N)->w_name = (V))
#define SetWLength(N,V)   ((N)->w_length = (V))
#define SetWNext(N,V)     ((N)->w_next = (V))

#define WNameAddr(N)      (&((N)->w_name))
/*}}}*/

/*{{{  tree walking constants*/
#define STOP_WALK     TRUE
#define CONTINUE_WALK FALSE
/*}}}*/
/*{{{  function headers*/

void applytoexp PARMS((treenode *tptr, void (*f1)(treenode *)));

void vtiinit PARMS((void));
void vtifinish PARMS((void));
void *memalloc PARMS((size_t size));
void memfree PARMS((void *ptr));
void *newvec PARMS((size_t n));

int  switch_to_temp_workspace PARMS((void));
int  switch_to_real_workspace PARMS((void));
void switch_to_prev_workspace PARMS((int old));
void freeup_temp_workspace PARMS((void));

#ifdef CONFIG
void freeup_all_workspace PARMS((void));
void freevec PARMS((void *ptr, size_t size));
void freenode PARMS((treenode **tptr));
void freetree PARMS((treenode **tptr));
#endif

long tablesize PARMS((void));

#if 0 /*def CONFIG*/
void markws PARMS((void));
void freews PARMS((void));
#endif

void marknametrans PARMS((void));
void freenametrans PARMS((void));
void addnametrans PARMS((treenode *o, treenode *n));
treenode *transcopytree PARMS((treenode *tptr, SOURCEPOSN locn));
treenode *copytree PARMS((treenode *tptr));
void initcopytree PARMS((void));

void prewalktree        PARMS((treenode  *tptr, int (*f1)(treenode  *)));
void prewalkproctree    PARMS((treenode  *tptr, int (*f1)(treenode  *)));
void modprewalktree     PARMS((treenode **tptr, int (*f1)(treenode **)));
void modprewalkproctree PARMS((treenode **tptr, int (*f1)(treenode **)));


treenode *newactionnode  PARMS((int t, SOURCEPOSN ln, treenode *l, treenode *r));
treenode *newaltnode  PARMS((int t, SOURCEPOSN ln, treenode *g,
                             treenode *i, treenode *b));
treenode *newarraynode    PARMS((int t, SOURCEPOSN ln, treenode *d, treenode *tp));
treenode *newarraysubnode PARMS((int t, SOURCEPOSN ln, treenode *b, treenode *i));
treenode *newchannode  PARMS((int t, SOURCEPOSN ln, treenode *p));
treenode *newcnode  PARMS((int t, SOURCEPOSN ln, treenode *b));
treenode *newcondnode  PARMS((int t, SOURCEPOSN ln, treenode *condition,
                              treenode *process));
treenode *newconstexpnode  PARMS((int t, SOURCEPOSN ln, treenode *e,
                                  BIT32 h, BIT32 l));
treenode *newconstant PARMS((BIT32 n));
treenode *newconsttablenode  PARMS((int t, SOURCEPOSN ln, wordnode *v,
                                    treenode *e));
treenode *newdeclnode  PARMS((int t, SOURCEPOSN ln, treenode *n,
                              treenode *val, treenode *b));
treenode *newdopnode  PARMS((int t, SOURCEPOSN ln, treenode *l, treenode *r, int type));
treenode *newhiddenparamnode  PARMS((int t, SOURCEPOSN ln, treenode *e, int d));
treenode *newinstancenode  PARMS((int t, SOURCEPOSN ln, treenode *n, treenode *p));
treenode *newleafnode  PARMS((int t, SOURCEPOSN ln));
treenode *newlistnode  PARMS((int t, SOURCEPOSN ln, treenode *l, treenode *r));
treenode *newlitnode  PARMS((int t, SOURCEPOSN ln, wordnode *w));
treenode *newmopnode  PARMS((int t, SOURCEPOSN ln, treenode *o, int type));
treenode *newnamenode PARMS((int tag, SOURCEPOSN ln,
                             wordnode *name,
                             treenode *type, treenode *spec,
                             int lexlevel, int scope,
                             int mode));
treenode *newprocessornode  PARMS((int t, SOURCEPOSN ln, treenode *exp,
                            wordnode *type,
                            treenode *process));
treenode *newreplcnode  PARMS((int t, SOURCEPOSN ln, treenode *n,
                               treenode *s, treenode *l, treenode *b));
treenode *newsegmentnode  PARMS((int t, SOURCEPOSN ln, treenode *n, treenode *s,
                                 treenode *l));
treenode *newspacenode  PARMS((int t, SOURCEPOSN ln, treenode *p,
                               BIT32 maxwsp, BIT32 datasize,
                               BIT32 vsusage, BIT32 nestedvs,
                               treenode *namechain, int cpoffset));
treenode *newvariantnode  PARMS((int t, SOURCEPOSN ln, treenode *tl, treenode *b));
treenode *newvalofnode  PARMS((int t,SOURCEPOSN ln, treenode *b, treenode *r));
wordnode *newwordnode  PARMS((int t, char *name, int len, wordnode *next));

treenode *NParamListOf PARMS((treenode *n));
void SetNParamList PARMS((treenode *n, treenode *v));

#ifdef CONDEXP
treenode *newcondexpnode PARMS((int t, SOURCEPOSN ln,
                          treenode *condition, treenode *true, treenode *false));
#endif

#ifdef CONFIG
treenode *newconfignode PARMS((int t, SOURCEPOSN ln, treenode *a, treenode *b, treenode *c));
#endif
/*}}}*/

/* pretty printing */
void printbyte PARMS((int b));
void printstring PARMS((char *s, int l));
void printexp PARMS((treenode *t));
void printtree PARMS((int i, treenode *t));
/*void printstatement PARMS((int indent, treenode *s));*/

/* node tags etc */
char *keywordstring PARMS((int t));
char *tagstring PARMS((int t));
char *itagstring PARMS((int t));
void  ftagstring PARMS((char *string, int t));
int nodetypeoftag PARMS((int t));

int parrepl PARMS((int replc));
#ifdef CONFIG
int network_datatype PARMS((int type));
#endif

void declkeywords PARMS((void));

/* special ASM names */
/* The order of these matters, cos they're inserted into the name array
   in this order */
#define ASMNAME_WSSIZE       0
#define ASMNAME_VSPTR        1
#define ASMNAME_STATIC       2

#define ASMNAMES_COUNT       3

/* Contents of the 'asmvalids' array: */
#define ASMNAME_INVALID           0       /* Value not yet known */
#define ASMNAME_VALID             1       /* Value can be inserted */
#define ASMNAME_ERROR             2       /* Value cannot be determined */

extern INT32 asmvalues[];
extern int   asmvalids[];
int which_asmname PARMS((treenode *tptr));

