/*#define DEBUG*/
/****************************************************************************
 *
 *  Occam two syntax analyser 4
 *
 *  parsing for configuration extensions
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1990
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include <string.h>
# include "includes.h"
# include "lexdef.h"
# include "lex1def.h"
# include "desc1def.h"
# include "syndef.h"
# include "synerror.h"
# include "syn1def.h"
# include "syn2def.h"
# include "syn3def.h"
# include "syn4def.h"
/*}}}*/

#ifdef CONFIG
/*{{{  PUBLIC treenode *rconfigdef ()*/
/* Terminates with symb at start of next line */
PUBLIC treenode *rconfigdef ()
{
  int indent = symbindent;
  SOURCEPOSN locn = flocn;
  wordnode *name;
  treenode *pbody;
  treenode *retptr;
  int oldlexlevel = lexlevel;
  int thistag = symb;
  char *string = tagstring(thistag);  /* Any name will do, so we use the keyword */
  DEBUG_MSG(("rconfigdef: %s\n", string));
  lexlevel++;
  foundroutine = TRUE;

  nextsymb();
  /*if ((name = rname ()) == NULL) goto error;*/
  if (symb == S_NAME)
    { name = lexword; nextsymb(); }
  else
    { /* invent a name */
      name = lookupword(string, strlen(string));
    }
  if (checknlindent (indent + 2)) goto error2;

  pbody = rprocess();

  if (checkindent (indent))     goto error2;
  while (symb == S_COMMENT)
    if (checknlindent (indent)) goto error2;
  if (checkfor (S_COLON))       goto error2;

  lexlevel = oldlexlevel;
  retptr = declare(thistag, locn, NULL, name, pbody);
  if (checknlindent (indent))
    { skiplines(indent); return(NULL); }
  return retptr;

/*error:
  nextline ();*/
error2:
  msg_out_s(SEV_INFO, SYN, SYN_SKIPPING_DEFN, 0, string);
  skiplines (indent);
  if (symb == S_COLON) nextline ();
  lexlevel = oldlexlevel;
  return NULL;
}
/*}}}*/
/*{{{  PUBLIC treenode *rset()*/
PUBLIC treenode *rset ( void )
/* What we are parsing:
   SET element '(' name {',' name} ':=' exp {',' exp} ')'
*/
{
  treenode *node, *lhs, *rhs;
  nextsymb();
  if (   (node = relement()) == NULL
      || checkfor(S_LPAREN)
      || checklinebreak()
      || (lhs = rlist((treenode *(*)())rname, S_COMMA)) == NULL
      || checkfor(S_ASS)
      || checklinebreak()
      || (rhs = rlist(rexp, S_COMMA)) == NULL
      || checkfor(S_RPAREN)
     )
    {
      nextline ();
      return NULL;
    }

  node = newconfignode(S_SET, flocn, node, lhs, rhs);
  checknewline ();
  return node;
}
/*}}}*/
/*{{{  PUBLIC treenode *rconnect()*/
PUBLIC treenode *rconnect ( void )
{
  /*{{{  what we are parsing*/
  /*
    'CONNECT' element 'TO' element [ 'WITH' element ]
  */
  /*}}}*/
  treenode *fromedge, *toedge, *arc = NULL;
  nextsymb(); /* Skip CONNECT */
  if (   (fromedge = relement()) == NULL
      || checkfor(S_TO)
      || checklinebreak()
      || (toedge = relement()) == NULL
      )
    {
      nextline ();
      return NULL;
    }
  if (symb == S_WITH)
    {
      nextsymb();
      checklinebreak();
      if ((arc = relement()) == NULL)
        { nextline(); return NULL; }
    }
  fromedge = newconfignode(S_CONNECT, flocn, fromedge, toedge, arc);
  checknewline ();
  return fromedge;
}
/*}}}*/
/*{{{  PUBLIC treenode *rmap()*/
PUBLIC treenode *rmap ( void )
{
  /*{{{  what we are parsing*/
  /*
    'MAP' {, element} 'ONTO' element
  */
  /*}}}*/
  treenode *sourcelist, *dest, *pri = NULL;
  nextsymb(); /* Skip MAP */
  
  if (   (sourcelist = rlist(relement, S_COMMA)) == NULL
      || checkfor(S_ONTO)
      || checklinebreak()
      || (dest = relement()) == NULL
      )
    {
      nextline ();
      return NULL;
    }
  if (symb == S_PRI)
    {
      nextsymb();
      checklinebreak();
      if ((pri = rexp()) == NULL)
        { nextline(); return NULL; }
    }
  sourcelist = newconfignode(S_MAP, flocn, sourcelist, dest, pri);
  checknewline ();
  return sourcelist;
}
/*}}}*/
#endif  /*CONFIG*/
