/*#define DEBUG*/
/****************************************************************************
 *
 *  Occam two syntax analyser 3
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include <string.h>
#if 0 /* ifdef SUN */
# include <ctype.h>
#endif
# include "includes.h"
# include "lexconst.h"
# include "chkdef.h"
# include "synerror.h"
# include "instdef.h"
# include "lex1def.h"
# include "lexdef.h"
# include "desc1def.h"
# include "syn1def.h"
# include "syn2def.h"
# include "syn3def.h"
# include "syndef.h"
# include "chk4def.h"
# include "chk1def.h"
#ifdef CONFIG
# include "syn4def.h"
# include "predefhd.h"
#endif
/*}}}*/

/*{{{  PRIVATE data*/
#ifdef CONFIG
PUBLIC treenode *hostedgeptr;
#endif
/*}}}*/

/*{{{  routines*/
/*{{{  reading predefined names*/
/*{{{  PRIVATE treenode *rpredefparam ()*/
/*****************************************************************************
 *
 *  rpredefparam reads in the specification of a parameter to a predefined
 *               PROC or FUNCTION.
 *
 *****************************************************************************/
PRIVATE treenode *rpredefparam (void)
{
  int ptag;
  if (symb == S_VAL)
    {
      ptag = N_VALPARAM;
      nextsymb();
    }
  else
    ptag = N_PARAM;
  return(declname(ptag, flocn, NULL, rspecifier(), NULL));
}
/*}}}*/
/*{{{  PRIVATE void rpredefs ()*/
/*****************************************************************************
 *
 *  rpredefs reads in and declares all the predefined names
 *           It does nothing sensible on error.
 *
 *****************************************************************************/
/*{{{  comment syntax*/
/*
   predef = ( FUNCTION specifier { ',' specifier } |
              PROC )
            '(' predefparam { ',' predefparam } ')' name ':'
          | field specifier name ':'

   predefparam = [ 'VAL' ] specifier
 */
/*}}}*/
PRIVATE void rpredefs ( void )
{
  int ntag;
  wordnode  *name;
  treenode *type, *ftypelist;
  while (symb != S_END)
    /*{{{  read a predefine specification*/
    {
      int pdno = pdnumber;  /* ** SHC 6-Apr-1988 */
    #ifdef CONFIG /* added globally visible configuration predefines */
      if (symb != S_FUNCTION && symb != S_PROC)
        {
          if (symb == S_CONFIG)
            {
              ntag = N_FIELD;
              nextsymb();
            }
          else
            ntag = N_DECL;
          type = rspecifier();
          name = rname();
          checkfor(S_COLON);
        }
      else
    #endif
      {
        if (symb == S_FUNCTION)
          /*{{{  set tag, read function type*/
          {
            ntag = N_PREDEFFUNCTION;
            nextsymb();
            ftypelist = rlist(rspecifier, S_COMMA);
          }
          /*}}}*/
        else if (symb == S_PROC)
          /*{{{  set tag*/
          {
            ntag = N_PREDEFPROC;
            nextsymb();
          }
          /*}}}*/
        else
          {
            synerr(SYN_PREDEF_ERROR, flocn);
            longjmp(env, TRUE);
          }
        checkfor(S_LPAREN);
        if (symb != S_RPAREN)
          type = rlist(rpredefparam, S_COMMA);
        else
          type = NULL;
        checkfor(S_RPAREN);
        name = rname();
        checkfor(S_COLON);
        if (ntag == N_PREDEFFUNCTION)
          type = newlistnode(S_FNTYPE, flocn, ftypelist, type);
      }
      /*{{{  make the namenode            **SHC 5-Apr-1988*/
      {
        treenode *nptr = declname(ntag, flocn, name, type, NULL);
        SetNMode(nptr, pdno);
      #ifdef CONFIG
        if (pdno == PD_HOSTEDGE)
          hostedgeptr = nptr;

        if (ntag == N_FIELD)
          add_attribute(nptr); /* not globally scoped */
        else
      #endif
          addname(nptr); /* Declare the predefined name to the scoper */
      }
      /*}}}*/
      checknewline();
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/

/*{{{  PUBLIC int rrepl(nptr, start, length)*/
/* parsing:      name '=' exp 'FOR' exp         */
PUBLIC int rrepl ( treenode **nptr , treenode **start , treenode **length )
{
  wordnode *name;

  if (((name = rname ()) == NULL)   ||
      (checkfor (S_EQ))   ||
      ((*start = rexp ()) == NULL)   ||
      (checkfor (S_FOR)) ||
      (checklinebreak ())           ||
      ((*length = rexp ()) == NULL))
    return TRUE;

  *nptr = declname (N_REPL, flocn, name, newleafnode (S_INT, flocn), NULL);
  SetNReplKnown(*nptr, FALSE); /* just make sure */

  return FALSE;
}
/*}}}*/
/*{{{  PRIVATE treenode *rspecorelement (specflag, indent)*/
PRIVATE treenode *rspecorelement ( int *specflag , int indent )
{
  /*{{{  what we are parsing*/
  /* Parse
              element
            | specification
     and return the parse tree.
     *specflag is TRUE  if a specification was found,
                  FALSE if an element was found.
  */
  /*}}}*/
  SOURCEPOSN locn = flocn;
  treenode *a;
  *specflag = FALSE;
  if (mustbespec(symb))
    { *specflag = TRUE; return (rspecification()); }
  switch (symb)
    {
      /*{{{  S_NAME*/
      case S_NAME:
        {
          a = (treenode *)rname();
          if (symb == S_IS)
            {
              *specflag = TRUE;
              return (rrestofspec (NULL, a, locn, indent));
            }
          else
            {
              if (symb == S_LBOX && ((a = rsubscript(a)) == NULL))
                goto error;
              return a;
            }
          break;
        }
      /*}}}*/
      /*{{{  S_LBOX*/
      case S_LBOX:
        nextsymb ();
        if ((a = rexp ()) == NULL)
          goto error;
        if (symb == S_RBOX)
          /*{{{  read declaration of array type, or function definition*/
          {
            treenode *spec;
            *specflag = TRUE;
            nextsymb ();
            if ((spec = rspecifier ()) == NULL)
              goto error;
            a = newarraynode (S_ARRAY, locn, a, spec);
            return (rspecnameandbody(a, locn, indent));
          }
          /*}}}*/
        else if (symb == S_FROM)
          /*{{{  read segment*/
          {
            if ((a = rsegment(a)) == NULL)
              goto error;
            if (symb == S_LBOX && ((a = rsubscript (a)) == NULL))
              goto error;
            return a;
          }
          /*}}}*/
        else
          {
            synerr_e (SYN_E_RBOX_OR_FROM, flocn, symb);
            goto error;
          }
        break;
      /*}}}*/
      default:
        synerr_e(SYN_E_ELEMENT_OR_SPEC, locn, symb);
      error:
        if (*specflag) { nextline (); skiplines (indent); }
        return NULL;
    }
}
/*}}}*/
#if 0 /* never used */
/*{{{  PRIVATE treenode *rplaceprocess ()*/
PRIVATE treenode *rplaceprocess ( void )
{
  treenode *a;
  treenode *procroot;
  treenode *(*procptr);
  procptr = &procroot;
  while (TRUE)
    {
      SOURCEPOSN locn = flocn;             /* Location of first symbol of process */
      int indent = symbindent;
      linebreakindent = (-1);
      DEBUG_MSG(("rplaceprocess... "));
      switch (symb)
        {
          /*{{{  S_NAME*/
          case S_NAME :
          {
            int specflag;
            if ((a = rspecorelement(&specflag, indent)) == NULL)
              goto error2;
            if (specflag)
              {*procptr = a; procptr = DBodyAddr(a);}
            else
              {
                if (symb == S_LPAREN)
                  /*{{{  parse procedure call; return*/
                  {
                    *procptr = rinstance(S_PINSTANCE, locn, a);
                    checknewline ();
                    return (procroot);
                  }
                  /*}}}*/
                else
                  {
                    synerr(SYN_PROG_ERROR, flocn);
                    goto error2;
                  }
              }
          }
          break;
          /*}}}*/
          /*{{{  S_SEQ*/
          case S_SEQ:
            *procptr = rconstruct (rplaceprocess, S_SEQ, S_REPLSEQ);
            return (procroot);
          /*}}}*/
          /*{{{  S_LBOX VAL PROTOCOL S_CHAN*/
          case S_PROC: case S_LBOX: case S_VAL:
            {
              if (symb != S_PROC || lexmode != LEX_SOURCE)
                {
                  treenode *s = rspecification ();
                  if (s == NULL)
                    goto error;
                  if ((TagOf(s) == S_LFUNCDEF) || (TagOf(s) == S_SFUNCDEF))
                    {
                      synerr(SYN_PROG_ERROR, flocn);
                      goto error;
                    }
                  else
                    {
                      *procptr = s;
                      procptr = DBodyAddr(*procptr);
                    }
                }
              else    
                {
                  synerr(SYN_PROG_ERROR, flocn);
                  goto error;
                }
              break;
            }
          /*}}}*/
          /*{{{  S_INCLUDE*/
          case S_INCLUDE: case S_USE: case S_IMPORT:
            if (!rfile ()) goto error2;
            break;
          /*}}}*/
          /*{{{  S_PRAGMA*/
          case S_PRAGMA:
            {
              int saved_indent = indent;
              if (!rpragma()) goto error2;
              ignorecomments(saved_indent);
            }
            break;
          /*}}}*/
          /*{{{  S_HCOMMENT*/
          case S_HCOMMENT:
            nextsymb();  /* string after comment */
            if (symb != S_STRING)
              {
                synerr(SYN_E_HCOMMENT, flocn);
                nextline();
              }
            else
              {
                process_hcomment(literalv, literalp);
                nextsymb (); /* should be end of line */
                /*{{{  check nl, indent*/
                if (checknlindent(indent))
                  goto error2;
                /*}}}*/
              }
            break;
          /*}}}*/
          /*{{{  S_OPTION*/
          case S_OPTION:
            synerr(SYN_OPTION_IN_BAD_POS, flocn);
            nextline();
            break;
          /*}}}*/
          /*{{{  S_STOP S_SKIP*/
          case S_STOP: case S_SKIP:
            *procptr = newleafnode (symb, locn);
            nextsymb (); checknewline ();
            return (procroot);
          /*}}}*/
          default:
            synerr(SYN_PROG_ERROR, flocn);
          error:
            nextline ();
          error2:
            skiplines (indent);
        }
    }
}
/*}}}*/
#endif
#if 0 /* this does both PLACED PAR and PROCESSOR */
/*{{{  PRIVATE treenode *rplacement ()*/
/**********************  Start comment out ****************************
placedpar == PLACED PAR
               placedpar
           | PROCESSOR element    -- for CONFIG
               process
           | PROCESSOR exp type   -- for normal compiler
               process
if error in first line, try to parse process anyway.
**********************   End comment out  ****************************/
PRIVATE treenode *rplacement ( void )
{
  int indent = symbindent;
  SOURCEPOSN locn = flocn;

  if (symb == S_PLACED)
    /*{{{  parsing PLACED PAR*/
    {
      nextsymb ();
      if (symb == S_PAR)
        {
          treenode *pp;
          pp = rconstruct (rplacement, S_PLACEDPAR, S_PLACEDREPLPAR);
          if (checkindent (indent))
            return NULL;
          return (pp);
        }
      synetoken (S_PAR);
      goto error;
    }
    /*}}}*/
  else if (!checkfor (S_PROCESSOR))
#ifdef CONFIG
    /*{{{  parsing PROCESSOR element*/
    {
      treenode *e;
      treenode *t;
      if ((e = relement()) == NULL)
        goto error;
      if (checknlindent (indent + 2))
        goto error2;
      lexlevel++;
      t = newprocessornode (S_PROCESSOR, locn, e, NULL, rprocess());
      lexlevel--;
      return (t);
    }
    /*}}}*/
#else
    /*{{{  parsing PROCESSOR EXP type*/
    {
      treenode *e;
      treenode *t;
      wordnode *ptype;
      if ((e = rexp ()) == NULL)
        goto error;
      if (symb == S_NAME)
        {
          ptype = lexword;
          nextsymb ();
          setprocessor(WNameOf(ptype)); setprocessorattr();
        }
      else
        {
          synerr_e(SYN_E_PROCESSOR_TYPE, flocn, symb);
          goto error;
        }
      if (checknlindent (indent + 2))
        goto error2;
      lexlevel++;
      t = newprocessornode (S_PROCESSOR, locn, e, ptype, rprocess());
      lexlevel--;
      return (t);
    }
    /*}}}*/
#endif
  else
    goto error;

error:
  nextline ();
error2:
  skiplines (indent);
  return NULL;
}
/*}}}*/
#endif
/*{{{  PRIVATE treenode *rprocessor ()*/
/**********************  Start comment out ****************************
processor = PROCESSOR element
              process
**********************   End comment out  ****************************/
PRIVATE treenode *rprocessor ( void )
{
  int indent = symbindent;
  treenode *e;
  treenode *t;
  SOURCEPOSN locn = flocn;

  nextsymb();
  if ((e = relement()) == NULL)
    goto error;
  if (checknlindent (indent + 2))
    goto error2;
  lexlevel++;
  t = newprocessornode (S_PROCESSOR, locn, e, NULL, rprocess());
  lexlevel--;
  return (t);

error:
  nextline ();
error2:
  skiplines (indent);
  return NULL;
}
/*}}}*/
/*{{{  PUBLIC treenode *rinputitem ()*/
PUBLIC treenode *rinputitem ( void )
{
  treenode *a;
  /* read in  {1 ';' (variable [:: variable]) } */
  DEBUG_MSG(("rinputitem... "));
  if ((a = relement ()) == NULL)
    return NULL;
  if (symb == S_COLON2)
    {
      SOURCEPOSN locn = flocn;
      treenode *array;
      nextsymb ();
      if ((array = relement ()) == NULL)
        return NULL;
      a = newdopnode (S_COLON2, locn, a, array, 0);
    }

  return (a);
}
/*}}}*/
/*{{{  PUBLIC treenode *routputitem ()*/
PUBLIC treenode *routputitem ( void )
{
  treenode *a;

  DEBUG_MSG(("routputitem... "));
  if ((a = rexp ()) == NULL)
    return NULL;
  if (symb == S_COLON2)
    {
      SOURCEPOSN locn = flocn;
      treenode *array;
      nextsymb ();
      if ((array = rexp ()) == NULL)
        return NULL;
      a = newdopnode (S_COLON2, locn, a, array, 0);
    }
  return (a);
}
/*}}}*/
/*{{{  PUBLIC treenode *rselection ()*/
PUBLIC treenode *rselection ( void )
{
  int indent = symbindent;
  SOURCEPOSN locn;
  treenode *selroot;
  treenode **selptr;

  DEBUG_MSG(("rselection... "));
  while (symb == S_COMMENT)
    if (checknlindent (indent))
      goto error;
  selptr = &selroot;
  /*{{{  parse selection*/
  {
    int reading = TRUE;
    while (reading)
      {
        treenode *exp;
        locn = flocn;
        linebreakindent = (-1);
        if (!rleadingspecs(selptr, &exp))
          {
            /*{{{  skip specs*/
            while (*selptr != NULL)
              selptr = DBodyAddr(*selptr);
            /*}}}*/
            locn = flocn; /* bug 873 28/1/91 */
            if (exp != NULL)
              /*{{{  it was an expression - read rest of selection*/
              {
                if (TagOf(exp) != S_LIST)
                  {
                    treenode *e = NULL;
                    if (symb == S_COMMA)
                      {
                        nextsymb();
                        if (checklinebreak ())
                          return NULL;
                        if ((e = rlist (rexp, S_COMMA)) == NULL)
                          { nextline (); goto error; }
                      }
                    *selptr = newlistnode(S_LIST, locn, exp, e);
                  }
                /* else we have read all the expressions in */
                reading = FALSE;
              }
              /*}}}*/
            else if (symb == S_ELSE)
              /*{{{  read body of else*/
              {
                *selptr = newleafnode(S_ELSE, locn);
                nextsymb();
                reading = FALSE;
              }
              /*}}}*/
            else
              {
                synerr_e(SYN_E_EXPR_OR_SPEC, locn, symb);
                nextline ();
              }
          }
        else
          { nextline (); return NULL; }
      }
  }
  /*}}}*/
  if (checknlindent (indent + 2))
    goto error;
  *selptr = newcondnode(S_SELECTION, locn, *selptr, rprocess());
  return (selroot);
error:
  skiplines (indent);
  return NULL;
}
/*}}}*/
/*{{{  PUBLIC treenode *rvariant ()*/
PUBLIC treenode *rvariant ( void )
{
  treenode *varroot;
  treenode **varptr;
  int indent = symbindent;
  DEBUG_MSG(("rvariant... "));
  varptr = &varroot;
  /*{{{  parse variant*/
  {
    treenode *exp;
    linebreakindent = (-1);
    if (!rleadingspecs(varptr, &exp))
      {
        SOURCEPOSN locn = flocn; /* moved for bug 873 28/1/91 */
        /*{{{  skip specs*/
        while (*varptr != NULL)
          varptr = DBodyAddr(*varptr);
        /*}}}*/
        if (exp != NULL)
          /*{{{  read rest of variant*/
          {
            treenode *a, *list = NULL;
            if (symb == S_SEMICOLON)
              /*{{{  parse tagged list*/
              {
                nextsymb();
                if (checklinebreak ())
                  goto error2;
                if ((list = rlist(rinputitem, S_SEMICOLON)) == NULL)
                  goto error;
              }
              /*}}}*/
            a = newlistnode (S_LIST, locn, exp, list);
            if (checknlindent (indent + 2))
              goto error2;
            *varptr = newvariantnode (S_VARIANT, locn, a, rprocess());
            return (varroot);
          }
          /*}}}*/
        else
          synerr_e(SYN_E_EXPR_OR_SPEC, locn, symb);
      }
    error:
      nextline ();
    error2:
      skiplines (indent);
      return NULL;
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC treenode *rconstruct (readbody, c, replc)*/
PUBLIC treenode *rconstruct (treenode *(*readbody)(void), int c , int replc )
{
  int indent = lineindent;           /* Indent of first token of construct */
  SOURCEPOSN locn = flocn;               /* Location of start of construct */
  DEBUG_MSG(("rconstruct... "));
  nextsymb ();
  ignore (S_COMMENT);                /* Ignore any trailing comment */
  if (symb == S_NEWLINE)
    /*{{{  we do not have a replicator*/
    {                                /* We do not have a replicator */
      treenode *w;
      nextline ();
      w = rproclist (readbody, indent + 2);
      return (newcnode (c, locn, w));
    }
    /*}}}*/
  else
    /*{{{  we have a replicator*/
    {
      treenode *start, *length;
      treenode *nptr, *rcptr;
    
      if (rrepl(&nptr, &start, &length))
        goto error;
      if (checknlindent (indent + 2))
        goto error2;
    
      /* Declare replicator variable */
      rcptr = newreplcnode (replc, locn, nptr, start, length, NULL);
      SetNDecl(nptr, rcptr);
      /* Increment lex level inside a replicated PAR */
      if (parrepl(replc)) lexlevel++;
      SetReplCBody(rcptr, (*readbody)());
      if (parrepl(replc)) lexlevel--;
      return (rcptr);
    
    error:
      nextline ();
    error2:
      skiplines (indent);
      return (newcnode (c, locn, NULL));
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE treenode *raltbody (a, locn, indent)*/
PRIVATE treenode *raltbody ( treenode *a , SOURCEPOSN locn , int indent )
{
  /*{{{  COMMENT what we are parsing*/
  /* Parse
        (  [ boolean '&' ] ( channel '?' {1 ';' input.item }  |
                            timer '?' 'AFTER' expression     |
                            channel '?' 'CASE' tagged.list   |
                            timer '?' variable               |
                            port '?' variable                )  |
            boolean '&' 'SKIP'                                    )
          process                                                   |
        [ boolean '&' ] channel '?' 'CASE'
          { variant }
  */
  /*}}}*/
  treenode *input;
  treenode *guard = NULL;

  if (symb == S_AMPERSAND)
    /*{{{  a was the boolean, so now read in the channel into a*/
    {
      guard = a;
      nextsymb ();
    
      if (symb == S_SKIP)
        /*{{{  there is no channel in the alt*/
        {
          nextsymb ();
          if (checknlindent (indent + 2))
            return NULL;
          return (newaltnode (S_ALTERNATIVE, locn, guard,
                                   newleafnode(S_SKIP, locn), rprocess()));
        }
        /*}}}*/
      else
        /*{{{  parse input*/
        if ((a = relement ()) == NULL)
          goto error;
        /*}}}*/
    }
    /*}}}*/
  /*{{{  read input*/
  {
    SOURCEPOSN ilocn = flocn;
    if (checkfor (S_INPUT))
      goto error;
    switch (symb)
      {
        /*{{{  case S_CASE*/
        case S_CASE:
          /*  We should have
              [ boolean '&' ] channel '?' 'CASE' tagged.list         |
              [ boolean '&' ] channel '?' 'CASE'
                { variant }
              and we have got as far as the 'CASE'
          */
          nextsymb ();
          if ((symb == S_COMMENT) || (symb == S_NEWLINE))
            /*{{{  look for variant list*/
            {
              treenode *vl;
              checknewline ();
              vl = rproclist (rvariant, indent + 2);
              input = newactionnode (S_CASE_INPUT, ilocn, a, vl);
              return (newaltnode (S_ALTERNATIVE, locn, guard, input, NULL));
              /* Get out early because there is no process following a
                 case input alternative */
            }
            /*}}}*/
          else
            /*{{{  look for tagged list*/
            {
              treenode *list;
              if ((list = rlist (rinputitem, S_SEMICOLON)) == NULL)
                goto error;
              input = newactionnode (S_TAGGED_INPUT, ilocn, a, list);
              checknewline ();
            }
            /*}}}*/
          break;
        /*}}}*/
        /*{{{  case S_AFTER*/
        case S_AFTER:
          {
            treenode *exp;
            nextsymb ();
            if ((exp = rexp ()) == NULL)
              goto error;
            input = newactionnode (S_DELAYED_INPUT, ilocn, a, exp);
            checknewline ();
            break;
          }
        /*}}}*/
        /*{{{  default*/
        default:
          {
            treenode *list;
            if ((list = rlist(rinputitem, S_SEMICOLON)) == NULL)
              goto error;
            input = newactionnode (S_INPUT, ilocn, a, list);
            checknewline ();
          }
        /*}}}*/
      }
  }
  /*}}}*/
  if (checkindent (indent + 2))
    return NULL;
  return (newaltnode (S_ALTERNATIVE, locn, guard, input, rprocess ()));

error:
  /*{{{  recover from error*/
  {
    nextline ();
    skiplines (indent);
    return NULL;
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC treenode *ralternative ()*/
PUBLIC treenode *ralternative ( void )
{
  int indent = symbindent;
  treenode *altroot;
  treenode * (*altptr);
  DEBUG_MSG(("ralternative... "));
  altptr = &altroot;
  /*{{{  parse the alternative*/
  {
    treenode *exp;
    linebreakindent = (-1);
    if (!rleadingspecs(altptr, &exp))
      {
        SOURCEPOSN locn = flocn; /* moved for bug 873 28/1/91 */
        /*{{{  skip specs*/
        while (*altptr != NULL)
          altptr = DBodyAddr(*altptr);
        /*}}}*/
        if (exp != NULL)
          /*{{{  read rest of alternative*/
          {
            *altptr = raltbody (exp, locn, indent);
            return (altroot);
          }
          /*}}}*/
        else if (symb == S_ALT || symb == S_PRI)
          /*{{{  another alt*/
          {
            int replsymb;
            if (symb == S_PRI)
              /*{{{  check for ALT*/
              {
                nextsymb ();
                if (symb != S_ALT)
                  {
                    synetoken(S_ALT);
                    goto error;
                  }
                symb = S_PRIALT;
                replsymb = S_PRIREPLALT;
              }
              /*}}}*/
            else
              replsymb = S_REPLALT;
            *altptr = rconstruct (ralternative, symb, replsymb);
            return (altroot);
          }
          /*}}}*/
        else
          synerr_e(SYN_E_EXPR_OR_SPEC, locn, symb);
      }
  error :
    nextline ();
    return NULL;
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE treenode *rchoicebody (a, locn, indent)*/
/* Parse
boolean
process
the boolean is already in a
*/
PRIVATE treenode *rchoicebody ( treenode *a , SOURCEPOSN locn , int indent )
{
  if (checknlindent (indent + 2))
    {
      skiplines (indent);
      return NULL;
    }
  return (newcondnode (S_CHOICE, locn, a, rprocess()));
}
/*}}}*/
/*{{{  PUBLIC treenode *rchoice ()*/
/*{{{  what we are parsing*/
/* Parse
boolean
process
| conditional
| specification
choice
*/
/*}}}*/
PUBLIC treenode *rchoice ( void )
{
  int indent = symbindent;
  treenode *choiceroot;                         /* Root of the tree built up */
  treenode *(*chptr);                    /* Pointer to next hole in the tree */
  DEBUG_MSG(("rchoice... "));
  chptr = &choiceroot;
  /*{{{  parse choice*/
  {
    treenode *exp;
    linebreakindent = (-1);
    if (!rleadingspecs(chptr, &exp))
      {
        SOURCEPOSN locn = flocn; /* moved for bug 873 28/1/91 */
        /*{{{  look for end of specs*/
        while (*chptr != NULL)
          chptr = DBodyAddr(*chptr);
        /*}}}*/
        if (exp != NULL)
          /*{{{  read choice body*/
          {
            *chptr = rchoicebody (exp, locn, indent);
            return (choiceroot);
          }
          /*}}}*/
        else if (symb == S_IF)
          {
            *chptr =  (rconstruct (rchoice, S_IF, S_REPLIF));
            return (choiceroot);
          }
        else
          synerr_e(SYN_E_EXPR_OR_SPEC, locn, symb);
      }
    nextline ();
    return NULL;
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE treenode *raction (lhs, locn, indent)*/
/* Syntax does not specify a case.input as an action, but as action is
only used once in syntax, we test for it here anyway                   */
PRIVATE treenode *raction ( treenode *lhs , SOURCEPOSN locn , int indent )
{
  DEBUG_MSG(("raction... "));
  switch (symb)
    {
      /*{{{  case S_ASS*/
      case S_ASS:
        {
          treenode *n;
          treenode *rhs;
          nextsymb ();
          if (checklinebreak ())
            return NULL;
          if (TagOf(lhs) == S_LIST)
            rhs = rlist(rexp, S_COMMA);
          else
            rhs = rexp();
          if (rhs == NULL)
            goto error;
          checknewline ();
          n = newactionnode(S_ASS, locn, lhs, rhs);
          return (n);
        }
      /*}}}*/
      /*{{{  case S_OUTPUT*/
      case S_OUTPUT:
        {
          treenode *n;
          /*{{{  check only one element on lhs*/
          if (TagOf(lhs) == S_LIST)
            {
              synerr(SYN_LIST_IN_IO, locn);
              goto error;
            }
          /*}}}*/
          nextsymb ();
          if ((n = rlist (routputitem, S_SEMICOLON)) == NULL)
            goto error;
          n = newactionnode(S_OUTPUT, locn, lhs,n);
          checknewline ();
          return (n);
        }
      /*}}}*/
      /*{{{  case S_INPUT*/
      case S_INPUT:
        {
          /*{{{  check only one element on lhs*/
          if (TagOf(lhs) == S_LIST)
            {
              synerr(SYN_LIST_IN_IO, locn);
              goto error;
            }
          /*}}}*/
          nextsymb ();
          switch (symb)
            {
              case S_CASE:
                /*{{{  tagged input or case input*/
                nextsymb();
                if ((symb == S_COMMENT) || (symb == S_NEWLINE))
                  /*{{{  look for variant list*/
                  {
                    treenode *vl;
                    checknewline ();
                    vl = rproclist(rvariant, indent + 2);
                    return (newactionnode (S_CASE_INPUT, locn, lhs, vl));
                  }
                  /*}}}*/
                else
                  {
                    treenode *n;
                    if ((n = rlist (rinputitem, S_SEMICOLON)) == NULL)
                      goto error;
                    n = newactionnode (S_TAGGED_INPUT, locn, lhs, n);
                    checknewline ();
                    return (n);
                  }
                /*}}}*/
              case S_AFTER:
                /*{{{  delayed input*/
                {
                  treenode *n;
                  nextsymb();
                  if ((n = rexp ()) == NULL)
                    goto error;
                  n = newactionnode (S_DELAYED_INPUT, locn, lhs, n);
                  checknewline ();
                  return (n);
                }
                /*}}}*/
              default:
                {
                  treenode *n;
                  if ((n = rlist(rinputitem,S_SEMICOLON)) == NULL)
                    goto error;
                  n = newactionnode (S_INPUT, locn, lhs, n);
                  checknewline ();
                  return (n);
                }
            };
        }
      /*}}}*/
      default:
        synerr_e(SYN_E_ACTION, locn, symb);
      error:
        nextline ();
        skiplines (indent);
        return NULL;
    };
}
/*}}}*/
/*{{{  PRIVATE wordnode *lookuplabel (char *labelname)*/
/*****************************************************************************
 *
 *  lookuplabel takes a string 'labelname' and looks it up as a label,
 *              ie. it prepends a ':' character and looks up this name.
 *
 *****************************************************************************/
PRIVATE wordnode *lookuplabel ( wordnode *labelname )
{
  char n[MAXNAMELENGTH + 1];
  n[0] = ':';
  memcpy(&n[1], WNameOf(labelname), WLengthOf(labelname));
  return lookupword(n, WLengthOf(labelname)+1);
}
/*}}}*/
/*{{{  PRIVATE treenode *rasmexp ()*/
/*****************************************************************************
*
*  rasmexp reads an expression, or ADDRESSOF expression
*
******************************************************************************/
PRIVATE treenode *rasmexp ( void )
{
  if (symb == S_NAME && (strcmp(WNameOf(lexword), "ADDRESSOF") == 0))
    {
      nextsymb();
      return (newmopnode(S_ADDRESSOF, flocn, rexp(), 0));
    }
  return (rexp());
}
/*}}}*/
/*{{{  PRIVATE treenode *rguy_or_asm ()*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  rguy_or_asm reads a line of GUY or ASM code.
 *
 *    asmline :== instruction {, asm-expression }
 *                primaryname ':' labelname |
 *                ':' labelname
 *
 *    guyline :== primaryname expression |
 *                primaryname '.' labelname |
 *                ':' labelname |
 *                'STEP' secondaryname |
 *                secondaryname
 *
 *****************************************************************************/
/*}}}*/
PRIVATE treenode *rguy_or_asm ( int guy_not_asm )
{
  SOURCEPOSN locn = flocn;
  int in_step = FALSE;
  /*{{{  check for STEP*/
  if (guy_not_asm && (symb == S_NAME) &&
      (STEP_S_LEN == WLengthOf(lexword)) &&
      (strcmp(STEP_S, WNameOf(lexword)) == 0) )
    {
      in_step = TRUE;
      nextsymb();
    }
  /*}}}*/
  switch(symb)
    {
      /*{{{  S_NAME ALT, AND, IN, NOT, OR, REM: primary or secondary instruction*/
      case S_NAME:
      case S_ALT: case S_AND: case S_IN: case S_NOT: case S_OR: case S_REM:
      case S_BYTE:
        {
          wordnode *instruction;
          treenode *operand = NULL;
          int ldlabeldiff = (LDLABELDIFF_S_LEN == WLengthOf(lexword)) &&
                            (strcmp(LDLABELDIFF_S, WNameOf(lexword)) == 0);
      
          {
            /* We hide the name behind a dot so that the resulting node MUST be
               a real S_NAME node, so that later treewalks don't get confused,
               when traversing the left hand node of a dopnode */
            char instname[MAXSTRING_SIZE + 1];
            instname[0] = '.'; /* strcpy(instname, "."); */
                               /* strcat(instname, WNameOf(lexword)); */
            memcpy(&instname[1], WNameOf(lexword), WLengthOf(lexword));
      
            instruction = lookupword(instname, WLengthOf(lexword)+1);
          }

          nextsymb();
          ignore(S_COMMENT);
          if (symb != S_NEWLINE)
            /*{{{  read the operand*/
            {
              if (ldlabeldiff)
                /*{{{  :label1 - :label2*/
                {
                  wordnode *label1, *label2;
                  if (checkfor(S_COLON)) goto error;
                  if (symb != S_NAME)
                    /*{{{  report error, abort*/
                    {
                      synerr_e(SYN_E_NAME, locn, symb);
                      goto error;
                    }
                    /*}}}*/
                  label1 = lookuplabel(lexword);
                  nextsymb();
                  if (checkfor(S_SUBTRACT)) goto error;
                  if (checkfor(S_COLON   )) goto error;
                  if (symb != S_NAME)
                    /*{{{  report error, abort*/
                    {
                      synerr_e(SYN_E_NAME, locn, symb);
                      goto error;
                    }
                    /*}}}*/
                  label2 = lookuplabel(lexword);
                  nextsymb();
                  operand = newlistnode(S_LIST, locn, (treenode *)label1,
                            newlistnode(S_LIST, locn, (treenode *)label2, NULL));
                }
                /*}}}*/
              else if (symb == (guy_not_asm ? S_DOT : S_COLON))
                {
                  nextsymb();
                  if (symb != S_NAME)
                    /*{{{  report error, abort*/
                    {
                      synerr_e(SYN_E_NAME, locn, symb);
                      goto error;
                    }
                    /*}}}*/
                  operand = newlistnode(S_LIST, locn,
                            (treenode *)lookuplabel(lexword), NULL);
                  nextsymb();
                }
              else
                {
                  operand = rlist(guy_not_asm ? rexp : rasmexp, S_COMMA);
                  if (operand == NULL) goto error;
                }
            }
            /*}}}*/
          checknewline();
          return newdopnode(in_step ? S_GUYSTEP : S_GUYCODE,
                            locn, (treenode *)instruction, operand, 0);
        }
      /*}}}*/
      /*{{{  S_COLON  label definition*/
      case S_COLON:
        {
          wordnode *labelname;
          nextsymb();
          if (symb != S_NAME)
            {
              synerr_e(SYN_E_NAME, flocn, symb);
              goto error;
            }
          labelname = lookuplabel(lexword);
          nextline();
          return declare(S_LABELDEF, locn, newleafnode(S_LABEL, locn),
                         labelname, NULL);
        }
      /*}}}*/
      /*{{{  INCLUDE etc*/
      case S_INCLUDE: case S_SC: case S_USE: case S_IMPORT:
        {
          int indent = symbindent;
          if (!rfile())
            {
              skiplines(indent);
              if (lineindent < indent)
                return NULL;
            }
        }
        return rguy_or_asm(guy_not_asm);
      /*}}}*/
      default:
        synerr(SYN_BAD_GUYLINE, flocn);
        goto error;
    }
  error:
    nextline();
    return NULL;
}
/*}}}*/
/*{{{  PRIVATEPARAM treenode *rguy ()*/
PRIVATEPARAM treenode *rguy ( void )
{
  return rguy_or_asm(TRUE);
}
/*}}}*/
/*{{{  PRIVATEPARAM treenode *rasm ()*/
PRIVATEPARAM treenode *rasm ( void )
{
  treenode *t;
  allow_asmnames = TRUE;
  t = rguy_or_asm(FALSE);
  allow_asmnames = FALSE;
  return t;
}
/*}}}*/
/*{{{  PUBLIC treenode *rprocess ()*/
PRIVATE int base_lexlevel;
PUBLIC treenode *rprocess ( void )
{
  treenode *a;
  treenode *procroot;
  treenode **procptr = &procroot;
  while (TRUE)
    {
      SOURCEPOSN locn = flocn;             /* Location of first symbol of process */
      int indent = symbindent;
      linebreakindent = (-1);
      DEBUG_MSG(("rprocess: symb is %s... ", tagstring(symb)));
      /*{{{   switch on current symb*/
      if (mustbespec(symb) || isscalartype(symb))
        /*{{{  read specification*/
        {
          *procptr = rspecification ();
          if ((*procptr) == NULL)
            goto error2;
          procptr = DBodyAddr(*procptr);
        }
        /*}}}*/
      else if (symb == S_NAME || symb == S_LBOX)
        /*{{{  S_NAME, S_LBOX   --  specification or action*/
        {
          int specflag;
          if ((a = rspecorelement(&specflag, indent)) == NULL)
            goto error2;
          if (specflag)
            {*procptr = a; procptr = DBodyAddr(a);}
          else
            {
              if (symb == S_LPAREN)
                /*{{{  parse procedure call; return*/
                {
                  *procptr = rinstance(S_PINSTANCE, locn, a);
                  checknewline ();
                  return (procroot);
                }
                /*}}}*/
              else
                /*{{{  parse variable or variable list followed by action; return*/
                {
                  if (symb == S_COMMA)
                    {
                      treenode *list;
                      nextsymb();
                      if (checklinebreak ())
                        goto error2;
                      if ((list = rlist (relement, S_COMMA)) == NULL)
                        goto error;
                      a = newlistnode(S_LIST, locn, a, list);
                    }
                  *procptr = raction(a, locn, indent);
                  if ((*procptr) == NULL)
                    goto error2;
                  return(procroot);
                }
                /*}}}*/
            }
        }
        /*}}}*/
      else  /* Read process */
        {
          switch (symb)
            {
              /*{{{  S_STOP, S_SKIP*/
              case S_STOP: case S_SKIP:
                *procptr = newleafnode (symb, locn);
                nextsymb (); checknewline ();
                return (procroot);
              /*}}}*/
              /*{{{  S_SEQ*/
              case S_SEQ:
                *procptr = rconstruct (rprocess, S_SEQ, S_REPLSEQ);
                return (procroot);
              /*}}}*/
              /*{{{  S_IF*/
              case S_IF:
                *procptr = rconstruct (rchoice, S_IF, S_REPLIF);
                return (procroot);
              /*}}}*/
              /*{{{  S_PAR*/
              case S_PAR:
                *procptr = rconstruct(rprocess, S_PAR, S_REPLPAR);
                return (procroot);
              /*}}}*/
              #ifdef CONFIG
              /*{{{  S_PAR*/
              case S_DO:
                *procptr = rconstruct(rprocess, S_DO, S_REPLDO);
                return (procroot);
              /*}}}*/
              #endif
              /*{{{  S_PRI*/
              case S_PRI:
                {
                  nextsymb ();
                  if (symb == S_PAR)
                    *procptr = rconstruct (rprocess, S_PRIPAR, S_PRIREPLPAR);
                  else if (symb == S_ALT)
                    *procptr = rconstruct (ralternative, S_PRIALT, S_PRIREPLALT);
                  else
                    /*{{{  error*/
                    {
                      synerr_e (SYN_E_PAR_OR_ALT, flocn, symb);
                      goto error;
                    }
                    /*}}}*/
                }
                return (procroot);
              /*}}}*/
              /*{{{  S_PLACED S_PROCESSOR*/
              case S_PLACED:
                nextsymb();
                if (symb == S_PAR)
                  *procptr = rconstruct(rprocess, S_PLACEDPAR, S_PLACEDREPLPAR);
                else
                  {
                    synetoken(S_PAR);
                    goto error;
                  }
                return procroot;
              /*case S_PLACED:*/ case S_PROCESSOR :
                 /**procptr = rplacement();*/
                 *procptr = rprocessor();
                 return (procroot);
              /*}}}*/
              /*{{{  S_ALT*/
              case S_ALT:
                *procptr = rconstruct (ralternative, S_ALT, S_REPLALT);
                return (procroot);
              /*}}}*/
              /*{{{  S_WHILE*/
              case S_WHILE:
                {
                  int indent = symbindent;
                  nextsymb();
                  if ((a = rexp()) == NULL)
                    goto error;
                  if (checknlindent (indent + 2))
                    goto error2;
                  *procptr = newcondnode (S_WHILE, locn, a, rprocess());  /* Read the body */
                  return (procroot);
                }
              /*}}}*/
              /*{{{  S_CASE*/
              case S_CASE:
                /* Parse
                         'CASE' selector
                           { selection }
                */
                {
                  treenode *selector, *slist;
              
                  nextsymb ();
                  if ((selector = rexp ()) == NULL)
                    goto error;
                  checknewline ();
                  slist = rproclist (rselection, indent + 2);
                  *procptr = newactionnode (S_CASE, locn, selector, slist);
                  return (procroot);
                }
              /*}}}*/
              /*{{{  S_GUY, S_ASM*/
              case S_GUY: case S_ASM:
                if (guyinserts)
                  {
                    int this_symb = symb;
                    int indent = symbindent;                      /* Indent of GUY keyword */
                    SOURCEPOSN locn = flocn;             /* Location of start of construct */
                    nextsymb ();
                    checknewline ();
                    *procptr = newcnode(this_symb, locn,
                      rproclist((this_symb == S_GUY) ? rguy : rasm, indent + 2));
                    return (procroot);
                  }
                else
                  {
                    synerr(SYN_GUY_NOT_ENABLED, flocn);
                    goto error;
                  }
              /*}}}*/
              /*{{{  S_INCLUDE S_SC S_USE S_IMPORT*/
              case S_INCLUDE: case S_SC: case S_USE: case S_IMPORT:
                if (!rfile ()) goto error2;
                  break;
              /*}}}*/
              /*{{{                S_PRAGMA*/
              case S_PRAGMA:
                {
                  int saved_indent = indent;
                  if (!rpragma ()) goto error2;
                  ignorecomments(saved_indent);
                }
                break;
              /*}}}*/
              /*{{{  S_HCOMMENT*/
              case S_HCOMMENT:
                nextsymb();  /* string after comment */
                if (symb != S_STRING)
                  {
                    synerr(SYN_E_HCOMMENT, flocn);
                    nextline();
                  }
                else
                  {
                    process_hcomment(literalv, literalp);
                    nextsymb (); /* should be end of line */
                    if (checknlindent(indent))
                      goto error2;
                  }
                break;
              /*}}}*/
              /*{{{  S_OPTION*/
              case S_OPTION:
                synerr(SYN_OPTION_IN_BAD_POS, flocn);
                nextline();
                break;
              /*}}}*/
              #ifdef CONFIG
              /*{{{  S_SET*/
              case S_SET:
                *procptr = rset();
                return (procroot);
              /*}}}*/
              /*{{{  S_CONNECT*/
              case S_CONNECT:
                *procptr = rconnect();
                return (procroot);
              /*}}}*/
              /*{{{  S_MAP*/
              case S_MAP:
                *procptr = rmap();
                return (procroot);
              /*}}}*/
              #endif
              default:
                if (lexlevel == base_lexlevel && symb == S_END)
                  {
                    if (lexmode == LEX_SOURCE && !foundroutine)
                      synerr(SYN_SC_EMPTY, flocn);
                    *procptr = newleafnode (symb, locn);
                    return (procroot);
                  }
                synerr(SYN_INVALID_PROCESS, flocn);
              error:
                nextline ();
              error2 :
                skiplines (indent);
                if (lineindent < indent)
                  /*{{{  indentation shows that we are at end of SEQ etc, so return*/
                  return NULL;
                  /*}}}*/
            }
        }
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *rscunit ()*/
PUBLIC treenode *rscunit ( void )
{
  treenode *tptr, *t;
  base_lexlevel = lexlevel;
  tptr = rprocess();
  t = tptr;
  while (t != NULL && TagOf(t) != S_END)
    {
      switch (TagOf(t))
        {
          default:
            DEBUG_MSG(("Tag is %s\n", tagstring(TagOf(t)) ));
            synerr(SYN_SC_ERROR, LocnOf(t));
            return tptr;
          case S_VALABBR: case S_VALRETYPE:
          case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
          case S_TPROTDEF: case S_SPROTDEF:
          #ifdef CONFIG
          CASE_CONFIG_SPEC
          case S_DECL: case S_ABBR: case S_PLACEON: /* leave these till later on */
          #endif
            t = DBodyOf(t);
            break;
        }
    }
  return tptr;
#if 0
  treenode *a;
  treenode *procroot;
  treenode **procptr = &procroot;
  while (TRUE)
    {
      SOURCEPOSN locn = flocn;             /* Location of first symbol of process */
      int indent = symbindent;
      linebreakindent = (-1);
      DEBUG_MSG(("rscunit... "));
      /*{{{   switch on current symb*/
      switch (symb)
        {
          /*{{{  VAL PROC PROTOCOL*/
          case S_PROC: case S_INLINE: case S_VAL:
          case S_NETWORK: /*case S_NODE:*/
          case S_PROTOCOL:
            {
              *procptr = rspecification ();
              if ((*procptr) == NULL)
                goto error;
              procptr = DBodyAddr(*procptr);
              break;
            }
          /*}}}*/
          /*{{{  S_LBOX*/
          case S_LBOX:
            nextsymb ();
            /*{{{  parse exp*/
            if ((a = rexp ()) == NULL)
              {
                while (symb != S_RBOX && symb != S_NEWLINE)
                  nextsymb ();
                if (symb == S_NEWLINE)
                  goto error;
              }
            /*}}}*/
            if (symb == S_RBOX)
              /*{{{  read function definition: array declaration not allowed in SC*/
              {
                nextsymb ();
                a = newarraynode (S_ARRAY, locn, a, rspecifier());
                if (symb == S_FUNCTION)
                  /*{{{  read function definition*/
                  {
                    *procptr = rfunctiondef(a, locn, indent);
                    if ((*procptr) == NULL)
                      goto error;
                    procptr = DBodyAddr(*procptr);
                  }
                  /*}}}*/
                else if (symb == S_COMMA)
                  /*{{{  read function type and definition*/
                  {
                    treenode *list;
                    nextsymb ();
                    if (checklinebreak ())
                      goto error2;
                    if ((list = rlist (rspecifier, S_COMMA)) == NULL)
                      goto error;
                    a = newlistnode(S_LIST, locn, a, list);
                    *procptr = rfunctiondef(a, locn, indent);
                    if ((*procptr) == NULL)
                      goto error;
                    procptr = DBodyAddr(*procptr);
                  }
                  /*}}}*/
                else
                  {
                    synerr(SYN_SC_ERROR, flocn);
                    goto error;
                  }
                break;
              }
              /*}}}*/
            else if (symb == S_FROM)
              /*{{{  error*/
              {
                synerr(SYN_SC_ERROR, flocn);
                goto error;
              }
              /*}}}*/
            else
              /*{{{  error*/
              {
                synetoken (S_RBOX);
                goto error;
              }
              /*}}}*/
          /*}}}*/
          /*{{{  primitive type or BOX*/
          case S_CHAN: case S_PORT: case S_BOOL: case S_BYTE:
          case S_INT: case S_INT16: case S_INT32: case S_INT64:
          case S_REAL32: case S_REAL64: case S_TIMER: case S_BOX:
            /* These are legal if they are function definitions, but not otherwise */
            {
              SOURCEPOSN currentlocn = flocn;
              treenode *s;
              if ((s = rspecification()) == NULL)
                goto error;
              if ((TagOf(s) == S_LFUNCDEF) || (TagOf(s) == S_SFUNCDEF))
                {
                  *procptr = s;
                  procptr = DBodyAddr(*procptr);
                }
              else
                {
                  synerr(SYN_SC_ERROR, currentlocn);
                  goto error;
                }
            }
            break;
          /*}}}*/
          /*{{{  S_END*/
          case S_END:
            if (lexmode == LEX_SOURCE && !foundroutine)
              synerr(SYN_SC_EMPTY, flocn);
            *procptr = newleafnode (symb, locn);
            return (procroot);
          /*}}}*/
          /*{{{  S_INCLUDE S_SC S_USE S_IMPORT*/
          case S_INCLUDE: case S_SC: case S_USE: case S_IMPORT:
            if (!rfile ()) goto error2;
            break;
          /*}}}*/
          /*{{{            S_PRAGMA*/
          case S_PRAGMA:
            {
              int saved_indent = indent;
              if (!rpragma ()) goto error2;
              ignorecomments(saved_indent);
            }
            break;
          /*}}}*/
          /*{{{  S_HCOMMENT*/
          case S_HCOMMENT:
            nextsymb();  /* string after comment */
            if (symb != S_STRING)
              {
                synerr(SYN_E_HCOMMENT, flocn);
                nextline();
              }
            else
              {
                process_hcomment(literalv, literalp);
                nextsymb (); /* should be end of line */
                /*{{{  check nl, indent*/
                if (checknlindent(indent))
                  goto error2;
                /*}}}*/
              }
            break;
          /*}}}*/
          /*{{{  S_OPTION*/
          case S_OPTION:
            synerr(SYN_OPTION_IN_BAD_POS, flocn);
            nextline();
            break;
          /*}}}*/
      #ifdef CONFIG
          /*{{{  S_CONFIG*/
          case S_CONFIG:
            {
              nextsymb ();
              checknewline();
              a = rproclist (rprocess, indent + 2);
              *procptr = newcnode (S_CONFIG, locn, a);
              if (symb != S_END)
                {
                  synetoken (S_END);
                  return (NULL);
                }
              return (procroot);
            }
          /*}}}*/
      #endif
          default:
            synerr(SYN_SC_ERROR, flocn);
          error:
            nextline ();
          error2:
            skiplines (indent);
        }
      /*}}}*/
    }
#endif
}
/*}}}*/
/*{{{  PRIVATE printerrors()*/
PRIVATE void printerrors(char *string, int errors)
{
  if (information)
    {
      fputs(string, outfile);
      if (errors != 0)
        fprintf(outfile, " - %d error%s\n", errors, (errors > 1) ? "s" : "");
      else
        fputs(" ok\n", outfile);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *rprogram (rbody, typecheck, fname)*/
/* The name of the root source file */
PUBLIC treenode *rprogram ( treenode *(*rbody)(void), void (*typecheck)(treenode **), char *fname )
  {
    int reporterrors = TRUE;
    treenode *progptr = NULL;
    jmp_buf savedenv;
    memcpy((char *)savedenv, (char *)env, sizeof(env));

    if (!setjmp (env))
      {
        rpredefs ();
#ifdef TDS
        readstdlibtree();
#endif
        if (open_file(fname, LEX_SOURCE, 0))
          /*{{{  lex, parse and check the program*/
          {
            nextsymb();
            while ((symb == S_COMMENT) || (symb == S_NEWLINE) || (symb == S_OPTION))
              {
                if (symb == S_OPTION)
                  /*{{{  process option string*/
                  {
                    nextsymb();  /* string with options */
                    if (symb != S_STRING)
                      {
                        synerr(SYN_E_OPTION, flocn);
                        nextline();
                      }
                    else
                      {
                        int ok = process_option(literalv);
                        if (ok && information)
                          fprintf(outfile, "%s \"%s\"\n", tagstring(S_OPTION), literalv);
                        nextsymb (); /* should be end of line */
                        checknewline ();
                      }
                  }
                  /*}}}*/
                else
                  nextline ();
              }
            /*{{{  COMMENT check indentation is zero at start*/
            /**********************  Start comment out ****************************
            @*{{{  check indentation is zero at start*@
            if (checkindent(0))
              return NULL;
            @*}}}*@
             **********************   End comment out  ****************************/
            /*}}}*/
            progptr = (*rbody)();
            printerrors("Parsed", errors);
            if (!nochecking)
              /*{{{  semantic check*/
              {
                const int s = errors;
                (*typecheck)(&progptr);
                printerrors("Checked", errors - s);
              }
              /*}}}*/

            /* This added to prevent later 'out of memory' errors reporting
               a silly line number - CON 22/1/91 */
            flocn = NOPOSN;

            /*{{{  COMMENT check we are at the end of file*/
            /**********************  Start comment out ****************************
            @*{{{  check we are at the end of file*@
            {
              if (!feof(infile))
                {
                  synerr_e(SYN_E_ENDOFPROGRAM, flocn, symb);
                  longjmp(env, TRUE);
                }
            }
            @*}}}*@
             **********************   End comment out  ****************************/
            /*}}}*/
          }
          /*}}}*/
        else
          {
            reporterrors = FALSE;
            synerr_s(SYN_FILE_OPEN_ERROR, NOPOSN, fname);
          }
      }
    /*{{{  restore environment, report errors*/
    {
      memcpy((char *)env, (char *)savedenv, sizeof(env));
      if (reporterrors)
        /*{{{  report number of errors found*/
        {
          if (errors)
            {
              fprintf (outfile, "%d error",errors);
              if (errors != 1)
                fputc ('s', outfile);
              fprintf (outfile, " found in source\n");
            }
          printundeclarednames (errfile);
        }
        /*}}}*/
    }
    /*}}}*/

    return progptr;
  }
/*}}}*/
/*{{{  void feinit()*/
/*****************************************************************************
 *
 *  feinit initialises the frontend
 *
 *****************************************************************************/
void feinit ( void )
{
  vtiinit();
  descinit();
  lexinit();
  syninit();
  scopeinit();
  chkinit();
}
/*}}}*/
/*}}}*/
