/*****************************************************************************
 *
 * Macro definitions for code generator fields within namenodes
 *
 *****************************************************************************/

/* Fields used by all of the namenode types */
#define NNameOf(N)              ((N)->n_u.n_s.n_name)
#define NTypeOf(N)              ((N)->n_u.n_s.n_type)
#define NDeclOf(N)              ((N)->n_u.n_s.n_decl)
#define NLexLevelOf(N)         (((N)->n_u.n_s.n_lexlev) & 0x3f)
#define NNestedPriParOf(N)    ((((N)->n_u.n_s.n_lexlev) & 0x80) != 0)
#define NUsedOf(N)            ((((N)->n_u.n_s.n_lexlev) & 0x40) != 0)
#define NScopeOf(N)             ((N)->n_u.n_s.n_scope)
#define NModeOf(N)              ((N)->n_u.n_s.n_mode)
#define NCheckerOf(N)           ((N)->n_u.n_s.n_checker)

#define SetNDeclType(N,V)       ((N)->n_u.n_s.n_decltype = (V))
#define SetNName(N,V)           ((N)->n_u.n_s.n_name = (V))
#define SetNType(N,V)           ((N)->n_u.n_s.n_type = (V))
#define SetNDecl(N,V)           ((N)->n_u.n_s.n_decl = (V))
#define SetNLexLevel(N,V)       ((N)->n_u.n_s.n_lexlev = \
                                ((N)->n_u.n_s.n_lexlev & 0xc0) | ((V) & 0x3f))
#define SetNNestedPriPar(N,V)   ((N)->n_u.n_s.n_lexlev = \
                                ((N)->n_u.n_s.n_lexlev & 0x7f) | (((V) == 0) ? 0 : 0x80))
#define SetNUsed(N,V)           ((N)->n_u.n_s.n_lexlev = \
                                ((N)->n_u.n_s.n_lexlev & 0xbf) | (((V) == 0) ? 0 : 0x40))
#define SetNScope(N,V)          ((N)->n_u.n_s.n_scope = (V))
#define SetNMode(N,V)           ((N)->n_u.n_s.n_mode = (V))
#define SetNChecker(N,V)        ((N)->n_u.n_s.n_checker = (V))

#define NTypeAddr(N)          (&((N)->n_u.n_s.n_type))
#define NDeclAddr(N)          (&((N)->n_u.n_s.n_decl))
#define NNameAddr(N)          (&((N)->n_u.n_s.n_name))

/*{{{  PROC/FUNCTION node*/

#define NPLabelOf(N)            ((N)->n_u.n_s.n_un.n_proc.n_label)
#define NPMaxwspOf(N)           ((N)->n_u.n_s.n_un.n_proc.n_maxwsp)
#define NPDatasizeOf(N)         ((N)->n_u.n_s.n_un.n_proc.n_datasize)
#define NPVSUsageOf(N)          ((N)->n_u.n_s.n_un.n_proc.n_vsusage)
/*#define NPNestedVSOf(N)       ((N)->n_u.n_s.n_un.n_proc.n_nestedvs)*/
#define NPParamsOf(N)    ((int)(((N)->n_u.n_s.n_un.n_proc.n_params) & 0xffff))
#define NPSLUsageOf(N)  ((int)((((N)->n_u.n_s.n_un.n_proc.n_params) >> 16) & 0xffff))

#define SetNPLabel(N,V)         ((N)->n_u.n_s.n_un.n_proc.n_label = (V))
#define SetNPMaxwsp(N,V)        ((N)->n_u.n_s.n_un.n_proc.n_maxwsp = (V))
#define SetNPDatasize(N,V)      ((N)->n_u.n_s.n_un.n_proc.n_datasize = (V))
#define SetNPVSUsage(N,V)       ((N)->n_u.n_s.n_un.n_proc.n_vsusage = (V))
/*#define SetNPNestedVS(N,V)    ((N)->n_u.n_s.n_un.n_proc.n_nestedvs = (V))*/

#define SetNPParams(N,V) ( (N)->n_u.n_s.n_un.n_proc.n_params = \
        ((N)->n_u.n_s.n_un.n_proc.n_params & 0xffff0000) | ((V) & 0xffff) )
#define SetNPSLUsage(N,V) ( (N)->n_u.n_s.n_un.n_proc.n_params = \
        ((N)->n_u.n_s.n_un.n_proc.n_params & 0x0000ffff) | (((V) & 0xffff) << 16) )


/* These are used by locally declared PROCs and FUNCTIONs */
#define NPConstTablesOf(N)      ((N)->n_u.n_s.n_un.n_proc.n_un1.n_ctable)
#define NPCPOffsetOf(N)         ((N)->n_u.n_s.n_un.n_proc.n_un2.n_cpoffset)

#define SetNPConstTables(N,V)   ((N)->n_u.n_s.n_un.n_proc.n_un1.n_ctable = (V))
#define SetNPCPOffset(N,V)      ((N)->n_u.n_s.n_un.n_proc.n_un2.n_cpoffset = (V))

/* These are used by library PROCs and FUNCTIONs */
#define NLExternalOf(N)         ((N)->n_u.n_s.n_un.n_proc.n_external)
#define NLEntryNextOf(N)        ((N)->n_u.n_s.n_un.n_proc.n_un1.n_nextlib)
#define NLEntryOffsetOf(N)      ((N)->n_u.n_s.n_un.n_proc.n_un2.n_liboffset)

#define SetNLExternal(N,V)      ((N)->n_u.n_s.n_un.n_proc.n_external = (V))
#define SetNLEntryNext(N,V)     ((N)->n_u.n_s.n_un.n_proc.n_un1.n_nextlib = (V))
#define SetNLEntryOffset(N,V)   ((N)->n_u.n_s.n_un.n_proc.n_un2.n_liboffset = (V))
/*}}}*/


/*{{{  variable node*/
/* all types of variables */
#define NVOffsetOf(N)           ((N)->n_u.n_s.n_un.n_var.n_offset)
#define SetNVOffset(N,V)        ((N)->n_u.n_s.n_un.n_var.n_offset = (V))

/* frontend only: */
#define NVSharedOf(N)           ((N)->n_u.n_s.n_un.n_var.n_un5.n_front.n_shared)
#define SetNVShared(N,V)        ((N)->n_u.n_s.n_un.n_var.n_un5.n_front.n_shared = (V))

/* backend only: */
#define NVNextOf(N)             ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_shares)
#define NVVarNumOf(N)           ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_varnum)
#define NVNextTempOf(N)         ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_nexttemp)
#define NVAllocNextOf(N)        ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_allocnext)
#define SetNVNext(N,V)          ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_shares = (V))
#define SetNVVarNum(N,V)        ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_varnum = (V))
#define SetNVNextTemp(N,V)      ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_nexttemp = (V))
#define SetNVAllocNext(N,V)     ((N)->n_u.n_s.n_un.n_var.n_un5.n_back.n_allocnext = (V))


/* actual variables only: */
#define NVVSOffsetOf(N)         ((N)->n_u.n_s.n_un.n_var.n_un3.n_vsoffset)
/* temporaries too: */
#define NVUseCountOf(N)         ((N)->n_u.n_s.n_un.n_var.n_un4.n_usecount)

#define SetNVVSOffset(N,V)      ((N)->n_u.n_s.n_un.n_var.n_un3.n_vsoffset = (V))
#define SetNVUseCount(N,V)      ((N)->n_u.n_s.n_un.n_var.n_un4.n_usecount = (V))

/* Replicators only: never known when in the backend */
#define NReplKnownOf(N)         ((N)->n_u.n_s.n_un.n_var.n_un3.n_replknown)
#define NReplValueOf(N)         ((N)->n_u.n_s.n_un.n_var.n_un4.n_replval)

#define SetNReplKnown(N,V)      ((N)->n_u.n_s.n_un.n_var.n_un3.n_replknown = (V))
#define SetNReplValue(N,V)      ((N)->n_u.n_s.n_un.n_var.n_un4.n_replval = (V))

/* Scalar channels only (TagOf(NTypeOf(n)) == S_CHAN) */
#define NChanMarkOf(N)          ((N)->n_u.n_s.n_un.n_var.n_un3.n_chanmark)
#define SetNChanMark(N,V)       ((N)->n_u.n_s.n_un.n_var.n_un3.n_chanmark = (V))


/* T_RESERVEDWS only: */
#define NVRSizeOf(N)            ((N)->n_u.n_s.n_un.n_var.n_un4.n_rsize)
#define SetNVRSize(N,V)         ((N)->n_u.n_s.n_un.n_var.n_un4.n_rsize = (V))

/*}}}*/

/*{{{  tag definition node*/
#define NTValueOf(N)        ((N)->n_u.n_s.n_un.n_tag.n_tagval)
#define SetNTValue(N,V)     ((N)->n_u.n_s.n_un.n_tag.n_tagval = (V))
/*}}}*/


/*{{{  name modes*/
#define NM_DEFAULT   0
#define NM_WORKSPACE 1
#define NM_VECSPACE  2
#define NM_PLACED    3
#define NM_POINTER   4
/*#define NM_INLINE  5*/ /* never used */
#define NM_WSPLACED  6
/*}}}*/
