/******************************************************************************
*
*  Occam Two compiler - list processing definitions
*
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/

#define ThisItem(L) (LeftOf(L))
#define NextItem(L) (RightOf(L))
#define EndOfList(L) ((L) == NULL)
#define EmptyList(L) ((L) == NULL)
#define NewItem(I,L) (SetLeft(L,I))
#define NewNextItem(I,L) (SetRight(L,I))
#define IsLastItem(L) (RightOf(L) == NULL)

#define ThisItemAddr(L) (LeftAddr(L))
#define NextItemAddr(L) (RightAddr(L))

/*{{{  function prototypes*/
int listitems PARMS((treenode *tptr));
treenode *lastnode PARMS((treenode *list));
treenode *appendnode PARMS((treenode *node,treenode *list));
treenode *appendlist PARMS((treenode *newlist,treenode *list));
treenode *insertnode PARMS((treenode *node,treenode *list));
treenode *addtofront PARMS((treenode *node,treenode *list));
treenode *insertlist PARMS((treenode *newlist,treenode *originallist));
treenode *reverselist PARMS((treenode *originallist));

/*void walklist PARMS((void (*p)(treenode *),treenode *list, BIT32 param));*/
void walklist PARMS((void (*p)(treenode *),treenode *list));
#if 0 /* never used */
void modwalklist  PARMS((void (*p)(treenode **), treenode *list));
#endif
/*}}}*/
