/******************************************************************************
*
*  Occam 2 compiler   list handling
*
******************************************************************************/
 
/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}*/
 
/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
/*# include "listhdr.h"*/ /* included inside "includes.h" */
/*}}}*/
 
/*{{{  PUBLIC int listitems (tptr)*/
PUBLIC int listitems ( treenode *tptr )
{
  int l = 0;
  for (; !EndOfList(tptr); tptr = NextItem(tptr))
    l++;
  return(l);
}
/*}}}*/
/*{{{  PUBLIC treenode *lastnode (list)*/
/*****************************************************************************
 *
 *  lastnode returns a pointer to the last node on the list 'list'
 *
 *****************************************************************************/
PUBLIC treenode *lastnode ( treenode *list )
{
  if (EmptyList(list))
    return(NULL);
  else
    {
      while (!(EndOfList(NextItem(list))))
        list = NextItem(list);
      return(list);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *appendnode (node, list)*/
/*****************************************************************************
 *
 *  appendnode appends 'node' to the list 'list'
 *
 *****************************************************************************/
PUBLIC treenode *appendnode ( treenode *node , treenode *list )
{
  treenode *n = newlistnode(S_LIST, NOPOSN, node, NULL);
  if (EmptyList(list))
    return(n);
  else
    {
      treenode *l = lastnode(list);
      NewNextItem(n, l);
      return(list);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *appendlist (newlist, list)*/
/*****************************************************************************
 *
 *  appendlist appends the list 'newlist' to the list 'list'
 *
 *****************************************************************************/
PUBLIC treenode *appendlist ( treenode *newlist , treenode *list )
{
  if (EmptyList(newlist))
    return(list);
  else if (EmptyList(list))
    return(newlist);
  else
    {
      treenode *l = lastnode(list);
      NewNextItem(newlist, l);
      return(list);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *insertnode (node, list)*/
/*****************************************************************************
 *
 *  insertnode inserts node into list
 *
 *****************************************************************************/
PUBLIC treenode *insertnode ( treenode *node , treenode *list )
{
  treenode *n = newlistnode(S_LIST, NOPOSN, node, NULL);
  if (EmptyList(list))
    return(n);
  else
    {
      treenode *nextl = NextItem(list);
      NewNextItem(n, list);
      NewNextItem(nextl, n);
      return(list);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *addtofront (node, list)*/
/*****************************************************************************
 *
 *  addtofront makes node the first item of list and returns the new list
 *
 *****************************************************************************/
PUBLIC treenode *addtofront ( treenode *node , treenode *list )
{
  return(newlistnode(S_LIST, NOPOSN, node, list));
}
/*}}}*/
/*{{{  PUBLIC treenode *insertlist  (newlist, originallist)*/
/*****************************************************************************
 *
 *  insertlist inserts newlist into originallist
 *
 *****************************************************************************/
PUBLIC treenode *insertlist ( treenode *newlist , treenode *originallist )
{
  if (EmptyList(originallist))
    return(newlist);
  else if (EmptyList(newlist))
    return(originallist);
  else
    {
      treenode *nextl = NextItem(originallist);
      NewNextItem(newlist, originallist);
      appendlist(nextl, newlist);
      return(originallist);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *reverselist  (originallist)*/
/*****************************************************************************
 *
 *  reverselist simply reverses the list
 *
 *****************************************************************************/
PUBLIC treenode *reverselist ( treenode *oldlist )
{
  treenode *newlist = NULL;
  while (!EmptyList(oldlist))
    {
      treenode *next = NextItem(oldlist);
      NewNextItem(newlist, oldlist);   /* oldlist->next := newlist */
      newlist = oldlist;
      oldlist = next;
    }
  return newlist;
}
/*}}}*/
/*{{{  PUBLIC void walklist (p, list, param)*/
/*****************************************************************************
 *
 *  walklist walks along a list applying p to each node
 *
 *****************************************************************************/
/*PUBLIC void walklist (void (*p)(treenode *), treenode *list , BIT32 param )*/
PUBLIC void walklist (void (*p)(treenode *), treenode *list)
{
  treenode *tptr = list;
  if (tptr != NULL && TagOf(tptr) == S_LIST)
    while (!EndOfList (tptr))
      {
        /*(*p)(ThisItem (tptr), param);*/
        (*p)(ThisItem (tptr));
        tptr = NextItem (tptr);
      }
}
/*}}}*/
#if 0 /* never used */
/*{{{  PUBLIC void modwalklist (p, list)*/
/*****************************************************************************
 *
 *  modwalklist walks along a list applying p to the address of each node
 *
 *****************************************************************************/
PUBLIC void modwalklist ( void (*p)(treenode **), treenode *list )
{
  treenode *tptr = list;
  if (tptr != NULL && TagOf(tptr) == S_LIST)
    while (!EndOfList (tptr))
      {
        (*p)(ThisItemAddr(tptr));
        tptr = NextItem (tptr);
      }
}
/*}}}*/
#endif
