/*****************************************************************************
 *
 *  Occam 2 compiler  instructions.h - instruction numbers
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *****************************************************************************/
/*}}}*/

/*{{{  masks and other bits*/
#define INST_MASK       0x0ffff /* enough for the 'step' stuff */
#define I_NEGATIVE      0x08000 /* Not masked off by the INST_MASK */
#define I_STEP_BIT      0x00800 /* Microcode 'step' bit */
#define I_PRIMARY       0x10000
#define I_FPU_ENTRY_BIT 0x20000
#define I_PSEUDO_OP     0x40000
/*}}}*/

/*{{{  primary instructions*/
#define I_LDL     0x70
#define I_STL     0xD0
#define I_LDLP    0x10
#define I_LDNL    0x30
#define I_STNL    0xE0
#define I_LDNLP   0x50
#define I_EQC     0xC0
#define I_LDC     0x40
#define I_ADC     0x80
#define I_J       0x00
#define I_CJ      0xA0
#define I_CALL    0x90
#define I_AJW     0xB0
#define I_PFIX    0x20
#define I_NFIX    0x60
#define I_OPR     0xF0
/*}}}*/
/*{{{  secondary instructions*/
/*{{{  rev, ret, ldpi, gajw, gcall, mint, lend*/
#define I_REV         0x00
#define I_RET         0x20
#define I_LDPI        0x1B
#define I_GAJW        0x3C
#define I_GCALL       0x06
#define I_MINT        0x42
#define I_LEND        0x21
/*}}}*/
/*{{{  csub0, ccnt1*/
#define I_CSUB0       0x13
#define I_CCNT1       0x4D
/*}}}*/
/*{{{  testerr, seterr, stoperr, clrhalterr, sethalterr, testhalterr*/
#define I_TESTERR     0x29
#define I_SETERR      0x10
#define I_STOPERR     0x55
#define I_CLRHALTERR  0x57
#define I_SETHALTERR  0x58
#define I_TESTHALTERR 0x59
/*}}}*/
/*{{{  bsub, wsub, bcnt, wcnt, lb, sb, move*/
#define I_BSUB        0x02
#define I_WSUB        0x0A
#define I_BCNT        0x34
#define I_WCNT        0x3F
#define I_LB          0x01
#define I_SB          0x3B
#define I_MOVE        0x4A
/*}}}*/
/*{{{  and, or, xor, not, shl, shr, add, sub, mul, div, rem, gt, diff, sum, prod*/
#define I_AND         0x46
#define I_OR          0x4B
#define I_XOR         0x33
#define I_NOT         0x32
#define I_SHL         0x41
#define I_SHR         0x40
#define I_ADD         0x05
#define I_SUB         0x0C
#define I_MUL         0x53
#define I_DIV         0x2C
#define I_REM         0x1F
#define I_GT          0x09
#define I_DIFF        0x04
#define I_SUM         0x52
#define I_PROD        0x08
/*}}}*/
/*{{{  startp, endp, runp, stopp, ldpri*/
#define I_STARTP      0x0D
#define I_ENDP        0x03
#define I_RUNP        0x39
#define I_STOPP       0x15
#define I_LDPRI       0x1E
/*}}}*/
/*{{{  in, out, outword, outbyte, resetch*/
#define I_IN          0x07
#define I_OUT         0x0B
#define I_OUTWORD     0x0F
#define I_OUTBYTE     0x0E
#define I_RESETCH     0x12
/*}}}*/
/*{{{  alt, altwt, altend, enbs, diss, ldtimer, tin, talt, taltwt, enbt, dist*/
#define I_ALT         0x43
#define I_ALTWT       0x44
#define I_ALTEND      0x45
#define I_ENBS        0x49
#define I_DISS        0x30
#define I_ENBC        0x48
#define I_DISC        0x2F
#define I_LDTIMER     0x22
#define I_TIN         0x2B
#define I_TALT        0x4E
#define I_TALTWT      0x51
#define I_ENBT        0x47
#define I_DIST        0x2E
/*}}}*/
/*{{{  xword, cword, xdble, csngl, ladd, lsub, lsum, ldiff, lmul, ldiv, lshl,lshr*/
#define I_XWORD       0x3A
#define I_CWORD       0x56
#define I_XDBLE       0x1D
#define I_CSNGL       0x4C
#define I_LADD        0x16
#define I_LSUB        0x38
#define I_LSUM        0x37
#define I_LDIFF       0x4F
#define I_LMUL        0x31
#define I_LDIV        0x1A
#define I_LSHL        0x36
#define I_LSHR        0x35
/*}}}*/
/*{{{  testpranal, saveh, savel, sthf, sthb, stlf, stlb, sttimer*/
#define I_TESTPRANAL  0x2A
#define I_SAVEH       0x3E
#define I_SAVEL       0x3D
#define I_STHF        0x18
#define I_STHB        0x50
#define I_STLF        0x1C
#define I_STLB        0x17
#define I_STTIMER     0x54
/*}}}*/
/*{{{  norm, unpacksn, roundsn, postnormsn, ldinf, cflerr*/
#define I_NORM        0x19
#define I_UNPACKSN    0x63
#define I_ROUNDSN     0x6D
#define I_POSTNORMSN  0x6C
#define I_LDINF       0x71
#define I_CFLERR      0x73
/*}}}*/
/*{{{  fmul*/
#define I_FMUL        0x72
/*}}}*/
/*{{{  start, testhardchan, testldd, testlde, testlds, teststd, testste, teststs*/
#define I_START       0x1ff
#define I_TESTHARDCHAN 0x2d
#define I_TESTLDD     0x25
#define I_TESTLDE     0x24
#define I_TESTLDS     0x23
#define I_TESTSTD     0x28
#define I_TESTSTE     0x27
#define I_TESTSTS     0x26
/*}}}*/
/*{{{  move2dinit, move2dall, move2dnonzero, move2dzero*/
#define I_MOVE2DINIT  0x5b
#define I_MOVE2DALL   0x5c
#define I_MOVE2DNONZERO 0x5d
#define I_MOVE2DZERO  0x5e
/*}}}*/
/*{{{  crcword, crcbyte, bitcnt, bitrevword, bitrevnbits*/
#define I_CRCWORD     0x74
#define I_CRCBYTE     0x75
#define I_BITCNT      0x76
#define I_BITREVWORD  0x77
#define I_BITREVNBITS 0x78
/*}}}*/
/*{{{  dup, wsubdb*/
#define I_DUP         0x5a
#define I_WSUBDB      0x81
/*}}}*/
/*{{{  inline fp codes*/
#define I_FPSTTEST    0x80
#define I_FPLDNLDBI   0x82
#define I_FPCHKERR    0x83
#define I_FPSTNLDB    0x84
#define I_FPLDTEST    0x85
#define I_FPLDNLSNI   0x86
#define I_FPADD       0x87
#define I_FPSTNLSN    0x88
#define I_FPSUB       0x89
#define I_FPLDNLDB    0x8a
#define I_FPMUL       0x8b
#define I_FPDIV       0x8c
#define I_FPLDNLSN    0x8e
#define I_FPREMFIRST  0x8f
#define I_FPREMSTEP   0x90
#define I_FPNAN       0x91
#define I_FPORDERED   0x92
#define I_FPNOTFINITE 0x93
#define I_FPGT        0x94
#define I_FPEQ        0x95
#define I_FPI32TOR32  0x96
#define I_FPI32TOR64  0x98
#define I_FPB32TOR64  0x9a
#define I_FPTESTERR   0x9c
#define I_FPRTOI32    0x9d
#define I_FPSTNLI32   0x9e
#define I_FPLDZEROSN  0x9f
#define I_FPLDZERODB  0xa0
#define I_FPINT       0xa1
#define I_FPDUP       0xa3
#define I_FPREV       0xa4
#define I_FPLDNLADDDB 0xa6
#define I_FPENTRY3    0xa7
#define I_FPLDNLMULDB 0xa8
#define I_FPENTRY2    0xa9
#define I_FPLDNLADDSN 0xaa
#define I_FPENTRY     0xab
#define I_FPLDNLMULSN 0xac
/*}}}*/
/*{{{  debugger support*/
#define I_BREAK         0xb1
#define I_CLRJ0BREAK    0xb2
#define I_SETJ0BREAK    0xb3
#define I_TESTJ0BREAK   0xb4
#define I_TIMERDISABLEH 0x7a
#define I_TIMERDISABLEL 0x7b
#define I_TIMERENABLEH  0x7c
#define I_TIMERENABLEL  0x7d
#define I_LDMEMSTARTVAL 0x7e
/*}}}*/
/*{{{  pop*/
#define I_POP          0x79
/*}}}*/
/*{{{  loader support*/
#define I_LDDEVID      0x17c
/*}}}*/
/*}}}*/
/*{{{  fpu entry codes*/
#define I_FPUSQRTFIRST (0x01 | I_FPU_ENTRY_BIT)
#define I_FPUSQRTSTEP  (0x02 | I_FPU_ENTRY_BIT)
#define I_FPUSQRTLAST  (0x03 | I_FPU_ENTRY_BIT)
#define I_FPURP        (0x04 | I_FPU_ENTRY_BIT)
#define I_FPURM        (0x05 | I_FPU_ENTRY_BIT)
#define I_FPURZ        (0x06 | I_FPU_ENTRY_BIT)
#define I_FPUR32TOR64  (0x07 | I_FPU_ENTRY_BIT)
#define I_FPUR64TOR32  (0x08 | I_FPU_ENTRY_BIT)
#define I_FPUEXPDEC32  (0x09 | I_FPU_ENTRY_BIT)
#define I_FPUEXPINC32  (0x0a | I_FPU_ENTRY_BIT)
#define I_FPUABS       (0x0b | I_FPU_ENTRY_BIT)
#define I_FPUNOROUND   (0x0d | I_FPU_ENTRY_BIT)
#define I_FPUCHKI32    (0x0e | I_FPU_ENTRY_BIT)
#define I_FPUCHKI64    (0x0f | I_FPU_ENTRY_BIT)
#define I_FPUDIVBY2    (0x11 | I_FPU_ENTRY_BIT)
#define I_FPUMULBY2    (0x12 | I_FPU_ENTRY_BIT)
#define I_FPURN        (0x22 | I_FPU_ENTRY_BIT)
#define I_FPUSETERR    (0x23 | I_FPU_ENTRY_BIT)
#define I_FPUCLRERR    (0x9c | I_FPU_ENTRY_BIT)
/*}}}*/
/*{{{  H1 instructions*/
/*{{{  Recoded FPU instructions*/
#define I_FPSETERR    0xcb
#define I_FPRN        0xd0
#define I_FPDIVBY2    0xd1
#define I_FPMULBY2    0xd2
#define I_FPSQRT      0xd3
#define I_FPRP        0xd4
#define I_FPRM        0xd5
#define I_FPRZ        0xd6
#define I_FPR32TOR64  0xd7
#define I_FPR64TOR32  0xd8
#define I_FPEXPDEC32  0xd9
#define I_FPEXPINC32  0xda
#define I_FPABS       0xdb
#define I_FPCLRERR    0xdc
#define I_FPNOROUND   0xdd
#define I_FPCHKI32    0xde
#define I_FPCHKI64    0xdf
/*}}}*/
/*{{{  New sequential code*/
#define I_GTU         0x5f
#define I_FPRANGE     0x8d
#define I_FPGE        0x97
#define I_FPLG        0x9b
#define I_XBWORD      0xb8
#define I_LBX         0xb9
#define I_CB          0xba
#define I_CBU         0xbb
#define I_SSUB        0xc1
#define I_CIR         0xc7
#define I_SS          0xc8
#define I_LS          0xca
#define I_CIRU        0xcc
#define I_FPREM       0xcf
#define I_XSWORD      0xf8
#define I_LSX         0xf9
#define I_CS          0xfa
#define I_CSU         0xfb
/*}}}*/
/*{{{  Error handling*/
#define I_LDFLAGS     0xb6
#define I_STFLAGS     0xb7
#define I_LDTH        0xc2
#define I_SYSCALL     ( 0x08 | I_NEGATIVE)
#define I_SELTH       ( 0x07 | I_NEGATIVE) /* was SELTRAPHANDLER */
#define I_GOPROT      ( 0x06 | I_NEGATIVE) /* was GOPROTECTED */
#define I_TRET        ( 0x05 | I_NEGATIVE)
#define I_LDSHADOW    ( 0x04 | I_NEGATIVE) /* was LOADSHADOW */
#define I_STSHADOW    ( 0x03 | I_NEGATIVE) /* was SAVESHADOW */
/*}}}*/
/*{{{  Process model*/
#define I_SETTIMESLICE 0xb0
#define I_LDPROC      0xb5
#define I_SWAPQUEUE   ( 0x10 | I_NEGATIVE)
#define I_SWAPTIMER   ( 0x0f | I_NEGATIVE)
#define I_INSERTQUEUE ( 0x0e | I_NEGATIVE)
#define I_TIMESLICE   ( 0x0d | I_NEGATIVE)
/*}}}*/
/*{{{  Communication*/
#define I_INSPHDR     0xbc
#define I_READBFR     0xbd
#define I_LDCNT       0xc0
#define I_LDCHSTATUS  0xc3
#define I_READHDR     (28 | I_NEGATIVE)
#define I_WRITEHDR    (27 | I_NEGATIVE)
#define I_INITVLCB    (26 | I_NEGATIVE)
#define I_SETCHMODE   (25 | I_NEGATIVE)
#define I_SETHDR      (24 | I_NEGATIVE)
#define I_SWAPBFR     (23 | I_NEGATIVE)
#define I_LDVLCB      (22 | I_NEGATIVE)
#define I_STVLCB      (21 | I_NEGATIVE)
#define I_VIN         (20 | I_NEGATIVE)
#define I_VOUT        (19 | I_NEGATIVE)
#define I_STOPCH      (18 | I_NEGATIVE)
/*}}}*/
/*{{{  Semaphores and resources*/
#define I_SIGNAL      ( 0x0c | I_NEGATIVE)
#define I_WAIT        ( 0x0b | I_NEGATIVE)
/*#define I_CLAIM     ( 0x20 | I_NEGATIVE)*/ /* removed 13/12/90 */
#define I_GRANT       ( 0x1f | I_NEGATIVE)
#define I_ENBG        ( 0x1e | I_NEGATIVE)
#define I_DISG        ( 0x1d | I_NEGATIVE)
/*#define I_RDRESPTR  ( 0x2a | I_NEGATIVE)*/ /* removed 13/12/90 */
/*#define I_WRRESPTR  ( 0x29 | I_NEGATIVE)*/ /* removed 13/12/90 */
/*}}}*/
/*{{{  Cache and configuration*/
#define I_LDCONF      0xbe
#define I_STCONF      0xbf
#define I_FDCA        ( 0x30 | I_NEGATIVE) /* was FDCB */
#define I_ICA         ( 0x2f | I_NEGATIVE) /* was ICB */
/*#define I_TESTUPREP   ( 0x2d | I_NEGATIVE)*/ /* removed 13/12/90 */
/*#define I_TESTULINE   ( 0x2c | I_NEGATIVE)*/ /* removed 13/12/90 */
/*#define I_TESTFLINE   ( 0x2b | I_NEGATIVE)*/ /* removed 13/12/90 */
/*#define I_TESTRDTAG   ( 0x2a | I_NEGATIVE)*/ /* removed 13/12/90 */
/*#define I_TESTWRTAG   ( 0x29 | I_NEGATIVE)*/ /* removed 13/12/90 */
/*}}}*/
/*{{{  Added 13/12/90 */
#define I_INTDIS      0xc0
#define I_INTENB      0xc1
#define I_CHANTYPE    0xc9
#define I_FPLDALL     ( 0x02 | I_NEGATIVE)
#define I_FPSTALL     ( 0x01 | I_NEGATIVE)
#define I_STMOVE2DINIT (0x20 | I_NEGATIVE)
#define I_FDCL        ( 0x2e | I_NEGATIVE)
#define I_ICL         ( 0x2d | I_NEGATIVE)
#define I_LDRESPTR    ( 0x28 | I_NEGATIVE)
#define I_STRESPTR    ( 0x27 | I_NEGATIVE)
#define I_ERDSQ       ( 0x26 | I_NEGATIVE)
#define I_IRDSQ       ( 0x25 | I_NEGATIVE)
#define I_MKRC        ( 0x24 | I_NEGATIVE)
#define I_UNMKRC      ( 0x23 | I_NEGATIVE)
/*}}}*/
/*{{{  Added 15/2/91 */
#define I_SWAPGSTATUS ( 0x09 | I_NEGATIVE)
/*}}}*/
/*}}}*/

