/*****************************************************************************
 *
 *  Occam 2 compiler  instdef.h
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *****************************************************************************/
/*}}}*/

/*{{{  constants*/
#define SEQUENTIALGUYS 1
#define FULLGUYS 2

/* Pseudo instructions: (Can overlay the real instructions OK) */
#define I_AJWRET        0x00
#define I_LDRETP        0x01
#define I_LD            0x02
#define I_LDAB          0x03
#define I_LDABC         0x04
#define I_ST            0x05
#define I_STAB          0x06
#define I_STABC         0x07
#define I_BYTE          0x08
#define I_WORD          0x09
#define I_ALIGN         0x0a
#define I_LDLABELDIFF   0x0b

#define INSTRUCTION_NOT_DECLARED (-1)
#define INSTRUCTION_NOT_ENABLED (-2)
#define INSTRUCTION_NOT_VALID (-3)

/* These two strings are parsed by context, so their strings appear here only */
#define LDLABELDIFF_S     "LDLABELDIFF"
#define LDLABELDIFF_S_LEN 11
#define STEP_S            "STEP"
#define STEP_S_LEN        4
/*}}}*/

INT32 lookupinstruction  PARMS((char *inst, int guy_not_asm, int *err, int *ops, int *ptrs, int *elems));
char *primaryname  PARMS((int inst));
char *secondaryname  PARMS((int inst));
