/******************************************************************************
*
*  conf2 definitions
*
*
******************************************************************************/

/*{{{   copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1990
*
******************************************************************************/
/*}}}*/

extern treenode *proclist;
extern treenode *chanlist;
extern treenode *edgelist;
extern treenode *arclist;
extern treenode *chanabbrlist;
extern connection_t *connectionchain;

extern prochwnode_t *root_processor;
extern INT32 romsize;

int empty_name(const namedesc_t *name);
int eq_names(const namedesc_t *name1, const namedesc_t *name2);
int empty_proc(const prochwnode_t *proc);
chanswnode_t *channodeof(const namedesc_t *name);
procswnode_t *procswnodeof(const namedesc_t *name);
prochwnode_t *prochwnodeof(const namedesc_t *name);

int valid_procswnode(const namedesc_t *name);
INT32 procswnode_priority(const namedesc_t *name);

INT32 setproctypeto(const namedesc_t *name);
int proc_wordlength(const namedesc_t *name);
void check_arc_status(const procswnode_t *procnode, SOURCEPOSN locn,
                      chanswnode_t *chan, int dirn);
int connection_status(const namedesc_t *fromproc, const namedesc_t *toproc);
void check_proc_hw(const namedesc_t *procname);

void walk_config_list PARMS((treenode *list, void (*f)(const namedesc_t *)));

void process_config PARMS((treenode *tptr, int hardware));
void process_mapping PARMS((treenode *tptr));
void check_hw_consistency PARMS((void));
void check_host_connection PARMS((void));

void dump_config PARMS((void));

