/****************************************************************************
 *
 *  Occam two compiler version details
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987, 1990
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <string.h>
# include "includes.h"
/*}}}*/

/*{{{  VERSION*/
/* C_COMPATIBILITY is no longer used */
/* define C_COMPATIBILITY "occam 2 product compiler (31st May 1988)" */
/*char *C_COMPATIBILITY = "occam 2 product compiler (26th January 1990)";*/

#define C_VERSION_SIZE 80
PUBLIC char C_VERSION[C_VERSION_SIZE];

#define V_DATE  __DATE__
#define V_TIME  __TIME__

/* The version string is supposed to look like:  Version rr.vv.mm
   where rr is the release number, vv is the version number, mm is the maintenance number
*/
/*#define V_VERSION "Version 04.08.17"*/
/*#define V_VERSION "Alpha V4.8.17"*/
/*#define V_VERSION "Version 00.48.55"*/
/*#define V_VERSION "Version 02.00.01"*/
/*#define V_VERSION "Version 02.00.04"*/ /* beta release */
/*#define V_VERSION "Version 2.00.16"*/ /* beta-2 release */
/*#define V_VERSION "Version 2.00.23"*/ /* beta-3 release */
/*#define V_VERSION "Version 2.00.28"*/ /* last release before the product */
/*#define V_VERSION "Version 2.01.00"*/ /* product release */
#define V_VERSION "Version 2.01.01"

/*#define V_TCOFF_OBJFORMAT " (TCOFF)"*/ /* don't bother saying this */

#ifdef ICHECK
  #define V_TOOL "occam 2 checker "
  #define TOOLNAME "icheck"
  #define TOOLFUNCTION "checker"
#endif

#if defined (CONFIG)
  #define V_TOOL "occam 2 configurer "
  #define TOOLNAME "occonf"
  #define TOOLFUNCTION "configurer"
#endif

#ifdef OC
  #define V_TOOL "occam 2 compiler "
  #define TOOLNAME "oc"
  #define TOOLFUNCTION "compiler"
#endif
/*}}}*/

/*{{{  Host type*/
/* Note that these are all defined to be the same length:
   this means that object files created by compilers on different hosts
   will be the same length.
*/
#ifdef IMS
  #define V_HOST     " (Transputer)"
#else
  #if defined(SUN) || defined(GNU)
    #ifdef sun3
      #define V_HOST " (SunOS-Sun3)"
    #elif defined (sun4)
      #define V_HOST " (SunOS-Sun4)"
    #else
      #define V_HOST " (SunOS-SUN?)"
    #endif
  #elif defined(DEC)
    #define V_HOST   " (DEC-VAXVMS)"
  #endif
#endif
/*}}}*/

PUBLIC char *compilername     = TOOLNAME;
PUBLIC char *compilerfunction = TOOLFUNCTION;

/*{{{  PUBLIC int setup_version_string*/
PUBLIC int setup_version_string()
{
  strcpy (C_VERSION, V_TOOL);
  strcat (C_VERSION, V_VERSION);
  strcat (C_VERSION, " (");
  strcat (C_VERSION, V_TIME);
  strcat (C_VERSION, " ");
  strcat (C_VERSION, V_DATE);
  strcat (C_VERSION, ")");
  strcat (C_VERSION, V_HOST);

  /* if (tcoff_obj_format) strcat (C_VERSION, V_TCOFF_OBJFORMAT); */

  return (strlen(C_VERSION) < C_VERSION_SIZE);
}
/*}}}*/
