 
/******************************************************************************
*
*  Code generator gen9 - case generation
*
******************************************************************************/

/*{{{   copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include <stdlib.h>
# include "includes.h"
# include "extlib.h"

# include "instruct.h"
# include "genhdr.h"
# include "generror.h"
# include "chkdef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen7def.h"
# include "gen9def.h"
# include "gen10def.h"
# include "gen11def.h"
# include "code1def.h"
# include "srcoutde.h"
/*}}}*/

/*{{{  constant and structure definitions*/
#define DELTA 3
#define MIN_JTAB_SIZE 13
#define DENSITY 3

typedef struct
  {
    INT32 lowvalue, highvalue;
    treenode *selectionexp;
    treenode *selectionp;
    int label;
    int jumpdest;
  } caseentry;
/*}}}*/

/*{{{  PRIVATE variables*/
PRIVATE caseentry *casetable;
PRIVATE int defaultlab, defaultjumpdest, selectortype;
PRIVATE int outerjoinlab;
PRIVATE treenode *selectorexp;
/*}}}*/

/*{{{  private routines*/
/*{{{  tjumptable forward declaration*/
PRIVATE void tjumptable PARMS((int high, int low, int nomorejumptables));
/*}}}*/
/*{{{  PRIVATE int casesin (tptr)*/
/*****************************************************************************
 *
 *  casesin takes a list of selections 'tptr' and returns the number of
 *          distinct selections (including an ELSE if one present).
 *
 *****************************************************************************/
PRIVATE int casesin ( treenode *tptr )
{
  int n = 0;
  while (!EndOfList(tptr))
    {
      treenode *thisguard = CondGuardOf(skipspecifications(ThisItem(tptr)));
      if (TagOf(thisguard) == S_ELSE)
        n++;
      else
        n += listitems(thisguard);
      tptr = NextItem(tptr);
    }
  return(n);
}
/*}}}*/
/*{{{  PRIVATE void tbinchop(low, high)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tbinchop generates a binary chop selection for the case values
 *           low to high.
 *           Only works for single-length values at the moment.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tbinchop ( int low , int high )
{
  int midpoint = (high + low) / 2;
  int thislabel = newlab();
  caseentry *thisselection = &(casetable[midpoint]);
  treenode *snode;
  /* Jump if exp <= value */
  int old = switch_to_temp_workspace();
  snode = newdopnode(S_GR, 0, selectorexp, thisselection->selectionexp, selectortype);
  switch_to_prev_workspace(old);
  tguard(snode, TRUE, thislabel);             /*        selectorexp          */
                                              /*        ldc   selection      */
                                              /*        gt                   */
                                              /*        cj    thislabel      */
  /* At this point, we know exp > value */
  tjumptable(midpoint + 1, high, TRUE);       /*        ...  higher cases    */
  setlab(thislabel);                          /* thislabel:                  */
  tjumptable(low, midpoint, TRUE);            /*        ...  lower cases     */
}
/*}}}*/
/*{{{  PRIVATE void tjumptable(low, high, nomorejumptables)*/
/*****************************************************************************
 *
 *  tjumptable generates the code for selecting cases given a sorted array
 *             of case values and labels.  Our case values are
 *             case[low .. high].
 *
 *****************************************************************************/
PRIVATE void tjumptable ( int low , int high , int nomorejumptables )
{
  int numcases = (high - low) + 1;
  int singlelength = fitsinword(selectortype);
  if (numcases <= DELTA)
    /*{{{  too few cases - output jumps*/
    {
      int i;
      int optimisedlast = FALSE;
      for (i = low; i < low + numcases; i++)
        /*{{{  output a jump for casetable[i]*/
        {
          caseentry *thiscase = &(casetable[i]);
          treenode *snode;
          if ((i == high) && (thiscase->lowvalue != ZERO32)
                          && (thiscase->lowvalue != MOSTNEG_INT32)
                          && fitsinword(selectortype)
                          && (!isinconstanttable(thiscase->selectionexp)))
            /*{{{  optimise the last case*/
            {
              int old = switch_to_temp_workspace();
              snode = newdopnode(S_EQ, 0, selectorexp, thiscase->selectionexp, selectortype);
              switch_to_prev_workspace(old);
              tguard(snode, TRUE, defaultlab);
              genbranch(I_J, thiscase->label);
              thiscase->jumpdest = TRUE;
              optimisedlast = TRUE;
            }
            /*}}}*/
          else
            {
              int old = switch_to_temp_workspace();
              snode = newdopnode(S_EQ, 0, selectorexp, thiscase->selectionexp, selectortype);
              switch_to_prev_workspace(old);
              tguard(snode, FALSE, thiscase->label);
            }
        }
        /*}}}*/
      if (!optimisedlast)
        {
          genbranch(I_J, defaultlab);
          defaultjumpdest = TRUE;
        }
    }
    /*}}}*/
  else
    /*{{{  look for biggest jump table*/
    {
      int bestlow, besthigh, bestsize;
      bestsize = 0;
      if (!nomorejumptables && (!singlelength || (numcases >= MIN_JTAB_SIZE)))
        /*{{{  look for best jump table*/
        {
          int i, j;
          int minjumps = singlelength ? MIN_JTAB_SIZE - 1 : DELTA;
          for (i = low; i < (low + numcases - DELTA); i++)
            {
              /*{{{  set j to minimum value possible for better subrange*/
              if (bestsize > minjumps)
                j = i + bestsize;
              else
                j = i + minjumps;
              /*}}}*/
              /*{{{  test all possible subranges starting at i, ending at or past j*/
              {
                int maxaccept = ((high - i) + 1) * DENSITY;
                if (singlelength)
                  /*{{{  single length*/
                  while (j <= high)
                    {
                      INT32 diff = casetable[j].lowvalue - casetable[i].lowvalue;
                      if ((diff < ZERO32) || (diff > maxaccept))
                        j = high;       /* no chance so exit */
                      else
                        {
                          int size = (j - i) + 1;
                          if (diff <= (DENSITY * size))  /* better subrange   */
                            {
                              bestlow = i;
                              besthigh = j;
                              bestsize = size;
                            }
                        }
                      j  = j + 1;
                    }
                  /*}}}*/
                else
                  /*{{{  double length*/
                  while (j <= high)
                    {
                      BIT32 hdiff, ldiff;
                      Int64Minus(&hdiff, &ldiff,
                                 casetable[j].highvalue, casetable[j].lowvalue,
                                 casetable[i].highvalue, casetable[i].lowvalue);
                      if ((hdiff != ZERO32) || (ldiff > maxaccept))
                        j = high;       /* no chance so exit */
                      else
                        {
                          int size = (j - i) + 1;
                          if (ldiff <= (DENSITY * size))  /* better subrange   */
                            {
                              bestlow = i;
                              besthigh = j;
                              bestsize = size;
                            }
                        }
                      j  = j + 1;
                    }
                  /*}}}*/
              }
              /*}}}*/
            }
        }
        /*}}}*/
      if (bestsize == 0)
        tbinchop(low, high);
      else
        /*{{{  do jump table*/
        {
          int lesslab, greaterlab;
          caseentry *lowestcase = &(casetable[bestlow]);
          caseentry *highestcase = &(casetable[besthigh]);
          /*{{{  test for below boundary*/
          {
            treenode *lselnexp = lowestcase->selectionexp;
            if (!ismostneg(selectortype, LoValOf(lselnexp), HiValOf(lselnexp)))
              {
                treenode *snode;
                int l;
          
                int old = switch_to_temp_workspace();
                snode = newdopnode(S_GE, 0, selectorexp, lselnexp, selectortype);
                switch_to_prev_workspace(old);
                if (bestlow == low)
                  l = defaultlab;
                else
                  {
                    lesslab = newlab();
                    l = lesslab;
                  }
                tguard(snode, TRUE, l);
              }
          }
          /*}}}*/
          /*{{{  test for above boundary*/
          {
            treenode *hselnexp = highestcase->selectionexp;
            if (!ismostpos(selectortype, LoValOf(hselnexp), HiValOf(hselnexp)))
              {
                treenode *snode;
                int l;
          
                int old = switch_to_temp_workspace();
                snode = newdopnode(S_LE, 0, selectorexp, hselnexp, selectortype);
                switch_to_prev_workspace(old);
          
                if (besthigh == high)
                  l = defaultlab;
                else
                  {
                    greaterlab = newlab();
                    l = greaterlab;
                  }
          
                tguard(snode, TRUE, l);
              }
          }
          /*}}}*/
          /*{{{  output jump table*/
          {
            int jlab = newlab(), l = newlab();
            treenode *snode;
          
            if (lowestcase->lowvalue != 0)
              /*{{{  selectorexp; ldc lowvalue; diff*/
              {
                int old = switch_to_temp_workspace();
                snode = newdopnode(S_MINUS, 0,      /*           selectorexp           */
                         selectorexp,               /*           ldc   selection       */
                         lowestcase->selectionexp,  /*           diff                  */
                         S_INT);
                switch_to_prev_workspace(old);
              }
              /*}}}*/
            else
              /*{{{  selectorexp*/
              snode = selectorexp;                  /*           selectorexp           */
              /*}}}*/
            texp(snode, MANY_REGS);
            gencasescale(I_LDC);                    /*           ldc   casescale       */
            gensecondary(I_PROD);                   /*           prod                  */
            genlabeldiff(I_LDC, jlab, l);           /*           ldc   jlab - l        */
            gensecondary(I_LDPI);                   /*           ldpi                  */
            setlab(l);                              /* l:                              */
            gensecondary(I_BSUB);                   /*           bsub                  */
            gensecondary(I_GCALL);                  /*           gcall                 */
            setlab(jlab);                           /* jlab:                           */
            genstartjumptable();
            genjumptableentry(I_J, lowestcase->label);
            lowestcase->jumpdest = TRUE;
                                                    /*           j     lowestcase      */
            /*{{{  other cases                                     j     othercases ..*/
            {
              int i;
              for (i = bestlow + 1; i <= besthigh; i++)
                {
                  int j;
                  for (j = 0;
                       j < ((casetable[i].lowvalue - casetable[i - 1].lowvalue) - 1);
                       j++)
                    {
                      genjumptableentry(I_J, defaultlab);
                      defaultjumpdest = TRUE;
                    }
                  genjumptableentry(I_J, casetable[i].label);
                  casetable[i].jumpdest = TRUE;
                }
            }
            /*}}}*/
            genendjumptable();
          }
          /*}}}*/
          if (bestlow > low)
            /*{{{  case on lower values*/
            {
              setlab(lesslab);
              tjumptable(low, bestlow - 1, FALSE);
            }
            /*}}}*/
          if (besthigh < high)
            /*{{{  case on higher values*/
            {
              setlab(greaterlab);
              tjumptable(besthigh + 1, high, FALSE);
            }
            /*}}}*/
        }
        /*}}}*/
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE int doublecomparecases (c1, c2)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  doublecomparecases takes two caseentry structure pointers, 'c1' and 'c2'
 *                     and returns
 *                       1 if c1 selection > c2 selection
 *                       0 if c1 selection = c2 selection
 *                      -1 if c1 selection < c2 selection
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int doublecomparecases ( caseentry *c1 , caseentry *c2 )
{
  int greater;
  Int64Gt(&greater, c1->highvalue, c1->lowvalue, c2->highvalue, c2->lowvalue);
  if (greater)
    return (1);
  else
    {
      int equal;
      Int64Eq(&equal, c1->highvalue, c1->lowvalue, c2->highvalue,c2->lowvalue);
      if (equal)
        return (0);
      else
        return(-1);
    }
}
/*}}}*/
/*{{{  PRIVATE int comparecases (c1, c2)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  comparecases takes two caseentry structure pointers, 'c1' and 'c2'
 *               and returns
 *                1 if c1 selection > c2 selection
 *                0 if c1 selection = c2 selection
 *               -1 if c1 selection < c2 selection
 *               The comparison is upon the low 32-bits only.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int comparecases ( caseentry *c1 , caseentry *c2 )
{
  if ((INT32)(c1->lowvalue) > (INT32)(c2->lowvalue))
    return(1);
  else if ((INT32)(c1->lowvalue) == (INT32)(c2->lowvalue))
    return(0);
  else
    return(-1);
}
/*}}}*/
/*{{{  PRIVATE void tselection (tptr, joinlab)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tvariant generates code for the selection tree 'tptr'.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tselection ( treenode *tptr , int joinlab )
{
  tptr = tspecs(tptr);
  if (TagOf(tptr) != S_SELECTION)
    badtag(genlocn, TagOf(tptr), "tselection");
  tprocess(CondBodyOf(tptr));
  genbranch(I_J, joinlab);
}
/*}}}*/
/*{{{  PRIVATE void tvariant (tptr, channelmode, channel, joinlab)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tvariant generates code for the variant tree 'tptr'.
 *           (channelmode, channel) is the channel on which to input
 *           the protocol following the tag.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tvariant ( treenode *tptr , int channelmode , treenode *channel , int joinlab )
{
  treenode *inputlist, *protocol;
  tptr = tspecs(tptr);
  if (TagOf(tptr) != S_VARIANT)
    badtag(genlocn, TagOf(tptr), "tvariant");
  inputlist = VRTaggedListOf(tptr);
  protocol = NTypeOf(CExpOf(ThisItem(inputlist)));
  inputlist = NextItem(inputlist);
  while (!EndOfList(inputlist))
    {
      tpreexp(ThisItem(inputlist));
      tinputitem(channelmode, channel, P_PTR, ThisItem(inputlist),
                 ThisItem(protocol));
      protocol = NextItem(protocol);
      inputlist = NextItem(inputlist);
    }
  tprocess(VRBodyOf(tptr));
  genbranch (I_J, joinlab);
}
/*}}}*/
/*}}}*/

/*{{{  public routines*/
/*{{{  PUBLIC void mapcase (tptr)*/
/*****************************************************************************
 *
 *  mapcase maps the case tree, tptr.
 *
 *****************************************************************************/
PUBLIC void mapcase ( treenode *tptr )
{
  treenode *selectorexp;
  treenode *selectionlist = RHSOf(tptr);
  mapexp(LHSAddr(tptr));
  selectorexp = LHSOf(tptr);
  if (!issimplelocal(selectorexp))
    /*{{{  preevaluate selector to a temporary*/
    SetLHS(tptr, gettemp(selectorexp, NM_WORKSPACE));
    /*}}}*/
  upusecount (LHSOf(tptr), 4);
  mapconstruction(selectionlist, mapprocess);
}
/*}}}*/
/*{{{  PUBLIC void tcase (tptr)*/
/*****************************************************************************
 *
 *  tcase generates code for a case process tptr
 *
 *****************************************************************************/
PUBLIC void tcase ( treenode *tptr )
{
  /*{{{  save globals*/
  caseentry *oldcasetable = casetable;
  int olddefaultlab = defaultlab;
  int olddefaultjumpdest = defaultjumpdest;
  int oldselectortype = selectortype;
  treenode *oldselectorexp = selectorexp;
  /*}}}*/
  int makedefault = TRUE;
  treenode *selectionlist = RHSOf(tptr);
  int joinlab = newlab();
  int maxcase = 0;
  treenode *defaultp = NULL;
  /*{{{  initialise globals*/
  defaultlab = -1;
  defaultjumpdest = FALSE;
  selectorexp = LHSOf(tptr);
  selectortype = typeof(selectorexp);
  /* make sure that we don't call memalloc with zero bytes */
  casetable = (caseentry *)memalloc(sizeof(caseentry) * casesin(selectionlist) +1);
  /*}}}*/
  /*{{{  evaluate the selector, if neccessary*/
  tpreexp(selectorexp);
  simplify(P_EXP, selectorexp);
  /*}}}*/
  /*{{{  build up table of selections, and generate jumps into case body*/
  {
    treenode *slist = selectionlist;
    while (!EndOfList(slist))
      {
        treenode *thisselection = skipspecifications(ThisItem(slist));
        treenode *v = CondGuardOf(thisselection);
        int l = newlab();
        if (TagOf(v) == S_ELSE)
          {
            defaultlab = l;
            defaultp = ThisItem(slist);
            makedefault = FALSE;
          }
        else
          /*{{{  set up labels and values*/
          while (!EndOfList(v))
            {
              treenode *thisconstant = ThisItem(v);
              caseentry *caseentryptr = &(casetable[maxcase]);
              caseentryptr->label = l;
              caseentryptr->jumpdest = FALSE;
              caseentryptr->lowvalue = LoValOf(thisconstant);
              caseentryptr->highvalue = HiValOf(thisconstant);
              caseentryptr->selectionexp = thisconstant;
              caseentryptr->selectionp = ThisItem(slist);
              maxcase++;
              v = NextItem(v);
            }
          /*}}}*/
        slist = NextItem(slist);
      }
    if (makedefault) defaultlab = newlab();
    local_qsort(casetable, maxcase, sizeof(caseentry),
                   fitsinword(selectortype) ?
                               (int(*)())comparecases :
                               (int(*)())doublecomparecases);
    tjumptable(0, maxcase - 1, FALSE);
  }
  /*}}}*/
  /*{{{  generate case body*/
  {
    int casesdone = 0;
    /*{{{  generate default process*/
    setlab(defaultlab);
    if (makedefault)
    {
      /*{{{  source output*/
      if (source_output)
        so_stop();
      /*}}}*/
      tstop(tptr);
    }
    else
      {
        if (defaultjumpdest) genstartblock();
        tselection(defaultp, joinlab);
      }
    /*}}}*/
    while (casesdone < maxcase)
      {
        treenode *thisprocess;
        int i, jdest;
        /* Find a process to generate */
        for (i = 0; (i < maxcase) && (casetable[i].selectionp == NULL); i++)
          ;
        thisprocess = casetable[i].selectionp;
        /* Generate thisprocess */
        setlab(casetable[i].label);
        jdest = casetable[i].jumpdest;
        /*{{{  find and delete other entries for this process*/
        {
          int j;
          for (j = i + 1; j < maxcase; j++)
            if (casetable[j].selectionp == thisprocess)
              {
                /* Delete the process, so we only generate it once */
                jdest = jdest | casetable[j].jumpdest;
                casetable[j].selectionp = NULL;
                casesdone++;
              }
        }
        /*}}}*/
        if (jdest) genstartblock();
        tselection(thisprocess, joinlab);
        casetable[i].selectionp = NULL;
        casesdone++;
      }
    setlab(joinlab);
    genstartblock();
  }
  /*}}}*/
  /*{{{  restore globals*/
  memfree(casetable);
  casetable = oldcasetable;
  defaultlab = olddefaultlab;
  defaultjumpdest = olddefaultjumpdest;
  selectortype = oldselectortype;
  selectorexp = oldselectorexp;
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tcaseinput (tptr)*/
/*****************************************************************************
 *
 *  tcaseinput generates code for the case input tree, 'tptr'.
 *
 *****************************************************************************/
/*{{{  comment     What the tree looks like*/
/*
                      S_CASEINPUT
                       /       \
(holds channel ptr) T_TEMP    T_TEMP (holds tag)
                     /           \
                 channel        S_LIST
                                /   \
                         S_VARIANT  S_LIST
                         /             .
                      S_LIST            .
                      /    \
   (const val S_CONSTEXP   S_LIST
    of tag)      /            .
            N_TAGDEF           .

N.B. The temporary inserted in front of the channel is optional, and only
     inserted if the channel is not a simple local.
     There is ALWAYS a temporary inserted in front of the variant list, to
     hold the tag.
*/
/*}}}*/
PUBLIC void tcaseinput ( treenode *tptr )
{
  /*{{{  save globals*/
  caseentry *oldcasetable = casetable;
  int olddefaultlab = defaultlab;
  int olddefaultjumpdest = defaultjumpdest;
  int oldselectortype = selectortype;
  treenode *oldselectorexp = selectorexp;
  /*}}}*/
  treenode *variantlist;
  int joinlab = newlab();
  int maxcase;
  int channelmode = chanaspointer ? P_EXP : P_PTR;
  treenode *channel = LHSOf(tptr);
  int usecall = iobycall && maybevirtualchan(channel);
  /*{{{  initialise globals*/
  defaultlab = newlab();
  defaultjumpdest = FALSE;
  selectorexp = RHSOf(tptr);
  selectortype = S_BYTE;
  variantlist = NDeclOf(selectorexp);
  maxcase = listitems(variantlist);
  /*}}}*/
  /*{{{  preevaluate pointer to channel if needed*/
  tpreexp(channel);
  channelmode = simplify(channelmode, channel);
  /*}}}*/
  /*{{{  input the tag*/
  if (maxcase != 0)
    zero_local_var(selectorexp); /* will always be a BYTE */
  tload2regs(P_TEMPPTR, selectorexp, channelmode, channel, FALSE);
                                                  /*           ldlp  selector  */
                                                  /*           ldptr channel   */
  loadconstant(ONE32);                            /*           ldc   1         */
  tioop(I_IN, usecall);
  SetTag(selectorexp, T_PREEVALTEMP);
  /*}}}*/
  /*{{{  build up table of cases and generate jumps into case body*/
  if (maxcase != 0)
  {
    int i = 0;
    treenode *vlist = variantlist;
    casetable = (caseentry *)memalloc(sizeof(caseentry) * maxcase);
    while (!EndOfList(vlist))
      {
        treenode *thisvariant = skipspecifications(ThisItem(vlist));
        treenode *thistag;
        caseentry *caseentryptr = &(casetable[i]);
        thistag = ThisItem(VRTaggedListOf(thisvariant));
        caseentryptr->label = newlab();
        caseentryptr->jumpdest = FALSE;
        caseentryptr->lowvalue = LoValOf(thistag);
        caseentryptr->highvalue = HiValOf(thistag);
        caseentryptr->selectionexp = thistag;
                                                         /* inc. leading specs */
        caseentryptr->selectionp = ThisItem(vlist);
        i++;
        vlist = NextItem(vlist);
      }
    local_qsort(casetable, maxcase, sizeof(caseentry), (int(*)())comparecases);
    tjumptable(0, maxcase - 1, FALSE);
  }
  /*}}}*/
  /*{{{  generate case body*/
  {
    int i;
    for (i = 0; i < maxcase; i++)
      {
        setlab(casetable[i].label);
        if (casetable[i].jumpdest) genstartblock();
        tvariant(casetable[i].selectionp, channelmode, channel, joinlab);
      }
    /* Generate default process */
    setlab(defaultlab);
    /*{{{  source output*/
    if (source_output)
      so_stop();
    /*}}}*/
    tstop(tptr);
    setlab(joinlab);
    genstartblock();
  }
  /*}}}*/
  /*{{{  restore globals*/
  if (maxcase != 0) memfree(casetable);
  casetable = oldcasetable;
  defaultlab = olddefaultlab;
  defaultjumpdest = olddefaultjumpdest;
  selectortype = oldselectortype;
  selectorexp = oldselectorexp;
  /*}}}*/
}
/*}}}*/

/*{{{  PUBLIC void caseinit()*/
PUBLIC void caseinit ( void )
{
  casetable = NULL;
  defaultlab = -1;
  defaultjumpdest = FALSE;
  outerjoinlab = -1;
  selectortype = -1;
  selectorexp = NULL;
}
/*}}}*/
/*}}}*/
