/*#define DEBUG*/
/******************************************************************************
*
*  Code generator gen4 - expression generation
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "generror.h"
# include "instruct.h"
# include "genhdr.h"
# include "syndef.h"
# include "chkdef.h"
# include "bind2def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen5def.h"
# include "gen7def.h"
# include "gen8def.h"
# include "gen11def.h"
# include "code1def.h"
/*}}}*/

/*{{{  forward*/
PRIVATE int revsfor PARMS((treenode *tptr , int regs ));
/*}}}*/

/*{{{  routines*/
/*{{{  PRIVATE int lowpowerof (INT32 p, INT32 v)*/
/*****************************************************************************
 *
 *  lowpowerof returns TRUE if v is a low power of p
 *
 *****************************************************************************/
#if 0
  #define lowpowerof(p,v) ((v == p) || (v == p*p) || (v == p*p*p))
#else
  PRIVATE int lowpowerof(INT32 p, INT32 v)
  {
    INT32 sq;
    return ((v == p) || (v == (sq = p*p)) || (v == sq*p));
  }
#endif
/*}}}*/
/*{{{  register counting*/
/*{{{  PRIVATE int regsfordop (tptr)*/
/*****************************************************************************
 *
 *  regsfordop returns the minimum number of registers required to evaluate
 *             the dyadic operator tree 'tptr'.
 *
 *****************************************************************************/
PRIVATE int regsfordop ( treenode *tptr )
{
  int regsforop1 = regsfor(LeftOpOf(tptr)),
      regsforop2 = regsfor(RightOpOf(tptr));

  return (regsforop1 > regsforop2) ? regsforop1 :
         (regsforop1 < regsforop2) ? regsforop2 :
                                     regsforop1 + 1;
}
/*}}}*/
/*{{{  PRIVATE int regsforfpoperand (treenode *tptr)*/
/*****************************************************************************
 *
 *  regsforfpoperand returns the number of integer registers needed to
 *                   load tptr onto the floating point stack
 *
 *****************************************************************************/
PRIVATE int regsforfpoperand ( treenode *tptr )
{
  return isaddressable(tptr) ? regsforaddr(tptr) : regsfor(tptr);
}
/*}}}*/
/*{{{  PUBLIC int regsfor (tptr)          with added inline fp*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  regsfor returns the minimum number of registers required to evaluate the
 *          expression 'tptr'. It only copes INT or shorter expressions on
 *          an integer processor, but will handle all reals on an fp processor
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int regsfor ( treenode *tptr )
{
  switch (TagOf(tptr))
    {
      default:
        badtag(genlocn, TagOf(tptr), "regsfor");
      /*{{{  monadic operators*/
      case S_NEG:
        if (isreal(MOpTypeOf(tptr)))  /* Added to fix bug 295, 30/4/90 by CO'N */
          return (fpinline ? regsforfpoperand(OpOf(tptr)) : MAXREGS);
        /* We have a choice of
            ldc 0; e; sub       or     e; not; adc 1
         */
        return (istargetintsize(MOpTypeOf(tptr))) ? regsfor(OpOf(tptr)) : MAXREGS;
      case S_UMINUS:
        return (istargetintsize(MOpTypeOf(tptr))) ? max(2, regsfor(OpOf(tptr)))
                                                  : MAXREGS;
      case S_NOT:
        return (istargetintsize(MOpTypeOf(tptr))) ? regsfor(OpOf(tptr)) : MAXREGS;
      case S_BITNOT:
        return (istargetintsize(MOpTypeOf(tptr))) ? regsfor(OpOf(tptr)) : MAXREGS;
      case S_SIZE:
      case S_ELSIZE:
      /* Our implementation guarantees that any array dimensions will be
         preevaluated into temporaries if they need more than one register to
         evaluate them. */
        /*return regsfor(dimexpof(OpOf(tptr), 0));*/ /* this should always be 1 */
        return 1;
      case S_SEGSTART:
        return regsfor(SStartExpOf(OpOf(tptr)));
      case S_ADDRESSOF:
        return regsforaddr(OpOf(tptr));
      /*}}}*/
      /*{{{  dyadic operators*/
      case S_ADD: case S_SUBTRACT:
      case S_MULT: case S_DIV: case S_REM:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE: case S_AFTER:
      case S_LSHIFT: case S_RSHIFT:
      case S_CSUB0: case S_CCNT1:
        if (isreal(DOpTypeOf(tptr)))
          /*{{{  we do reals inline if we have the appropriate hardware*/
          return (fpinline && (TagOf(tptr) != S_REM || H1_instr))
             ? max(regsforfpoperand(LeftOpOf(tptr)), regsforfpoperand(RightOpOf(tptr)))
             : MAXREGS;
          /*}}}*/
        else if (istargetintsize(DOpTypeOf(tptr)))
          /*{{{  inline code*/
          switch (TagOf(tptr))
            {
              /*{{{  S_ADD*/
              case S_ADD:
                {
                  treenode *left = LeftOpOf(tptr),
                           *right = RightOpOf(tptr);
              
                /* add constant optimisation */
                  return (isconst(left) && !isinconstanttable(left))   ? regsfor(right)   :
                         (isconst(right) && !isinconstanttable(right)) ? regsfor(left)    :
                                                                         regsfordop(tptr);
                }
              /*}}}*/
              /*{{{  S_SUBTRACT*/
              case S_SUBTRACT:
                /* add constant optimisation */
                return (isconst(RightOpOf(tptr)) && !isinconstanttable(RightOpOf(tptr)))
                         ? regsfor(LeftOpOf(tptr))
                         : regsfordop(tptr);
              /*}}}*/
              /*{{{  S_TIMES*/
              case S_TIMES:
                {
                  treenode *left = LeftOpOf(tptr),
                           *right = RightOpOf(tptr);
                  /* bcnt optimisation */
                  return (isconst(left) &&
                          lowpowerof((INT32)bytesperword, LoValOf(left)))  ? regsfor(right) :
                         (isconst(right) &&
                          lowpowerof((INT32)bytesperword, LoValOf(right))) ? regsfor(left) :
                                                                            regsfordop(tptr);
                }
              /*}}}*/
              default:
                return regsfordop(tptr);
            }
          /*}}}*/
        else
          return MAXREGS;
      case S_EVAL:
        return regsfor(RightOpOf(tptr));
      case S_AND: case S_OR:
        return max(regsfor(LeftOpOf(tptr)), regsfor(RightOpOf(tptr)));
      /*}}}*/
      /*{{{  conversion*/
      case S_EXACT:
      case S_ROUND: case S_TRUNC:
        {
          treenode *source = OpOf(tptr);
          int sourcetype = typeof(source),
              desttype = MOpTypeOf(tptr);
          if (isreal(sourcetype) || isreal(desttype))
            {
              if (fpinline)
                /*{{{  use the specialised hardware*/
                /* must be a null conversion or REAL32 to REAL64 */
                {
                  if (isreal(desttype))
                    {
                      if (sourcetype == S_INT64)
                        return max(2, regsforfpoperand(source));
                      else
                        return regsforfpoperand(source);
                    }
                  else /* desttype is integer (and fits in a word), sourcetype is real */
                    return regsforfpoperand(source);
                }
                /*}}}*/
              else
                return MAXREGS;
            }
          /*{{{  if double length or quadruple length  => MAXREGS*/
          /* For double-length,
             this is not optimal as there are some cases where we don't need all
             the registers, eg. if the source only requires one register to load,
             we only need two registers (load each half and csngl), if we aren't
             checking, we only need to load the lower half anyway. */
          if (isdoublelength(sourcetype) || isquadlength(sourcetype))
            return(MAXREGS);
          /*}}}*/
      
          /*if ((CONVERSIONCHECKING && hasgreaterrange(sourcetype, desttype)) ||
              (hasgreaterrange(desttype, sourcetype) && issignedtype(sourcetype)))
            return max(2, regsfor(OpOf(tptr)));*/
          if (CONVERSIONCHECKING && hasgreaterrange(sourcetype, desttype))
            {
              if (H1_instr && (desttype == S_BYTE || desttype == S_INT16))
                return regsfor(OpOf(tptr));
              return max(2, regsfor(OpOf(tptr)));
            }
          else if (hasgreaterrange(desttype, sourcetype) && issignedtype(sourcetype))
            {
              if (H1_instr && sourcetype == S_INT16)
                return regsfor(OpOf(tptr));
              return max(2, regsfor(OpOf(tptr)));
            }
          else
            return regsfor(OpOf(tptr));
        }
      /*}}}*/
      /*{{{  literals names  constant expression*/
      case N_VALABBR:
      case N_ABBR:
      case N_VALRETYPE:
      case N_RETYPE:
      case N_DECL:
      case N_VALPARAM:
      case N_PARAM:
        /* See  if it has to be preevaluated to a temp before we can load it */
        return (isshortint(TagOf(NTypeOf(tptr))) && ispointer(tptr)) ? MAXREGS : 1;
      case N_REPL:
      case S_CONSTEXP:
      case S_ASMNAME:
        return 1;
      /*}}}*/
      /*{{{  function instance, specification ... valof*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
      case S_FINSTANCE:  /** Need to think about floating point predefs on t8 */
        return MAXREGS;
      /*}}}*/
      /*{{{  subscript*/
      case S_ARRAYITEM:
        {
          int expregs = (ASExpOf(tptr) != NULL) ? regsfor(ASExpOf(tptr)) : 0;
          if (isshortint(typeof(tptr)))
          /* It has to be preevaluated to a temp before we can load it */
            return max(MAXREGS, expregs);
          else
            {
              int baseregs = regsforaddr(ASBaseOf(tptr));
              return (baseregs <  expregs) ? expregs :
                     (baseregs == expregs) ? expregs + 1 : baseregs;
            }
        }
      /*}}}*/
      /*{{{  constructor                   ***/
      case S_CONSTRUCTOR:
      #if 1
        /* This was previously commented out, for testing of multiple assignment*/
        {
          int maxr = 0;
          tptr = OpOf(tptr);
          while (!EndOfList(tptr))
            {
              maxr = max(maxr, regsfor(ThisItem(tptr)));
              tptr = NextItem(tptr);
            }
          return(maxr);
        }
      #else
        return MAXREGS;
      #endif
      /*}}}*/
      /*{{{  special parameter types*/
      case S_PARAM_STATICLINK:
      case S_PARAM_VSP:
      case S_FNFORMALRESULT:
        return 1;
      case S_HIDDEN_PARAM:
        return regsfor(HExpOf(tptr));
      case S_FNACTUALRESULT:
        return regsforaddr(HExpOf(tptr));
      /*}}}*/
      /*{{{  temporary*/
      case T_TEMP:
        return regsfor(NDeclOf(tptr));
      case T_PREEVALTEMP: /* Preevaluated temporary */
        return 1;
      /*}}}*/
      /*{{{  dummy expression*/
      case S_DUMMYEXP:
        return 0;
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC int regsforaddr(tptr)*/
/*****************************************************************************
 *
 *  regsforaddr returns the minimum number of registers required to
 *              evaluate a pointer to the element or constant table 'tptr'.
 *
 *****************************************************************************/
PUBLIC int regsforaddr ( treenode *tptr )
{
  switch(TagOf(tptr))
    {
      default:
        return(regsfor(tptr));
      /*{{{  name*/
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_DECL:
      case N_VALPARAM: case N_PARAM:
      case S_STRING:
      case S_CONSTCONSTRUCTOR:
      case N_LABELDEF:
      case T_TEMP:
      case T_PREEVALTEMP:
        return 1;
      /*}}}*/
      /*{{{  subscript*/
      case S_ARRAYITEM:
        {
          int expregs = (ASExpOf(tptr) != NULL) ? regsfor(ASExpOf(tptr)) : 0;
          int baseregs = regsforaddr(ASBaseOf(tptr));
          return (baseregs <  expregs) ? expregs :
                 (baseregs == expregs) ? expregs + 1 : baseregs;
        }
      case S_ARRAYSUB:
        return regsforaddr(ASBaseOf(tptr));
      /*}}}*/
      /*{{{  segment*/
      case S_SEGMENTITEM:
        /* Return number of registers needed to load a pointer to the segment */
        {
          int baseregs = regsforaddr(SNameOf(tptr));
          int expregs = (SSubscriptExpOf(tptr) != NULL)
                          ? regsfor(SSubscriptExpOf(tptr)) : 0;
          return (expregs > baseregs) ?  expregs  :
                 (baseregs > expregs) ?  baseregs : baseregs + 1;
        }
      case S_SEGMENT:
        return regsforaddr(SNameOf(tptr));
      /*}}}*/
      case S_CONSTRUCTOR:  /* Added by CO'N 2/4/90 */
        return MAXREGS;
    }
}
/*}}}*/
/*{{{  PUBLIC int regsforstore (dest)*/
/*****************************************************************************
 *
 *  regsforstore returns the number of registers required to store the contents
 *               of Areg in dest (the number returned does not include the
 *               register holding the value to be stored) .
 *
 *****************************************************************************/
PUBLIC int regsforstore ( treenode *dest )
{
  if (issimplelocal(dest))
    return(0);                 /* Store local */
  else if (isshortint(typeof(dest))) /* added 19/10/90 for bug 777 */
    return MAXREGS;            /* Store via a block move */
  else
    return(regsforaddr(dest)); /* Store through a pointer */
}
/*}}}*/
/*{{{  PUBLIC int regsforopd(opdmode, opd)*/
/*****************************************************************************
 *
 *  regsforopd returns the minimum number of registers required to evaluate
 *             the operand (opdmode, opd).
 *
 *****************************************************************************/
PUBLIC int regsforopd ( int opdmode , treenode *opd )
{
  switch (opdmode)
    {
      case P_EXP:     return(regsfor(opd));
      case P_PTR:     return(regsforaddr(opd));
      case P_TEMP:
      case P_TEMPPTR: return(1);
      default:
        geninternal_is(GEN_BAD_OPD, opdmode, "regsforopd");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PUBLIC int regsforaddropd (opdmode, opd)*/
/*****************************************************************************
 *
 *  regsforaddropd returns the minimum number of registers required to load
 *                 a pointer to (opdmode, opd).
 *
 *****************************************************************************/
PUBLIC int regsforaddropd ( int opdmode , treenode *opd )
{
  switch (opdmode)
    {
      case P_TEMP:    return 1;
      case P_EXP:     return(regsforaddr(opd));
      default:        geninternal_is(GEN_BAD_OPD, opdmode, "regsforaddropd");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*}}}*/
/*{{{  rev instruction counting*/
/*{{{  PRIVATE int revsfordop (left, right, commutes, regs)*/
/*****************************************************************************
 *
 *  revsfordop returns the minimum number of 'rev' instructions required
 *             to evaluate a dyadic operation upon the two operands 'left'
 *             and 'right', in at most 'regs' registers.
 *             if the dyadic operation is commutative, then 'commutes' is TRUE.
 *
 *****************************************************************************/
PRIVATE int revsfordop ( treenode *left , treenode *right , int commutes , int regs )
{
  int revbase = (commutes ? 0 : 1);

  if (regsfor(left) == regs)
    /*{{{  must generate left; right; op*/
    return (revsfor(left, regs) + revsfor(right, regs - 1));
    /*}}}*/
  else if (regsfor(right) == regs)
    /*{{{  must generate right; left; (rev; ) op*/
    return (revsfor(right, regs) + revsfor(left, regs - 1) + revbase);
    /*}}}*/
  else
    /*{{{  return the minimum revs  for either left first or right first*/
    return (min(revsfor(left, regs) + revsfor(right, regs - 1),
                revsfor (right, regs) + revsfor(left, regs -1) + revbase));
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE int revsfor (tptr, regs)*/
/*****************************************************************************
 *
 *  revsfor returns the minimum number  of 'rev' instructions neccessarry
 *          when evaluating expression 'tptr' in at most 'regs' registers.
 *
 *****************************************************************************/
PRIVATE int revsfor ( treenode *tptr , int regs )
{
  switch (TagOf(tptr))
    {
      /*{{{  monadic operators*/
      /*{{{  NOT BITNOT UMINUS ADDRESSOF*/
      case S_NOT:
      case S_BITNOT:
      case S_UMINUS:
      case S_ADDRESSOF:
        return (revsfor(OpOf(tptr), regs));
      /*}}}*/
      /*{{{  NEG*/
      case S_NEG:
        /* If we generate
              ldc 0; e; sub         =>  revsfor(e, regs - 1)
              e; not; adc 1         =>  revsfor (e, regs)
         */
        return (revsfor(OpOf(tptr), regs));
      /*}}}*/
      /*{{{  SIZE*/
      case S_SIZE:
      case S_ELSIZE:
        return(revsfor(dimexpof(OpOf(tptr), 0), regs));
      case S_SEGSTART:
        return revsfor(SStartExpOf(OpOf(tptr)), regs);
      /*}}}*/
      /*}}}*/
      /*{{{  conversion*/
      case S_EXACT:
        return(revsfor(OpOf(tptr), regs));
      case S_ROUND: case S_TRUNC:
        #if 0 /* we've done this check in trans */
        if (typeof(OpOf(tptr)) == MOpTypeOf(tptr))
          return(revsfor(OpOf(tptr), regs));
        else
        #endif
          return(MAXREGS);
      /*}}}*/
      /*{{{  dyadic operators*/
      /*{{{  S_ADD*/
      case S_ADD:                                     /* add constant optimisation */
        {
          treenode *left = LeftOpOf(tptr), *right = RightOpOf(tptr);
      
          if (TagOf(left) == S_CONSTEXP)
            return (revsfor(right, regs));
          if (TagOf(right) == S_CONSTEXP)
            return (revsfor(left, regs));
          return (revsfordop(LeftOpOf(tptr), RightOpOf(tptr), TRUE, regs));
        }
      /*}}}*/
      /*{{{  S_SUBTRACT*/
      case S_SUBTRACT:                                /* add constant optimisation */
        {
          treenode *left = LeftOpOf(tptr), *right = RightOpOf(tptr);
      
          if (TagOf(right) == S_CONSTEXP)
            return (revsfor(left, regs));
          return (revsfordop(left, right, FALSE, regs));
        }
      /*}}}*/
      case S_MULT:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS:
        return (revsfordop(LeftOpOf(tptr), RightOpOf(tptr), TRUE, regs));
      case S_AND: case S_OR:
      case S_DIV: case S_REM:
      case S_LSHIFT: case S_RSHIFT:
      case S_MINUS: case S_TIMES:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE: case S_AFTER:
      case S_CSUB0: case S_CCNT1:
        return (revsfordop(LeftOpOf(tptr), RightOpOf(tptr), FALSE, regs));
      case S_EVAL:
        return revsfor(RightOpOf(tptr), regs);
      /*}}}*/
      /*{{{  names  constant expression function instance temps arraydim ...*/
      case N_VALABBR: case N_ABBR: case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM: case N_DECL: case N_REPL:
      case S_CONSTEXP: case S_ASMNAME:
      case S_FINSTANCE:
      case S_VALABBR: case S_ABBR: case S_VALRETYPE: case S_RETYPE: /* spec..valof */
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
      case T_TEMP:
      case T_PREEVALTEMP:
      case S_SEGMENT:
        return (0);
      /*}}}*/
      /*{{{  array item*/
      case S_ARRAYITEM:
        {
          treenode *subscriptexp = ASExpOf(tptr);
          if (subscriptexp != NULL)
            return(revsfor(subscriptexp, regs));
          else
            return(0);
        }
      /*}}}*/
      /*{{{  segment item*/
      case S_SEGMENTITEM: /* This is getting a bit complicated .. so give up */
        return 0;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "revsfor");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*}}}*/
/*{{{  PRIVATE void compdop (dop)*/
/*****************************************************************************
 *
 *  compdop generates the appropriate transputer instruction for dyadic
 *          operator 'dop'.
 *
 *****************************************************************************/
PRIVATE void compdop ( int dop )
{
  switch (dop)
    {
      /*{{{  arithmetic operators*/
      case S_ADD:      gensecondary (I_ADD); break;
      case S_SUBTRACT: gensecondary (I_SUB); break;
      case S_MULT:     gensecondary (NEED_ERRORS ? I_MUL : I_PROD); break;
      case S_DIV:      gensecondary (I_DIV); break;
      case S_REM:      gensecondary (I_REM); break;
      /*}}}*/
      /*{{{  logical operators*/
      case S_BITAND:   gensecondary (I_AND); break;
      case S_BITOR:    gensecondary (I_OR); break;
      case S_XOR:      gensecondary (I_XOR); break;
      /*}}}*/
      /*{{{  shifts*/
      case S_LSHIFT:   gensecondary (I_SHL); break;
      case S_RSHIFT:   gensecondary (I_SHR); break;
      /*}}}*/
      /*{{{  modulo arithmetic*/
      case S_PLUS:   /*gensecondary (I_SUM);*/ gensecondary (I_BSUB); break;
      case S_MINUS:    gensecondary (I_DIFF); break;
      case S_TIMES:    gensecondary (I_PROD); break;
      /*}}}*/
      /*{{{  subscript check*/
      case S_CSUB0:    gensecondary (I_CSUB0); break;
      case S_CCNT1:    gensecondary (I_CCNT1); break;
      /*}}}*/
      /*{{{  comparison*/
      case S_GR:       gensecondary (I_GT); break;
      /*}}}*/
      default:
        badtag(genlocn, dop, "compdop");
    }
}
/*}}}*/
/*{{{  expressions*/
/*{{{  PUBLIC void tdimensionplusn(tptr, n, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 * tdimensionplusn   generates code to load the size plus 'n' of the
 *                   dimension of tptr into Areg.
 *                   At the moment this routine only copes with tptr being an
 *                   element, though it could be expanded to work with any
 *                   expression.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tdimensionplusn ( treenode *tptr , int n , int regs )
{
  treenode *dimexp = dimexpof(tptr, 0);
  if (isconst(dimexp))
    loadconstant(LoValOf(dimexp) + (INT32)n);
  else
    {
      texp(dimexp, regs);
      genprimary(I_ADC, (BIT32)n);
    }
}
/*}}}*/
/*{{{  PUBLIC void tdimension(tptr, regs)*/
/*****************************************************************************
 *
 * tdimension   generates code to load the size of
 *              dimension of tptr into Areg
 *              At the moment this routine only copes with tptr being an
 *              element, though it could be expanded to work with any
 *              expression.
 *
 *****************************************************************************/
PUBLIC void tdimension ( treenode *tptr , int regs )
{
  texp(dimexpof(tptr, 0), regs);
}
/*}}}*/
/*{{{  PUBLIC void tcheckdim (type1, type2)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tcheckdim takes two array type trees, 'type1' and 'type2', and generates
 *                   code to check that a hidden dimensions in either type
 *                   matches the corresponding dimension in the other type.
 *                   Code to check a dimension is of the form
 *                     ld dim1; eqc dim2; ldc 1; ccnt1
 *                   or
 *                     ld dim1; ld dim2; diff; ldc 1; csub0
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tcheckdim ( treenode *type1 , treenode *type2 )
{
  if (ARDimOf(type2) != (-1))
    { treenode *temp = type1; type1 = type2; type2 = temp; }
  if (ARDimOf(type1) != (-1))
    /*{{{  one dimension is constant*/
    {
      texpopd(P_EXP, ARDimLengthOf(type2), MANY_REGS); /*        ld    dim2   */
      genprimary(I_EQC, ARDimOf(type1));               /*        eqc   dim1   */
      loadconstant(1);                                 /*        ldc   1      */
      gensecondary(I_CCNT1);                           /*        ccnt1        */
    }
    /*}}}*/
  else
    /*{{{  both non-constant*/
    {
      tload2regs(P_EXP, ARDimLengthOf(type1),         /*         ld    dim1   */
                 P_EXP, ARDimLengthOf(type2), TRUE);  /*         ld    dim2   */
      gensecondary(I_DIFF);                           /*         diff         */
      genprimary (I_LDC, ONE32);                      /*         ldc   1      */
      gensecondary(I_CSUB0);                          /*         csub0        */
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tcheckdimensions (type1, type2)*/
/*****************************************************************************
 *
 *  tcheckdimensions takes two type trees, 'type1' and 'type2', and generates
 *                   code to check that any hidden dimensions in either type
 *                   match the corresponding dimensions in the other type.
 *                   Code to check a dimension is of the form
 *                     ld dim1; eqc dim2; ldc 1; ccnt1
 *                   or
 *                     ld dim1; ld dim2; diff; ldc 1; csub0
 *
 *****************************************************************************/
PUBLIC void tcheckdimensions ( treenode *type1 , treenode *type2 )
{
  while (TagOf(type1) == S_ARRAY)
    {
      if ((ARDimOf(type1) == (-1) || ARDimOf(type2) == (-1)) &&
          !issame(ARDimLengthOf(type1), ARDimLengthOf(type2)))
        tcheckdim(type1, type2);
      type1 = ARTypeOf(type1);
      type2 = ARTypeOf(type2);
    }
}
/*}}}*/
/*{{{  PUBLIC void tdop (op, type, left, right, regs, commutative)*/
/*****************************************************************************
 *
 *  tdop generates code for the dyadic operator 'op' upon the operands
 *       'left' and 'right' of type 'type'.
 *       'commutative' is TRUE if 'op' is commutative.
 *
 *****************************************************************************/

/*{{{  comment on code sequences*/
/* The code sequences we consider are:
a  left; right; op
   The best sequence: if left uses MAXREGS or less, and right uses
   MAXREGS - 1 or less.
b  right; left; (rev; ) op
   As good as a for commutative operators, otherwise we have to introduce
   a 'rev' instruction.
c  right; stl temp; left; ldl temp; op
   If right uses more temporaries than left.
d  left; stl temp; right; ldl temp; (rev; ) op
   As good as c if op is commutative.  Generally we choose between
   c and d to minimise temporary usage.

                  regsfor(right)
                    >3   3  2  1
                   =l >l
              ------------------
        >3 =r |    c  d  !  !  !       ! = impossible
regsfor    >r |    c  !  d  a  a
(left)   3    |    !  c  c  a  a       MAXREGS = 3
         2    |    !  b  b  a  a
         1    |    !  b  b  a  a
*/
/*}}}*/
PUBLIC void tdop ( int op , int type , treenode *left , treenode *right , int regs , int commutative )
{
  int r = (regs == MANY_REGS) ? MAXREGS : regs;
  int dummy; dummy = type; /* stop unused variable warning */
  /*{{{  look for some optimisations*/
  switch (op)
    {
      default:
        break;
      case S_ADD:
        /*{{{  see if one side is constant*/
        {
          if (isconst(right)) { treenode *temp = right; right = left; left= temp; }
          if (isconst(left) && !isinconstanttable(left))
            /*{{{  we can optimise*/
            {
              texp(right, regs);
              genprimary (I_ADC, LoValOf(left));
              return;
            }
            /*}}}*/
        }
        /*}}}*/
        break;
      case S_SUBTRACT:
        if (isconst(right) && !isinconstanttable(right) &&
            !ismint(LoValOf(right)))
          /*{{{  we can optimise*/
          {
            texp(left, regs);
            genprimary(I_ADC, diff(0, LoValOf(right)));
            return;
          }
          /*}}}*/
        break;
      case S_TIMES:
        {
          treenode *l = left, *r = right;
          if (isconst(r)) { l = right; r = left; }
          if (isconst(l) && (lowpowerof((INT32)bytesperword, LoValOf(l))))
            /*{{{  bytesperword; e; prod => e; bcnt*/
            {
              BIT32 v;
              texp(r, regs);
              for (v = LoValOf(l); v != 1; v /= bytesperword)
                gensecondary(I_BCNT);
              return;
            }
            /*}}}*/
        }
        break;
      case S_CSUB0: case S_CCNT1:
        if (disable_csub0)
          {
            texp(left, regs);
            return;
          }
        break;
    }
  /*}}}*/
  if (TagOf(right) == T_TEMP  && !needtemptoload(P_EXP, NDeclOf(right)))
    /*{{{  right; stl temp; left; ldl temp; op*/
    {
      simplify(P_EXP, right);
      texp(left, regs);
      loadname(right, 0);
      compdop(op);
    }
    /*}}}*/
  else if (TagOf(left) == T_TEMP && !needtemptoload(P_EXP, NDeclOf(left)))
    /*{{{  left; stl temp; right; ldl temp; (rev; ) op*/
    {
      simplify(P_EXP, left);
      texp(right, regs);
      loadname(left, 0);
      if (!commutative) gensecondary(I_REV);
      compdop(op);
    }
    /*}}}*/
  else
    /*{{{  don't need to introduce temporaries here*/
    if (FALSE)/*(hasdup && issame(left, right))*/
      {
        /*if (warning_flags & WARNING_CSE) genwarning(GEN_CSE, 0, 0);*/
        texp(left, r);
        gensecondary(I_DUP);
        compdop(op);
      }
    else
      {
        int regsforleft = regsfor(left),
            regsforright = regsfor(right);
        int leftfirst = TRUE;
    
        /*{{{  set leftfirst TRUE if we generate lhs first, FALSE otherwise*/
        if (max(regsforleft, regsforright) > MAXREGS)
            leftfirst = (regsforleft >= regsforright);
        else if (regsforleft == r)
          leftfirst = TRUE;
        else if (regsforright == r)
          leftfirst = FALSE;
        else
          /*{{{  either 'left; right; op'  or  'right; left; (rev; ) op'*/
          {
            int revbase = commutative ? 0 : 1,
                revs_for_left_first = revsfor(left, r) + revsfor(right, r - 1),
                revs_for_right_first =
                                revsfor(right, r) + revsfor(left, r - 1) + revbase;
          
            leftfirst = (revs_for_left_first <= revs_for_right_first);
          }
          /*}}}*/
        /*}}}*/
    
        if (leftfirst)
          /*{{{  left; right; op*/
          {
            texp(left, regs);
            texp(right, r - 1);
            compdop (op);
          }
          /*}}}*/
        else
          /*{{{  right; left; (rev; ) op*/
          {
            texp(right, regs);
            texp(left, r - 1);
            if (!commutative) gensecondary(I_REV);
            compdop(op);
          }
          /*}}}*/
      }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void texp (tptr, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  texp generates code for the expression 'tptr'.  The type of tptr must be
 *       targetintsize or smaller.
 *       'regs' is the maximum number of registers available for the
 *       expression, it may take the special value MANY_REGS which means
 *       we can use all the registers, and must look out for temporaries, too.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void texp ( treenode *tptr , int regs )
{
  /*{{{  write out the expression*/
  if (diagnostics)
    commentexp (tptr);
  /*}}}*/
  switch (TagOf(tptr))
    {
      /*{{{  dyadic operator*/
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
      case S_LSHIFT: case S_RSHIFT:
      case S_CSUB0: case S_CCNT1:
        tdop (TagOf(tptr), DOpTypeOf(tptr),
              LeftOpOf(tptr), RightOpOf(tptr), regs, commutes(tptr));
        break;
      case S_EVAL:
        texp(RightOpOf(tptr), regs);
        break;
      /*}}}*/
      /*{{{  monadic operators and conversions*/
      /*{{{  NEG                                break*/
      case S_NEG:
        /*{{{  simple inline code*/
        {
          /* We have two options here :
             1  e; not; adc 1    uses one register, but is 1 byte and 1 cycle longer
             2  ldc 0; e; sub    uses two registers, but is shorter and faster and is
                                 to be preferred if we have the registers available.
          */
          treenode *e = OpOf(tptr);
          int r = (regs == MANY_REGS) ? MAXREGS : regs;
          if (regsfor (e) >= r)
            /*{{{  need all registers, so use option 1*/
            {
              texp (e, regs);
              gensecondary (I_NOT);
              genprimary (I_ADC, ONE32);
            }
            /*}}}*/
          else
            /*{{{  see if option 2 uses more rev operations*/
            {
              int revs_for_not = revsfor (e, MAXREGS),
                  revs_for_sub = revsfor (e, MAXREGS - 1);
              if (revs_for_sub == revs_for_not)
                /*{{{  we have the registers for    ldc 0; e; sub    so generate it*/
                {
                  genprimary (I_LDC, ZERO32);
                  texp (e, r - 1);
                  gensecondary (I_SUB);
                }
                /*}}}*/
               else
                 /*{{{  option 2 uses more 'rev' operations, so generate option 1*/
                 {
                   texp(e, regs);
                   gensecondary (I_NOT);
                   genprimary (I_ADC, ONE32);
                 }
                 /*}}}*/
            }
            /*}}}*/
        }
        /*}}}*/
        break;
      /*}}}*/
      /*{{{  unary MINUS                        break*/
      case S_UMINUS:
        tdop(S_MINUS, MOpTypeOf(tptr), newconstant(ZERO32),
                  OpOf(tptr), regs, FALSE);
        break;
      /*}}}*/
      /*{{{  BITNOT                             break*/
      case S_BITNOT:
        texp(OpOf(tptr), regs);
        gensecondary(I_NOT);
        break;
      /*}}}*/
      /*{{{  SIZE ELSIZE SEGSTART               break*/
      case S_SIZE:
        tdimension(OpOf(tptr), regs);
        break;
      case S_ELSIZE:
        tptr = OpOf(tptr);
        if ((TagOf(tptr) == S_SEGMENT) || (TagOf(tptr) == S_SEGMENTITEM))
          /* Evaluate a segment length into a temporary */
          simplify(P_EXP, SLengthExpOf(tptr));
        tdimension(tptr, regs);
        break;
      case S_SEGSTART:
        tptr = OpOf(tptr);
        simplify(P_EXP, SStartExpOf(tptr));
        texp(SStartExpOf(tptr), regs);
        break;
      /*}}}*/
      /*{{{  EXACT                              break*/
      case S_EXACT:
        {
          int sourcetype = typeof(OpOf(tptr)),
              desttype = MOpTypeOf(tptr);
          treenode *source = OpOf(tptr);
      
          /*{{{  COMMENT check for evaluating source to a temporary*/
          /**********************  Start comment out ****************************
          @*{{{  check for evaluating source to a temporary*@
          if (fpinline && preeval(P_EXP, source) &&
              needtemptoload(P_EXP, NDeclOf(source)))
            @* If source is a real to int conversion on an fp processor, then it will
               have to be evaluated to a temporary *@
            simplify(P_EXP, source);
          @*}}}*@
           **********************   End comment out  ****************************/
          /*}}}*/
      
          if (isdoublelength(sourcetype))
            /*{{{  load and check it fits in a single word, change sourcetype to INT*/
            {
              int sourcemode = P_EXP;
              if (CONVERSIONCHECKING || !isaddressable(source))
                {
                  sourcemode = addresslopd(sourcemode, source);
                  loadopd(sourcemode, source, 1);
                  loadopd(sourcemode, source, 0);
                  gensecondary(I_CSNGL);
                }
              else
                loadopd(sourcemode, source, 0);
              sourcetype = S_INT;
            }
            /*}}}*/
          else
            texp(source, regs);
      
          if (CONVERSIONCHECKING && hasgreaterrange(sourcetype, desttype))
            /*{{{  we have to check the range*/
            {
              /* we know that sourcetype is <= S_INT32, and desttype <= S_INT32(?) */
              if (H1_instr && desttype == S_BYTE)
                gensecondary(I_CBU);
              else if (H1_instr && desttype == S_INT16)
                gensecondary(I_CS);
              else if (issignedtype(desttype))
                /*{{{  use cword*/
                {
                  loadconstant(checkmask(desttype));
                  gensecondary(I_CWORD);
                }
                /*}}}*/
              else
                /*{{{  use csub0*/
                {
                  loadconstant(checkmask(desttype));
                  gensecondary(I_CSUB0);
                }
                /*}}}*/
            }
            /*}}}*/
          else if (hasgreaterrange(desttype, sourcetype) && issignedtype(sourcetype))
            /*{{{  extend to full word*/
            /* desttype > sourcetype and sourcetype is signed, means that
               sourcetype = S_INT16, or sourcetype = S_INT32.
               In practice, only S_INT16 ever gets here! */
            {
              if (H1_instr && sourcetype == S_INT16)
                gensecondary(I_XSWORD);
              else
                {
                  loadconstant(typemask(sourcetype));
                  gensecondary(I_AND);
                  loadconstant(checkmask(sourcetype));
                  gensecondary(I_XWORD);
                }
            }
            /*}}}*/
        }
        break;
      /* One might reasonably ask,"What happened to ROUND and TRUNC?"
         Well the answer is this: if we are on a T4, they will have been turned
         into function calls; if we are on a T8, we must be doing a real to
         integer conversion to expect one here,
         so the source is evaluated on the fpu, then stored
         to a temporary. We look for those round/truncs in routine
         "assign", not here, which enables us to generate better code. */
      /*}}}*/
      /*{{{  ADDRESSOF                          break*/
      case S_ADDRESSOF:
        loadelementpointer(OpOf(tptr), 0, regs);
        break;
      /*}}}*/
      /*}}}*/
      /*{{{  Boolean operator*/
      case S_NOT:
      case S_AND: case S_OR:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE: case S_AFTER:
        tbool (tptr, regs);     /* tbool calls texp recursively if needed */
        break;
      /*}}}*/
      /*{{{  element*/
      case N_DECL: case N_REPL:
      case N_ABBR: case N_VALABBR:
      case N_PARAM: case N_VALPARAM:
      case N_RETYPE: case N_VALRETYPE:
      case S_ARRAYITEM:
      case S_SEGMENTITEM: /* When we're retyping a segment to fit in a word */
      case T_PREEVALTEMP: /* A pre-evaluated temporary */
        loadelement(tptr, 0, regs);
        break;
      case T_TEMP:
        if (needtemptoload(P_EXP, NDeclOf(tptr)))
          {
            simplify(P_EXP, tptr);
            loadname(tptr, 0);
          }
        else
          loadelement(tptr, 0, regs);
        break;
      /*}}}*/
      /*{{{  function instance*/
      case S_FINSTANCE:
        if (TagOf(INameOf(tptr)) == N_PREDEFFUNCTION)
          tpredef(tptr, NULL);
        else
          tinstance(tptr);
        break;
      /*}}}*/
      /*{{{  specification ... valof*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
        tvalof(tptr, NULL);
        break;
      /*}}}*/
      /*{{{  special parameter values*/
      case S_PARAM_STATICLINK:
        loadstaticlink(instancedlevel);                       /* Uses one register */
        break;
      case S_PARAM_VSP:
        loadnewvsp(HDimensionOf(tptr));                       /* Uses one register */
        break;
      case S_HIDDEN_PARAM:
        texp(HExpOf(tptr), regs);
        break;
      case S_FNACTUALRESULT:
        loadelementpointer(HExpOf(tptr), 0, regs);
        gencomment0("actualresult");
        break;
      /*}}}*/
      /*{{{  constant*/
      case S_CONSTEXP:
        if (isinconstanttable(tptr))
          /*{{{  load from constant table*/
          {
            genprimary(I_LDL, constptr + nameoffsetof(lexlevel));
            gencomment0("constptr");
            genprimary(I_LDNL, CEOffsetOf(tptr));
          }
          /*}}}*/
        else
          loadconstant(LoValOf(tptr));
        break;
      /*}}}*/
      /*{{{  special ASM name - NOT converted */
      case S_ASMNAME:
        generr_s(GEN_BAD_ASMNAME, WNameOf((wordnode *)tptr));
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "texp");
    }
}
/*}}}*/
/*{{{  PUBLIC void texpopd (opdmode, opd, regs)         ***/
/*****************************************************************************
 *
 *  texpopd generates code to evaluate the operand (opdmode, opd), using
 *          at most 'regs' registers.
 *
 *****************************************************************************/
PUBLIC void texpopd ( int opdmode , treenode *opd , int regs )
{
  switch (opdmode)
    {
      case P_TEMP:    loadname(opd, 0);
                      /*gencomment1 ("$temp%d", (BIT32)NVVarNumOf(opd));*/
                      break;
      case P_TEMPPTR: loadnamepointer(opd, 0);
                      /*gencomment1 ("$temp%d", (BIT32)NVVarNumOf(opd));*/
                      break;
      case P_EXP:     texp(opd, regs);
                      break;
      case P_PTR:     loadelementpointer(opd, 0, regs);
                      break;
      default:        geninternal_is(GEN_BAD_OPD, opdmode, "texpopd");
    }
}
/*}}}*/
/*}}}*/
/*{{{  loading registers*/
/*{{{  PUBLIC void tload2regs(e1mode, e1, e2mode, e2, commutative)*/
/*****************************************************************************
 *
 *  tload2regs generates code for loading (e1mode, e1) and (e2mode, e2)
 *             into Areg and Breg.
 *             If commutative is FALSE, e1 will be in Breg and e2 will be
 *             in Areg; otherwise they may be reversed.
 *
 *****************************************************************************/
PUBLIC void tload2regs ( int e1mode , treenode *e1 , int e2mode , treenode *e2 , int commutative )
{
  if (preeval(e2mode, e2))
    /*{{{  e2; stl temp; e1; ldl temp*/
    {
      e2mode = simplify(e2mode, e2);
      texpopd(e1mode, e1, MANY_REGS);
      loadopd(e2mode, e2, 0);
    }
    /*}}}*/
  else if (preeval(e1mode, e1))
    /*{{{  temp := e1; e2; ldl temp; (rev) | temp := e1; ldl temp; e2*/
    {
      e1mode = simplify(e1mode, e1);
      if (regsforopd(e2mode, e2) < MAXREGS)
        {
          loadopd(e1mode, e1, 0);
          texpopd(e2mode, e2, MAXREGS - 1);
        }
      else
        {
          texpopd(e2mode, e2, MAXREGS - 1);
          loadopd(e1mode, e1, 0);
          if (!commutative) gensecondary(I_REV);
        }
    }
    /*}}}*/
  else
    /*{{{  count registers to decide which to evaluate first*/
    {
      if (FALSE)/*(hasdup && e1mode == e2mode && issame(e1, e2))*/
        {
          /*if (warning_flags & WARNING_CSE) genwarning(GEN_CSE, 0, 0);*/
          texpopd(e1mode, e1, MANY_REGS);
          gensecondary(I_DUP);
        }
      else
        {
          if (regsforopd(e2mode, e2) >= MAXREGS)
            {
              texpopd(e2mode, e2, MANY_REGS);
              texpopd(e1mode, e1, MAXREGS - 1);
              if (!commutative) gensecondary(I_REV);
            }
          else
            {
              texpopd(e1mode, e1, MANY_REGS);
              texpopd(e2mode, e2, MAXREGS - 1);
            }
        }
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tload3regs(e1mode, e1, e2mode, e2, e3mode, e3, loadseq)*/
/*****************************************************************************
 *
 *  tload3regs generates code for loading (e1mode, e1) into Creg,
 *             (e2mode, e2) into Breg, (e3mode, e3) into Areg.
 *             loadseq defines the loading sequence for e1, e2, e3.
 *
 *****************************************************************************/
PUBLIC void tload3regs ( int e1mode , treenode *e1 , int e2mode , treenode *e2 , int e3mode , treenode *e3 , int loadseq )
{
  e2mode = simplify(e2mode, e2);
  e3mode = simplify(e3mode, e3);
  switch(loadseq)
    /*{{{  do the loading*/
    {
      case 1:
        /*{{{  e1; e2; e3*/
        texpopd(e1mode, e1, MANY_REGS);
        texpopd(e2mode, e2, MAXREGS - 1);
        texpopd(e3mode, e3, MAXREGS - 2);
        break;
        /*}}}*/
      case 2:
        /*{{{  e1; e3; e2; rev*/
        texpopd(e1mode, e1, MANY_REGS);
        texpopd(e3mode, e3, MAXREGS - 1);
        texpopd(e2mode, e2, MAXREGS - 2);
        gensecondary(I_REV);
        break;
        /*}}}*/
      case 3:
        /*{{{  e2; e1; rev; e3*/
        texpopd(e2mode, e2, MANY_REGS);
        texpopd(e1mode, e1, MAXREGS - 1);
        gensecondary(I_REV);
        texpopd(e3mode, e3, MAXREGS - 2);
        break;
        /*}}}*/
      case 4:
        /*{{{  e3; e1; rev; e2; rev*/
        texpopd(e3mode, e3, MANY_REGS);
        texpopd(e1mode, e1, MAXREGS - 1);
        gensecondary(I_REV);
        texpopd(e2mode, e2, MAXREGS - 2);
        gensecondary(I_REV);
        break;
        /*}}}*/
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
/*{{{  storing registers*/
/*{{{  PUBLIC void tstoreregs (dest, nregs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tstoreregs stores up to MAXREGS register values to their destinations.
 *             'nregs' is the number of registers to be stored.
 *             'dest' is an array containing pointers to the trees representing
 *             the destinations.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tstoreregs ( treenode **dest [MAXREGS ], int nregs )
{
  int regsfordest[MAXREGS];
  int i;
  int ndone;
  int topreg = nregs - 1;
  int freeregs = MAXREGS - nregs;
  for (i = 0; i < nregs; i++)
    {
      regsfordest[i] = regsforstore(*dest[i]);
      DEBUG_MSG(("tstoreregs: regsfordest %d is %d\n", i, regsfordest[i]));
    }
  for (ndone = 0; ndone < nregs; ndone++)
    /*{{{  (store top register) or (rev; store top register)*/
    {
      if (TagOf(*dest[topreg]) == T_TEMP)
        {
          DEBUG_MSG(("tstoreregs: storing in temporary\n"));
          storeinopd(P_TEMP, *dest[topreg], ZERO32, freeregs);
        }
      else if (regsfordest[topreg] <= freeregs)
        {
          DEBUG_MSG(("tstoreregs: storing directly\n"));
          storeinopd(P_EXP, *dest[topreg], ZERO32, freeregs);
        }
      else /* regsfordest[topreg - 1] <= freeregs */
        {
          DEBUG_MSG(("tstoreregs: doing rev ; store\n"));
          gensecondary(I_REV);
          storeinopd(P_EXP, *dest[topreg - 1], ZERO32, freeregs);
          dest[topreg - 1] = dest[topreg];
          regsfordest[topreg - 1] = regsfordest[topreg];
        }
      topreg--;
      freeregs++;
     }
    /*}}}*/
  /*{{{  move temporaries to real destinations*/
  for (i = 0; i < nregs; i++)
    if (TagOf(*dest[i]) == T_TEMP)
      {
        treenode *destexp = NDeclOf(*dest[i]);
        DEBUG_MSG(("tstoreregs: moving temp %d to dest\n", i));
        tsimpleassign(typeof(destexp), P_EXP, destexp, P_TEMP, *dest[i], MANY_REGS);
      }
  /*}}}*/
}
/*}}}*/
/*}}}*/
/*}}}*/
