/*#define DEBUG*/
/*****************************************************************************
 *
 *  Code generator gen3 - general support routines, overspill from gen2
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *
 *****************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "generror.h"
# include "chkdef.h"
# include "gen1def.h"
# include "gen2def.h"
# include "genhdr.h"
/*}}}*/

/*{{{  PUBLIC int check_aligned (treenode *tptr, int required_align)*/
/*****************************************************************************
 *
 *  check_aligned takes an element 'tptr' and returns TRUE if it is
 *                definitely aligned on a word or half word boundary,
 *                FALSE if it is not, or it is unknown.
 *                required_align will be bytesperword, or maybe 2 on a 32bit
 *****************************************************************************/
PUBLIC int check_aligned ( treenode *tptr, int required_align )
{
  DEBUG_MSG(("check_aligned: tag is %d\n", TagOf(tptr)));
  switch (TagOf(tptr))
    {
      default:          return FALSE;
      case N_DECL:
      case N_REPL:      return TRUE;
      case N_VALABBR:
      case N_VALRETYPE:
      case N_VALPARAM:
        /* bug 1129 28/1/91: the following comment about bug 1015 is now
           irrelevant. We now align ALL constant valabbrs. CON.
        */
        /* bug 1015: this assumption is a little strong. Constant tables
           are N_VALABBRs, but are not necessarily word aligned.
           We have made use of the fact that the item we are checking
           will always be bytesperword long (ie check_aligned is only called when
           bytesin(gettype(tptr)) == bytesperword)
           and we specifically word align constant tables which are a word
           long (see tconsttable), so all this ends up fine.
           CON 12/10/90 */
        return (NModeOf(tptr) != NM_POINTER);
      /*{{{  S_ARRAYITEM S_SEGMENTITEM*/
      case S_ARRAYITEM:
      case S_SEGMENTITEM:
        {
          treenode *base, *exp;
          INT32 offset;
          if (TagOf(tptr) == S_ARRAYITEM)
            { base = ASBaseOf(tptr); exp = ASExpOf(tptr); offset = ASOffsetOf(tptr); }
          else
            { base = SNameOf(tptr); exp = SSubscriptExpOf(tptr);
              offset = SOffsetOf(tptr); }
      
          if (check_aligned(base, required_align))
            {
              int b = bytesinscalar(basetype(gettype(tptr)));
              DEBUG_MSG(("check_aligned: base is ok; b is %d, exp==NULL?:%d, offset is %ld\n", b, exp==NULL, offset));
              return (b >= bytesperword) ||
                     (exp == NULL && (offset % (INT32)(required_align / b)) == 0);
            }
          else
            return FALSE;
        }
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC int isquadlength (int type)*/
/*****************************************************************************
 *
 *  isquadlength returns TRUE if an object of type 'type' occupies four
 *               machine words.
 *
 *****************************************************************************/
PUBLIC int isquadlength ( int type )
{
   return (targetintsize == S_INT16) && (type == S_INT64 || type == S_REAL64);
}
/*}}}*/
/*{{{  PUBLIC INT32 wordof (treenode *tptr, int word)*/
/*****************************************************************************
 *
 *  wordof takes a constant node 'tptr' and returns the constant value of
 *         the word'th word of it.
 *
 *****************************************************************************/
PUBLIC INT32 wordof ( treenode *tptr , int word )
{
  INT32 result;
  if (word == 0)
    result = (targetintsize == S_INT16) ? LoValOf(tptr) & 0xffff
                                        : LoValOf(tptr);
  else if (word == 1)
    result = (targetintsize == S_INT16) ? (LoValOf(tptr) >> 16) & 0xffff
                                        : HiValOf(tptr);
  else
    badtag(genlocn, word, "wordof");
  return result;
}
/*}}}*/
#if 0  /* never used */
/*{{{  PUBLIC int hastruealtguard (tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  usedinaltguards takes an element, 'n', and an alt tree, 'tptr' and
 *                  returns TRUE if 'n' is referenced in a guard or channel
 *                  of any of the alternatives in 'tptr', otherwise returns
 *                  FALSE.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int hastruealtguard ( treenode *tptr )
{
  while (tptr != NULL)
    {
      tptr = skipspecifications(tptr);
      switch (TagOf(tptr))
        {
          /*{{{  ALT PRIALT*/
          case S_ALT: case S_PRIALT:
            tptr = CBodyOf(tptr);
            break;
          /*}}}*/
          /*{{{  REPLALT PRIREPLALT*/
          case S_REPLALT: case S_PRIREPLALT:
            tptr = ReplCBodyOf(tptr);
            break;
          /*}}}*/
          /*{{{  LIST*/
          case S_LIST:
            if (hastruealtguard(ThisItem(tptr)))
              return TRUE;
            else
              tptr = NextItem(tptr);
            break;
          /*}}}*/
          /*{{{  ALTERNATIVE*/
          case S_ALTERNATIVE:
            tptr = AltGuardOf(tptr);
            return (tptr == NULL || istrueguard(tptr));
          /*}}}*/
        }
    }
  return FALSE;
}
/*}}}*/
#endif /* 0 */
/*{{{  PRIVATE treenode *skipdims(treenode *tptr)*/
/*****************************************************************************
 *
 *  skipdims takes a treenode tptr, and walks inside any S_ELSIZE or
 *           S_SEGSTART nodes.
 *
 *****************************************************************************/
PRIVATE treenode *skipdims ( treenode *tptr )
{
  if (TagOf(tptr) == S_ELSIZE)
    return dimexpof(OpOf(tptr), 0);
  else if (TagOf(tptr) == S_SEGSTART)
    return SStartExpOf(OpOf(tptr));
  else
    return tptr;
}
/*}}}*/
/*{{{  PUBLIC int issame(treenode *t1, treenode *t2)*/
/*****************************************************************************
 *
 *  issame takes two expression trees, 't1' and 't2' and returns TRUE
 *         if they represent the same expression, FALSE otherwise.
 *
 *****************************************************************************/
PUBLIC int issame ( treenode *t1 , treenode *t2 )
{
  while (t1 != NULL && t2 != NULL &&
         (TagOf(t1 = skipdims(t1)) == TagOf(t2 = skipdims(t2))))
    /*{{{  look at the nodes*/
    switch(TagOf(t1))
      {
        default: return FALSE;
        /*{{{  monadics*/
        case S_NEG: case S_UMINUS: case S_BITNOT: case S_NOT: case S_SIZE:
          t1 = OpOf(t1); t2 = OpOf(t2);
          break;
        /* These two are handled by skipdims :
        case S_ELSIZE:
        case S_SEGSTART: */
        /*}}}*/
        /*{{{  conversions*/
        case S_EXACT: case S_ROUND: case S_TRUNC:
          if (DOpTypeOf(t1) != DOpTypeOf(t2))
            return FALSE;
          t1 = OpOf(t1);
          t2 = OpOf(t2);
          break;
        /*}}}*/
        /*{{{  dyadics*/
        case S_AND: case S_OR:
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
        case S_BITAND: case S_BITOR: case S_XOR:
        case S_LSHIFT: case S_RSHIFT:
        case S_PLUS: case S_MINUS: case S_TIMES:
        case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
        case S_AFTER:
        case S_CSUB0:
        case S_CCNT1:
          if (!issame(LeftOpOf(t1), LeftOpOf(t2)))
            return FALSE;
          t1 = RightOpOf(t1);
          t2 = RightOpOf(t2);
          break;
        /*}}}*/
        /*{{{  instance*/
        case S_FINSTANCE:
          if (!issame(INameOf(t1), INameOf(t2)))
            return FALSE;
          t1 = IParamListOf(t1);
          t2 = IParamListOf(t2);
          break;
        /*}}}*/
        /*{{{  list*/
        case S_LIST:
          if (!issame(ThisItem(t1), ThisItem(t2)))
            return FALSE;
          t1 = NextItem(t1);
          t2 = NextItem(t2);
          break;
        /*}}}*/
        /*{{{  constant expression*/
        case S_CONSTEXP:
          if (LoValOf(t1) != LoValOf(t2))
            return FALSE;
          else
            return (bytesinscalar(typeof(t1)) < 4) || (HiValOf(t1) == HiValOf(t2));
        /*}}}*/
        /*{{{  element*/
        case S_ARRAYSUB:
          if (!issame(ASBaseOf(t1), ASBaseOf(t2)))
            return FALSE;
          t1 = ASIndexOf(t1);
          t2 = ASIndexOf(t2);
          break;
        case S_ARRAYITEM:
          if (!issame(ASBaseOf(t1), ASBaseOf(t2)) ||
               ASOffsetOf(t1) != ASOffsetOf(t2))
            return FALSE;
          t1 = ASExpOf(t1);
          t2 = ASExpOf(t2);
          break;
        case N_DECL: case N_REPL:
        case N_ABBR: case N_VALABBR:
        case N_RETYPE: case N_VALRETYPE:
        case N_PARAM: case N_VALPARAM:
        case N_TAGDEF:
        case N_SFUNCDEF: case N_LFUNCDEF:
        case N_SCFUNCDEF: case N_LIBFUNCDEF:
        case N_PREDEFFUNCTION:
        case T_TEMP: case T_PREEVALTEMP:
          return t1 == t2;
        /*}}}*/
        /*{{{  special variables*/
        case S_HIDDEN_PARAM:
          t1 = HExpOf(t1);
          t2 = HExpOf(t2);
          break;
        /*}}}*/
      }
    /*}}}*/
  return (t1 == t2);
}
/*}}}*/
/*{{{  PUBLIC int ismostpos(int type, BIT32 loval, BIT32 hival)*/
/*****************************************************************************
 *
 *  ismostpos returns TRUE if (loval, hival) represents the MOSTPOS value
 *            of type 'type' : 'type' must be integer or byte type.
 *
 *****************************************************************************/
PUBLIC int ismostpos ( int type , BIT32 loval , BIT32 hival )
{
  if (type == S_INT) type = targetintsize;
  switch (type)
    {
      case S_BYTE: return (loval == 255);
      case S_INT16: return (loval == MOSTPOS_INT16);
      case S_INT32: return (loval == MOSTPOS_INT32);
      case S_INT64: return (loval == 0xffffffffl && hival == MOSTPOS_INT32);
    }
  return (FALSE); /* Not reached */
}
/*}}}*/
/*{{{  PUBLIC int ismostneg(int type, BIT32 loval, BIT32 hival)*/
/*****************************************************************************
 *
 *  ismostneg returns TRUE if (loval, hival) represents the MOSTNEG value
 *            of type 'type' : 'type' must be integer or byte type.
 *
 *****************************************************************************/
PUBLIC int ismostneg ( int type , BIT32 loval , BIT32 hival )
{
  if (type == S_INT) type = targetintsize;
  switch (type)
    {
      case S_BYTE: return (loval == 0);
      case S_INT16: return (loval == MOSTNEG_INT16);
      case S_INT32: return (loval == MOSTNEG_INT32);
      case S_INT64: return (loval == ZERO32 && hival == MOSTNEG_INT32);
    }
  return (FALSE); /* Not reached */
}
/*}}}*/
/*{{{  PUBLIC int issimplechan(nptr)*/
/*****************************************************************************
 *  int issimplechan returns TRUE if the name nptr is a channel which
 *                   is not accessed via a pointer.
 *
 *                   Only ever called if chanaspointer is TRUE.
 *
 *                   This is used to optimise local channels which
 *                   don't need a pointer too.
 *
 *****************************************************************************/
PUBLIC int issimplechan ( treenode *nptr )
{
#if OPTIMISE_LOCAL_CHANS
  /* treat all local channels as `simple' */
  /* return (TagOf(nptr) == N_DECL && TagOf(NTypeOf(nptr)) == S_CHAN); */

  /* treat all local channels as simple, as long as they're not marked
     as accessed by 'nasty' things */
  return (TagOf(nptr) == N_DECL && TagOf(NTypeOf(nptr)) == S_CHAN &&
          (!NChanMarkOf(nptr) || (NModeOf(nptr) == NM_PLACED)));
#else
/* we treat this as a `simple' channel only if it is a PLACED scalar channel*/
  return (TagOf(nptr) == N_DECL && TagOf(NTypeOf(nptr)) == S_CHAN &&
          NModeOf(nptr) == NM_PLACED);
#endif
}
/*}}}*/
/*{{{  PUBLIC int maybevirtualchan(nptr)*/
/*****************************************************************************
 *  int maybevirtualchan returns TRUE if the element nptr is a channel which
 *                       may be a virtual channel.
 *****************************************************************************/
PUBLIC int maybevirtualchan ( treenode *nptr )
{
  while (nptr != NULL)
    switch (TagOf(nptr))
      {
        case S_ARRAYSUB:
        case S_ARRAYITEM:   nptr = ASBaseOf(nptr);  break;
        case S_SEGMENT:
        case S_SEGMENTITEM: nptr = SNameOf(nptr);  break;
        case N_ABBR:        nptr = DValOf(NDeclOf(nptr)); break;
        case T_PREEVALTEMP:
        case T_TEMP:        nptr = NDeclOf(nptr); break;
        case N_DECL:        return FALSE;
        default:            return TRUE;
      }
  return TRUE;
}
/*}}}*/
/*{{{  PUBLIC int ismint(c)*/
PUBLIC int ismint ( INT32 c )
{
  if (targetintsize == S_INT32)
    return (c == MOSTNEG_INT32);
  else
    return (c == MOSTNEG_INT16);
}
/*}}}*/
/*{{{  PUBLIC INT32 diff(a,b)*/
PUBLIC INT32 diff ( INT32 a , INT32 b )
{
#if defined(TDS) && !defined(OC)
  asm { ldl a; ldl b; diff; stl a;} /* will not set error */
#else
  a = a - b;
#endif
  return a;
}
/*}}}*/
/*{{{  PUBLIC INT32 sum(a,b)*/
PUBLIC INT32 sum ( INT32 a , INT32 b )
{
#if defined(TDS) && !defined(OC)
  asm { ldl b; ldl a; sum; stl a;} /* will not set error */
#else
  a = a + b;
#endif
  return a;
}
/*}}}*/
