/*#define DEBUG*/
/*****************************************************************************
 *
 *  Code generator gen12 - hardware floating point expression generation
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *
 *****************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "generror.h"
# include "instruct.h"
# include "genhdr.h"
# include "syndef.h"
# include "chkdef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen5def.h"
# include "gen8def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
/*}}}*/

/*{{{  defintions*/
#define REAL32_2      0x40000000   /* 2.0(REAL32) */
#define REAL64_2_LOW  0            /* lower 32-bits of 2.0(REAL64) */
#define REAL64_2_HIGH 0x40000000   /* higher 32-bits of 2.0(REAL64) */
/*}}}*/

/*{{{  forward definitions*/
PRIVATE int fpregsfor PARMS((treenode *tptr));
/*}}}*/
/*{{{  support routines*/
/*{{{  PRIVATE int isfpconst2_0 (treenode *tptr)*/
/*****************************************************************************
 *
 *  isfpconst2_0 returns TRUE if 'tptr' is a real (REAL32 or REAL64)
 *               constant of value 2.0
 *
 *****************************************************************************/
PRIVATE int isfpconst2_0 ( treenode *tptr )
{
  return (TagOf(tptr) == S_CONSTEXP) &&
       (((typeof(tptr) == S_REAL32) && (LoValOf(tptr) == REAL32_2)) ||
       ((LoValOf(tptr) == REAL64_2_LOW) && (HiValOf(tptr) == REAL64_2_HIGH)));
}
/*}}}*/
/*{{{  PRIVATE int fpregsfor_fpoperand (treenode *tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  fpregsfor_fpoperand returns the minimum number of floating point registers
 *                      required to load the expression 'tptr' onto the
 *                      fp stack.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int fpregsfor_fpoperand ( treenode *tptr )
{
  if (!isaddressable(tptr))
    return fpregsfor(tptr);
  else
    switch (TagOf(tptr))
    {
      /*{{{  literals names  constant expression*/
      case N_VALABBR:
      case N_ABBR:
      case N_VALRETYPE:
      case N_RETYPE:
      case N_DECL:
      case N_VALPARAM:
      case N_PARAM:
      case N_REPL:
      case T_PREEVALTEMP: /* Preevaluated temporary */
      case S_CONSTEXP:
        return 1;
      /*}}}*/
      /*{{{  subscript*/
      case S_ARRAYITEM:
        return (ASExpOf(tptr) == NULL) ? 1 : max(1, fpregsfor(ASExpOf(tptr)));
      /*}}}*/
      /*{{{  temporary*/
      case T_TEMP:
        return fpregsfor(NDeclOf(tptr));
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "fpregsfor");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE int fpregsfordop (treenode *tptr)*/
/*****************************************************************************
 *
 *  fpregsfordop returns the number of floating point registers needed to
 *               evaluate floating dyadic operator 'tptr'.
 *
 *****************************************************************************/
PRIVATE int fpregsfordop ( treenode *tptr )
{
  int fpregsforleft = fpregsfor_fpoperand(LeftOpOf(tptr)),
      fpregsforright = fpregsfor_fpoperand(RightOpOf(tptr));
  return (fpregsforleft >  fpregsforright) ?  fpregsforleft :
         (fpregsforleft == fpregsforright) ?  fpregsforleft + 1 :
                                              fpregsforright;
}
/*}}}*/
/*{{{  PRIVATE int fpregsfor (treenode *tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  fpregsfor returns the minimum number of floating point registers
 *            required to evaluate the expression 'tptr'.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int fpregsfor ( treenode *tptr )
{
  switch (TagOf(tptr))
    {
      /*{{{  monadic operators*/
      /* None of these monadic operators can have REAL operands
         (okay, so NEG can theoretically, but we transform the tree
          to a subtract from zero for a real operand)  */
      case S_NEG:
      case S_NOT:
      case S_UMINUS:
      case S_BITNOT:
        return fpregsfor(OpOf(tptr));
      case S_SIZE:
      case S_ELSIZE:
        return fpregsfor(dimexpof(OpOf(tptr), 0));
      case S_SEGSTART:
        return fpregsfor(SStartExpOf(OpOf(tptr)));
      /*}}}*/
      /*{{{  dyadic operators*/
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
        if (!isreal(DOpTypeOf(tptr)))
          return max(fpregsfor(LeftOpOf(tptr)), fpregsfor(RightOpOf(tptr)));
        else
          switch(TagOf(tptr))
            {
              /*{{{  ADD SUBTRACT EQ NE LS LE GR GE*/
              case S_ADD: case S_SUBTRACT:
              case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
                return fpregsfordop(tptr);
              /*}}}*/
              /*{{{  MULT*/
              case S_MULT:
                if (isfpconst2_0(LeftOpOf(tptr)))
                  return fpregsfor_fpoperand(RightOpOf(tptr));
                else if (isfpconst2_0(RightOpOf(tptr)))
                  return fpregsfor_fpoperand(LeftOpOf(tptr));
                else
                  return fpregsfordop(tptr);
              /*}}}*/
              /*{{{  DIV*/
              case S_DIV:
                if (isfpconst2_0(RightOpOf(tptr)))
                  return fpregsfor_fpoperand(LeftOpOf(tptr));
                else
                  return fpregsfordop(tptr);
              /*}}}*/
              /*{{{  REM*/
              case S_REM:
                if (H1_instr)
                  return fpregsfordop(tptr);
                return MAXFPUREGS;
              /*}}}*/
            }
      case S_AFTER: case S_AND: case S_OR:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
      case S_LSHIFT: case S_RSHIFT:
      case S_CSUB0: case S_CCNT1:
        /* None of these dyadic operators can have REAL operands */
        return max(fpregsfor(LeftOpOf(tptr)), fpregsfor(RightOpOf(tptr)));
      case S_EVAL:
        return fpregsfor(RightOpOf(tptr));
      /*}}}*/
      /*{{{  conversion*/
      case S_EXACT: case S_ROUND: case S_TRUNC:
        {
          treenode *source = OpOf(tptr);
          int sourcetype = typeof(source),
              desttype = MOpTypeOf(tptr);
          if (isreal(desttype) || isreal(sourcetype))
            /*{{{  we need fp registers to do the conversion*/
            switch (desttype)
              {
                case S_REAL32:
                case S_REAL64:
                  /*{{{  something to real conversion*/
                  if (sourcetype == S_INT64)
                    return max(2, fpregsfor(source));
                  else
                    return max(1, fpregsfor(source));
                  /*}}}*/
                case S_INT64: /* Must be converting from a real */
                  return max(2, fpregsfor(source));
                case S_INT:
                case S_INT32:
                  return max (1, fpregsfor(source));
              }
            /*}}}*/
          else /* no fp registers required */
            return fpregsfor(source);
        }
      /*}}}*/
      /*{{{  literals names  constant expression*/
      case N_VALABBR:
      case N_ABBR:
      case N_VALRETYPE:
      case N_RETYPE:
      case N_DECL:
      case N_VALPARAM:
      case N_PARAM:
      case N_REPL:
      case T_PREEVALTEMP: /* Preevaluated temporary */
      case S_CONSTEXP:
      case S_PARAM_STATICLINK:
      case S_PARAM_VSP:
      case S_FNFORMALRESULT:
      case S_DUMMYEXP:
        return 0;
      /*}}}*/
      /*{{{  function instance, specification ... valof*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
      case S_FINSTANCE:
        return MAXFPUREGS;
      /*}}}*/
      /*{{{  subscript*/
      case S_ARRAYITEM:
      case S_SEGMENTITEM:
        {
          treenode *subscriptexp =
            (TagOf(tptr) == S_ARRAYITEM) ? ASExpOf(tptr) : SSubscriptExpOf(tptr);
          return (subscriptexp != NULL) ? fpregsfor(subscriptexp) : 0;
        }
      /*}}}*/
      /*{{{  constructor*/
      case S_CONSTRUCTOR:
        {
          int maxfpr = 0;
          tptr = OpOf(tptr);
          while (!EndOfList(tptr))
            {
              maxfpr = max(maxfpr, fpregsfor(ThisItem(tptr)));
              tptr = NextItem(tptr); /* added for bug 526, 11/7/90 */
            }
          return(maxfpr);
        }
      /*}}}*/
      /*{{{  special parameter types*/
      case S_HIDDEN_PARAM:
      case S_FNACTUALRESULT:
        return fpregsfor(HExpOf(tptr));
      /*}}}*/
      /*{{{  temporary*/
      case T_TEMP:
        return fpregsfor(NDeclOf(tptr));
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "fpregsfor");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE int fprevsfor (treenode *tptr, int fpregs)*/
/*****************************************************************************
 *
 *  fprevsfor returns the minimum number of 'fprev' instructions necessary
 *            when evaluating expression 'tptr' in at most 'fpregs' floating
 *            registers.
 *
 *****************************************************************************/
PRIVATE int fprevsfor ( treenode *tptr , int fpregs )
{
  switch(TagOf(tptr))
    {
      /*{{{  monadic operators*/
      /* None of these monadic operators can have REAL operands
         (okay, so NEG can theoretically, but we transform the tree
          to a subtract from zero for a real operand)  */
      case S_NEG:
      case S_NOT:
      case S_UMINUS:
      case S_BITNOT:
        return fprevsfor(OpOf(tptr), fpregs);
      case S_SIZE:
      case S_ELSIZE:
        return fprevsfor(dimexpof(OpOf(tptr), 0), fpregs);
      case S_SEGSTART:
        return fprevsfor(SStartExpOf(OpOf(tptr)), fpregs);
      case S_HIDDEN_PARAM:
      case S_FNACTUALRESULT:
        return fprevsfor(HExpOf(tptr), fpregs);
      /*}}}*/
      /*{{{  dyadic operator which may have real operands*/
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
        {
          treenode *left = LeftOpOf(tptr), *right = RightOpOf(tptr);
          if (!isreal(DOpTypeOf(tptr)))
            return max(fprevsfor(left, fpregs), fprevsfor(right, fpregs));
          else
            {
              int revbase = commutes(tptr) ? 0 : 1;
              if (fpregsfor_fpoperand(left) == fpregs)
                /*{{{  left; right; op*/
                return fprevsfor(left, fpregs) + fprevsfor(right, fpregs - 1);
                /*}}}*/
              else if (fpregsfor_fpoperand(right) == fpregs)
                /*{{{  right; left; (rev; ) op*/
                return fprevsfor(right, fpregs) + fprevsfor(left, fpregs - 1) +
                       revbase;
                /*}}}*/
              else
                /*{{{  return minimum number of revs for either left or right first*/
                return min(fprevsfor(left, fpregs) + fprevsfor(right, fpregs - 1),
                           fprevsfor(right, fpregs) + fprevsfor(left, fpregs - 1) + revbase);
                /*}}}*/
            }
        }
      case S_EVAL:
        return fprevsfor(RightOpOf(tptr), fpregs);
      /*}}}*/
      /*{{{  dyadic operator which cannot have real operands*/
      case S_AFTER: case S_AND: case S_OR:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
      case S_LSHIFT: case S_RSHIFT:
      case S_CSUB0: case S_CCNT1:
        /* None of these dyadic operators can have REAL operands */
        return max(fprevsfor(LeftOpOf(tptr), fpregs),
                   fprevsfor(RightOpOf(tptr), fpregs));
      /*}}}*/
      /*{{{  name temp constant finstance specification ... valof ...*/
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM:
      case N_DECL: case N_REPL:
      case T_TEMP: case T_PREEVALTEMP:
      case S_CONSTEXP:
      case S_PARAM_STATICLINK:
      case S_PARAM_VSP:
      case S_FNFORMALRESULT:
      case S_DUMMYEXP:
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
      case S_FINSTANCE:
        return 0;
      /*}}}*/
      /*{{{  conversion*/
      case S_EXACT: case S_ROUND: case S_TRUNC:
        return fprevsfor(OpOf(tptr), fpregs);
      /*}}}*/
      /*{{{  subscript*/
      case S_ARRAYITEM:
      case S_SEGMENTITEM:
        {
          treenode *subscriptexp =
            (TagOf(tptr) == S_ARRAYITEM) ? ASExpOf(tptr) : SSubscriptExpOf(tptr);
          return (subscriptexp != NULL) ? fprevsfor(subscriptexp, fpregs) : 0;
        }
      /*}}}*/
      /*{{{  constructor*/
      case S_CONSTRUCTOR:
        {
          int maxfpr = 0;
          tptr = OpOf(tptr);
          while (!EndOfList(tptr))
            maxfpr = max(maxfpr, fprevsfor(ThisItem(tptr), fpregs));
          return maxfpr;
        }
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "fprevsfor");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE void compfpdop (int op)*/
/*****************************************************************************
 *
 *  compfpdop generates code for floating point operation, op.
 *
 *****************************************************************************/
PRIVATE void compfpdop ( int op )
{
  switch (op)
    {
      case S_ADD:      gensecondary(I_FPADD); break;
      case S_SUBTRACT: gensecondary(I_FPSUB); break;
      case S_MULT:     gensecondary(I_FPMUL); break;
      case S_DIV:      gensecondary(I_FPDIV); break;
      /*{{{  S_REM*/
      case S_REM:
        if (H1_instr)
          gensecondary(I_FPREM);
        else
        {
          int loop = newlab(), next = newlab();
          gensecondary(I_FPREMFIRST);           /*       fpremfirst       */
          genprimary(I_EQC, ZERO32);            /*       eqc         0    */
          genbranch(I_CJ, next);                /*       cj          next */
          setlab(loop);                         /* loop:                  */
          gensecondary(I_FPREMSTEP);            /*       fpremstep        */
          genbranch(I_CJ, loop);                /*       cj          loop */
          setlab(next);                         /* next:                  */
        }
        break;
      /*}}}*/
      case S_GR:       gensecondary(I_FPGT);  break;
      case S_EQ:       gensecondary(I_FPEQ);  break;
      default:
        badtag(genlocn, op, "compfpdop");
    }
}
/*}}}*/
/*}}}*/
/*{{{  expression mapping*/
/*{{{  PRIVATEPARAM void mapfpvalof (treenode *tptr)*/
PRIVATEPARAM void mapfpvalof ( treenode *tptr )
{
  treenode **resultexpaddr = ThisItemAddr(VLResultListOf(tptr));
  treenode *savedtemplist = templist;
  templist = NULL;
  mapprocess(VLBodyOf(tptr));
  mappreprocess(*resultexpaddr);
  mapfpexp(resultexpaddr);
  freetemplist(templist);
  templist = savedtemplist;
}
/*}}}*/
/*{{{  PUBLIC void mapfpload2regs (treenode **left, treenode **right)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapfpload2regs maps loading two operands onto the floating stack
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapfpload2regs ( treenode **left , treenode **right )
{
  if (issame(*left, *right))  /* use fpdup */
    mapfpexp(left);
  else
    {
      int fpregsforleft = fpregsfor_fpoperand(*left),
          fpregsforright = fpregsfor_fpoperand(*right);
      if (max(fpregsforleft, fpregsforright) > MAXFPUREGS)
        /*{{{  need a temporary somewhere*/
        {
          if (fpregsforright >= fpregsforleft)
            /*{{{  evaluate right first*/
            {
              if (fpregsforleft >= MAXFPUREGS) /* right must be stored in a temporary */
                /*{{{  right; stl temp; left*/
                {
                  mapfpexp(right);
                  *right = gettemp(*right, NM_WORKSPACE);
                  upusecount(*right, 2);
                  mapfpexp(left);
                  freetemp(*right);
                }
                /*}}}*/
              else
                /*{{{  right; left*/
                { mapfpexp(right); mapfpexp(left); }
                /*}}}*/
            }
            /*}}}*/
          else
            /*{{{  evaluate left first*/
            {
              if (fpregsforright >= MAXFPUREGS) /* left must be  stored in a temporary */
                /*{{{  left; stl temp; right*/
                {
                  mapfpexp(left);
                  *left = gettemp(*left, NM_WORKSPACE);
                  upusecount(*left, 2);
                  mapfpexp(right);
                  freetemp(*left);
                }
                /*}}}*/
              else
                /*{{{  left; right*/
                { mapfpexp(left); mapfpexp(right); }
                /*}}}*/
            }
            /*}}}*/
        }
        /*}}}*/
      else if (fpregsforleft == MAXFPUREGS && fpregsforright == MAXFPUREGS)
        /*{{{  right; stl temp; left*/
        {
          mapfpexp(right);
          *right = gettemp(*right, NM_WORKSPACE);
          upusecount(*right, 2);
          mapfpexp(left);
          freetemp(*right);
        }
        /*}}}*/
      else /* no temporaries needed */
        { mapfpexp(left); mapfpexp(right); }
    }
}
/*}}}*/
/*{{{  PUBLIC void mapfpexp (treenode **tptr)*/
/*****************************************************************************
 *
 *  mapfpexp maps a floating point expression which is to be loaded into
 *           the fpu.
 *
 *****************************************************************************/
PUBLIC void mapfpexp ( treenode **tptr )
{
  switch(TagOf(*tptr))
    {
      /*{{{  monadic ops*/
      case S_NEG:
        {
          int type = MOpTypeOf(*tptr);
          *tptr = newdopnode(S_SUBTRACT, LocnOf(*tptr),
                    newconstexpnode(S_CONSTEXP, LocnOf(*tptr),
                      newlitnode(littag(MOpTypeOf(*tptr)), LocnOf(*tptr), NULL),
                      ZERO32, ZERO32),
                    OpOf(*tptr), type);
          mapfpexp(tptr);
        }
        break;
      /*}}}*/
      /*{{{  dyadic ops*/
      case S_MULT:
        if (isfpconst2_0(LeftOpOf(*tptr)))
          /*{{{  swap left and right, to get the 2.0 on the right*/
          {
            treenode *temp = LeftOpOf(*tptr);
            SetLeftOp(*tptr, RightOpOf(*tptr));
            SetRightOp(*tptr, temp);
          }
          /*}}}*/
        /* !!! Fall through */
      case S_DIV:
        if (isfpconst2_0(RightOpOf(*tptr)))
          /*{{{  we will use a mulby2 / divby2 instruction*/
          {
            mapfpexp(LeftOpAddr(*tptr));
            return;
          }
          /*}}}*/
        /* !!! Fall through */
      case S_ADD: case S_SUBTRACT: case S_REM:
      case S_EQ: case S_NE: case S_GR: case S_GE: case S_LE: case S_LS:
        mapfpload2regs(LeftOpAddr(*tptr), RightOpAddr(*tptr));
        break;
      /*}}}*/
      /*{{{  name temp*/
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM:
      case N_DECL:
      case T_TEMP: case T_PREEVALTEMP:
      case S_ARRAYITEM:
      case S_FNFORMALRESULT:  /*CON - Bug 135*/
        mapaddr(tptr);
        break;
      /*}}}*/
      /*{{{  constant*/
      case S_CONSTEXP:
        {
          int type = typeof(*tptr);
          if ((LoValOf(*tptr) == ZERO32) &&
              (type == S_REAL32 || HiValOf(*tptr) == ZERO32))
            ; /* we can use FPLDZEROxx */
          else
            mapaddr(tptr);
        }
        break;
      /*}}}*/
      /*{{{  conversions*/
      case S_EXACT: case S_ROUND: case S_TRUNC:
        {
          treenode **sourceptr = OpAddr(*tptr);
          int sourcetype = typeof(*sourceptr);
          /*int desttype = MOpTypeOf(*tptr);*/
          #if 0 /* now done in trans */
          /*{{{  remove a null conversion*/
          if (desttype == sourcetype)
            {
              *tptr = *sourceptr;
              mapfpexp(tptr);
              return;
            }
          /*}}}*/
          #endif
          if (sourcetype == S_INT16)
            /*{{{  convert an INT16 source to an INT32 source*/
            {
              *sourceptr = newmopnode(S_EXACT, LocnOf(*sourceptr), *sourceptr, S_INT32);
              sourcetype = S_INT32;
            }
            /*}}}*/
          switch(sourcetype)
            {
              /*{{{  REAL32 REAL64*/
              case S_REAL32:
              case S_REAL64:
                mapfpexp(sourceptr);
                break;
              /*}}}*/
              /*{{{  INT64*/
              case S_INT64:
                {
                  int sourcemode = P_PTR;
                  int freeopdtemp = FALSE;
                  sourcemode = mapaddresslopd(sourcemode, sourceptr, &freeopdtemp);
                  if (freeopdtemp)
                    freetemp(*sourceptr);
                }
                break;
              /*}}}*/
              /*{{{  INT32 INT*/
              case S_INT32: case S_INT:
                /* ldptr source; fpi32torxx */
                if (isaddressable(*sourceptr))
                  mapaddr(sourceptr);
                else
                  {
                    mapexp(sourceptr);
                    *sourceptr = gettemp(*sourceptr, NM_WORKSPACE);
                    upusecount(*sourceptr, 2);
                    freetemp(*sourceptr);
                  }
                break;
              /*}}}*/
              default:
                geninternal_is(GEN_ERROR_IN_ROUTINE, 1, "mapfpexp");
                break;
            }
        }
        break;
      /*}}}*/
      /*{{{  function call*/
      case S_FINSTANCE:
        /* It must be a single-valued real function, so the result will
           come back in the fp Areg */
        if (TagOf(INameOf(*tptr)) == N_PREDEFFUNCTION)
          if (mappredef(*tptr, NULL))
            return; /* Exit cos it was an inline function */
            SetIParamList(*tptr, augmentparams(IParamListOf(*tptr),
                                   FnParamsOf(NTypeOf(INameOf(*tptr))),
                                           NULL));
            mapinstance(*tptr);
        return;
      /*}}}*/
      /*{{{  specification .. valof*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
        mapdeclandbody(*tptr, mapfpvalof, FALSE, FALSE);
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(*tptr), "mapfpexp");
    }
}
/*}}}*/
/*{{{  PUBLIC void mapfpassign(destmode, dest, sourcemode, source)*/
/*****************************************************************************
 *
 *  mapfpassign maps the assignment of a floating point expression into
 *              (destmode, dest).
 *
 *****************************************************************************/
PUBLIC void mapfpassign ( int destmode , treenode **dest , int sourcemode , treenode **source )
{
  int dummy; dummy = sourcemode; /* stop unused variable warning */
  DEBUG_MSG(("mapfpassign: destmode: %d\n", destmode));
  destmode = ptrmodeof(destmode);
  if (fpregsfor(*dest) < MAXFPUREGS)
    /*{{{  load source into fpu; load destptr into cpu; store*/
    {
      mapfpexp(source);
      mapexpopd(destmode, dest);
    }
    /*}}}*/
  else if (regsfor(*source) < MAXREGS)
    /*{{{  destaddr; source; stind*/
    {
      mapexpopd(destmode, dest);
      mapfpexp(source);
    }
    /*}}}*/
   else
    /*{{{  source; st temp; destaddr; ld temp; stind*/
    {
      mapfpexp(source);
      *source = gettemp(*source, NM_WORKSPACE);
      mapexpopd(destmode, dest);
      freetemp(*source);
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
/*{{{  expression generation*/
/*{{{  PRIVATE void tfpexpandop (treenode *tptr, int regs, int fpregs, int op)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tfpexp generates code to load floating point expression 'tptr', and
 *         perform floating point dyadic operation 'op'.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tfpexpandop ( treenode *tptr , int regs , int fpregs , int op )
{
  if ((op == S_ADD || op == S_MULT) && isaddressable(tptr))
    {
      int type = typeof(tptr);
      int inst =
        (op == S_ADD) ? ((type == S_REAL32) ? I_FPLDNLADDSN : I_FPLDNLADDDB)
                      : ((type == S_REAL32) ? I_FPLDNLMULSN : I_FPLDNLMULDB);
      loadelementpointer(tptr, 0, regs);
      gensecondary(inst);
    }
  else
    {
      tfpexp(tptr, regs, fpregs);
      compfpdop(op);
    }
}
/*}}}*/
/*{{{  PUBLIC void tfpload2regs (exp1, exp2, regs, fpregs, commutes)*/
/*****************************************************************************
 *
 *  tfpload2regs loads exp1 and exp2 into fpbreg and fpareg, using at most
 *               'regs' integer registers and 'fpregs' floating point
 *               registers.
 *               If 'commutes' is TRUE the expressions may be loaded in
 *               reverse order.
 *
 *****************************************************************************/
PUBLIC void tfpload2regs ( treenode *exp1 , treenode *exp2 , int regs , int fpregs , int commutes )
{
  int fpr = (fpregs == MANY_REGS) ? MAXFPUREGS : fpregs;
  if (TagOf(exp2) == T_TEMP)
    /*{{{  exp2; ldlp temp; fpstnl; exp1; ldlp temp; fpldnl*/
    {
      simplify(P_EXP, exp2);
      tfpexp(exp1, regs, fpregs);
      tfpexp(exp2, regs, fpr - 1);
    }
    /*}}}*/
  else if (TagOf(exp1) == T_TEMP)
    /*{{{  exp1; ldlp temp; fpstnl; exp2; fpldnl; (fprev;)*/
    {
      simplify(P_EXP, exp1);
      tfpexp(exp2, regs, fpregs);
      tfpexp(exp1, regs, fpr - 1);
      if (!commutes)
        gensecondary(I_FPREV);
    }
    /*}}}*/
  else
    /*{{{  don't need to introduce temporaries here*/
    {
      if (issame(exp1, exp2))
        {
          /*if (warning_flags & WARNING_CSE) genwarning(GEN_CSE, 0, 0);*/
          tfpexp(exp1, regs, fpr);
          gensecondary(I_FPDUP);
        }
      else
        {
          int fpregsforexp1 = fpregsfor(exp1),
              fpregsforexp2 = fpregsfor(exp2);
    
          /*{{{  decide whether to do exp1 or exp2 first, then do it*/
          {
            int exp1first = TRUE;
            /*{{{  set exp1first TRUE if we do exp1 first, FALSE otherwise*/
            if (max(fpregsforexp1, fpregsforexp2) > MAXFPUREGS)
              exp1first = (fpregsforexp1 >= fpregsforexp2);
            else if (fpregsforexp1 == fpr)
              exp1first = TRUE;
            else if (fpregsforexp2 == fpr)
              exp1first = FALSE;
            else
              /*{{{  go into all the high-tech stuff of counting fprev instructions*/
              {
                int fprevs_for_exp1_first = fprevsfor(exp1, fpr) + fprevsfor(exp2, fpr - 1);
                int fprevs_for_exp2_first = fprevsfor(exp2, fpr) +
                                             fprevsfor(exp1, fpr -1) + (commutes ? 0 : 1);
                if (fprevs_for_exp1_first > fprevs_for_exp2_first)
                  exp1first = FALSE;
              }
              /*}}}*/
            /*}}}*/
            /*{{{  generate the expression*/
            if (exp1first)
              /*{{{  exp1; exp2;*/
              {
                tfpexp(exp1, regs, fpr);
                tfpexp(exp2, regs, fpr - 1);
              }
              /*}}}*/
            else
              /*{{{  exp2; exp1; (fprev);*/
              {
                tfpexp(exp2, regs, fpregs);
                tfpexp(exp1, regs, fpr - 1);
                if (!commutes)
                  gensecondary(I_FPREV);
              }
              /*}}}*/
            /*}}}*/
          }
          /*}}}*/
        }
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tfpexp (treenode *tptr, int regs, int fpregs)*/
/*****************************************************************************
 *
 *  tfpexp generates code for the floating point expression 'tptr', using
 *         at most 'regs' integer registers and 'fpregs' floating point
 *         registers.
 *
 *****************************************************************************/
PUBLIC void tfpexp ( treenode *tptr , int regs , int fpregs )
{
  switch(TagOf(tptr))
    {
      /*{{{  dyadic ops*/
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
      case S_EQ: case S_GR:
        {
          int op = TagOf(tptr);
          treenode *left = LeftOpOf(tptr), *right = RightOpOf(tptr);
          int commutative = commutes(tptr);
          int fpr = (fpregs == MANY_REGS) ? MAXFPUREGS : fpregs;
          /*{{{  look for some optimisations*/
          if ((op == S_MULT || op == S_DIV) && isfpconst2_0(right))
            {
              tfpexp(left, regs, fpregs);
              if (H1_instr) gensecondary(op == S_MULT ? I_FPMULBY2 : I_FPDIVBY2);
              else          genfpuentry(op == S_MULT ? I_FPUMULBY2 : I_FPUDIVBY2);
              return;
            }
          /*}}}*/
          if (TagOf(right) == T_TEMP)
            /*{{{  right; ldlp temp; fpstnl; left; ldlp temp; fpldnlop*/
            {
              simplify(P_EXP, right);
              tfpexp(left, regs, fpregs);
              tfpexpandop(right, regs, fpr - 1, op);
            }
            /*}}}*/
          else if (TagOf(left) == T_TEMP)
            /*{{{  left; ldlp temp; fpstnl; right; fpldnl; (fprev;) op*/
            {
              simplify(P_EXP, left);
              tfpexp(right, regs, fpregs);
              if (commutative)
                tfpexpandop(left, regs, fpr - 1, op);
              else
                {
                  tfpexp(left, regs, fpregs);
                  gensecondary(I_FPREV);
                  compfpdop(op);
                }
            }
            /*}}}*/
          else
            /*{{{  don't need to introduce temporaries here*/
            {
              if (issame(left, right))
                {
                  /*if (warning_flags & WARNING_CSE) genwarning(GEN_CSE, 0, 0);*/
                  tfpexp(left, regs, fpr);
                  gensecondary(I_FPDUP);
                  compfpdop(op);
                }
              else
                {
                  int fpr = (fpregs == MANY_REGS) ? MAXFPUREGS : fpregs;
                  int fpregsforleft = fpregsfor(left),
                      fpregsforright = fpregsfor(right);
            
                  /*{{{  decide whether to do left or right first, then do it*/
                  {
                    int leftfirst = TRUE;
                    /*{{{  set leftfirst TRUE if we do left-hand-side first, FALSE otherwise*/
                    if (max(fpregsforleft, fpregsforright) > MAXFPUREGS)
                      leftfirst = (fpregsforleft >= fpregsforright);
                    else if (fpregsforleft == fpr)
                      leftfirst = TRUE;
                    else if (fpregsforright == fpr)
                      leftfirst = FALSE;
                    else
                      /*{{{  go into all the high-tech stuff of counting fprev instructions*/
                      {
                        int fprevs_for_left_first = fprevsfor(left, fpr) + fprevsfor(right, fpr - 1);
                        int fprevs_for_right_first = fprevsfor(right, fpr) +
                                                     fprevsfor(left, fpr -1) + (commutative ? 0 : 1);
                        if (fprevs_for_left_first > fprevs_for_right_first)
                          leftfirst = FALSE;
                      }
                      /*}}}*/
                    /* If we are doing add or mul, and we think we ought to load left first,
                       BUT left is addressable and right is not, and we have enough registers
                       around, load in the opposite order so we can do the load and op in one
                       instruction. */
                    if ((op == S_ADD || op == S_MULT) && leftfirst &&
                         isaddressable(left) && !isaddressable(right) && fpregsforright < fpr)
                      leftfirst = FALSE;
                    /*}}}*/
                    /*{{{  generate the expression*/
                    if (leftfirst)
                      /*{{{  left; right; op*/
                      {
                        tfpexp(left, regs, fpr);
                        tfpexpandop(right, regs, fpr - 1, op);
                      }
                      /*}}}*/
                    else
                      /*{{{  right; left; (fprev); op*/
                      {
                        tfpexp(right, regs, fpregs);
                        if (commutative)
                          tfpexpandop(left, regs, fpr - 1, op);
                        else
                          {
                            tfpexp(left, regs, fpr - 1);
                            gensecondary(I_FPREV);
                            compfpdop(op);
                          }
                      }
                      /*}}}*/
                    /*}}}*/
                  }
                  /*}}}*/
                }
            }
            /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  conversions*/
      case S_EXACT: case S_ROUND: case S_TRUNC:
        {
          treenode *source = OpOf(tptr);
          int sourcetype = typeof(source),
              desttype = MOpTypeOf(tptr);
          int roundmode = TagOf(tptr);
          switch(sourcetype)
            {
              /*{{{  REAL32 REAL64*/
              case S_REAL32:
                /* desttype MUST be REAL64 otherwise conversion would have been removed */
                /* EXACT conversion, no possibility of floating point error */
                tfpexp(source, regs, fpregs);
                if (H1_instr) gensecondary(I_FPR32TOR64);
                else          genfpuentry(I_FPUR32TOR64);
                break;
              case S_REAL64:
                /* desttype MUST be REAL32 otherwise conversion would have been removed */
                tfpexp(source, regs, fpregs);
                if (H1_instr)
                  {
                    if (roundmode == S_TRUNC) gensecondary(I_FPRZ);
                    gensecondary(I_FPR64TOR32);
                  }
                else
                  {
                    if (roundmode == S_TRUNC) genfpuentry(I_FPURZ);
                    genfpuentry(I_FPUR64TOR32);
                  }
                break;
              /*}}}*/
              /*{{{  INT64*/
              case S_INT64:
                /* ROUND / TRUNC  no possibility of setting error */
                {
                  int sourcemode;
                  int simple;
                  sourcemode = ptrmodeof(addresslopd(P_EXP, source));
                  simple = issimplelocal(source); /* bug 738 5/11/90 */
                  loadopd(sourcemode, source, 0);              /*  ldp source   */
                  if (!simple) gensecondary(I_DUP);            /*  dup          */
                  gensecondary(I_FPB32TOR64);                  /*  fpb32tor64   */
                  if (desttype == S_REAL32)
                    {
                      if (H1_instr) gensecondary(I_FPNOROUND); /*  fpnoround    */
                      else          genfpuentry(I_FPUNOROUND);
                    }
                  if (simple)
                    loadopd(sourcemode, source, 1);            /*  ldp source+1 */
                  else
                    genprimary(I_LDNLP, ONE32);                /*  ldnlp  1     */
                  gensecondary(I_FPI32TOR64);                  /*  fpi32or64    */
                  if (H1_instr)     gensecondary(I_FPEXPINC32);/*  fpexpinc32   */
                  else              genfpuentry(I_FPUEXPINC32);
                  if (desttype == S_REAL32)
                    {
                      if (H1_instr) gensecondary(I_FPNOROUND); /*  fpnoround    */
                      else          genfpuentry(I_FPUNOROUND);
                    }
                  if (roundmode == S_TRUNC)
                    {
                      if (H1_instr) gensecondary(I_FPRZ);      /*  fprz         */
                      else          genfpuentry(I_FPURZ);
                    }
                  gensecondary(I_FPADD);                       /*  fpadd        */
                }
                break;
              /*}}}*/
              /*{{{  INT32 INT*/
              case S_INT32: case S_INT:
                {
                  int sourcemode = P_EXP;
                  sourcemode = simplify(sourcemode, source);
                  loadopd(ptrmodeof(sourcemode), source, 0);
                  if (desttype == S_REAL32)
                    /* ROUND / TRUNC  no possibility of setting error */
                    {
                      if (roundmode == S_TRUNC)
                        {
                          if (H1_instr) gensecondary(I_FPRZ);
                          else          genfpuentry(I_FPURZ);
                        }
                      gensecondary(I_FPI32TOR32);
                    }
                  else
                    /* EXACT  no possibility of setting error */
                    gensecondary(I_FPI32TOR64);
                }
                break;
              /*}}}*/
              default:
                geninternal_is(GEN_ERROR_IN_ROUTINE, 1, "tfpexp");
                break;
            }
        }
        break;
      /*}}}*/
      /*{{{  name temp*/
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM:
      case N_DECL:
      case T_TEMP: case T_PREEVALTEMP:
        loadelementpointer(tptr, 0, regs);
        gensecondary((typeof(tptr) == S_REAL32) ? I_FPLDNLSN : I_FPLDNLDB);
        break;
      /*}}}*/
      /*{{{  constant*/
      case S_CONSTEXP:
        {
          int type = typeof(tptr);
          if ((LoValOf(tptr) == ZERO32) &&
              (type == S_REAL32 || HiValOf(tptr) == ZERO32))
            gensecondary(type == S_REAL32 ? I_FPLDZEROSN : I_FPLDZERODB);
          else
            {
              if (!isinconstanttable(tptr))
                geninternal_is(GEN_ERROR_IN_ROUTINE, 2, "tfpexp");
              loadelementpointer(tptr, 0, regs);
              gensecondary((type == S_REAL32) ? I_FPLDNLSN : I_FPLDNLDB);
            }
        }
        break;
      /*}}}*/
      /*{{{  array item*/
      case S_ARRAYITEM:
        /* We can improve the code by using the FPLDNLxxI instruction */
        {
          int type = typeof(tptr);
          if (ASExpOf(tptr) != NULL)
            {
              treenode *name = nameof(tptr);
              texp(ASExpOf(tptr), regs);
            #if 0
              loadnamepointer(name, 0);
            #else /* new version, fixing bug 570 CO'N 23/7/90 */
              if (ispointer(name))
                {
                  loadnamepointer(name, 0);
                  genprimary(I_LDNLP, ASOffsetOf(tptr));
                }
              else
                {
                  loadnamepointer(name, ASOffsetOf(tptr));
                }
            #endif
              gensecondary((type == S_REAL32) ? I_FPLDNLSNI : I_FPLDNLDBI);
            }
          else
            {
              /* Note that this adds in ASOffsetOf itself - CO'N 13/12/90 */
              loadelementpointer(tptr, 0, regs);
              gensecondary((type == S_REAL32) ? I_FPLDNLSN : I_FPLDNLDB);
            }
        }
        break;
      /*}}}*/
      /*{{{  function instance*/
      case S_FINSTANCE:
        /* It must be a single-valued real function, so the result will
           come back in the fp Areg */
        if (TagOf(INameOf(tptr)) == N_PREDEFFUNCTION)
          tpredef(tptr, NULL);
        else
          tinstance(tptr);
        break;
      /*}}}*/
      /*{{{  specification .. valof*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
        {
          treenode *resultexp;
          tptr = tspecs(tptr);
          resultexp = ThisItem(VLResultListOf(tptr));
          tprocess(VLBodyOf(tptr));
          tpreexp(resultexp);
          tfpexp(resultexp, regs, fpregs);
        }
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "tfpexp");
    }
}
/*}}}*/
/*{{{  PUBLIC void tfpassign (destmode, dest, sourcemode, source, regs)*/
/*{{{  COMMENT */
/**********************  Start comment out ****************************
@*{{{  *@
@*****************************************************************************
 *
 *  tfpassign generates code to assign floating point expression
 *            (sourcemode, source) to (destmode, dest)
 *
 *****************************************************************************@
@*}}}*@
 **********************   End comment out  ****************************/
/*}}}*/
PUBLIC void tfpassign ( int type , int destmode , treenode *dest , int sourcemode , treenode *source , int regs )
{
  /* int r = (regs == MANY_REGS) ? MAXREGS : regs; */
  destmode = ptrmodeof(destmode);

  if (preeval(sourcemode, source))
    /*{{{  generate source to temp; assign temp to dest*/
    {
      sourcemode = simplify(sourcemode, source);
      tsimpleassign(typeof(dest), destmode, dest, sourcemode, source, regs);
    }
    /*}}}*/
  else if (fpregsfor(dest) < MAXFPUREGS)
    /*{{{  load source into fpu; load destptr into cpu; store*/
    {
      tfpexp(source, regs, MANY_REGS);
      loadopd(destmode, dest, 0);
      checkerror ();
      gensecondary((type == S_REAL32) ? I_FPSTNLSN : I_FPSTNLDB);
    }
    /*}}}*/
  else /*  (regsfor(source) < r) */
    /*{{{  destaddr; source; stind*/
    {
      loadopd(destmode, dest, 0);
      tfpexp(source, regs, MANY_REGS);
      checkerror ();
      gensecondary((type == S_REAL32) ? I_FPSTNLSN : I_FPSTNLDB);
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
