/*#define DEBUG*/
/******************************************************************************
*
*  Code generator gen11 - operand loading and storing
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include "includes.h"
# include "generror.h"
# include "instruct.h"
# include "genhdr.h"
# include "syndef.h"
# include "lexdef.h"
# include "chkdef.h"
# include "usedef.h"
# include "trandef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen5def.h"
# include "gen8def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
/*}}}*/

/*{{{  constants*/
#define LOAD    1
#define STORE   2
#define LOADPTR 3
/*}}}*/

/*{{{  local variables*/
PRIVATE int wspadjusts[MAX_LEX_LEVELS];
PRIVATE BIT32 staticlinkoffsets[MAX_LEX_LEVELS];
/*}}}*/

/*{{{  forward declarations*/
PRIVATE void tconstructorassign PARMS((treenode *dest, treenode *source));
/*}}}*/

/*{{{  loading/storing operands*/
/*{{{  scope adjustment handling*/
/*{{{  PUBLIC void adjustworkspace (adjustment)*/
/*****************************************************************************
 *
 *  adjustworkspace updates the code generator's view of where the workspace
 *                  pointer is.  All workspace accesses will be 'adjustment'
 *                  slots higher than they were.
 *
 *****************************************************************************/
PUBLIC void adjustworkspace ( INT32 adjustment )
{
  wspadjusts[lexlevel] += adjustment;
#ifdef DEBUG
  if (adjustment != 0)
    DEBUG_MSG(("adjustworkspace: adjusting lexlevel %d by %ld to %ld\n",
               lexlevel, adjustment, wspadjusts[lexlevel]));
#endif
  asmvalues[ASMNAME_WSSIZE] += adjustment;
  asmvalues[ASMNAME_STATIC] += adjustment;
  asmvalues[ASMNAME_VSPTR ] += adjustment;
}
/*}}}*/
/*{{{  PUBLIC void setadjust (lexlevel, v)*/
/*****************************************************************************
 *
 *  setadjust  initialises the code generator's view of where the workspace
 *             pointer is for lexical level 'lexlevel'.
 *
 *****************************************************************************/
PUBLIC void setadjust ( int lexlevel , INT32 v )
{
  DEBUG_MSG(("setadjust: setting adjust for lexlevel %d to %ld\n", lexlevel, v));
  wspadjusts[lexlevel] = v;
}
/*}}}*/
/*}}}*/
/*{{{  static link and vector space pointer routines*/
/*{{{  PUBLIC void setsloffset(lexlevel, v)*/
/*****************************************************************************
 *
 *  setsloffset sets the static link offset for 'lexlevel' to v
 *
 *****************************************************************************/
PUBLIC void setsloffset ( int lexlevel , INT32 v )
{
  DEBUG_MSG(("setsloffset: setting sloffset for lexlevel %d to %ld\n", lexlevel, v));
  staticlinkoffsets[lexlevel] = v;
}
/*}}}*/
/*{{{  PRIVATE INT32 sloffsetof(level)*/
/*****************************************************************************
 *
 *  sloffsetof returns the workspace offset of the static link at lex level
 *             'level' relative to the static link pointer of lex level
 *             'level - 1' (or if level is the current lexical level, relative
 *             to the current value of wptr).
 *
 *****************************************************************************/
PRIVATE INT32 sloffsetof ( int level )
{
  if (level == lexlevel)
    return((staticlinkoffsets[level] & OFFSET_BITS) + wspadjusts[level]);
  else
    {
      INT32 sloffset = staticlinkoffsets[level] & OFFSET_BITS;
      if (staticlinkoffsets[level + 1] & REPL_FLAG)
        sloffset += wspadjusts[level];
      return(sloffset);
    }
}
/*}}}*/
/*{{{  PUBLIC INT32 nameoffsetof(level)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  nameoffsetof returns the adjustment to the workspace offset of a
 *               variable at lexical level 'level'.  If 'level' is the current
 *               lexical level, this is relative to the current wptr,
 *               otherwise it is relative to the static link at offset
 *               'level - 1'.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC INT32 nameoffsetof ( int level )
{
  if (level == lexlevel)
    return(wspadjusts[level]);
  else if (staticlinkoffsets[level + 1] & REPL_FLAG)
    return(wspadjusts[level]);
  else
    return(ZERO32);
}
/*}}}*/
/*{{{  PRIVATE int loadlex (l)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  loadlex takes a lexical level, l, and returns FALSE if it is the current
 *          level, otherwise it loads a pointer to the workspace at level l
 *          and returns TRUE.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int loadlex ( int l )
{
  /* Generate static link code to fetch workspace at level l */
  if (l != lexlevel)
    {
      int level = lexlevel - 1;
      INT32 sloffset = sloffsetof(lexlevel);
      genprimary(I_LDL, sloffset);
      gencomment0("staticlink");
      while (level > l)
        /*{{{  load static link for level*/
        {
          /* If it is a repl PAR static link the static link contains the
             workspace pointer of the routine setting up the repl
             AT THE TIME OF SETTING UP THE REPL */
          genprimary (I_LDNL, sloffsetof(level));
          level--;
        }
        /*}}}*/
      return(TRUE);
    }
  else
    return(FALSE);
}
/*}}}*/
/*{{{  PUBLIC void loadstaticlink (newlevel)*/
PUBLIC void loadstaticlink ( int newlevel )
{
  if (newlevel == (lexlevel + 1))
    genprimary(I_LDLP, wspadjusts[lexlevel]);
    /* This should be the current workspace offset */
  else
    {
      int nonlocal = loadlex(newlevel);
      genprimary(nonlocal ? I_LDNL : I_LDL, sloffsetof(newlevel));
      /* if required static link isn't normalised, normalise it */
      if (staticlinkoffsets[newlevel] & REPL_FLAG)
        genprimary(I_LDNLP, wspadjusts[newlevel - 1]);
    }
  gencomment0("staticlink");
}
/*}}}*/
/*{{{  PUBLIC void loadreplreturnlink ()*/
/*****************************************************************************
 *
 *  loadreplreturnlink loads the static link required when ending a replicated
 *                     parallel process
 *
 *****************************************************************************/
PUBLIC void loadreplreturnlink ( void )
{
  genprimary(I_LDL, sloffsetof(lexlevel));
  gencomment0("repljoin");
}
/*}}}*/
/*{{{  PUBLIC void loadnewvsp(offset)*/
PUBLIC void loadnewvsp ( BIT32 offset )
{
  genprimary(I_LDL, vspoffset + wspadjusts[lexlevel]);
  gencomment0("vsp");
  genprimary(I_LDNLP, offset);
}
/*}}}*/
/*}}}*/
/*{{{  PUBLIC int simplify (opdmode, opd)*/
/*****************************************************************************
 *
 *  simplify evaluates an expression into a temporary, if required
 *
 *****************************************************************************/
PUBLIC int simplify ( int opdmode , treenode *opd )
{
  if (preeval(opdmode, opd))
    {
      int newmode = tempmodeof(opdmode);
      /* Mark opd as initialised so that in the course of initialising it
         we don't start to recursively initialise it. */
      SetTag(opd, T_PREEVALTEMP);
      if (NModeOf(opd) == NM_POINTER)
        /*{{{  treat temporary as an abbreviation*/
        {
          if (opdmode != P_PTR)
            geninternal_is(GEN_BAD_OPD, opdmode, "simplify");
          loadopd(opdmode, NDeclOf(opd), 0);
          storeinname(opd, 0);
        }
        /*}}}*/
      else
        /*{{{  treat temporary as a declaration*/
        tsimpleassign(typeof(opd), newmode, opd,
                            opdmode, NDeclOf(opd), MANY_REGS);
        /*}}}*/
      opdmode = newmode;
    }
  return opdmode;
}
/*}}}*/
/*{{{  load                     constants*/
/*{{{  PUBLIC void loadconstant (c)*/
/*****************************************************************************
 *
 *  loadconstant loads the value of the constant c onto the expression stack
 *
 *****************************************************************************/
PUBLIC void loadconstant ( INT32 c )
{
  if (targetintsize == S_INT32)
    /*{{{  load constant on 32 bit machine*/
    {
      if ((c <= LDNLPNEG_INT32) && ((c & 0x3) /*(c % bytesperword)*/ == 0))
        {
          gensecondary(I_MINT);
          genprimary(I_LDNLP, diff(c, MOSTNEG_INT32) / 4 /*bytesperword*/);
        }
      else if (c <= ADCNEG_INT32)
        {
          gensecondary(I_MINT);
          genprimary(I_ADC, diff(c, MOSTNEG_INT32));
        }
      else if (c == MOSTPOS_INT32)
        {
          gensecondary(I_MINT);
          gensecondary(I_NOT);
        }
      else if (fpsupport
               && ((c >= LDINF_NEG_WORD) && (c <= LDINF_POS_WORD) && ((c & 0x3) == 0)))
        {
          gensecondary(I_LDINF);
          genprimary(I_LDNLP, diff(c, INFINITY) / 4 /*bytesperword*/);
        }
      else if (fpsupport
               && ((c >= LDINF_NEG_BYTE) && (c <= LDINF_POS_BYTE) ))
        {
          gensecondary(I_LDINF);
          genprimary(I_ADC, diff(c, INFINITY));
        }
      else
        genprimary(I_LDC, c);
    }
    /*}}}*/
  else  /* targetintsize == S_INT16 */
    /*{{{  load constant on 16 bit machine*/
    {
      if ((c <= LDNLPNEG_INT16) && ((c & 0x1) /*(c % bytesperword)*/ == 0))
        {
          gensecondary(I_MINT);
          genprimary(I_LDNLP, (c - MOSTNEG_INT16) / 2 /*bytesperword*/);
        }
      else if (c <= ADCNEG_INT16)
        {
          gensecondary(I_MINT);
          genprimary(I_ADC, c - MOSTNEG_INT16);
        }
      else
        genprimary(I_LDC, c);
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
/*{{{  PRIVATE void tbyteoffset*/
PRIVATE void tbyteoffset(INT32 offset)
{
  if ((bytesperword == 2) && ((offset & 0x1) == 0))
    genprimary(I_LDNLP, offset / 2 /* bytesperword */);
  else if ((bytesperword == 4) && ((offset & 0x3) == 0))
    genprimary(I_LDNLP, offset / 4 /* bytesperword */);
  else
    genprimary(I_ADC, offset);
}
/*}}}*/
/*{{{  load/store/loadptr       names*/
/*{{{  PRIVATE void movename (nptr, w, ilocal, inonlocal)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  movename loads or stores a name or a pointer to a name.
 *           nptr represents the name.
 *           For a long type, w is the word which we wish to load/store.
 *           ilocal is the load/store instruction used for a local object,
 *           inonlocal is the load/store instruction used for a non-local
 *           object.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void movename ( treenode *nptr , INT32 w , int ilocal , int inonlocal )
{
  if (NVUseCountOf(nptr) == 0) /* This should never happen */
    geninternal_s(GEN_BAD_USECOUNT, WNameOf(NNameOf(nptr)));
  if (isplaced(nptr))
    /*{{{  move to/from a placed variable*/
    {
      loadconstant(NVOffsetOf(nptr));
      genprimary(inonlocal, w);
    }
    /*}}}*/
  else
    /*{{{  move to/from a normal variable*/
    {
      int level = NLexLevelOf(nptr);
      int nonlocal = loadlex(level);
      INT32 wsposn = NVOffsetOf(nptr) + w + nameoffsetof(level);
    
      genprimary((nonlocal ? inonlocal : ilocal), wsposn);
    }
    /*}}}*/
  /*{{{  debugging*/
  if (assembly_output)
  {
    if ((TagOf(nptr) == T_TEMP) || (TagOf(nptr) == T_PREEVALTEMP))
      gencomment1("$temp%d", NVVarNumOf(nptr));
    else
      gencomment0(WNameOf(NNameOf(nptr)));
    if (w != 0)
      fprintf(outfile, " + %ld", w);
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void loadname (nptr, w)*/
PUBLIC void loadname ( treenode *nptr , INT32 w )
{
  if (chanaspointer && issimplechan(nptr))
    /* Very special case */
    movename(nptr, w, I_LDLP, I_LDNLP);
  else
    {
      if (ispointer(nptr))
        {
          movename(nptr, 0, I_LDL, I_LDNL);
          genprimary(I_LDNL, w);
        }
      else
        movename(nptr, w, I_LDL, I_LDNL);
    }
}
/*}}}*/
/*{{{  PUBLIC void storeinname (nptr, w)*/
PUBLIC void storeinname ( treenode *nptr , INT32 w )
{
  checkerror ();
  movename(nptr, w, I_STL, I_STNL);
}
/*}}}*/
/*{{{  PUBLIC void zero_local_var*/
PUBLIC void zero_local_var(treenode *nptr)
{
  loadconstant(ZERO32);
  storeinname(nptr, 0);
}
/*}}}*/
/*{{{  PRIVATE int return_subscript*/
PRIVATE int return_subscript(treenode *tptr)
{
  const int b = bytesinscalar(basetype(gettype(tptr)));
  if      (haswsubdb && b > bytesperword) return I_WSUBDB;
  else if (b >= bytesperword)             return I_WSUB;
  else                                    return I_BSUB;
  
}
/*{{{*/
/*{{{  PRIVATE void add_scaled_offset*/
PRIVATE void add_scaled_offset(treenode *tptr, const INT32 offset)
{
  const int isubscript = return_subscript(tptr);
  if (isubscript == I_BSUB)
    tbyteoffset(offset);
  else
    genprimary (I_LDNLP, offset);
}
/*}}}*/
/*{{{  PUBLIC void loadnamepointer (nptr, w)*/
PUBLIC void loadnamepointer ( treenode *nptr , INT32 w )
{
  treenode *name = NULL;
  if (TagOf(nptr) == N_VALABBR || TagOf(nptr) == N_VALRETYPE)
    {
      treenode *constptr = DValOf(NDeclOf(nptr));
      name = nptr;
      if ((TagOf(constptr) == S_STRING) ||
          (TagOf(constptr) == S_CONSTCONSTRUCTOR))
        nptr = constptr;
    }

  if ((TagOf(nptr) == S_STRING) || (TagOf(nptr) == S_CONSTCONSTRUCTOR))
    /*{{{  load a pointer to a constant table*/
    {
      const int constlab = CTLabelOf(nptr);
      const int l = newlab();
      genlabeldiff(I_LDC, constlab, l);
      gensecondary(I_LDPI);
      if (name != NULL)
        gencomment0(WNameOf(NNameOf(name)));
      setlab(l);
      add_scaled_offset(nptr, w); /* Added for bug 1071 13/12/90 */
    }
    /*}}}*/
  else if (ispointer(nptr))
    movename(nptr, w, I_LDL, I_LDNL);
  else
    movename(nptr, w, I_LDLP, I_LDNLP);
}
/*}}}*/
/*}}}*/
/*{{{  load/store/loadptr       arrays*/
/*{{{  PRIVATE INT32 loadarraypointer (tptr, word, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  loadarraypointer loads a pointer to the array element 'tptr' into Areg,
 *                   using at most regs registers.
 *                   A (word) offset from the loaded pointer to the element
 *                   is returned.
 *
 *****************************************************************************/
/*}}}*/
/* A transformed subscript tree */
PRIVATE INT32 loadarraypointer ( treenode *tptr , INT32 word , int regs )
{
  const int segmentitem = (TagOf(tptr) == S_SEGMENTITEM);
  const int isubscript = return_subscript(tptr);
  treenode *nptr = nameof(tptr);
  treenode *subscriptexp = segmentitem ? SSubscriptExpOf(tptr) : ASExpOf(tptr);
  INT32 offset = segmentitem ? SOffsetOf(tptr) + word : ASOffsetOf(tptr) + word;
  
  if (directload(P_EXP, tptr))
    /*{{{  load local pointer*/
    {
      loadnamepointer (nptr, offset);
      offset = ZERO32;
    }
    /*}}}*/
  else
    /*{{{  load a pointer*/
    {
      if (subscriptexp != NULL)
        /*{{{  perform subscript calculation*/
        {
          texp(subscriptexp, regs);
          loadnamepointer (nptr, 0);
          gensecondary (isubscript);
        }
        /*}}}*/
      else
        loadnamepointer (nptr, 0);
    }
    /*}}}*/
  if (isubscript == I_BSUB)
    /*{{{  add in the offset now*/
    {
      tbyteoffset(offset);
      offset = ZERO32;
    }
    /*}}}*/
  return (offset);
}
/*}}}*/
/*{{{  PRIVATE void loadarrayitempointer (tptr, word, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  loadarrayitempointer loads a pointer to the array item or segment item
 *                       'tptr' into Areg,
 *                       using at most regs registers.
 *                       No offset is returned.
 *                       Local workspace arrays are optimised.
 *
 *****************************************************************************/
/*}}}*/
/* A transformed subscript tree */
PRIVATE void loadarrayitempointer ( treenode *tptr , INT32 word , int regs )
{
  INT32 offset = loadarraypointer(tptr, word, regs);
  add_scaled_offset(tptr, offset);
}
/*}}}*/
/*{{{  PRIVATE void loadarrayitem(tptr, word, regs)*/
/* A transformed subscript node */
PRIVATE void loadarrayitem ( treenode *tptr , INT32 word , int regs )
{
  treenode *nptr = nameof(tptr);
  const int type = basetype(gettype(nptr));

  if ((type == S_INT16) && (targetintsize != S_INT16))
    badtag(genlocn, type, "loadarrayitem");
  else
    {
      if (directload(P_EXP, tptr))
        loadname (nptr, ASOffsetOf(tptr) + word);
      else
        /*{{{  ldptr item; load*/
        {
          const int b = bytesinscalar(type);
          if (b >= bytesperword)
            {
              BIT32 offset = loadarraypointer(tptr, word, regs);
              genprimary (I_LDNL, offset);
            }
          else
            {
              loadarrayitempointer(tptr, word, regs);
              gensecondary (I_LB);
            }
        }
        /*}}}*/
    }
}
/*}}}*/
/*{{{  PRIVATE void storeinarrayitem(tptr, word, regs)*/
/* A transformed subscript node */
PRIVATE void storeinarrayitem ( treenode *tptr , INT32 word , int regs )
{
  treenode *nptr = nameof(tptr);
  int type = basetype(gettype(nptr));

  if ((type == S_INT16) && (targetintsize != S_INT16))
    badtag(genlocn, type, "storeinarrayitem");
  else
    {
      if (directstore(P_EXP, tptr))
        storeinname(nptr, ASOffsetOf(tptr) + word);
      else
        /*{{{  ldptr item; store*/
        {
          int b = bytesinscalar(type);
          if (b >= bytesperword)
            {
              BIT32 offset = loadarraypointer(tptr, word, regs);
              checkerror();
              genprimary (I_STNL, offset);
            }
          else
            {
              loadarrayitempointer(tptr, word, regs);
              checkerror();
              gensecondary(I_SB);
            }
        }
        /*}}}*/
    }
}
/*}}}*/
/*}}}*/
/*{{{  load/store/loadptr       elements*/
/*{{{  PRIVATE void moveelement (tptr, word, dirn, regs)*/
/* Load or store the element represented by tptr.
If dirn is LOAD load the element into Areg,
if dirn is STORE store Areg into the element.
If dirn is LOADPTR load a pointer to the element into Areg.
If the element is long, load/store the word'th word of it. */
  /* modified 5/11/90 by CO'N for bug 738, to work with word != 0 when
     dirn == LOADPTR. (IE until now, it has always assumed that the offset
     is zero when loading a pointer.
     The idea is that it simply loads a pointer to the same data which it
     would have loaded if dirn was LOAD
  */
PRIVATE void moveelement ( treenode *tptr , INT32 word , int dirn , int regs )
{
  int ilocal, inonlocal;

  /*{{{  set up ilocal and inonlocal*/
  switch(dirn)
    {
      case LOAD:
        if (chanaspointer && issimplechan(tptr))
          /* Very special case */
          {
            ilocal = I_LDLP;
            inonlocal = I_LDNLP;
          }
        else
          {
            ilocal = I_LDL;
            inonlocal = I_LDNL;
          }
        break;
      case STORE:
        ilocal = I_STL;
        inonlocal = I_STNL;
        break;
      case LOADPTR:
        ilocal = I_LDLP;
        inonlocal = I_LDNLP;
        break;
      default:
        geninternal_i(GEN_BAD_MOVEELEMENT_DIRN, dirn);
    }
  /*}}}*/

  switch(TagOf(tptr))
    /*{{{  cases*/
    {
      /*{{{  decl repl param var.abbrev retype preevaltemp*/
      case N_DECL: case N_REPL: case N_PARAM: case N_VALPARAM:
      case N_ABBR: case N_RETYPE: case T_PREEVALTEMP:
      case T_TEMP: /* code commoned-ed up 5/11/90 */
        {
          int type = typeof(tptr);
          /* T_TEMP code commoned-ed up 5/11/90 */
          if ((TagOf(tptr) == T_TEMP) && (dirn == LOAD) && isshortint(type))
            simplify(P_EXP, tptr); /* Move the value to a temporary */
          if (ispointer(tptr))
            {
              movename(tptr, 0, I_LDL, I_LDNL);
              if (dirn == STORE) checkerror ();
              if (istargetbytesize(type))
                /*{{{  load or store byte*/
                {
                  tbyteoffset(word);
                  if (dirn != LOADPTR) /* bug 738 5/11/90 */
                    gensecondary((dirn == LOAD) ? I_LB : I_SB);
                }
                /*}}}*/
              else
                /*{{{  load or store word*/
                genprimary(inonlocal, word);
                /*}}}*/
              /* INT16's on 32-bit machine are always preevaluated */
            }
          else
            {
              if (dirn == STORE)  checkerror ();
              movename(tptr, word, ilocal, inonlocal);
            }
        }
        break;
      /*}}}*/
      /*{{{  N_VALABBR N_VALRETYPE*/
      case N_VALABBR:
      case N_VALRETYPE:
        /* Could be a constant table. If so, we can only load a pointer */
        {
          treenode *constptr = DValOf(NDeclOf(tptr));
          int t = TagOf(constptr);
          if (t == S_STRING || t == S_CONSTEXP  || t == S_CONSTCONSTRUCTOR)
            /*{{{  its a constant table, load a pointer to it*/
            moveelement(constptr, word, dirn, regs);
            /*}}}*/
          else if (ispointer(tptr))
            {
              movename(tptr, 0, I_LDL, I_LDNL);
              /* if (dirn != LOADPTR) */ /* test removed for bug 738 5/11/90 */
                genprimary(inonlocal, word);
            }
          else
            movename(tptr, word, ilocal, inonlocal);
          break;
        }
      /*}}}*/
      /*{{{  S_ARRAYITEM S_SEGMENTITEM*/
      case S_ARRAYITEM:
      case S_SEGMENTITEM:
        {
          /* tnestedsegments(tptr, regs); */
          /*{{{  see if we have to preevaluate a constructor*/
          {
            treenode *nptr = nameof((TagOf(tptr) == S_ARRAYITEM) ? ASBaseOf(tptr) : SNameOf(tptr));
            if (preeval(P_EXP, nptr))
              {
                SetTag(nptr, T_PREEVALTEMP);
                tconstructorassign(nptr, NDeclOf(nptr));
              }
          }
          /*}}}*/
      
          if (dirn == LOAD)
            loadarrayitem(tptr, word, regs);
          else if (dirn == STORE)
            storeinarrayitem(tptr, word, regs);
          else /* dirn == LOADPTR */
            loadarrayitempointer(tptr, word, regs);
        }
        break;
      /*}}}*/
      /*{{{  S_STRING S_CONSTCONSTRUCTOR N_LABELDEF*/
      case S_STRING:
      case S_CONSTCONSTRUCTOR:
      case N_LABELDEF:
        {
          if (dirn == LOADPTR)
            {
              int constlab = (TagOf(tptr) == N_LABELDEF) ? NVOffsetOf(tptr)
                                                         : CTLabelOf(tptr),
              l = newlab();
              genlabeldiff(I_LDC, constlab, l);
              gensecondary(I_LDPI);
              setlab(l);
              /* I suppose that here we should add an offset if 'word' is
                 non-zero - bug 738 5/11/90.  */
              /* type(S_STRING) and type(S_CONSTCONSTRUCTOR) etc are S_ARRAY,
                 so we always load a word offset:
                 (I would guess that this never happens, since it seems wrong
                  for S_STRING etc, but at least it is consistent with
                  what is done for names, etc. CO'N 5/11/90) */
              genprimary(I_LDNLP, word);
            }
          else
            geninternal_i(GEN_BAD_CONSTANT_LOAD, dirn);
        }
        break;
      /*}}}*/
      /*{{{  S_FNFORMALRESULT*/
      case S_FNFORMALRESULT:
        /* A function result pointer is effectively an abbreviation to the
           result destination */
        {
          genprimary(I_LDL, HOffsetOf(tptr));
          gencomment0("formalresult");
          if (dirn == STORE) checkerror ();
          if (istargetbytesize(TagOf(HExpOf(tptr))))
            {
              tbyteoffset(word);
              if (dirn != LOADPTR)
                gensecondary((dirn == LOAD) ? I_LB : I_SB);
            }
          else
            genprimary(inonlocal, word);
          /* INT16's on 32-bit machine are always preevaluated */
        }
        break;
      /*}}}*/
      /*{{{  S_CONSTEXP*/
      case S_CONSTEXP:
        if (isinconstanttable(tptr))
          {
            genprimary(I_LDL, constptr + nameoffsetof(lexlevel));
            gencomment0("constptr");
            genprimary(inonlocal, CEOffsetOf(tptr) + word);
          }
        else if (dirn == LOAD)
          loadconstant(wordof(tptr, word));
        else
          geninternal_i(GEN_BAD_MOVEELEMENT_DIRN, dirn);
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "moveelement");
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void loadelement(tptr, word, regs)*/
PUBLIC void loadelement ( treenode *tptr , INT32 word , int regs )
{
  moveelement(tptr, word, LOAD, regs);
}
/*}}}*/
/*{{{  PUBLIC void storeinelement(tptr, word, regs)*/
PUBLIC void storeinelement ( treenode *tptr , INT32 word , int regs )
{
  moveelement(tptr, word, STORE, regs);
}
/*}}}*/
/*{{{  PUBLIC void loadelementpointer(tptr, regs)*/
PUBLIC void loadelementpointer ( treenode *tptr , INT32 word, int regs )
{
  /* modified 5/11/90 to take a 'word' parameter too */
  moveelement(tptr, word, LOADPTR, regs);
}
/*}}}*/
/*{{{  PUBLIC BIT32 loadelementpointeroffset(tptr, regs)*/
PUBLIC INT32 loadelementpointeroffset ( treenode *tptr , int regs )
{
  INT32 offset = ZERO32;
  if (TagOf(tptr) == S_ARRAYITEM)
    offset = loadarraypointer(tptr, ZERO32, regs); /* better code */
  else
    moveelement(tptr, 0, LOADPTR, regs);
  return(offset);
}
/*}}}*/
/*}}}*/
/*{{{  load/store/loadptr       opds*/
/*{{{  PUBLIC void loadopd(opdmode, opd, word)*/
PUBLIC void loadopd ( int opdmode , treenode *opd , INT32 word )
{
  switch (opdmode)
    {
      case P_EXP:     loadelement(opd, word, MANY_REGS); break;
      case P_TEMP:    loadname(opd, word); break;
      case P_PTR:     loadelementpointer(opd, word, MANY_REGS); break;
      case P_TEMPPTR: loadnamepointer(opd, word); break;
    }
}
/*}}}*/
/*{{{  PUBLIC void storeinopd (opdmode, opd, word, regs)*/
/*****************************************************************************
 *
 *  storeinopd pulls the top of stack and places it in (opdmode, opd)
 *
 *****************************************************************************/
PUBLIC void storeinopd ( int opdmode , treenode *opd , INT32 word , int regs )
{
  switch (opdmode)
    {
      case P_TEMPPTR:
      case P_TEMP:
      case P_EXP:      storeinelement(opd, word, regs);
                       break;
      default:
        geninternal_is(GEN_BAD_OPD, opdmode, "storeinopd");
    }
}
/*}}}*/
/*{{{  PUBLIC void loadopdpointer (opdmode, opd)*/
PUBLIC void loadopdpointer ( int opdmode , treenode *opd )
{
  switch(opdmode)
    {
      case P_TEMPPTR:
      case P_EXP:
      case P_TEMP:    loadelementpointer(opd, 0, MANY_REGS); break;
      default:
        geninternal_is(GEN_BAD_OPD, opdmode, "loadopdpointer");
    }
}
/*}}}*/
/*{{{  BIT32 loadopdpointeroffset (opdmode, opd)*/
PRIVATE INT32 loadopdpointeroffset ( int opdmode , treenode *opd )
{
  INT32 offset = ZERO32;
  switch(opdmode)
    {
      case P_TEMPPTR:
      case P_EXP:
      case P_TEMP:    offset = loadelementpointeroffset (opd, MANY_REGS);
                      break;
      default:
        geninternal_is(GEN_BAD_OPD, opdmode, "loadopdpointeroffset");
    }
  return(offset);
}
/*}}}*/
/*}}}*/

/*{{{  PRIVATE void setregdests (nregresults, regdests, destlist, instancedfn)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  setregdests takes the left- and right- hand sides of a call to a
 *              multivalued function and builds up a table, 'regdests' of
 *              the destination elements of the register results of the
 *              function. On exit, '*nregresults' contains the number of
 *              register results returned by the function.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void setregdests ( int *nregresults , treenode **regdests [MAXREGS ], treenode *destlist , treenode *instancedfn )
{
  int i, regsused = 0;
  treenode *ftypelist = FnTypeListOf(NTypeOf(instancedfn));
  while (!EndOfList(ftypelist)  && (regsused < MAXREGS))
    {
      if (fitsinregister(TagOf(ThisItem(ftypelist))))
        regdests[regsused++] = ThisItemAddr(destlist);
      destlist = NextItem(destlist);
      ftypelist = NextItem(ftypelist);
    }

  /* The list appears in the wrong order, so reverse it */
  for (i = 0; i < regsused / 2; i++)
    {
      /* Swap elements i and j (where j is the i'th from top) */
      int j = regsused - 1 - i;
      treenode **temp = regdests[i];
      regdests[i] = regdests[j];
      regdests[j] = temp;
    }

  *nregresults = regsused;
}
/*}}}*/
/*}}}*/

/*{{{  assignment mapping*/
/*#define MAX_ASSIGNMENTS 10*/
typedef struct
  {
    treenode *adest,
             *asource;
    int atype;
    int aregs, astoreregs;
    int aevaluated;
  } assigninfo_t;
/*{{{  PRIVATE int regsforassignments (assignment, nassignments)*/
/*****************************************************************************
 *
 *  regsforassignments returns the number of registers required to perform
 *                     all unevaluated assignments in the table 'assignment'.
 *
 *****************************************************************************/
PRIVATE int regsforassignments ( assigninfo_t assignment [], int nassignments )
{
  int i;
  int maxr = -1;
  for (i = 0; i < nassignments; i++)
    if (assignment[i].aevaluated == FALSE)
      maxr = max(maxr, assignment[i].aregs);
  return(maxr);
}
/*}}}*/
/*{{{  PRIVATE int ndependson (i, assignment, dependson, nassignments)*/
/*****************************************************************************
 *
 *  ndependson returns the number of assignments which assignment i
 *             depends on.
 *
 *****************************************************************************/
PRIVATE int ndependson ( int i , assigninfo_t assignment [], char dependson [], int nassignments )
{
  int d = 0;
  int j;
  for (j = 0; j < nassignments; j++)
    if ((assignment[j].aevaluated == FALSE) && dependson[(i * nassignments) + j])
      d = d + 1;
  return(d);
}
/*}}}*/
/*{{{  PRIVATE int ndependants (i, assignment, dependson, nassignments)*/
/*****************************************************************************
 *
 *  ndependants returns the number of assignments which depend upon
 *              assignment i.
 *
 *****************************************************************************/
PRIVATE int ndependants ( int i , assigninfo_t assignment [], char dependson [], int nassignments )
{
  int dependants = 0;
  int j;
  for (j = 0; j < nassignments; j++)
    if ((assignment[j].aevaluated == FALSE) && dependson[(j * nassignments) + i])
      dependants = dependants + 1;
  return(dependants);
}
/*}}}*/
/*{{{  PRIVATE int forced_assignment (assignment, dependson, nassignments)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  forced_assignment finds the best assignment to perform from the
 *                    assignment table 'assignment'.
 *                    The best assignment is the one which is depended upon
 *                    by the most other assignments (this breaks the greatest
 *                    number of cyclic dependencies), or in the case of a
 *                    draw, the assignment which uses most registers.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int forced_assignment ( assigninfo_t assignment [], char dependson [], int nassignments )
{
  int best_assignment = -1, maxdependants = -1, maxregisters = -1, i;

  for (i = 0; i < nassignments; i++)
    {
      if (assignment[i].aevaluated == FALSE)
        {
          int d = ndependants(i, assignment, dependson, nassignments);
          if
            /*{{{  best assignment so far*/
            ((d > maxdependants) ||
              ((d == maxdependants) && (assignment[i].aregs > maxregisters)))
            /*}}}*/
              /*{{{  choose this assignment*/
              {
                best_assignment = i;
                maxdependants = d;
                maxregisters = assignment[i].aregs;
              }
              /*}}}*/
        }
    }

  return(best_assignment);
}
/*}}}*/
/*{{{  PUBLIC void mapmoveopd (destmode, destptr, sourcemode, sourceptr)*/
/*****************************************************************************
 *
 *  mapmoveopd maps out the moving of (sourcemode, sourceptr) to
 *             (destmode, destptr)  : both operands must be addressable
 *             N.B. At the moment, this routine assumes that source must
 *             be moved to dest using a move instruction, as other cases
 *             are pulled out by mapsimpleassign.
 *
 *****************************************************************************/
PUBLIC void mapmoveopd ( int destmode , treenode **destptr , int sourcemode , treenode **sourceptr )
{
  /*{{{  default to a move instruction (with some last minute optimisations)*/
  {
    treenode *desttype = gettype_main(*destptr);  /* we now want to keep this type tree */
    BIT32 b;
  
    /*{{{  turn expressions into pointers*/
    sourcemode = ptrmodeof(sourcemode);
    destmode = ptrmodeof(destmode);
    /*}}}*/
  
    b = bytesin(desttype);
    if (b == -1) b = bytesin(gettype(*sourceptr));
    if ((b == 1) || (b == bytesperword &&
                     check_aligned(*sourceptr, b) && check_aligned(*destptr, b)))
      mapload2regs(destmode, destptr, sourcemode, sourceptr);
    else if (b == (-1))
      /*{{{  length is an expression*/
      {
        treenode *lengthexp;
        treenode **lengthexpp = &lengthexp;  /* just in case */
      
        /*switch_to_temp_workspace();*/
        lengthexp = scaletreeof(desttype, S_BYTE);
        /*switch_to_real_workspace();*/
      
        /* Now we save the length of the block move - CO'N 18/5/90 */
        if (TagOf(*destptr) == S_ARRAYITEM)
          {
            DEBUG_MSG(("mapmoveopd: S_ARRAYITEM\n"));
            SetASLength(*destptr, lengthexp);
            lengthexpp = ASLengthAddr(*destptr);
          }
        else if (TagOf(*destptr) == S_SEGMENTITEM)
          {
            DEBUG_MSG(("mapmoveopd: S_SEGMENTITEM\n"));
            SetSLength(*destptr, lengthexp);
            lengthexpp = SLengthAddr(*destptr);
          }
        else
          DEBUG_MSG(("mapmoveopd: neither S_ARRAYITEM nor S_SEGMENTITEM\n"));

        mapload3regs(sourcemode, sourceptr, destmode, destptr,
                   P_EXP, lengthexpp);
        /* And, as usual, throw away the load sequence */
      }
      /*}}}*/
    else
      /*{{{  length is a constant*/
      mapload2regs(sourcemode, sourceptr, destmode, destptr);
      /*}}}*/
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE treenode *makeconstructordesttree (dest)*/
/*****************************************************************************
 *
 *  makeconstructordesttree builds an ARRAYITEM tree for the first element
 *                          of the constructor destination tree, 'dest'.
 *
 *****************************************************************************/
PRIVATE treenode *makeconstructordesttree ( treenode *dest )
{
  treenode *dexp = dummyexp_p; /* added for bug 679 31/8/90 */
  BIT32 doffset  = ZERO32;
  treenode *desttree;
  if (TagOf(dest) == S_ARRAYITEM)
    {
      dexp = ASExpOf(dest);
      doffset = ASOffsetOf(dest);
      dest = newarraysubnode(S_ARRAYSUB, 0, ASBaseOf(dest), dummyexp_p);
    }
  desttree = newarraysubnode(S_ARRAYITEM, 0, dest, dexp);
  SetASOffset(desttree, doffset);

#ifdef DEBUG
  fputs("*desttree from makeconstructordesttree is :", outfile);
  printtree(0, desttree);
  fputc('\n', outfile);
#endif

  return(desttree);
}
/*}}}*/
/*{{{  PUBLIC void mapconstructorassign(destmode, destptr, sourcemode, sourceptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapconstructorassign maps the assignment of the constructor, source, to
 *                       dest
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapconstructorassign ( int destmode , treenode **destptr , int sourcemode , treenode **sourceptr )
{
  if (sourcemode != P_EXP)
    geninternal_is(GEN_BAD_OPD, sourcemode, "mapconstructorassign");

  if (TagOf(*sourceptr) == S_CONSTRUCTOR)
    sourceptr = OpAddr(*sourceptr);
  else
    badtag(genlocn, TagOf(*sourceptr), "mapconstructorassign");

#ifdef DEBUG
  fputs("*destptr before mapping is :", outfile);
  printtree(0, *destptr);
  fputc('\n', outfile);
#endif

  {
    int old = switch_to_temp_workspace();
    treenode *desttree = makeconstructordesttree(*destptr); /* bug 337 */
    switch_to_prev_workspace(old);
    while (!EndOfList(*sourceptr))
      {
        mapsimpleassign(typeof(ThisItem(*sourceptr)), destmode, &desttree,
                                            P_EXP, ThisItemAddr(*sourceptr));
        sourceptr = NextItemAddr(*sourceptr);
      }
#ifdef DEBUG
    fputs("*desttree after mapping is :", outfile);
    printtree(0, desttree);
    fputc('\n', outfile);
#endif
  }
#if 0
  {
    while (!EndOfList(*sourceptr))
      {
        mapsimpleassign(typeof(ThisItem(*sourceptr)), destmode, destptr,
                                            P_EXP, ThisItemAddr(*sourceptr));
        sourceptr = NextItemAddr(*sourceptr);
      }
  }
#endif
#ifdef DEBUG
  fputs("*destptr after mapping is :", outfile);
  printtree(0, *destptr);
  fputc('\n', outfile);
#endif
}
/*}}}*/
/*{{{  PUBLIC void mapsimpleassign(type, destmode, dest, sourcemode, source)  ***/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapsimpleassign maps out the assignment of source to dest, where
 *                  source and dest are single items of type 'type'.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapsimpleassign ( int type , int destmode , treenode **dest , int sourcemode , treenode **source )
{
  DEBUG_MSG(("mapsimpleassign: type: %d, destmode: %d, sourcemode: %d\n", type, destmode, sourcemode));
  if (fpinline && isreal(type)
      && !isaddressableopd(sourcemode, *source) /* bug 353 11/9/90 */
      && !isconstopd(sourcemode, *source)) /* bug 708 12/9/90 */
    mapfpassign(destmode, dest, sourcemode, source);
  else if (istargetintsize(type) || istargetbytesize(type))
    /*{{{  single-length assign*/
    {
      if (fpinline && isconversion(*source) && isreal(typeof(OpOf(*source))))
        /*{{{  real to int conversion as source*/
        {
          int desttempused = FALSE;
          if (!issimpleopd(destmode, *dest)) /* added for bug 739 24/9/90 */
            {
              *dest = gettemp(*dest, NM_POINTER);
              destmode = tempmodeof(destmode);
              mapexp(NDeclAddr(*dest));
              upusecount(*dest, 1);
              desttempused = TRUE;
            }
          mapfpexp(OpAddr(*source));
          destmode = ptrmodeof(destmode);
          mapexpopd(destmode, dest);
          if (desttempused)
            freetemp(*dest);
        }
        /*}}}*/
      else if (directstore(destmode, *dest))
        {
          mapexpopd(sourcemode, source);
          mapstoreinopd(destmode, dest);
        }
      else
        /*{{{  load pointer to dest and load source, store through pointer*/
        {
          destmode = ptrmodeof(destmode);
          mapload2regs(sourcemode, source, destmode, dest);
        }
        /*}}}*/
    }
    /*}}}*/
  else if (isdoublelength(type))
    mapmovelopd(destmode, dest, sourcemode, source);
  else
    /*{{{  special cases for assign*/
    switch (type)
      {
        /* other cases  still to come */
        /*{{{  INT64 REAL64 on 16-bit machine*/
        case S_INT64:
        case S_REAL64:
          mapmoveqopd(destmode, dest, sourcemode, source);
          break;
        /*}}}*/
        /*{{{  INT16 on 32-bit machine*/
        case S_INT16:
          if (isaddressableopd(sourcemode, *source) || isconstopd(sourcemode, *source))
            {
              int needtempdest   = needtemptoload(destmode, *dest);
              int notconst       = !isconstopd(sourcemode, *source);
              int needtempsource = needtemptoload(sourcemode, *source);
              DEBUG_MSG(("mapsimpleassign: INT16: needtempdest=%d, notconst=%d, needtempsource=%d\n",
                         needtempdest, notconst, needtempsource));
              if (needtempdest || (notconst && needtempsource))
                /*{{{  ldptr source; ldptr dest; ldc 2; move*/
                {
                  DEBUG_MSG(("mapsimpleassign: INT16: first case, mapping for move\n"));
                  destmode = ptrmodeof(destmode);
                  sourcemode = ptrmodeof(sourcemode);
                  mapload2regs(destmode, dest, sourcemode, source);
                }
                /*}}}*/
              else
                /*{{{  ld source; st dest*/
                {
                  DEBUG_MSG(("mapsimpleassign: INT16: first case, turn into INT\n"));
                  mapexpopd(sourcemode, source);
                  mapstoreinopd(destmode, dest);
                }
                /*}}}*/
            }
          else
            {
              DEBUG_MSG(("mapsimpleassign: INT16: second case\n"));
              if (!issimpleopd(destmode, *dest) || ispointer(*dest))
                /*{{{  temp := source; dest := temp*/
                {
                  *source = gettemp(*source, NM_WORKSPACE);
                  mapsimpleassign(type, P_TEMP, source, sourcemode,NDeclAddr(*source));
                  sourcemode = P_TEMP;
                  mapsimpleassign(type, destmode, dest, sourcemode, source);
                  freetemp(*source);
                }
                /*}}}*/
              else
                /*{{{  ld source; st dest*/
                {
                  mapexpopd(sourcemode, source);
                  mapstoreinopd(destmode, dest);
                }
                /*}}}*/
            }
          break;
        /*}}}*/
        /*{{{  ARRAY*/
        case S_ARRAY:
          if (isaddressableopd(sourcemode, *source))
            mapmoveopd(destmode, dest, sourcemode, source);
          else
            /*{{{  rhs must contain a constructor*/
            {
              /* Special case channel constuctors **ACS*** */
              if (basetype(NTypeOf(nameof(*dest))) != S_CHAN && usedin(*dest, *source))
                /*{{{  preevaluate source to a temporary*/
                {
                  /* Make a temporary to evaluate the source into */
                  *source = gettemp(*source, NM_WORKSPACE);
                
                  /* Now we load each element of the constructor and store it in the temp */
                  mapconstructorassign(P_TEMP, source, P_EXP, NDeclAddr(*source));
                
                  /* Move the temporary to the destination */
                  mapmoveopd(destmode, dest, sourcemode, source);
                
                  freetemp(*source);
                }
                /*}}}*/
              else
                /*{{{  move each element of the source to the dest*/
                {
                  int desttempused = FALSE;
                  /*{{{  preevaluate a pointer to the destination if neccessary*/
                  /* I've turned this off for the moment, till I have time to
                     fix it!  IT WAS TOTALLY WRONG AS IT STANDS   CO'N 20/2/90 */
                  /*if (!issimplelocalopd(destmode, *dest))*/ /* testing for bug 679 31/8/90 */
                  if (!issimpleopd(destmode, *dest)) /* testing for bug 679 31/8/90 */
                    {
                      DEBUG_MSG(("mapsimpleassign: turning constructor dest into a pointer\n"));
                      /**dest = gettemp(*dest, NM_WORKSPACE);*/
                      *dest = gettemp(*dest, NM_POINTER);
                      destmode = P_TEMP;
                      /**dest = gettemp(newmopnode(S_ADDRESSOF, LocnOf(*dest), *dest, 0), NM_WORKSPACE);
                      destmode = P_TEMPPTR;*/
                      mapexp(NDeclAddr(*dest));
                      upusecount(*dest, 1);
                      desttempused = TRUE;
                    }
                  /*}}}*/
                  /* Now we load each element of the constructor and store it in the dest */
                  mapconstructorassign(destmode, dest, sourcemode, source);
                  /*{{{  free up the destination pointer if neccessary*/
                  if (desttempused)
                    freetemp(*dest);
                  /*}}}*/
                }
                /*}}}*/
            }
            /*}}}*/
          break;
        /*}}}*/
        default:
          geninternal_is(GEN_ERROR_IN_ROUTINE, 4, "mapsimpleassign");
      }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE void mapmultiassign (mdestlist, msourcelist)  ***/
/* N.B. !!! Doesn't work for reals with inline fp */
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapmultiassign takes a list of destinations, 'mdestlist' and a list of
 *                 sources, 'msourcelist', reorders them and
 *                 allocates and inserts temporaries required.  Note that
 *                 'special' temporary nodes are inserted for sources which
 *                 are held in registers before storing.
 *                 This routine only works for lists of expression sources,
 *                 multiple assignments which have multi-valued functions or
 *                 valofs on the right-hand side are handled separately.
 *                 Note in all the multiple assignment code that we can have
 *                 a multiple assignment nested inside another multiple
 *                 assignment (in a valof), so all the routines have to be
 *                 reentrant.
 *
 *                 Modified to use memalloc rather than fixing MAX_ASSIGNMENTS
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void mapmultiassign ( treenode *mdestlist , treenode *msourcelist )
{
  treenode *sourcelist = msourcelist,
           *destlist   = mdestlist;
  int nassignments     = listitems(destlist);
  assigninfo_t *assignment =
 (assigninfo_t *)memalloc( (sizeof(assigninfo_t))
                                     * nassignments);
  char *dependson = (char *)memalloc((sizeof(char)) * nassignments * nassignments);
  int  *evalorder = (int  *)memalloc((sizeof(int))  * nassignments);

  int i, j, ndone = 0;
  int regtemp[MAXREGS];
  int nregtemps = 0;
  DEBUG_MSG(("In mapmultiassign\n"));
  /*{{{  initialise 'assignment'*/
  for (i = 0; i < nassignments; i++)
    {
      assigninfo_t *ass = &(assignment[i]);
      treenode *dest = ThisItem(destlist),
               *source = ThisItem(sourcelist);
      int type = typeof(dest);
      ass->atype = type;
      ass->adest = dest;
      ass->asource = source;
      ass->aevaluated = FALSE;
      /*{{{  set ass->aregs and ass->astoreregs*/
      if (istargetbytesize(type) || istargetintsize(type))
        {
          int sr = regsfor(source),
              dr = regsforstore(dest);
          ass->astoreregs = dr;
          ass->aregs = ((sr == dr) ? sr + 1 : max(sr, dr));
        }
      else
        {
          ass->astoreregs = MAXREGS;
          ass->aregs = MAXREGS;
        }
      DEBUG_MSG(("Assignment %d, type %d, storeregs:%d, aregs:%d\n", i, ass->atype, ass->astoreregs, ass->aregs));
      /* There is a hole here : a scalar INT16 source (on T4) to scalar INT16
         dest only takes one register */
      /*}}}*/
      destlist = NextItem(destlist);
      sourcelist = NextItem(sourcelist);
    }
  /*}}}*/
  /*{{{  initialise 'dependson'*/
  for (i = 0; i < nassignments; i++)
    for (j = 0; j < nassignments; j++)
      {
        dependson[(nassignments * i) + j] = (i == j) ? FALSE :
                  usedin(assignment[i].adest, assignment[j].asource);
        DEBUG_MSG(("%d dependson %d: %d\n", i, j, dependson[(nassignments * i) + j]));
      }
  /*}}}*/
  while (ndone < nassignments)
    /*{{{  move the sources to destinations, temporaries, or registers*/
    {
      /*{{{  do the assignments which aren't dependant upon any others*/
      int done_an_assignment = TRUE;
      while (done_an_assignment)
        {
          done_an_assignment = FALSE;
          for (i = 0; i < nassignments; i++)
            if (!assignment[i].aevaluated &&
                (ndependson(i, assignment, dependson, nassignments) == 0))
              {
                assignment[i].aevaluated = TRUE;
                done_an_assignment = TRUE;
                evalorder[ndone++] = i;
                DEBUG_MSG(("Doing asignment %d\n", i));
                mapsimpleassign(assignment[i].atype,
                                P_EXP, &(assignment[i].adest),
                                P_EXP, &(assignment[i].asource));
              }
        }
      /*}}}*/
      if (ndone < nassignments)
        /*{{{  break a cycle of dependency*/
        {
          int freeregs = MAXREGS - nregtemps;
          int type;
          i = forced_assignment(assignment, dependson, nassignments);
          assignment[i].aevaluated = TRUE;
          evalorder[ndone++] = i;
          DEBUG_MSG(("Breaking cycle with assignment %d ", i));
          type = assignment[i].atype;
          if
            (fitsinregister(type) &&
             !(fpinline && isreal(type)) && /* added for bug 1002 4/10/90 */
             (regsforassignments(assignment, nassignments) <= freeregs - 1) &&
             (assignment[i].astoreregs <= freeregs - 1))
              /*{{{  we can keep the source in a register*/
              {
                DEBUG_MSG(("in register\n"));
                mapexp(&(assignment[i].asource));
                assignment[i].asource = newtempnode(T_REGTEMP, assignment[i].asource,
                                                    NM_WORKSPACE);
                regtemp[nregtemps++] = i;
              }
              /*}}}*/
            else
              /*{{{  assign source i to a temporary*/
              {
                /* bug 1002 4/10/90 - cannot simply create scalars for all scalar
                   variables - we mustn't if it is a long, or if on FPU */
                if (fitsinregister(type) && !(fpinline && isreal(type)))
                  /*{{{  create a scalar temporary and generate into that*/
                  {
                    DEBUG_MSG(("scalar temporary\n"));
                    mapexp(&(assignment[i].asource));
                    assignment[i].asource = gettemp(assignment[i].asource,
                                                    NM_WORKSPACE);
                    upusecount(assignment[i].asource,1);
                  }
                  /*}}}*/
                else
                  /*{{{  create a (vector/long/real) temporary and assign into that*/
                  {
                    DEBUG_MSG(("(vector/long/real) temporary\n"));
                    /* This branch creates a temporary _before_ evaluating the rhs, which
                       is okay for vectors, but suboptimal for scalar expressions */
                    assignment[i].asource = gettemp(assignment[i].asource, NM_WORKSPACE);
                    /* it would seem that we could just change NM_WORKSPACE to NM_DEFAULT,
                    but if we do, the temp is never initialised to point at vectorspace,
                    and the vectorspace is never allocated */
                    /*assignment[i].asource = gettemp(assignment[i].asource, NM_DEFAULT);*/ /* bug 235 17/9/90 */
                    mapsimpleassign(type, P_TEMP, &(assignment[i].asource),
                                          P_EXP, NDeclAddr(assignment[i].asource));
                  }
                  /*}}}*/
              }
              /*}}}*/
        }
        /*}}}*/
    }
    /*}}}*/
  /*{{{  store any values held in registers*/
  for (i = nregtemps - 1; i >= 0; i--)
    {
      DEBUG_MSG(("Saving register temp %d\n", regtemp[i]));
      mapaddr(&(assignment[regtemp[i]].adest));
    }
  /*}}}*/
  /*{{{  move temporaries to destinations*/
  for (i = 0; i < nassignments; i++)
    if (TagOf(assignment[i].asource) == T_TEMP)
      /*{{{  move temporary i to destination*/
      {
        DEBUG_MSG(("Moving temp %d back\n", i));
        mapsimpleassign(assignment[i].atype, P_EXP, &(assignment[i].adest),
                              P_TEMP, &(assignment[i].asource));
        freetemp(assignment[i].asource);
      }
      /*}}}*/
  /*}}}*/
  /*{{{  remake the multi-assign node with the new order*/
  destlist = mdestlist;
  sourcelist = msourcelist;
  for (i = 0; i < nassignments; i++)
    {
      assigninfo_t *ass = &(assignment[evalorder[i]]);
      NewItem(ass->adest, destlist);
      NewItem(ass->asource, sourcelist);
      destlist = NextItem(destlist);
      sourcelist = NextItem(sourcelist);
    }
  /*}}}*/
  memfree(assignment);
  memfree(dependson);
  memfree(evalorder);
}
/*}}}*/
/*{{{  PUBLIC void mapassign (destptr, sourceptr)*/
/*****************************************************************************
 *
 *  mapassign maps the assignment of 'sourceptr' to 'destptr'.
 *            The source and destinations may be single items or lists.
 *
 *****************************************************************************/
PUBLIC void mapassign ( treenode **destptr , treenode **sourceptr )
{
  treenode *dest = *destptr,
           *source = *sourceptr;
  if (TagOf(dest) == S_LIST)
    /*{{{  deal with multiple assignments*/
    {
      if (listitems(source) > 1)
        mapmultiassign(dest, source);
      else
        /*{{{  multi-valued function or valof*/
        {
          treenode *sourceitem = ThisItem(source);
          switch (TagOf(sourceitem))
            {
              /*{{{  specification ... valof*/
              case S_VALABBR: case S_ABBR:
              case S_VALRETYPE: case S_RETYPE:
              case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
              case S_DECL:
              case S_VALOF:
              case S_TPROTDEF: case S_SPROTDEF:
                mapvalof(sourceitem, destptr);
                break;
              /*}}}*/
              /*{{{  function instance*/
              case S_FINSTANCE:
                {
                  treenode *instancedfn;
                  if (TagOf(INameOf(sourceitem)) == N_PREDEFFUNCTION)
                    if (mappredef(sourceitem, dest))
                      break;  /* Exit if done inline */
              
                  instancedfn = INameOf(sourceitem);
                  /*{{{  map multi-valued function instance*/
                  {
                    treenode *paramlist = IParamListOf(sourceitem);
                    paramlist = augmentparams(paramlist,
                                              FnParamsOf(NTypeOf(instancedfn)), dest);
                    SetIParamList(sourceitem, paramlist);
                    /* Insert temporaries in front of any results assigned through result
                       pointers which are aliassed in the function */
                    /*{{{  insert temporaries in front of aliassed results*/
                    {
                      treenode *p = paramlist;
                      while (!EndOfList(p))
                        {
                          treenode *thisparam = ThisItem(p);
                          if (TagOf(thisparam) == S_FNACTUALRESULT)
                            {
                              treenode *r = HExpOf(thisparam);
                              if (usedin(r, paramlist) ||
                                  isafreevarof(basedecl(r), instancedfn))
                                SetHExp(thisparam, gettemp(r, NM_WORKSPACE));
                            }
                          p = NextItem(p);
                        }
                    }
                    /*}}}*/
                    mapinstance(sourceitem);
                    /*{{{  store the register results*/
                    {
                      int nregresults;
                      treenode **regdests[MAXREGS];
                      setregdests(&nregresults, regdests, dest, instancedfn);
                      if (nregresults > 0)
                        mapstoreregs(regdests, nregresults);
                    }
                    /*}}}*/
                    /*{{{  move temporary results to their real locations, free temps*/
                    {
                      treenode *p = paramlist;
                      while (!EndOfList(p))
                        {
                          treenode *thisparam = ThisItem(p);
                          if (TagOf(thisparam) == S_FNACTUALRESULT)
                            {
                              treenode *pnode = HExpOf(thisparam);
                              if (TagOf(pnode) == T_TEMP)
                                {
                                  treenode *r = NDeclOf(pnode);
                                  mapsimpleassign(typeof(r), P_EXP, NDeclAddr(pnode),
                                                             P_TEMP, HExpAddr(thisparam));
                                  freetemp(pnode);
                                }
                            }
                          p = NextItem(p);
                        }
                    }
                    /*}}}*/
                  }
                  /*}}}*/
                }
                break;
              /*}}}*/
              default:
                geninternal_is(GEN_ERROR_IN_ROUTINE, 5, "mapassign");
            }
        }
        /*}}}*/
    }
    /*}}}*/
  else
    mapsimpleassign (typeof(dest), P_EXP, destptr, P_EXP, sourceptr);
}
/*}}}*/
/*}}}*/

/*{{{  assign*/
/*{{{  PUBLIC void moveopd (destmode, dest, sourcemode, source)*/
/*****************************************************************************
 *
 * moveopd copies (sourcemode, source) to (destmode, dest)
 *         source and dest are assumed to be addressable.
 *
 *****************************************************************************/
PUBLIC void moveopd ( int destmode , treenode *dest , int sourcemode , treenode *source )
{
  int type = typeof(dest);
  DEBUG_MSG(("moveopd\n"));
  /*{{{  see if we can pretend its an integer assign*/
  if (isshortint(type))
    {
      /* If the source isn't addressable, we must be able to store directly
         to dest, otherwise the source would have to be preevaluated to a
         temporary.
         Otherwise, we need a temp to load test on source and dest
         decides whether we can pretend it's an integer assign */
      if (!isaddressableopd(sourcemode, source) ||
          (!needtemptoload(destmode, dest) &&
           !needtemptoload(sourcemode, source)))
        {
          DEBUG_MSG(("moveopd: converted INT16 move into INT move\n"));
          type = targetintsize;
        }
      #if 0 /* bug 328 11/9/90 */
      else
        {
          if (destmode == P_TEMP)
            zero_local_var(dest);
        }
      #endif
    }
  else if (isshorttype(type) &&
      issimpleopd(destmode, dest) && issimpleopd(sourcemode, source))
    {
      DEBUG_MSG(("moveopd: converted short move into INT move\n"));
      type = targetintsize;
    }
  /*}}}*/
  if (istargetintsize(type))
    /*{{{  optimise single length move*/
    {
      if (preeval(destmode, dest))
        /*{{{  ldptr dest; stl temp; source; ldl temp; stnl offset*/
        {
          BIT32 offset = loadelementpointeroffset(NDeclOf(dest), MANY_REGS);
          storeinname(dest, 0);
          texpopd(sourcemode, source, MANY_REGS);
          loadname(dest, 0);
          checkerror ();
          genprimary(I_STNL, offset);
        }
        /*}}}*/
      else if (regsforaddropd(destmode, dest) < MAXREGS)
        /*{{{  source; st dest*/
        {
          texpopd(sourcemode, source, MANY_REGS);
          storeinopd(destmode, dest, 0, MAXREGS - 1);
        }
        /*}}}*/
      else /* We know destmode isn't TEMP or TEMPPTR due to regsfor result */
        /*{{{  ldptr dest; source; rev; stnl offset*/
        {
          BIT32 offset = loadelementpointeroffset(dest, MAXREGS);
          texpopd(sourcemode, source, MANY_REGS);
          gensecondary(I_REV);
          checkerror ();
          genprimary(I_STNL, offset);
        }
        /*}}}*/
    }
    /*}}}*/
  else if (isdoublelength(type))
    /*{{{  optimise double length move*/
    movelopd (destmode, dest, sourcemode, source);
    /*}}}*/
  else
    /*{{{  default to a move instruction (with some last minute optimisations)*/
    {
      treenode *desttype = gettype(dest),
               *sourcetype = gettype(source);
      BIT32 b;
    
      /*{{{  turn expressions into pointers*/
      sourcemode = ptrmodeof(sourcemode);
      destmode = ptrmodeof(destmode);
      /*}}}*/
    
      b = bytesin(desttype);
      if (b == (-1))
        b = bytesin(sourcetype);
    
      if (b == 1)
        /*{{{  optimise byte move*/
        {
          tload2regs(destmode, dest, sourcemode, source, FALSE);
          gensecondary(I_LB);
          gensecondary(I_REV);
          checkerror ();
          gensecondary(I_SB);
        }
        /*}}}*/
      else if (b == bytesperword &&
               check_aligned(source, b) && check_aligned(dest, b))
        /*{{{  optimise word-aligned word move*/
        {
          tload2regs(destmode, dest, sourcemode, source, FALSE);
          genprimary(I_LDNL, 0);
          gensecondary(I_REV);
          checkerror ();
          genprimary(I_STNL, 0);
        }
        /*}}}*/
      else
        /*{{{  use a move instruction*/
        {
          if (b == (-1))
            /*{{{  length is an expression*/
            {
              int preeval_e2, preeval_e3;
              int loadseq;
              treenode *lengthexp;
            
              if (TagOf(dest) == S_ARRAYITEM)
                {
                  DEBUG_MSG(("moveopd: dest is an ARRAYITEM; picking up length\n"));
                  lengthexp = ASLengthOf(dest);
                }
              else if (TagOf(dest) == S_SEGMENTITEM)
                {
                  DEBUG_MSG(("moveopd: dest is a SEGMENTITEM; picking up length\n"));
                  lengthexp = SLengthOf(dest);
                }
              else
                {
                  int old = switch_to_temp_workspace();
                  DEBUG_MSG(("moveopd: neither ARRAYITEM nor SEGMENTITEM\n"));
                  lengthexp = scaletreeof(desttype, S_BYTE);
                  switch_to_prev_workspace(old);
                }
            
              /* We only do this call so that we have a loadseq parameter for
                 tload3regs, ideally we should make the binder save loadseq
                 in the tree. */
              loadseq = giveorder(sourcemode, source, destmode, dest,
                                  P_EXP, lengthexp, &preeval_e2, &preeval_e3);
              DEBUG_MSG(("moveopd: calling tload3regs; loadseq is %d\n", loadseq));
              tload3regs(sourcemode, source, destmode, dest,
                         P_EXP, lengthexp, loadseq);
            }
            /*}}}*/
          else
            /*{{{  length is a constant*/
            {
              tload2regs(sourcemode, source, destmode, dest, FALSE);
              loadconstant(b);
            }
            /*}}}*/
          checkerror ();
          gensecondary (I_MOVE);
        }
        /*}}}*/
    }
    /*}}}*/
}
/*}}}*/

/*{{{  PRIVATE void tconstructorassign(dest, source)*/
/*****************************************************************************
 *
 *  tconstructorassign generates code to assign source to dest, where source
 *                     is a constructor.
 *
 *****************************************************************************/
PRIVATE void tconstructorassign ( treenode *dest , treenode *source )
{
  treenode *desttree;
  treenode *typetree;
  int old;
  INT32 scale;
  /*{{{  find the constructor expression list*/
  if (TagOf(source) == S_CONSTRUCTOR)
    source = OpOf(source);
  else
    badtag(genlocn, TagOf(source), "tconstructorassign");
  /*}}}*/
  typetree = gettype(ThisItem(source));
  /*{{{  set up scale*/
  scale = (bytesinscalar(basetype(typetree)) >= bytesperword) ? wordsin(typetree)
                                                 : bytesin(typetree);
  /*}}}*/
  old = switch_to_temp_workspace();
  desttree = makeconstructordesttree(dest);
  switch_to_prev_workspace(old);
  /*{{{  assign each element of the constructor*/
  while (!EndOfList(source))
    {
      tsimpleassign(TagOf(typetree), P_EXP, desttree, P_EXP, ThisItem(source),
             MANY_REGS);
      SetASOffset(desttree, ASOffsetOf(desttree) + scale);
      source = NextItem(source);
    }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tsimpleassign (type, destmode, dest, sourcemode, source, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tsimpleassign generates code to evaluate (sourcemode, source) and store the
 *         result in (destmode, dest).
 *         'type' is the type of the destination, 'regs' is the maximum
 *         number of registers available for the assignment.
 *
 *
 *****************************************************************************/
/*}}}*/

/* The largest number of registers we may use */
PUBLIC void tsimpleassign ( int type , int destmode , treenode *dest , int sourcemode , treenode *source , int regs )
{
  int r = (regs == MANY_REGS) ? MAXREGS : regs;
  /*{{{  pick out cases which can be turned into an INT assign*/
  if (istargetbytesize(type) && issimpleopd(destmode, dest))
    /* Byte sized types are ok, because we can load bytes directly.
       Other short types (the only one currently is INT16 on a 32-bit
       machine) can only be treated as an INT  assign if both source
       and destination are simple. */
    type = targetintsize;
  else if ((type == S_CHAN) || (type == S_PORT))
    type = targetintsize;
  /*}}}*/

  if (fpinline && isreal(type)
      && !isaddressableopd(sourcemode, source) /* re-inserted 11/9/90 bug 353 */
      && !isconstopd(sourcemode, source))      /* bug 708 12/9/90 */
    tfpassign(type, destmode, dest, sourcemode, source, regs);
  else if (istargetintsize(type))
    /*{{{  optimise single length assign*/
    if (fpinline && isconversion(source) && isreal(typeof(OpOf(source))))
      /*{{{  special case a conversion from real on an fp processor*/
      {
        destmode = ptrmodeof(destmode);
        destmode = simplify(destmode, dest); /* added 24/9/90 for bug 739 */
        tfpexp(OpOf(source), regs, MANY_REGS);    /*      fp.source    */
        if (TagOf(source) == S_TRUNC)
          {
            if (H1_instr) gensecondary(I_FPRZ);   /*      (fprz)       */
            else          genfpuentry(I_FPURZ);
          }
        gensecondary(CONVERSIONCHECKING ? I_FPRTOI32 /*   fprtoi32     */
                                        : I_FPINT);  /*   or fpint     */
        loadopd(destmode, dest, 0);               /*      ldp   dest   */
        checkerror ();
        gensecondary(I_FPSTNLI32);                /*      fpstnli32    */
      }
      /*}}}*/
    else if (preeval(destmode, dest))
      /*{{{  ldptr dest; stl temp; source; ldl temp; stnl*/
      {
        BIT32 offset = loadopdpointeroffset(destmode, NDeclOf(dest));
        storeinname(dest, 0);
        texpopd(sourcemode, source, MANY_REGS);
        loadnamepointer(dest, 0);
        checkerror ();
        genprimary(I_STNL, offset);
      }
      /*}}}*/
    else if (directstore(destmode, dest))
      /*{{{  simplest case: generate source, store in dest*/
      {
        texpopd(sourcemode, source, regs);
        storeinopd(destmode, dest, 0, r - 1);
      }
      /*}}}*/
    else if (preeval(sourcemode, source))
      /*{{{  source; stl temp; ldptr dest; ldl temp; rev; stnl*/
      {
        BIT32 offset;
        texpopd(sourcemode, NDeclOf(source), MANY_REGS);
        storeinname(source, 0);
        sourcemode = P_TEMP;
        offset = loadopdpointeroffset(destmode, dest);
        loadname(source, 0);
        gensecondary(I_REV);
        checkerror ();
        genprimary(I_STNL, offset);
      }
      /*}}}*/
    else if (regsforopd(destmode, dest) < r)
      /*{{{  source; ldptr dest; stnl*/
      {
        BIT32 offset;
        texpopd(sourcemode, source, regs);
        offset = loadelementpointeroffset(dest, r - 1);
        checkerror ();
        genprimary(I_STNL, offset);
      }
      /*}}}*/
    else
      /*{{{  ldptr dest; source; rev; stnl*/
      {
        BIT32 offset = loadelementpointeroffset(dest, regs);
        texpopd(sourcemode, source, r - 1);
        gensecondary(I_REV);
        checkerror ();
        genprimary(I_STNL, offset);
      }
      /*}}}*/
    /*}}}*/
  else if (isdoublelength(type))
    movelopd(destmode, dest, sourcemode, source);
  else
    /*{{{  special cases for assign*/
    switch (type)
      {
        /*{{{  BYTE BOOL*/
        /* dest MUST be via a pointer */
        case S_BYTE:
        case S_BOOL:
          destmode = ptrmodeof(destmode);
          tload2regs(sourcemode, source, destmode, dest, FALSE);
          checkerror ();
          gensecondary(I_SB);
        #if 0
          destmode = simplify(destmode, dest);  /* Preeval dest ptr if necessary */
          if (regsforaddropd(destmode, dest) < r)
            /*{{{  generate source, store into dest*/
            {
              texpopd(sourcemode, source, regs);
              storeinopd(destmode, dest, 0, r - 1);
            }
            /*}}}*/
          else /* we know destmode isn't P_TEMP or P_TEMPPTR */
            /*{{{  make pointer to dest, generate source, store through pointer*/
            {
              loadelementpointer(dest, 0, regs);
              texpopd(sourcemode, source, r - 1);
              gensecondary(I_REV);
              checkerror ();
              gensecondary(I_SB);
            }
            /*}}}*/
        #endif
          break;
        /*}}}*/
        /*{{{  INT16 on 32-bit machine*/
        case S_INT16: /* we must be on a 32-bit machine */
          sourcemode = simplify(sourcemode, source);
          moveopd (destmode, dest, sourcemode, source);
          break;
        /*}}}*/
        /*{{{  INT64 REAL64 on 16-bit machine*/
        case S_INT64:
        case S_REAL64:
          moveqopd(destmode, dest, sourcemode, source);
          break;
        /*}}}*/
        /*{{{  ARRAY*/
        case S_ARRAY:
          if (isaddressableopd(sourcemode, source))
            moveopd(destmode, dest, sourcemode, source);
          else
            /*{{{  right-hand side must contain a constructor*/
            {
              if (TagOf(dest) == T_TEMP)
                destmode = P_PTR;
              destmode = simplify(destmode, dest);
            
              if (preeval(sourcemode, source))
                {
                  SetTag(source, T_PREEVALTEMP);
                  tconstructorassign(source, NDeclOf(source));
                  moveopd(destmode, dest, P_TEMP, source);
                }
              else
                {
                  if (TagOf(dest) == T_TEMP)
                    SetTag(dest, T_PREEVALTEMP);
                  tconstructorassign(dest, source);
                }
            }
            /*}}}*/
          break;
        /*}}}*/
        default:
          geninternal_is(GEN_ERROR_IN_ROUTINE, 3, "tsimpleassign");
      }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE void tmultiassign (mdestlist, msourcelist)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tmultiassign takes a multiple - assignment tree, tptr, which has been
 *               reordered by the mapper, and generates code for it.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tmultiassign ( treenode *mdestlist , treenode *msourcelist )
{
  /*{{{  range check each assignment if neccessary*/
  if (RANGECHECKING)
    {
      treenode *destlist = mdestlist,
               *sourcelist = msourcelist;
      while (!EndOfList(destlist))
        {
          treenode *thisdest = ThisItem(destlist);
          if (typeof(thisdest) == S_ARRAY)
            tcheckdimensions(gettype(thisdest), gettype(ThisItem(sourcelist)));
          destlist = NextItem(destlist);
          sourcelist = NextItem(sourcelist);
        }
    }
  /*}}}*/
  /*{{{  do the assignment*/
  {
    treenode *destlist = mdestlist,
             *sourcelist = msourcelist;
    treenode *regdest[MAXREGS];
    int nregtemps = 0, i;
    while (!EndOfList(destlist))
      /*{{{  move source to register, temporary, or directly to dest*/
      {
        /*{{{  do this assignment*/
        {
          treenode *dest = ThisItem(destlist),
                   *source = ThisItem(sourcelist);
          if (TagOf(source) == T_TEMP)
            /*{{{  move to temporary*/
            tsimpleassign(typeof(dest), P_TEMP, source,
                   P_EXP, NDeclOf(source), MAXREGS - nregtemps);
            /*}}}*/
          else if (TagOf(source) == T_REGTEMP)
            /*{{{  load to register*/
            {
              texpopd(P_EXP, NDeclOf(source), MANY_REGS);
              regdest[nregtemps++] = dest;
            }
            /*}}}*/
          else
            /*{{{  move directly to dest*/
            tsimpleassign(typeof(dest), P_EXP, dest, P_EXP, source, MAXREGS - nregtemps);
            /*}}}*/
        }
        /*}}}*/
        destlist = NextItem(destlist);
        sourcelist = NextItem(sourcelist);
      }
      /*}}}*/
    /*{{{  store register temporaries in their destinations*/
    for (i = nregtemps - 1; i >= 0; i--)
      storeinopd(P_EXP, regdest[i], 0, MAXREGS - (i + 1));
    /*}}}*/
    /*{{{  move temporaries to their destinations*/
    destlist = mdestlist;
    sourcelist = msourcelist;
    while (!EndOfList(destlist))
      {
        treenode *dest = ThisItem(destlist),
                 *source = ThisItem(sourcelist);
        if (TagOf(source) == T_TEMP)
          tsimpleassign(typeof(dest), P_EXP, dest, P_TEMP, source, MANY_REGS);
        destlist = NextItem(destlist);
        sourcelist = NextItem(sourcelist);
      }
    /*}}}*/
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tassign (dest, source)*/
/*****************************************************************************
 *
 *  tassign generates code to assign source to dest.
 *          source and dest may be lists, in which case it is assumed that
 *          they have been reordered and temporaries inserted as necessary.
 *
 *****************************************************************************/
PUBLIC void tassign ( treenode *dest , treenode *source )
{
  if (TagOf(dest) == S_LIST)
    /*{{{  we have a multiple assignment*/
    {
      if (listitems(source) > 1)
        tmultiassign(dest, source);
      else
        /*{{{  multi-valued function or valof*/
        /* N.B. Here I assume that functions and valofs always have scalar results
                - if they have vector results then hidden dimension size checking
                code must be generated. */
        {
          treenode *sourceitem = ThisItem(source);
          switch (TagOf(sourceitem))
            {
              /*{{{  specification ... valof*/
              case S_VALABBR: case S_ABBR:
              case S_VALRETYPE: case S_RETYPE:
              case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
              case S_TPROTDEF: case S_SPROTDEF:
              case S_DECL:
              case S_VALOF:
                tvalof(sourceitem, dest);
                break;
              /*}}}*/
              /*{{{  function instance*/
              case S_FINSTANCE:
                if (TagOf(INameOf(sourceitem)) == N_PREDEFFUNCTION)
                  tpredef(sourceitem, dest);
                else
                  {
                    tinstance(sourceitem);
                    /* store the register results */
                    /*{{{  store the register results*/
                    {
                      treenode **regdests[MAXREGS];
                      int nregresults;
                      setregdests(&nregresults, regdests, dest, INameOf(sourceitem));
                      if (nregresults > 0)
                        tstoreregs(regdests, nregresults);
                    }
                    /*}}}*/
                    /*{{{  move any results put into temporaries to their real destinations*/
                    {
                      treenode *paramlist = IParamListOf(sourceitem);
                      while (!EndOfList(paramlist))
                        {
                          treenode *thisparam = ThisItem(paramlist);
                          if (TagOf(thisparam) == S_FNACTUALRESULT)
                            {
                              treenode *p = HExpOf(thisparam);
                              if (TagOf(p) == T_TEMP)
                                {
                                  treenode *r = NDeclOf(p);
                                  tsimpleassign(typeof(r), P_EXP, r, P_TEMP, p, MANY_REGS);
                                }
                            }
                          paramlist = NextItem(paramlist);
                        }
                    }
                    /*}}}*/
                  }
                break;
              /*}}}*/
              default:
                geninternal_is(GEN_ERROR_IN_ROUTINE, 5, "tassign");
            }
        }
        /*}}}*/
    }
    /*}}}*/
  else
    {
      int type = typeof(dest);
      if ((type == S_ARRAY) && RANGECHECKING)
        tcheckdimensions(gettype(dest), gettype(source));
      tsimpleassign (type, P_EXP, dest, P_EXP, source, MANY_REGS);
    }
}
/*}}}*/
/*}}}*/
