/*#define DEBUG*/
/******************************************************************************
 *
 *  Code generator gen10 - channel input and output generation
 *
 *****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <assert.h>
# include <stdio.h>
# include "includes.h"
# include "instruct.h"
# include "generror.h"
# include "genhdr.h"
# include "lex1def.h"
# include "chkdef.h"
# include "trandef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen7def.h"
# include "gen9def.h"
# include "gen10def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
# include "srcoutde.h"
/*}}}*/

/*{{{  private variables*/
/*#define MAX_NESTED_ALTS 10*/ /* There is now no hard limit */

PRIVATE treenode **replaltstack;
PRIVATE int replaltstacklen;
PRIVATE int replaltvaluesbase; /* WS offset of first saved replicator */
PRIVATE int nalternatives, alternativecount;
PRIVATE int inreplalt, inskippingalt, altcheckneeded, altcheckdone;
PRIVATE treenode *replaltvector; /* Used in mapaltenable */
PRIVATE int premapped_alt; /* TRUE if mapping top level of an ALT */

PRIVATE treenode *intnodeptr = NULL; /* used for processing counted arrays */

#ifdef VIRTUALCHANS
  #define virtualinstring      "VIRTUAL.IN%"
  #define virtualoutstring     "VIRTUAL.OUT%"
  #define virtualoutbytestring "VIRTUAL.OUT.BYTE%"
  #define virtualoutwordstring "VIRTUAL.OUT.WORD%"
#endif
/*}}}*/
/*{{{  private routines*/
#ifdef VIRTUALCHANS
/*{{{  PRIVATE treenode *iocallname(ioinst)*/
PRIVATE treenode *iocallname ( int ioinst )
{
  char *str;
  switch(ioinst)
    {
      case I_IN      : str = virtualinstring;      break;
      case I_OUT     : str = virtualoutstring;     break;
      case I_OUTWORD : str = virtualoutwordstring; break;
      case I_OUTBYTE : str = virtualoutbytestring; break;
    }
  DEBUG_MSG(("In iocallname: str = %s\n", str));
  return (vlibentry(processlibname(str, 1, vlibsuffix)));
}
/*}}}*/
#endif
/*{{{  PRIVATE mapioop(ioinst, iobycall)*/
PRIVATE void mapioop ( int ioinst , int iobycall )
{
  DEBUG_MSG(("In mapioop: ioinst = %d, iobycall = %d\n", ioinst, iobycall));
#ifdef VIRTUALCHANS
  if (iobycall)
    {
      treenode *nptr = iocallname(ioinst);
      INT32 ws, vs;
      getprocwsandvs(nptr, &ws, &vs);
      datasize = max(datasize, (ws + REG_PARAMS + INS_EXTRA));
      /* vs will always be zero */
      add_to_libentries(nptr);
    }
  else
#endif
    {
      datasize = max(datasize, DS_IO);
      if (ioinst == I_OUTWORD || ioinst == I_OUTBYTE)
        reservelowworkspace(1);
    }
}
/*}}}*/

/*{{{  PRIVATE treenode *fixporttype(portuse)*/
/*****************************************************************************
 *
 *  fixporttype converts a port namenode (used in the tree 'portuse')
 *              from being a 'PORT OF t' to being a 't'.
 *              This unpleasant trick allows us to use the general
 *              assign code on port input and port output.
 *              The original type tree is returned so that it can be
 *              put backk at the earliest possible opportunity (see
 *              routine 'restoreporttype').
 *
 *****************************************************************************/
PRIVATE treenode *fixporttype ( treenode *portuse )
{
  treenode *portname = nameof(portuse);
  treenode **porttype = NTypeAddr(portname);
  treenode *result;
  while (TagOf(*porttype) == S_ARRAY) porttype = ARTypeAddr(*porttype);
  result = *porttype;
  *porttype = ProtocolOf(*porttype);
  return result;
}
/*}}}*/
/*{{{  PRIVATE void restoreporttype(portuse, porttype)*/
/*****************************************************************************
 *
 *  restoreporttype sets the type field of the port namenode
 *                  (used in the tree 'portuse') to 'porttype'.
 *
 *****************************************************************************/
PRIVATE void restoreporttype ( treenode *portuse , treenode *porttype )
{
  treenode *portname = nameof(portuse);
  treenode **type = NTypeAddr(portname);
  while ((*type) != ProtocolOf(porttype))
    {
      if (TagOf(*type) != S_ARRAY)
        badtag(genlocn, TagOf(*type), "restoreporttype");
      type = ARTypeAddr(*type);
    }
  *type = porttype;
}
/*}}}*/
/*{{{  PRIVATE int numberofalternatives(tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  numberofalternatives count the number of alternatives in an ALT
 *                       construct: a replicated alternative counts as 1.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int numberofalternatives ( treenode *tptr )
{
  while (isspecification(tptr))
    tptr = DBodyOf(tptr);
  switch(TagOf(tptr))
    {
      case S_ALTERNATIVE:
        return 1;
      case S_ALT:
      case S_PRIALT:
        {
          int count = 0;
          for (tptr = CBodyOf(tptr); !EndOfList(tptr); tptr = NextItem(tptr))
            count += numberofalternatives(ThisItem(tptr));
          return count;
        }
      case S_REPLALT:
      case S_PRIREPLALT:
        return numberofalternatives(ReplCBodyOf(tptr));
      default :
        badtag(genlocn, TagOf(tptr), "numberofalternatives");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE int countnestedalts(tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  countnestedalts counts the max number of nested levels in an ALT
 *
 *****************************************************************************/
/*}}}*/
#define NESTED_ALTS  0  /* count all levels of the ALT */
#define NESTED_REPLS 1  /* just count the replicated levels */
PRIVATE int countnestedalts ( treenode *tptr, int flag)
{
  DEBUG_MSG(("countnestedalts: %s\n", flag == NESTED_ALTS ? "nested ALTs" : "nested repls"));
  while (isspecification(tptr))
    tptr = DBodyOf(tptr);
  switch(TagOf(tptr))
    {
      case S_ALTERNATIVE:
        if (flag == NESTED_ALTS)
          return 1;
        else
          return 0;
      case S_ALT:
      case S_PRIALT:
        {
          int count = 0;
          for (tptr = CBodyOf(tptr); !EndOfList(tptr); tptr = NextItem(tptr))
            count = max(count, countnestedalts(ThisItem(tptr), flag));
          if (flag == NESTED_ALTS)
            return (count + 1);
          else  /* (flag == NESTED_REPLS) */
            return (count);
        }
      case S_REPLALT:
      case S_PRIREPLALT:
        return (countnestedalts(ReplCBodyOf(tptr), flag) + 1);
      default :
        badtag(genlocn, TagOf(tptr), "countnestedalts");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE int hastruealtguard(tptr)*/
/*****************************************************************************
 *
 *  hastruealtguard returns TRUE if the ALT construct tptr has at least
 *                  one TRUE Boolean guard
 *
 *****************************************************************************/
PRIVATE int hastruealtguard ( treenode *tptr )
{
  while (tptr != NULL)
    {
      tptr = skipspecifications(tptr);
      switch(TagOf(tptr))
        {
          /*{{{  S_ALT S_PRIALT*/
          case S_ALT: case S_PRIALT:
            tptr = CBodyOf(tptr);
            while (!EndOfList(tptr))
              if (hastruealtguard(ThisItem(tptr)))
                return TRUE;
              else
                tptr = NextItem(tptr);
            break;
          /*}}}*/
          /*{{{  S_ALTERNATIVE*/
          case S_ALTERNATIVE:
            return istrueguard(AltGuardOf(tptr));
          /*}}}*/
          /*{{{  S_REPLALT S_PRIREPLALT*/
          case S_REPLALT: case S_PRIREPLALT:
            tptr = ReplCBodyOf(tptr);
            break;
          /*}}}*/
        }
    }
  return FALSE;
}
/*}}}*/
#if 0 /* Firstly this isn't needed anymore cos all the work is done in transformalt */
      /* Secondly this is broken anyway, cos it forgets about leading specs */
/*{{{  PRIVATE int usedinaltguards (n, tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  usedinaltguards takes an element, 'n', and an alt tree, 'tptr' and
 *                  returns TRUE if 'n' is referenced in a guard or channel
 *                  of any of the alternatives in 'tptr', otherwise returns
 *                  FALSE.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int usedinaltguards ( treenode *n , treenode *tptr )
{
  DEBUG_MSG(("usedinaltguards\n"));
  tptr = skipspecifications(tptr);
  while (tptr != NULL)
    switch (TagOf(tptr))
      {
        /*{{{  S_ALTERNATIVE              return*/
        case S_ALTERNATIVE:
          {
            treenode *channel = NULL;
            treenode *input = skipspecifications(AltInputOf(tptr));
            int inputtype = inputtypeof(input);
            if ((inputtype == INP_INPUT) || (inputtype == INP_CASE_INPUT) ||
                (inputtype == INP_TAGGED_INPUT) || (inputtype == INP_PORT_INPUT))
              channel = LHSOf(input);
            return(usedin(n, channel) || usedin(n, AltGuardOf(tptr)));
          }
        /*}}}*/
        /*{{{  S_ALT S_PRIALT             return*/
        case S_ALT: case S_PRIALT:
          tptr = CBodyOf(tptr);
          while (!EndOfList(tptr))
            if (usedinaltguards(n, ThisItem(tptr)))
              return(TRUE);
            else
              tptr = NextItem(tptr);
          return(FALSE);
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT     break*/
        case S_REPLALT: case S_PRIREPLALT:
          tptr = ReplCBodyOf(tptr);
          break;
        /*}}}*/
      }
  return(FALSE);
}
/*}}}*/
#endif /* 0 */
/*{{{  PRIVATEPARAM void mapaltenables(tptr)*/
/*****************************************************************************
 *
 *  mapaltenables allocates workspace for enabling each guard in
 *                the ALT tree 'tptr'.
 *
 *****************************************************************************/
PRIVATEPARAM void mapaltenables ( treenode *tptr )
  {
    int saved_premapped_alt = premapped_alt;
    premapped_alt = FALSE;
    DEBUG_MSG(("mapaltenables: replaltstacklen is %d\n", replaltstacklen));
    switch(TagOf(tptr))
      {
        default:               /* Must be a leading specification */
          /* modified so that this calls mappreprocess now - bug 776 5/10/90 */
          mapdeclandbody(tptr, mapaltenables, TRUE, TRUE);
          break;
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          SetCTemp(tptr, replaltvector);
          if (!saved_premapped_alt) mappreprocess(tptr);
          mapconstruction(CBodyOf(tptr), mapaltenables);
          break;
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          {
            INT32 oldweight = loop_weight;
            uploop_weight((INT32)2); /* Enable + disables */
            SetReplCTemp(tptr, replaltvector);
            replaltstacklen++;
            DEBUG_MSG(("mapaltenables: found a repl, replaltstacklen is now %d\n", replaltstacklen));
            if (!saved_premapped_alt) mappreprocess(tptr);
            maprepl(tptr, mapaltenables);
            replaltstacklen--;
            /*addusecount(replaltvector, NVUseCountOf(ReplCNameOf(tptr)));*/
            loop_weight = oldweight;
          }
          break;
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          {
            treenode *input = skipspecifications(AltInputOf(tptr)),
                     **guard = AltGuardAddr(tptr);
          #if 0 /* now done in trans: 2/11/90 */
            if (*guard == NULL)
              {
                SetAltGuard(tptr, trueguard);
                guard = &trueguard;
              }
          #endif
            /*{{{  map for enable/disable*/
            mappreprocess(tptr);
            {
              switch(inputtypeof(input))   /* map for enable/disable */
                {
                  /*{{{  skip*/
                  case INP_SKIP: case INP_PORT_INPUT: case INP_TIMER_INPUT:
                    mapbool(guard);
                    break;
                  /*}}}*/
                  /*{{{  input and case input  and tagged input*/
                  case INP_INPUT: case INP_CASE_INPUT: case INP_TAGGED_INPUT:
                    {
                      int channelmode = chanaspointer ? P_EXP : P_PTR;
                      treenode **chanexp = AltChanExpAddr(tptr); /* added 2/11/90 bug 779 */
                      if (!istrueguard(*guard) && cancauseerror(/*LHSOf(input)*/ *chanexp))
                        {
                          mapexpopd(P_EXP, guard);
                          mapexpopd(channelmode, /*LHSAddr(input)*/ chanexp);
                        }
                      else
                        mapload2regs(channelmode, /*LHSAddr(input)*/ chanexp, P_EXP, guard);
                      break;
                    }
                  /*}}}*/
                  /*{{{  delayed input*/
                  case INP_DELAYED_INPUT:
                    /* map lhs incase of subscript checks */
                    mapexpopd(P_EXP, LHSAddr(input)); /* Bug 288 22/5/90 */
                    if (!istrueguard(*guard) && cancauseerror(RHSOf(input)))
                      {
                        mapexpopd(P_EXP, guard);
                        mapexpopd(P_EXP, RHSAddr(input));
                      }
                    else
                      mapload2regs(P_EXP, RHSAddr(input), P_EXP, guard);
                    break;
                  /*}}}*/
                }
            }
            /*}}}*/
            /*SetAltTemp(tptr, replaltvector);*/
            addusecount(replaltvector, replaltstacklen);
          }
          break;
        /*}}}*/
      }
    premapped_alt = saved_premapped_alt;
  }
/*}}}*/
/*{{{  void mapaltbodies(tptr)                  ** global for 3L bug*/
/*****************************************************************************
 *
 *  mapaltbodies allocates workspace for the body of each guarded process in
 *                the ALT tree 'tptr'.
 *
 *****************************************************************************/
PRIVATEPARAM void mapaltbodies ( treenode *tptr )
  {
    int *scope = save_scope();
    tptr = resurrect_specs(tptr);
    switch(TagOf(tptr))
      {
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          mapconstruction(CBodyOf(tptr), mapaltbodies);
          break;
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          {
            /* Don't include the enabling and disabling loops in the usage
               calculation for the replaltvector */
            INT32 enable_count = NVUseCountOf(ReplCNameOf(tptr));
            resurrect_var(ReplCNameOf(tptr));
            mapaltbodies(ReplCBodyOf(tptr));
            addusecount(ReplCTempOf(tptr), NVUseCountOf(ReplCNameOf(tptr)) - enable_count);
          }
          break;
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          /* Have to be careful, because alternatives
             will not yet have been through mappreprocess. */
          {
            treenode *input = AltInputOf(tptr);
            if (isspecification(input))
              /*{{{  map the deferred specification and the input*/
              {
                /* mapdeclandbody will descope the specs before the input
                 * so we must resurrect them before we process the body
                 */
                /* modified so that this calls mappreprocess now - bug 776 5/10/90 */
                mapdeclandbody(input, mapinput, TRUE, TRUE);
                input = resurrect_specs(input);
              }
              /*}}}*/
            else
              mapinput(input);
            /*{{{  map the body*/
            {
              switch(inputtypeof(input))
                {
                  /*{{{  case input*/
                  case INP_CASE_INPUT:
                    break;   /* There is no body */
                  /*}}}*/
                  /*{{{  everything else*/
                  default:
                    mapprocess(AltBodyOf(tptr));
                    break;
                  /*}}}*/
                }
            }
            /*}}}*/
          }
          break;
        /*}}}*/
      }
    restore_scope(scope);
  }
/*}}}*/
/*{{{  PRIVATE void taltcheck()*/
PRIVATE void taltcheck ( void )
{
  if (altcheckneeded)
    /*{{{  do a check*/
    {
      if (!inreplalt && alternativecount == 1)
        genprimary(I_STL, 0);
      else
        {
          genprimary(I_LDL, 0);
          gensecondary(I_OR);
          if (!inreplalt && !inskippingalt && alternativecount == nalternatives)
            {
              genprimary(I_LDC, 1);
              gensecondary(I_CCNT1);
              altcheckdone = TRUE;
            }
          else
            genprimary(I_STL, 0);
        }
    }
    /*}}}*/
}
/*}}}*/
/*{{{  void taltenables(tptr)                   ** global for 3L bug*/
/*****************************************************************************
 *
 *  taltenables enables all the guards in the ALT or replicated ALT tree tptr,
 *              including those of any nested alternatives.
 *
 *****************************************************************************/
PRIVATEPARAM void taltenables ( treenode *tptr )
  {
    treenode *aptr = skipspecifications(tptr);
    DEBUG_MSG(("taltenables\n"));
    /*{{{  translate leading specifications for the first time*/
    #if 0  /* We've now guaranteed (in transformalt) that all leading specs are necessary*/
    while (isspecification(tptr))
      {
        if (usedinaltguards(DNameOf(tptr), aptr))
          tspecification(tptr);
        tptr = DBodyOf(tptr);
      }
    #endif
    tptr = tspecs(tptr);
    /*}}}*/
    switch(TagOf(aptr))
      {
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          DEBUG_MSG(("taltenables: found a nested ALT or PRIALT\n"));
          aptr = CBodyOf(aptr);
          while (!EndOfList(aptr))
            {
              taltenables(ThisItem(aptr));
              aptr = NextItem(aptr);
            }
          break;
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          {
            treenode *guard = AltGuardOf(aptr),
                     *input = skipspecifications(AltInputOf(aptr));
        
            DEBUG_MSG(("taltenables: found a branch of the ALT\n"));
            inskippingalt = FALSE;
            alternativecount++;
            switch (inputtypeof(input))
              {
                /*{{{  skip  timer_input or port_input*/
                /* if the  front end allows it */
                case INP_SKIP: case INP_TIMER_INPUT: case INP_PORT_INPUT:
                  tpreexp(guard);
                  tbool(guard, MANY_REGS);
                  gensecondary(I_ENBS);
                  taltcheck();
                  break;
                /*}}}*/
                /*{{{  channel input, case input and tagged input*/
                case INP_INPUT: case INP_CASE_INPUT: case INP_TAGGED_INPUT:
                  {
                    /* bug 779 2/11/90 - modified to use AltChanExpOf */
                    treenode *inputchannel = /*LHSOf(input)*/ AltChanExpOf(aptr);
                    int channelmode = chanaspointer ? P_EXP : P_PTR;
                    int skiplab = newlab();
                    /* Don't try and preevaluate it here */
                    if (TagOf(inputchannel) == T_TEMP)
                      inputchannel = NDeclOf(inputchannel);
                    tpreexp(guard);
                    tpreexp(inputchannel);
                    if (!istrueguard(guard) && cancauseerror(inputchannel))
                      {
                        inskippingalt = TRUE;
                        tguard(guard, TRUE, skiplab);
                        texpopd(channelmode, inputchannel, MANY_REGS);
                        loadconstant(1);
                      }
                    else
                      tload2regs(channelmode, inputchannel, P_EXP, guard, FALSE);
                    gensecondary(I_ENBC);
                    taltcheck();
                    setlab(skiplab);
                  }
                  break;
                /*}}}*/
                /*{{{  delayed input*/
                case INP_DELAYED_INPUT:
                  {
                    int skiplab = newlab();
                    treenode *time = RHSOf(input);
                    tpreexp(guard);
                    tpreexp(LHSOf(input)); /* Bug 288 22/5/90 */
                    tpreexp(time);
                    if (!istrueguard(guard) && cancauseerror(time))
                      {
                        inskippingalt = TRUE;
                        tguard(guard, TRUE, skiplab);
                        texp(time, MANY_REGS);
                        loadconstant(1);
                      }
                    else
                      tload2regs(P_EXP, time, P_EXP, guard, FALSE);
                    gensecondary(I_ENBT);
                    taltcheck();
                    setlab(skiplab);
                  }
                  break;
                /*}}}*/
              }
          }
          break;
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          {
            int savedinreplalt = inreplalt;
            DEBUG_MSG(("taltenables: found a nested REPLALT or PRIREPLALT\n"));
            tpreexp(ReplCStartExpOf(aptr));
            tpreexp(ReplCLengthExpOf(aptr));
            inreplalt = TRUE;
            trepl(aptr, taltenables, ZERO32, ZERO32);
            inreplalt = savedinreplalt;
          }
          break;
        /*}}}*/
      }
  }
/*}}}*/
/*{{{  void taltdisables(tptr, altendlab)       ** global for 3L bug*/
/*****************************************************************************
 *
 *  taltdisables disables all the guards in the ALT or replicated ALT tree
 *               tptr, including those of any nested alternatives.
 *
 *****************************************************************************/
PRIVATEPARAM void taltdisables ( treenode *tptr , int altendlab )
  {
    treenode *aptr = skipspecifications(tptr);
    DEBUG_MSG(("taltdisables, replaltstacklen is %d\n", replaltstacklen));    
    /*{{{  translate leading specifications for the second time*/
    /* These specifications can be translated in REDUCED error mode as
       we have already translated them once, and if anything was going to
       go wrong, it would have done so already.
       Don't do 'tpreexp' a second time. */
    #if 0  /* We've now guaranteed (in transformalt) that all leading specs are necessary*/
    while (isspecification(tptr))
      {
        if (usedinaltguards(DNameOf(tptr), aptr))
          tspecification(tptr);
        tptr = DBodyOf(tptr);
      }
    #endif
    tptr = tspecs(tptr);
    /*}}}*/
    switch(TagOf(aptr))
      {
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          aptr = CBodyOf(aptr);
          while (!EndOfList(aptr))
            {
              taltdisables(ThisItem(aptr), altendlab);
              aptr = NextItem(aptr);
            }
          break;
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          {
            treenode *guard = AltGuardOf(aptr),
                     *input = skipspecifications(AltInputOf(aptr));
            int startlab = newlab();
            int skiplab = newlab();
        
            SetAltLabel(aptr, startlab);
            switch(inputtypeof(input))
              {
                /*{{{  skip*/
                case INP_SKIP:
                case INP_PORT_INPUT:
                case INP_TIMER_INPUT:
                  tbool(guard, MANY_REGS);
                  genlabeldiff(I_LDC, startlab, altendlab);
                  gensecondary(I_DISS);
                  break;
                /*}}}*/
                /*{{{  channel input, case input and tagged input*/
                case INP_INPUT:
                case INP_CASE_INPUT:
                case INP_TAGGED_INPUT:
                  {
                    /* bug 779 2/11/90 - modified to use AltChanExpOf */
                    treenode *inputchannel = /*LHSOf(input)*/ AltChanExpOf(aptr);
                    int channelmode = chanaspointer ? P_EXP : P_PTR;
                    /* Don't try and preevaluate it here */
                    if (TagOf(inputchannel) == T_TEMP)
                      inputchannel = NDeclOf(inputchannel);
                    if (!istrueguard(guard) && cancauseerror(inputchannel))
                      {
                        tguard(guard, TRUE, skiplab);
                        texpopd(channelmode, inputchannel, MANY_REGS);
                        loadconstant(1);
                      }
                    else
                      tload2regs(channelmode, inputchannel, P_EXP, guard, FALSE);
                    genlabeldiff(I_LDC, startlab, altendlab);
                    gensecondary(I_DISC);
                  }
                  break;
                /*}}}*/
                /*{{{  timer input*/
                case INP_DELAYED_INPUT:
                  {
                    treenode *time = RHSOf(input);
                    if (!istrueguard(guard) && cancauseerror(time))
                      {
                        tguard(guard, TRUE, skiplab);
                        texp(time, MANY_REGS);
                        loadconstant(1);
                      }
                    else
                      tload2regs(P_EXP, time, P_EXP, guard, FALSE);
                    genlabeldiff(I_LDC, startlab, altendlab);
                    gensecondary(I_DIST);
                  }
                  break;
                /*}}}*/
              }
            /*{{{  select current value of any enclosing replicators*/
            {
              int i;
              if (replaltstacklen > 0)
                {
                  genbranch(I_CJ, skiplab);                  /*          cj    skiplab   */
                  for (i = 0; i < replaltstacklen; i++)
                    {
                      treenode *replname = replaltstack[i];
                      loadname(replname, REPL_BASE);          /*          ldl   i        */
                      /*storeinname(replname, REPL_SELECTED);*//*         stl   i + 2    */
                      genprimary(I_STL, replaltvaluesbase + i); /*        stl   saved_repl */
                      gencomment1("saved repl %d", i);
                    }
                }
            }
            /*}}}*/
            setlab(skiplab);                            /* skiplab:                */
          }
          break;
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          replaltstack[replaltstacklen++] = ReplCNameOf(aptr);
          DEBUG_MSG(("taltdisables: found a repl, replaltstacklen is now %d\n", replaltstacklen));
          trepl(aptr, taltdisables, altendlab, ZERO32);
          replaltstacklen--;
          break;
        /*}}}*/
      }
  }
/*}}}*/
/*{{{  PRIVATE void taltbodies(tptr, joinlab)*/
/*****************************************************************************
 *
 *  taltbodies generates code for all the ALT bodies contained in the ALT or
 *             replicated ALT tree, tptr, including the bodies of nested ALTs.
 *
 *****************************************************************************/
PRIVATE void taltbodies ( treenode *tptr , int joinlab,
                          treenode **altbodystack, int altbodystackptr )
  {
    DEBUG_MSG(("taltbodies: altbodystackptr is %d\n", altbodystackptr));
    altbodystack[altbodystackptr] = tptr;
    tptr = skipspecifications(tptr);
    switch(TagOf(tptr))
      {
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          tptr = CBodyOf(tptr);
          while (!EndOfList(tptr))
            {
              taltbodies(ThisItem(tptr), joinlab, altbodystack, altbodystackptr+1);
              tptr = NextItem(tptr);
            }
          break;
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          {
            treenode *input = AltInputOf(tptr);
            treenode *body = AltBodyOf(tptr);
            int startlab = AltLabelOf(tptr);
        
            setlab(startlab);
            /*{{{  translate specifications leading up to this alternative*/
            {
              /* These specifications can be translated in REDUCED error mode as
                 we have already translated them at least twice, and if anything
                 was going to go wrong, it would have done so already. */
              int i;
              for (i = 0; i < (altbodystackptr+1); i++)
                {
                  treenode *t = altbodystack[i];
                  t = tspecs(t);
                }
            }
            /*}}}*/
            /*{{{  translate specifications moved in front of the input*/
            input = tspecs(input);
            /*}}}*/
            switch(inputtypeof(input))
              {
                /*{{{  input, port input, timer input, tagged input*/
                case INP_INPUT:
                case INP_PORT_INPUT:
                case INP_TIMER_INPUT:
                case INP_TAGGED_INPUT:
                  tinput(input);
                  tprocess(body);
                  break;
                /*}}}*/
                /*{{{  case input*/
                case INP_CASE_INPUT:
                  tinput(input);
                  break;  /* There is no body */
                /*}}}*/
                /*{{{  skip, delayed input*/
                case INP_SKIP:
                case INP_DELAYED_INPUT:
                  tprocess(body);
                  break;
                /*}}}*/
              }
            genjump(joinlab);
          }
          break;
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          /* Change the position of the replicator from replicated_i to saved i */
          {
            treenode *replname = ReplCNameOf(tptr);
          /*INT32 newoffset = NVOffsetOf(replname) + (REPL_SELECTED - REPL_BASE);*/
          /*INT32 newoffset = replaltvaluesbase + replaltstacklen;*/
            INT32 newoffset = replaltvaluesbase + replaltstacklen - nameoffsetof(NLexLevelOf(replname));
            replaltstacklen++;
            SetNVOffset(replname, newoffset);
            if (!isconst(ReplCLengthExpOf(tptr)) || (LoValOf(ReplCLengthExpOf(tptr)) != ZERO32))
              taltbodies(ReplCBodyOf(tptr), joinlab, altbodystack, altbodystackptr+1);
            replaltstacklen--;
          }
          break;
        /*}}}*/
      }
  }
/*}}}*/
/*}}}*/
/*{{{  public routines*/
/*{{{  PUBLIC void tioop(ioinst, iobycall)*/
PUBLIC void tioop ( int ioinst , int iobycall )
{
  DEBUG_MSG(("In tioop: ioinst = %d, iobycall = %d\n", ioinst, iobycall));
#ifdef VIRTUALCHANS
  if (iobycall)
    {
      treenode *nptr = iocallname(ioinst);
      genbranch (I_CALL, NPLabelOf(nptr));
      if (assembly_output)
        gencomment1("Call %s", (BIT32)WNameOf(NNameOf(nptr)));
    }
  else
#endif
    {
      gensecondary(ioinst);
    }
}
/*}}}*/
/*{{{  PUBLIC void mapoutputitem(channelmode, channel,outputitemmode,outputitem)*/
/*****************************************************************************
 *
 *  mapoutputitem allocates workspace required for outputting
 *                (outputitemmode, outputitem) on channel
 *                (channelmode, channel)
 *
 *****************************************************************************/
PUBLIC void mapoutputitem ( int channelmode , treenode **channel , int outputitemmode , treenode **outputitem )
{
  const int usecall = iobycall && maybevirtualchan(*channel);
  DEBUG_MSG(("mapoutputitem: usecall is %d\n", usecall));
  if (TagOf(*outputitem) == S_COLON2)
    /*{{{  map counted output*/
    {
      treenode **countexp = LeftOpAddr(*outputitem),
               **arrayexp = RightOpAddr(*outputitem);
      treenode *dimexp = dimexpof(*arrayexp, 0);
      int countmode = P_EXP;
      const int constantcount = isconst(*countexp);
      const int type = typeof(*countexp);
      /*{{{  preevaluate count to a temporary if neccessary*/
      if (!constantcount)
        {
          if (!issimplelocal(*countexp)) /* || !fitsinword(type))*/ /* bug 1132 29/1/91 */
            {
              *countexp = gettemp(*countexp, NM_WORKSPACE);
              upusecount (*countexp, 1);
              mapsimpleassign(type, P_TEMP, countexp, P_EXP, NDeclAddr(*countexp));
              countmode = P_TEMP;
            }
          if (isshortint(type))
            upusecount(*countexp, 2); /* sign extension */ /* bug 706 13/9/90 */
        }
      /*}}}*/
      /*{{{  output the count*/
      mapoutputitem(channelmode, channel, countmode, countexp);
      /*}}}*/
      /*{{{  output the array from 0 for count*/
      if /* count is variable or count is constant but not zero */
        (!constantcount || (LoValOf(*countexp) != ZERO32) ||
                           (HiValOf(*countexp) != ZERO32))
          /*{{{  output the array from 0 for count*/
          {
            treenode *checkedcount;
            int checkcount = FALSE;
            /*{{{  map the conversion (check) if a quad word */
            /* Added for bug 1130 29/1/91 */
            if (!constantcount && isquadlength(type))
              {
                const int old = switch_to_temp_workspace();
                treenode *conversion = makeconversion (type, S_INT, *countexp, S_EXACT);
                switch_to_prev_workspace(old);
                mapexp(&conversion);
              }
            /*}}}*/
            /*{{{  check the count if it or the dimension are not constant*/
            if (!constantcount || !isconst(dimexp))
              {
                const int old = switch_to_temp_workspace();
                checkedcount = newdopnode(S_CCNT1, NOPOSN, *countexp, dimexp, S_INT);
                switch_to_prev_workspace(old);
                checkcount = TRUE;
              }
            else
              checkedcount = *countexp;
            /*}}}*/
            if (constantcount)
              {
                 if (checkcount) mapexp(&checkedcount);
                 mapload2regs(P_PTR, arrayexp, channelmode, channel);
              }
            else
              /*{{{  ldptr array; ldptr channel; ld length*/
              {
                treenode *lengthexp;
                const int old = switch_to_temp_workspace();
                /* 10 is just a dummy value as we don't know the real size,
                   and it doesn't matter what it is anyway, just as long
                   as the lengthexp takes two registers to load */
                lengthexp = newdopnode(S_TIMES, NOPOSN, checkedcount, newconstant(10), S_INT);
                switch_to_prev_workspace(old);
                mapload3regs(P_PTR, arrayexp, channelmode, channel, P_EXP, &lengthexp);
              }
              /*}}}*/
            mapioop(I_OUT, usecall);
          }
          /*}}}*/
      /*}}}*/
      /*{{{  free the count temporary if neccessary*/
      if (countmode == P_TEMP)
        freetemp(*countexp);
      /*}}}*/
    }
    /*}}}*/
  else
    {
      int t = typeof(*outputitem);
      int freeoutputitem = FALSE;
      /* This bit added by CO'N for eg. out ! x + x, REAL32 on T8 */
      if (fpinline && isreal(t) && !isaddressable(*outputitem))
        {
          if (isconst(*outputitem))
            placeintable(*outputitem);
          else
            {
            #if 0 /* This isn't quite right, or is it? */
              treenode *type = gettype(*outputitem);
              *outputitem = gettemp(*outputitem, NM_WORKSPACE);
              upusecount(*outputitem, 1);
              mapsimpleassign(TagOf(type), P_TEMP, outputitem, outputitemmode,
                              NDeclAddr(*outputitem));
              outputitemmode = P_TEMP;
              freeoutputitem = TRUE;
            #endif
              mapfpexp(outputitem);
              *outputitem = gettemp (*outputitem, NM_WORKSPACE);
              outputitemmode = P_TEMP;
              freeoutputitem = TRUE;
            }
        }
      /* end of added bit */
      if (istargetintsize(t))
        /*{{{  outword*/
        {
          mapload2regs(channelmode, channel, outputitemmode, outputitem);
          mapioop(I_OUTWORD, usecall);
        }
        /*}}}*/
      else if (istargetbytesize(t))
        /*{{{  outbyte*/
        {
          mapload2regs(channelmode, channel, outputitemmode, outputitem);
          mapioop(I_OUTBYTE, usecall);
        }
        /*}}}*/
      else
        /*{{{  out*/
        {
          treenode *type = gettype(*outputitem);
          INT32 s = bytesin(type);
          /*{{{  if outputitem is not addressable, evaluate it into a temporary*/
          if (!isaddressableopd(outputitemmode, *outputitem))
            {
              if (isconst(*outputitem))
                placeintable(*outputitem);
              else
                {
                  *outputitem = gettemp(*outputitem, NM_WORKSPACE);
                  upusecount(*outputitem, 1);
                  mapsimpleassign(TagOf(type), P_TEMP, outputitem, outputitemmode,
                                  NDeclAddr(*outputitem));
                  outputitemmode = P_TEMP;
                  freeoutputitem = TRUE;
                }
            }
          /*}}}*/
        
          outputitemmode = ptrmodeof(outputitemmode);
          if (s == (-1))
            /*{{{  length is an expression*/
            {
              int loadseq;
              treenode *lengthexp;
            
              int old = switch_to_temp_workspace();
              lengthexp = scaletreeof(type, S_BYTE);
              switch_to_prev_workspace(old);
            
              loadseq = mapload3regs(outputitemmode, outputitem, channelmode, channel,
                                     P_EXP, &lengthexp);
              /* Ideally we should save this loadseq value on the tree somewhere
                 so that we don't have to recalculate it in the code generator */
            }
            /*}}}*/
          else
            mapload2regs(outputitemmode, outputitem, channelmode, channel);
          mapioop(I_OUT, usecall);
        }
        /*}}}*/
      if (freeoutputitem)
        freetemp(*outputitem);
    }
}
/*}}}*/
/*{{{  PUBLIC void mapinputitem(channelmode, channel, inputitemmode, inputitem)*/
/*****************************************************************************
 *
 *  mapinputitem allocates workspace required for inputting inputitem
 *                on channel (channelmode, channel)
 *
 *****************************************************************************/
PUBLIC void mapinputitem ( int channelmode , treenode **channel , int inputitemmode , treenode **inputitem )
{
  int usecall = iobycall && maybevirtualchan(*channel);
  DEBUG_MSG(("mapinputitem, usecall %d\n", usecall));
  if (TagOf(*inputitem) == S_COLON2)
    /*{{{  do counted input*/
    {
      treenode **countexp = LeftOpAddr(*inputitem),
               **arrayexp = RightOpAddr(*inputitem);
      int countmode = P_EXP;
      int counttype = typeof(*countexp);
      treenode *checkedcount;
      /*{{{  declare a temporary to hold count, if necessary*/
      {
        if (!issimplelocal(*countexp))
          /*{{{  input to a temporary; move to the destination*/
          {
            *countexp = gettemp(*countexp, NM_WORKSPACE);
            upusecount (*countexp, 1);
            countmode = P_TEMP;
            /*{{{  input to a temporary*/
            mapinputitem(channelmode, channel, P_TEMPPTR, countexp);
            /*}}}*/
            /*{{{  move to the destination*/
            mapsimpleassign(counttype, P_EXP, NDeclAddr(*countexp), P_TEMP, countexp);
            /*}}}*/
          }
          /*}}}*/
        else
          /*{{{  input to the destination*/
          {
            countmode = P_EXP;
            mapinputitem(channelmode, channel, P_PTR, countexp);
          }
          /*}}}*/
        if (isshortint(counttype))
          upusecount(*countexp, 2); /* sign extension */
      }
      /*}}}*/
      /*{{{  convert a long int to int if neccessary*/
      /* It will be in a temp if it isn't a local simple BYTE, or short INT */
      /* The only conversions that need checking are long ints to int */
      /* No mapping required */ /* WRONG!!!!!! */
      /*{{{  map the conversion (check) if a quad word */
      /* Added for bug 1130 29/1/91 */
      if (isquadlength(counttype))
        {
          const int old = switch_to_temp_workspace();
          treenode *conversion = makeconversion(counttype, S_INT, *countexp, S_EXACT);
          switch_to_prev_workspace(old);
          mapexp(&conversion);
        }
      /*}}}*/
      /*}}}*/
      /*{{{  if count = 0 goto skiplab*/
      /* No mapping required: we've already mapped the count */
      /*}}}*/
      /*{{{  add rangecheck to count expression if necessary*/
      if (RANGECHECKING)
        {
          const int old = switch_to_temp_workspace();
          checkedcount = newdopnode(S_CCNT1, 0, *countexp, dimexpof(*arrayexp, 0), S_INT);
          switch_to_prev_workspace(old);
        }
      else
        checkedcount = *countexp;
      /*}}}*/
      /*{{{  input array from 0 for count*/
      {
        treenode *lengthexp;
        /*{{{  lengthexp = checkedcount * scale*/
        {
          const int old = switch_to_temp_workspace();
          /* 10 is just a dummy value as we don't know the real size,
             and it doesn't matter what it is anyway, just as long
             as the lengthexp takes two registers to load */
          lengthexp = newdopnode(S_TIMES, 0, checkedcount, newconstant(10), S_INT);
          switch_to_prev_workspace(old);
        }
        /*}}}*/
        mapload3regs(P_PTR, arrayexp, channelmode, channel, P_EXP, &lengthexp);
        mapioop(I_IN, usecall);
      }
      /*}}}*/
      /*{{{  free the temporary holding count, if necessary*/
      if (countmode == P_TEMP)
        freetemp(*countexp);
      /*}}}*/
    
    }
    /*}}}*/
  else
    {
      treenode *type = gettype(*inputitem);
      if (bytesin(type) == (-1))
        /*{{{  length is an expression*/
        {
          int loadseq;
          treenode *lengthexp;
        
          const int old = switch_to_temp_workspace();
          lengthexp = scaletreeof(type, S_BYTE);
          switch_to_prev_workspace(old);
        
          loadseq = mapload3regs(inputitemmode, inputitem, channelmode, channel,
                                 P_EXP, &lengthexp);
          /* Ideally we should save this loadseq value on the tree somewhere
             so that we don't have to recalculate it in the code generator */
        }
        /*}}}*/
      else
        mapload2regs(inputitemmode, inputitem, channelmode, channel);
      mapioop(I_IN, usecall);
    }
}
/*}}}*/
/*{{{  PUBLIC void mapoutput(tptr)*/
/*****************************************************************************
 *
 *  mapoutput allocates workspace and temporaries for an OUTPUT node
 *
 *****************************************************************************/
PUBLIC void mapoutput ( treenode *tptr )
{
  treenode *channel = LHSOf(tptr),
           *outputlist = RHSOf(tptr);
  const int noutputitems = listitems(outputlist);
  treenode *channeltype = gettype(channel);
  DEBUG_MSG(("mapoutput\n"));
  if (TagOf(channeltype) == S_PORT)
    /*{{{  handle a PORT output*/
    {
      treenode *porttype = fixporttype(channel);
      mapsimpleassign(typeof(channel),
                      P_EXP, LHSAddr(tptr),
                      P_EXP, ThisItemAddr(outputlist));
      restoreporttype(channel, porttype);
    }
    /*}}}*/
  else
    /*{{{  handle a channel output*/
    {
      int channelmode = chanaspointer ? P_EXP : P_PTR;
      int channeltempmode = tempmodeof(channelmode);
      if (!issimplelocal(channel) && ((noutputitems > 1) ||
                                      (TagOf(ThisItem(outputlist)) == S_COLON2)))
        /*{{{  preevaluate pointer to channel into temporary before doing outputs*/
        {
          DEBUG_MSG(("mapoutput: preevaluating pointer to chan\n"));
          mapexpopd(channelmode, LHSAddr(tptr));
          channel = getopdtemp(channelmode, channel);
          SetLHS(tptr, channel);
          upusecount (channel, 1);
          channelmode = tempmodeof(channelmode);
        }
        /*}}}*/
      while (!EndOfList(outputlist))
        /*{{{  map this outputitem, move to next*/
        {
          mapoutputitem(channelmode, LHSAddr(tptr), P_EXP, ThisItemAddr(outputlist));
          outputlist = NextItem(outputlist);
        }
        /*}}}*/
      if (channelmode == channeltempmode)
        freetemp(channel);
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void mapinput(tptr)*/
/*****************************************************************************
 *
 *  mapinput allocates workspace and temporaries for an INPUT node
 *
 *****************************************************************************/
PUBLIC void mapinput ( treenode *tptr )
{
  if (TagOf(tptr) != S_SKIP)
    {
      treenode *channel = LHSOf(tptr);
      treenode **channeladdr = LHSAddr(tptr);
      treenode *inputlist = skipspecifications(RHSOf(tptr));
      int channelmode = chanaspointer ? P_EXP: P_PTR;
      int channeltempmode = tempmodeof(channelmode);

      /*{{{  switch on the input type*/
      switch(inputtypeof(tptr))
        {
          /*{{{  channel input*/
          case INP_INPUT:
            datasize = max(datasize, DS_IO);
            if (!issimplelocal(channel) && ((listitems(inputlist) > 1) ||
                                            (TagOf(ThisItem(inputlist)) == S_COLON2)))
              /*{{{  preevaluate pointer to channel into temporary before doing outputs*/
              {
                mapexpopd(channelmode, channeladdr);
                channel = getopdtemp(channelmode, channel);
                SetLHS(tptr, channel);
                upusecount(channel, 1);
                channelmode = tempmodeof(channelmode);
              }
              /*}}}*/
            while (!EndOfList(inputlist))
              /*{{{  map this inputitem, move to next*/
              {
                mapinputitem(channelmode, LHSAddr(tptr), P_PTR, ThisItemAddr(inputlist));
                inputlist = NextItem(inputlist);
              }
              /*}}}*/
            if (channelmode == channeltempmode)
              freetemp(channel);
            break;
          /*}}}*/
          /*{{{  read timer*/
          case INP_TIMER_INPUT:
            mapexp(channeladdr); /* Just to mark the timer as used, also for subscript checks */
            mapaddr(ThisItemAddr(inputlist));
            break;
          /*}}}*/
          /*{{{  delayed input*/
          case INP_DELAYED_INPUT:
            datasize = max(datasize, DS_WAIT);
            mapexp(channeladdr);
            mapexp(&inputlist);
            break;
          /*}}}*/
          /*{{{  port input*/
          case INP_PORT_INPUT:
            {
              treenode *porttype = fixporttype(channel);
              mapsimpleassign(typeof(channel),
                              P_EXP, ThisItemAddr(inputlist),
                              P_EXP, channeladdr);
              restoreporttype(channel, porttype);
            }
            break;
          /*}}}*/
          /*{{{  case input*/
          /*{{{  comment     What the tree looks like after mapping*/
          /*
                                S_CASE_INPUT
                                 /      \
          (holds channel ptr) T_TEMP   T_TEMP (holds inputted tag)
                                          \
                                        S_LIST
                                        /    \
                                   S_VARIANT  S_LIST
                                   /             .
                                S_LIST            .
                                /    \
              (const val S_CONSTEXP    .
               of tag)      /           .
                      N_TAGDEF
          
          N.B. The temporary inserted in front of the channel is optional, and only
               inserted if the channel is not a simple local.
               There is ALWAYS a temporary inserted in front of the variant list, to
               hold the tag.
          */
          /*}}}*/
          case INP_CASE_INPUT:
            datasize = max(datasize, DS_IO);
            {
              if (!issimplelocal(channel))
                /*{{{  preevaluate pointer to channel into temporary before doing inputs*/
                {
                  mapexpopd(channelmode, channeladdr);
                  SetLHS(tptr, getopdtemp(channelmode, channel));
                  channelmode = tempmodeof(channelmode);
                  channel = LHSOf(tptr);
                  upusecount(channel, 1);
                }
                /*}}}*/
              /*{{{  load tag into tag temporary*/
              SetRHS(tptr, gettypedtemp(RHSOf(tptr), NM_WORKSPACE, newleafnode(S_BYTE, NOPOSN)));
              upusecount(RHSOf(tptr), 1);
              mapexpopd(channelmode, LHSAddr(tptr));
              mapioop(I_IN, iobycall && maybevirtualchan(channel));
              freetemp(RHSOf(tptr));
              /*}}}*/
              /*{{{  map the body*/
              {
                int savedglobchannelmode = globchannelmode;
                treenode **savedglobchannelptr = globchannelptr;
              
                /* Set up global variables for mapvariant */
                globchannelmode = channelmode;
                globchannelptr = LHSAddr(tptr);
                mapconstruction(inputlist, mapprocess);
              
                globchannelptr = savedglobchannelptr;
                globchannelmode = savedglobchannelmode;
              }
              /*}}}*/
              if (channelmode == channeltempmode)
                freetemp(channel);
            }
            break;
          /*}}}*/
          /*{{{  tagged input*/
          /*{{{  comment     What the tree looks like after mapping*/
          /*
                                S_TAGGED_INPUT
                                 /      \
          (holds channel ptr) T_TEMP   T_TEMP (holds inputted tag)
                                          \
                                        S_LIST
                                        /    \
                      (const val S_CONSTEXP  other input items
                       of tag)      /           .
                               N_TAGDEF          .
          
          N.B. The temporary inserted in front of the channel is optional, and only
               inserted if the channel is not a simple local.
               There is ALWAYS a temporary inserted in front of the input item list, to
               hold the tag.
          */
          /*}}}*/
          case INP_TAGGED_INPUT:
            datasize = max(datasize, DS_IO);
            {
              if (!issimplelocal(channel))
                /*{{{  preevaluate pointer to channel into temporary before doing inputs*/
                {
                  mapexpopd(channelmode, channeladdr);
                  SetLHS(tptr, getopdtemp(channelmode, channel));
                  channelmode = tempmodeof(channelmode);
                  channel = LHSOf(tptr);
                  upusecount(channel, 1);
                }
                /*}}}*/
              /*{{{  load tag into tag temporary*/
              SetRHS(tptr, gettypedtemp(RHSOf(tptr), NM_WORKSPACE, newleafnode(S_BYTE, NOPOSN)));
              mapexpopd(channelmode, LHSAddr(tptr));
              mapioop(I_IN, iobycall && maybevirtualchan(channel));
              upusecount(RHSOf(tptr),1);
              freetemp(RHSOf(tptr));
              /*}}}*/
          
              inputlist = NextItem(inputlist); /* Move past the tag */
              while (!EndOfList(inputlist))
                /*{{{  map this inputitem, move to next*/
                {
                  mapinputitem(channelmode, LHSAddr(tptr), P_PTR, ThisItemAddr(inputlist));
                  inputlist = NextItem(inputlist);
                }
                /*}}}*/
              if (channelmode == channeltempmode)
                freetemp(channel);
            }
            break;
          /*}}}*/
        }
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC void mapalt(tptr)*/
PUBLIC void mapalt ( treenode *tptr )
{
  /* The following mapping does the enables and disables */
  /* Reserve wsp0 from the enables and disables.
      During enabling it may be used as a temporary to trap degenerate
     ALTs, during disabling it is used by the disabling instructions.
   */
  int saved_premapped_alt = premapped_alt;
  treenode *reserved, *replvector, *type;
  int repls = countnestedalts(tptr, NESTED_REPLS);
  type = newarraynode(S_ARRAY, LocnOf(tptr),
              newconstexpnode(S_CONSTEXP, LocnOf(tptr), dummyexp_p, ZERO32, repls),
              newleafnode(S_INT, LocnOf(tptr)));
  SetARDim(type, repls);
  DEBUG_MSG(("mapalt: nested repls is %d\n", repls));
  replvector = gettypedtemp(tptr, NM_WORKSPACE, type);
  if (nodetypeoftag(TagOf(tptr)) == CNODE)
    SetCTemp(tptr, replvector);
  else
    SetReplCTemp(tptr, replvector);
  replaltvector = replvector;
  reserved = alloc_fixedws(0, 1);
  insidealtguard = TRUE;
  alt_ds = (timerguardinalt(tptr)) ? DS_WAIT : DS_IO;
  replaltstacklen = 0; /* used while mapping for usage count of replaltvector */
  premapped_alt = TRUE; /* indicate that mappreprocess has already been called */
  mapaltenables(tptr);
  kill_var(reserved);
  insidealtguard = FALSE;
  /* Map ALT bodies above ALT enables */
  mapaltbodies(tptr);
  freetemp(replvector);
  premapped_alt = saved_premapped_alt;
}
/*}}}*/

/*{{{  PRIVATE void tlengthcheck*/
PRIVATE void tlengthcheck(treenode *lengthexp)
{
  if (RANGECHECKING) /* bug 1139 4/2/91 */
    {
      /* Check for zero length communications on a CHAN OF ANY */
      texp(lengthexp, MANY_REGS);
      genprimary(I_EQC, 0);
      genprimary(I_LDC, 1);
      gensecondary(I_CSUB0);
    }
}
/*}}}*/
/*{{{  PRIVATE void tsignextend*/
PRIVATE void tsignextend(treenode *nptr, int already_zeroed)
{
  if (RANGECHECKING || !already_zeroed)
    {
      loadname(nptr, 0);
      if (!already_zeroed)
        {
          loadconstant(typemask(S_INT16));
          gensecondary(I_AND);
        }
      if (RANGECHECKING)
        {
          /* if not range checking, we assume that the count is never negative! */
          loadconstant(checkmask(S_INT16));
          gensecondary(I_XWORD);
        }
      storeinname(nptr, 0);
    }
}
/*}}}*/
/*{{{  PUBLIC void toutputitem (channelmode, channel, outputitemmode, outputitem, prot.)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  toutputitem generates code to output (outputitemmode, outputitem) on
 *              channel (channelmode, channel)
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void toutputitem ( int channelmode , treenode *channel , int outputitemmode , treenode *outputitem , treenode *prottype )
{
  const int usecall = iobycall && maybevirtualchan(channel);
  DEBUG_MSG(("toutputitem: usecall is %d\n", usecall));
  if (TagOf(outputitem) == S_COLON2)
    /*{{{  do counted output*/
    {
      treenode *countexp = LeftOpOf(outputitem),
               *arrayexp = RightOpOf(outputitem);
      int countmode = P_EXP;
      const int constantcount = isconst(countexp);
      int counttype = typeof(countexp);
      treenode *origtype = NTypeOf(countexp); /* bug 864 29/1/91 */
      int skiplab;
      treenode *dimexp = dimexpof(arrayexp, 0);
      int zeroed_temp = FALSE;
      treenode *leftprottype, *rightprottype;
      /*{{{  set up leftprottype and rightprottype*/
      if (TagOf(prottype) == S_ANY)
        {
          leftprottype = prottype;
          rightprottype = prottype;
        }
      else
        {
          leftprottype = LeftOpOf(prottype);
          rightprottype = RightOpOf(prottype);
        }
      /*}}}*/
      if (preeval(countmode, countexp))
        /*{{{  preevaluate count to a temporary*/
        {
          if (isshortint(counttype)) /* bug 706 13/9/90 */
            { zero_local_var(countexp); zeroed_temp = TRUE; }
          tsimpleassign(counttype, P_TEMP, countexp, P_EXP, NDeclOf(countexp), MANY_REGS);
          SetTag(countexp, T_PREEVALTEMP);
          countmode = P_TEMP;
        }
        /*}}}*/
      /*{{{  output the count*/
      toutputitem(channelmode, channel, countmode, countexp, leftprottype);
      /*}}}*/
      /*{{{  skip if count is 0, check count against size of array*/
      if (!constantcount)
        {
          /* It will be in a temp if it isn't a local simple BYTE, or short INT */
          /* The only conversions that need checking are long ints to int */

          if (isshortint(counttype)) /* bug 706 13/9/90 */
            /* must be a simplelocal, or would have been mapped to a temporary */
            tsignextend(countexp, zeroed_temp);
          else if (!fitsinword(counttype))
            /*{{{  convert long int temporary to int temporary*/
            {
              if (RANGECHECKING)
                {
                  treenode *checktree;
                  const int old = switch_to_temp_workspace();
                  if (isquadlength(counttype)) /* bug 1130 29/1/91 */
                    checktree = makeconversion(counttype, S_INT, countexp, S_EXACT);
                  else
                    checktree = newmopnode(S_EXACT, NOPOSN, countexp, S_INT);
                  switch_to_prev_workspace(old);
                  texp(checktree, MANY_REGS);
                }
              if (intnodeptr == NULL) intnodeptr = newleafnode(S_INT, NOPOSN);
              SetNType(countexp, intnodeptr); /* bug 864 - see below */
            }
            /*}}}*/
          texpopd(countmode, countexp, MANY_REGS);
          skiplab = newlab();
          genbranch(I_CJ, skiplab);
        }
      /*}}}*/
      /*{{{  preprocess the arrayexp*/
      /* The array expression may contain segments whose base and length
         cannot be calculated until the count has been inputted.  */
      tpreexp(arrayexp);
      /*}}}*/
      /*{{{  output the array from 0 for count*/
      if /* count is variable or count is constant but not zero */
        (!constantcount || (LoValOf(countexp) != ZERO32))
          /*{{{  output the array from 0 for count*/
          {
            const INT32 b = bytesin(ARTypeOf(gettype(arrayexp)));
            treenode *checkedcount;
            int checkcount = FALSE;
            /*{{{  add range checking to countexp if neccessary*/
            if (RANGECHECKING && (!constantcount || !isconst(dimexp)))
              {
                const int old = switch_to_temp_workspace();
                checkedcount = newdopnode(S_CCNT1, NOPOSN, countexp, dimexp, S_INT);
                switch_to_prev_workspace(old);
                checkcount = TRUE;
              }
            else
              checkedcount = countexp;
            /*}}}*/
            if (constantcount)
              /*{{{  ldptr array; ldptr channel; ldc length*/
              {
                if (checkcount)
                  texp(checkedcount, MANY_REGS);
                tload2regs(P_PTR, arrayexp, channelmode, channel, MAXREGS);
                loadconstant(b * LoValOf(countexp));
              }
              /*}}}*/
            else
              /*{{{  ldptr array; ldptr channel; ld length*/
              {
                treenode *lengthexp;
                int preeval_e2, preeval_e3, loadseq;
                /*{{{  lengthexp = checkedcount * scale*/
                if (b != 1)
                  {
                    int old = switch_to_temp_workspace();
                    lengthexp = newdopnode(S_TIMES, NOPOSN, checkedcount,
                                           newconstant(b), S_INT);
                    switch_to_prev_workspace(old);
                  }
                else
                  lengthexp = checkedcount;
                /*}}}*/
                loadseq = giveorder(P_PTR, arrayexp, channelmode, channel, P_EXP, lengthexp,
                                      &preeval_e2, &preeval_e3);
                tload3regs(P_PTR, arrayexp, channelmode, channel, P_EXP, lengthexp, loadseq);
              }
              /*}}}*/
            tioop(I_OUT, usecall);
          }
          /*}}}*/
      /*}}}*/
      SetNType(countexp, origtype); /* bug 864 */
      if (!constantcount)
        setlab(skiplab);
    }
    /*}}}*/
  else
    {
      const int t = typeof(outputitem);
      if (istargetintsize(t))
        /*{{{  ldptr channel; ld outputitem; outword*/
        {
          tload2regs(channelmode, channel, outputitemmode, outputitem, FALSE);
          tioop(I_OUTWORD, usecall);
        }
        /*}}}*/
      else if (istargetbytesize(t))
        /*{{{  ldptr channel; ld outputitem; outbyte*/
        {
          tload2regs(channelmode, channel, outputitemmode, outputitem, FALSE);
          tioop(I_OUTBYTE, usecall);
        }
        /*}}}*/
      else
        /*{{{  ldptr channel; ldptr outputitem; ld length; out*/
        {
          treenode *type = gettype(outputitem);
        
          const INT32 s = bytesin(type);
          /*{{{  preevaluate the outputitem if necessary*/
          #if 0 /* bug 743 makes this evaluate twice 21/9/90 */
          if (preeval(outputitemmode, outputitem))
            {
              int tmode = tempmodeof(outputitemmode);
              tsimpleassign(TagOf(type), tmode, outputitem, outputitemmode,
                            NDeclOf(outputitem), MANY_REGS);
              outputitemmode = tmode;
            }
          #else
          outputitemmode = simplify(outputitemmode, outputitem);
          #endif
          /*}}}*/
          outputitemmode = ptrmodeof(outputitemmode);
          if (s == (-1))
            /*{{{  length is an expression*/
            {
              /*{{{  check hidden dimensions*/
              if ((TagOf(prottype) != S_ANY) && RANGECHECKING)
                tcheckdimensions(type, prottype);
              /*}}}*/
              /*{{{  load operands for an 'out' instruction*/
              {
                int preeval_e2, preeval_e3;
                int loadseq;
                treenode *lengthexp;
              
                int old = switch_to_temp_workspace();
                lengthexp = scaletreeof((TagOf(prottype) != S_ANY) ? prottype : type, S_BYTE);
                switch_to_prev_workspace(old);
              
                /* We only do this call so that we have a loadseq parameter for
                   tload3regs, ideally we should make the binder save loadseq
                   in the tree. */
                loadseq = giveorder(outputitemmode, outputitem,
                                    channelmode, channel,
                                    P_EXP, lengthexp, &preeval_e2, &preeval_e3);
                if (TagOf(prottype) == S_ANY) /* bug 412 29/8/90 */
                  tlengthcheck(lengthexp);
                tload3regs(outputitemmode, outputitem, channelmode, channel,
                           P_EXP, lengthexp, loadseq);
              }
              /*}}}*/
            }
            /*}}}*/
          else
            {
              tload2regs(outputitemmode, outputitem, channelmode, channel, FALSE);
              genprimary(I_LDC, s);
            }
          tioop(I_OUT, usecall);
        }
        /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC void tinputitem(channelmode, channel, inputitemmode, inputitem, prottype)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tinputitem generates code to input 'inputitem' on channel
 *              (channelmode, channel)
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tinputitem ( int channelmode , treenode *channel , int inputitemmode , treenode *inputitem , treenode *prottype )
{
  const int usecall = iobycall && maybevirtualchan(channel);
  DEBUG_MSG(("tinputitem: usecall is %d\n", usecall));
  if (TagOf(inputitem) == S_COLON2)
    /*{{{  do counted input*/
    {
      treenode *countexp = LeftOpOf(inputitem),
               *arrayexp = RightOpOf(inputitem);
      treenode *leftprottype, *rightprottype;
      treenode *origexp  = countexp;          /* added for bug 864 */
      treenode *origtype = NTypeOf(countexp); /* ditto */
      int countmode = P_EXP;
      const int counttype = typeof(countexp);
      const int skiplab = newlab();
    
      /*{{{  set up leftprottype and rightprottype*/
      if (TagOf(prottype) == S_ANY)
        {
          leftprottype = prottype;
          rightprottype = prottype;
        }
      else
        {
          leftprottype = LeftOpOf(prottype);
          rightprottype = RightOpOf(prottype);
        }
      /*}}}*/
      /*{{{  input the count*/
      if (preeval(countmode, countexp))
        {
          countmode = P_TEMP;
          /* we initialise INT16 temporaries here, unlike normal, so that
             the sign extension goes better (bug 706 11/9/90) */
          if (/*istargetbytesize(counttype)*/ isshorttype(counttype))
            zero_local_var(countexp);
          /*{{{  input to the temporary*/
          tinputitem(channelmode, channel, P_TEMPPTR, countexp, leftprottype);
          /*}}}*/
          if (isshortint(counttype)) /* bug 706 11/9/90 */
            tsignextend(countexp, TRUE);
          /*{{{  move count to its real destination*/
          tsimpleassign(counttype, P_EXP, NDeclOf(countexp), P_TEMP, countexp, MANY_REGS);
          SetTag(countexp, T_PREEVALTEMP);
          /*}}}*/
        }
      else
        {
          countmode = P_EXP;
          /*{{{  input the count*/
          tinputitem(channelmode, channel, P_PTR, countexp, leftprottype);
          /*}}}*/
          if (isshortint(counttype)) /* bug 706 11/9/90 */
            /* must be a simplelocal, or would have been mapped to a temporary */
            tsignextend(countexp, FALSE);
        }
      /*}}}*/
      /*{{{  convert a long int to int if neccessary*/
      /* It will be in a temp if it isn't a local simple BYTE, or short INT */
      /* The only conversions that need checking are long ints to int */
      if (!fitsinword(counttype))
        /*{{{  convert long int temporary to int temporary*/
        {
          if (RANGECHECKING)
            {
              treenode *checktree;
              int old = switch_to_temp_workspace();
              if (isquadlength(counttype)) /* bug 1130 29/1/91 */
                checktree = makeconversion(counttype, S_INT, countexp, S_EXACT);
              else
                checktree = newmopnode(S_EXACT, NOPOSN, countexp, S_INT);
              switch_to_prev_workspace(old);
              texp(checktree, MANY_REGS);
            }
          if (intnodeptr == NULL) intnodeptr = newleafnode(S_INT, NOPOSN);
          SetNType(countexp, intnodeptr); /* bug 864 - see below */
        }
        /*}}}*/
      /*}}}*/
      /*{{{  if count = 0 goto skiplab*/
      texpopd(countmode, countexp, MANY_REGS);
      genbranch(I_CJ, skiplab);
      /*}}}*/
      /*{{{  preprocess the arrayexp*/
      /* The arrray expression may contain segments whose base and length
         cannot be calculated until the count has been inputted.  */
      tpreexp(arrayexp);
      /*}}}*/
      /*{{{  add rangecheck to count expression if neccessary*/
      if (RANGECHECKING)
        {
          const int old = switch_to_temp_workspace();
          countexp = newdopnode(S_CCNT1, NOPOSN, countexp, dimexpof(arrayexp, 0), S_INT);
          switch_to_prev_workspace(old);
        }
      /*}}}*/
      /*{{{  input array from 0 for count*/
      {
        int loadseq, preeval_e2, preeval_e3;
        treenode *lengthexp;
        /*{{{  lengthexp = countexp * scale*/
        {
          const INT32 b = bytesin(ARTypeOf(gettype(arrayexp)));
          if (b != 1)
            {
              const int old = switch_to_temp_workspace();
              lengthexp = newdopnode(S_TIMES, NOPOSN, countexp,
                                     newconstant(b), S_INT);
              switch_to_prev_workspace(old);
            }
          else
            lengthexp = countexp;
        }
        /*}}}*/
        /* We only do this call so that we have a loadseq parameter for
           tload3regs, ideally we should make the binder save loadseq
           in the tree. */
        loadseq = giveorder(P_PTR, arrayexp, channelmode, channel,
                            P_EXP, lengthexp, &preeval_e2, &preeval_e3);
        tload3regs(P_PTR, arrayexp, channelmode, channel, P_EXP, lengthexp, loadseq);
        tioop(I_IN, usecall);
      }
      /*}}}*/
      /*{{{  clear up the mess */
      /* bug 864 - if countexp was a long, we temporarily modified it
         to pretend that it was an INT. This reclaims the type tree. 28/1/91.
      */
      SetNType(origexp, origtype);
      /*}}}*/
      setlab(skiplab);
    }
    /*}}}*/
  else
    /*{{{  input an element*/
    {
      treenode *type = gettype(inputitem);
      const INT32 s = bytesin(type);
    #if 0 /*def DEBUG*/
      DEBUG_MSG(("tinputitem: bytesin is %ld, type is", s));
      printtree(0, type);
      DEBUG_MSG(("\n"));
    #endif
      if (s == (-1))
        /*{{{  length is an expression*/
        {
          /*{{{  check hidden dimensions*/
          if ((TagOf(prottype) != S_ANY) && RANGECHECKING)
            tcheckdimensions(type, prottype);
          /*}}}*/
          /*{{{  load operands for an 'in' instruction*/
          {
            int preeval_e2, preeval_e3;
            int loadseq;
            treenode *lengthexp;
          
            const int old = switch_to_temp_workspace();
            lengthexp = scaletreeof((TagOf(prottype) != S_ANY) ? prottype : type, S_BYTE);
            switch_to_prev_workspace(old);
          
            /* We only do this call so that we have a loadseq parameter for
               tload3regs, ideally we should make the binder save loadseq
               in the tree. */
            loadseq = giveorder(inputitemmode, inputitem, channelmode, channel,
                                P_EXP, lengthexp, &preeval_e2, &preeval_e3);
            if (TagOf(prottype) == S_ANY) /* bug 412 29/8/90 */
              tlengthcheck(lengthexp);
            tload3regs(inputitemmode, inputitem, channelmode, channel,
                       P_EXP, lengthexp, loadseq);
          }
          /*}}}*/
        }
        /*}}}*/
      else
        {
          tload2regs(inputitemmode, inputitem, channelmode, channel, FALSE);
          genprimary(I_LDC, s);
        }
      tioop(I_IN, usecall);
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void toutput(tptr)*/
/*****************************************************************************
 *
 *  toutput generates code for an OUTPUT node
 *
 *****************************************************************************/
PUBLIC void toutput ( treenode *tptr )
{
  treenode *channel = LHSOf(tptr),
           *outputlist = RHSOf(tptr);
  treenode *channeltype = gettype(channel);
  DEBUG_MSG(("toutput\n"));
  if (TagOf(channeltype) == S_PORT)
    /*{{{  handle PORT output*/
    {
      treenode *porttype;
      tpreexp(channel);
      tpreexp(ThisItem(outputlist));
      porttype = fixporttype(channel);
      tsimpleassign(typeof(channel), P_EXP, channel,
                              P_EXP, ThisItem(outputlist), MANY_REGS);
      restoreporttype(channel, porttype);
    }
    /*}}}*/
  else
    /*{{{  handle CHAN output*/
    {
      int channelmode = chanaspointer ? P_EXP : P_PTR;
      treenode *protocol = ProtocolOf(channeltype);
      int outputtag = FALSE; /* True when we are generating code to output a tag */
    
      /*{{{  find the protocol type*/
      if (TagOf(protocol) == N_SPROTDEF)
        protocol = NTypeOf(protocol);
      else if (TagOf(protocol) == N_TPROTDEF)
        /* Pick out the type tree of the tag node */
        {
          protocol = NTypeOf(CExpOf(ThisItem(outputlist)));
          outputtag = TRUE;
        }
      /*}}}*/
    
      tpreexp(channel);
      channelmode = simplify(channelmode, channel);
      while (!EndOfList(outputlist))
        /*{{{  output item of list, move to next item*/
        {
          treenode *prottype = ((protocol != NULL) && (TagOf(protocol) == S_LIST))
                                 ? ThisItem(protocol) : protocol;
          tpreexp(ThisItem(outputlist));
          toutputitem(channelmode, channel, P_EXP, ThisItem(outputlist), prottype);
          if ((protocol != NULL) && (TagOf(protocol) == S_LIST) && !outputtag)
            protocol = NextItem(protocol);
          outputtag = FALSE;
          outputlist = NextItem(outputlist);
        }
        /*}}}*/
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void tinput(tptr)*/
/*****************************************************************************
 *
 *  tinput generates code for an INPUT node
 *
 *****************************************************************************/
PUBLIC void tinput ( treenode *tptr )
{
  treenode *channel = LHSOf(tptr),
           *inputlist = RHSOf(tptr);

  DEBUG_MSG(("tinput\n"));
  switch (inputtypeof(tptr))
    {
      /*{{{  channel input*/
      case INP_INPUT:
        {
          int channelmode = chanaspointer ? P_EXP : P_PTR;
          treenode *protocol = ProtocolOf(gettype(channel));
          if (TagOf(protocol) == N_SPROTDEF)
            protocol = NTypeOf(protocol);
          tpreexp(channel);
          channelmode = simplify(channelmode, channel);
          while (!EndOfList(inputlist))
            /*{{{  input item of list, move to next item*/
            {
              treenode *prottype = (TagOf(protocol) == S_LIST) ? ThisItem(protocol)
                                                               : protocol;
              tpreexp(ThisItem(inputlist));
              tinputitem(channelmode, channel, P_PTR, ThisItem(inputlist), prottype);
              if (TagOf(protocol) == S_LIST)
                protocol = NextItem(protocol);
              inputlist = NextItem(inputlist);
            }
            /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  timer input*/
      case INP_TIMER_INPUT:
        {
          treenode *dest = ThisItem(inputlist);
          tpreexp(dest);
          tpreexp(channel);         /* Bug 288 22/5/90 */
          /*texp(channel, MANY_REGS);*/ /* Bug 288 22/5/90 */
          if (regsfor(dest) < MAXREGS)
            /*{{{  ldtimer; st dest*/
            {
              gensecondary(I_LDTIMER);
              storeinelement(dest, 0, MAXREGS - 1);
            }
            /*}}}*/
          else
            /*{{{  make pointer to dest, generate source, store through pointer*/
            {
              BIT32 offset = loadelementpointeroffset(dest, MANY_REGS);
              gensecondary(I_LDTIMER);
              gensecondary(I_REV);
              genprimary(I_STNL, offset);
            }
            /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  delayed input*/
      case INP_DELAYED_INPUT:
        tpreexp(inputlist);
        tpreexp(channel);         /* Bug 288 22/5/90 */
        /*texp(channel, MANY_REGS);*/ /* Bug 288 22/5/90 */
        texp(inputlist, MANY_REGS);
        gensecondary(I_TIN);
        break;
      /*}}}*/
      /*{{{  port input*/
      case INP_PORT_INPUT:
        tpreexp(channel);
        {
          treenode *porttype = fixporttype(channel);
          tpreexp(ThisItem(inputlist));
          tsimpleassign(typeof(channel), P_EXP, ThisItem(inputlist),
                                  P_EXP, channel, MANY_REGS);
          restoreporttype(channel, porttype);
        }
        break;
      /*}}}*/
      /*{{{  case input*/
      case INP_CASE_INPUT:
        tcaseinput(tptr);
        break;
      /*}}}*/
      /*{{{  tagged input*/
      case INP_TAGGED_INPUT:
        {
          int channelmode = chanaspointer ? P_EXP : P_PTR;
          treenode *tagtemp = inputlist;
          treenode *protocol;
          inputlist = NDeclOf(tagtemp);

          /* Pick out the type tree of the tag node */
          /* Tag node is the first item of the input list, but the mapper will
             have put a temporary on top of the input list */
          protocol = NTypeOf(CExpOf(ThisItem(inputlist)));

          tpreexp(channel);
          /*{{{  preevaluate pointer to channel, if neccessary*/
          channelmode = simplify(channelmode, channel);
          /*}}}*/
          /*{{{  input the tag*/
          zero_local_var(tagtemp); /* will always be a BYTE */
          tload2regs(P_TEMPPTR, tagtemp, channelmode, channel, FALSE);
                                                          /*           ldlp  temp      */
                                                          /*           ldptr channel   */
          loadconstant(ONE32);                            /*           ldc   1         */
          tioop(I_IN, iobycall && maybevirtualchan(channel)); /*           in              */
          SetTag(tagtemp, T_PREEVALTEMP);
          /*}}}*/
          /*{{{  compare inputted tag with required tag*/
          {
            treenode *snode;
            int continuelab = newlab();
            int old = switch_to_temp_workspace();
            snode = newdopnode(S_EQ, 0, tagtemp, ThisItem(inputlist), S_BYTE);
            switch_to_prev_workspace(old);
            tguard(snode, FALSE, continuelab);
            /*{{{  source output*/
            if (source_output)
              so_stop();
            /*}}}*/
            tstop(tptr);
            setlab(continuelab);
          }
          /*}}}*/
          /*{{{  input the rest of the items on the list*/
          inputlist = NextItem(inputlist);
          while (!EndOfList(inputlist))
            {
              tpreexp(ThisItem(inputlist));
              tinputitem(channelmode, channel, P_PTR, ThisItem(inputlist),
                         ThisItem(protocol));
              protocol  = NextItem(protocol);
              inputlist = NextItem(inputlist);
            }
          /*}}}*/
        }
        break;
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC void talt(tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  talt generates code for a complete ALT construct
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void talt ( treenode *tptr )
{
  int joinlab = newlab(), altendlab = newlab();
  int timedalt = timerguardinalt(tptr);
  int savedreplaltvaluesbase   = replaltvaluesbase;
  int savedreplaltstacklen     = replaltstacklen;
  treenode **savedreplaltstack = replaltstack;
  treenode *savedrepls = (nodetypeoftag(TagOf(tptr)) == CNODE) ?
                         CTempOf(tptr) : ReplCTempOf(tptr);
  /* This will be the number of nested levels of replicators: */
  int repllevels = allocsize(NTypeOf(savedrepls));

  DEBUG_MSG(("talt: mallocing size %d replaltstack\n", repllevels));
  /* add 1 to malloc-ed size to prevent problems with zero byte malloc */
  replaltstack = (treenode **)memalloc(sizeof(treenode *) * repllevels + 1);
  replaltstacklen = 0;
  /*replaltvaluesbase = NVOffsetOf(savedrepls);*/
  replaltvaluesbase = NVOffsetOf(savedrepls) + nameoffsetof(NLexLevelOf(savedrepls));

  nalternatives = numberofalternatives(tptr);
  if (nalternatives != 0)
    /*{{{  generate the alternatives*/
    {
      alternativecount = 0;
      inreplalt = FALSE;
      altcheckneeded = (NEED_ERRORS && !hastruealtguard(tptr));
      altcheckdone = FALSE;
      gensecondary(timedalt ? I_TALT : I_ALT);
      insidealtguard = TRUE; alt_ds = timedalt ? DS_WAIT : DS_IO;
      /*{{{  check if we need to initialise degenerate alt trap*/
      if (altcheckneeded)
        {
          int inittemp = TRUE;
          treenode *alt = tptr;
          while (alt != NULL && TagOf(alt) != S_ALTERNATIVE)
            /*{{{  walk down to the first alternative*/
            {
              alt = skipspecifications(alt);
              switch(TagOf(alt))
                {
                  case S_ALT: case S_PRIALT:
                    alt = CBodyOf(alt);
                    break;
                  case S_LIST:
                    alt = ThisItem(alt);
                    break;
                  case S_REPLALT: case S_PRIREPLALT:
                    alt = NULL;
                    break;
                  case S_ALTERNATIVE:
                    break;
                }
            }
            /*}}}*/
      
          if (alt != NULL && TagOf(alt) == S_ALTERNATIVE)
            /*{{{  if (don't need to init. temp) inittemp = FALSE*/
            {
              treenode *input = skipspecifications(AltInputOf(alt));
              treenode *guard = AltGuardOf(alt);
              switch (inputtypeof(input))
                {
                  case INP_SKIP:
                  case INP_TIMER_INPUT:
                  case INP_PORT_INPUT:
                    inittemp = FALSE;
                    break;
                  case INP_INPUT:
                  case INP_CASE_INPUT:
                  case INP_TAGGED_INPUT:
                    if (istrueguard(guard) || !cancauseerror(LHSOf(input)))
                      inittemp = FALSE;
                    break;
                  case INP_DELAYED_INPUT:
                    if (istrueguard(guard) || !cancauseerror(RHSOf(input)))
                      inittemp = FALSE;
                    break;
                }
            }
            /*}}}*/
      
          if (inittemp)
            {
              genprimary(I_LDC, 1);
              genprimary(I_STL, 0);
            }
        }
      /*}}}*/
      taltenables(tptr);
      /*{{{  check for degenerate ALT (if not done already)*/
      if (altcheckneeded && !altcheckdone)
        {
          genprimary(I_LDL, 0);
          genprimary(I_LDC, 1);
          gensecondary(I_CCNT1);
        }
      /*}}}*/
      if (alternativecount == 0)
        {
          /* all replicators must have had zero counts */
          if (source_output)
            so_stop();
          tstop (tptr);
        }
      else
        gensecondary(timedalt ? I_TALTWT : I_ALTWT);
      disable_csub0 = TRUE;
      taltdisables(tptr, altendlab);
      disable_csub0 = FALSE;
      insidealtguard = FALSE;
      if (alternativecount != 0)
        gensecondary(I_ALTEND);
      setlab(altendlab);
      /*{{{  generate all the bodies*/
      {
        treenode **altbodystack;
        int nestedalts = countnestedalts(tptr, NESTED_ALTS);
        DEBUG_MSG(("talt: mallocing size %d altbodystack\n", nestedalts));
        altbodystack = (treenode **)memalloc(sizeof(treenode *) * nestedalts);
        taltbodies(tptr, joinlab, altbodystack, 0); /* Generate all the bodies */
        DEBUG_MSG(("talt: freeing size %d altbodystack\n", nestedalts));
        memfree(altbodystack);
      }
      /*}}}*/
      setlab(joinlab);
      genstartblock();
    }
    /*}}}*/
  else
    {
      /*{{{  source output*/
      if (source_output)
        so_stop();
      /*}}}*/
      tstop (tptr);
    }
  DEBUG_MSG(("talt: freeing size %d replaltstack\n", repllevels));
  memfree(replaltstack);
  replaltvaluesbase = savedreplaltvaluesbase;
  replaltstacklen   = savedreplaltstacklen;
  replaltstack      = savedreplaltstack;
}
/*}}}*/
/*}}}*/
