/*#define DEBUG*/
/*****************************************************************************
 *
 *  Code generator gen1 - main driver
 *
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *
 *****************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include <string.h>
# include "includes.h"
# include "instdef.h"
# include "instruct.h"
# include "genhdr.h"
# include "generror.h"
# include "lexdef.h"
# include "syndef.h"
# include "chkdef.h"
# include "desc1def.h"
# include "trandef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen7def.h"
# include "gen8def.h"
# include "gen9def.h"
# include "gen10def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
# include "debugdef.h"
# include "srcoutde.h"
/*}}}*/

/*{{{  global variables*/
PUBLIC SOURCEPOSN genlocn;
PUBLIC BIT32 vspoffset;
PUBLIC treenode *trueguard = NULL;
PUBLIC BIT32 constptr; /* Offset of constant pointer in workspace */
PUBLIC wordnode *tempname_p = NULL;
PUBLIC int instancedlevel;
PUBLIC int initlexlevel;
PUBLIC int insidealtguard; /* TRUE when we are mapping, or code generating
                              an alternative Boolean guard. */
PUBLIC int alt_ds;

PUBLIC int inside_asm;  /* Used to stop error handling while in ASM or GUY */
PUBLIC int disable_csub0 = FALSE; /* Used to prevent checking when disabling ALTs */
/*}}}*/

/*{{{  local variables*/
/* Label marking the start of the scalar constant table */
PRIVATE int scalarconstlab;
PRIVATE treenode *globaltablechain;

PRIVATE char* tempname = "temporary";

PRIVATE treenode *replaltvar = NULL;
PRIVATE int       replaltlevel;
/*}}}*/

/*{{{  routines*/
/*{{{  forward definitions*/
PRIVATE void tnestedroutines PARMS((treenode *tptr));
PRIVATE void tif PARMS((treenode *tptr, int *trueguard, int endlabel));
/*}}}*/
/*{{{  generating constructs*/
/*{{{  PRIVATE void tguy (tptr)*/
/*****************************************************************************
 *
 *  tguy generates code for a GUY tree
 *
 *****************************************************************************/
PRIVATE void tguy_or_asm ( treenode *tptr , int guy_not_asm )
{
  genlocn = LocnOf(tptr);
  if (debugoutput && need_locate(TagOf(tptr)))
    genlocate(tptr);
  inside_asm = TRUE;
  switch(TagOf(tptr))
    {
      /*{{{  S_LABELDEF*/
      case S_LABELDEF:
        setlab((int)NVOffsetOf(DNameOf(tptr)));
        break;
      /*}}}*/
      /*{{{  S_GUYSTEP*/
      case S_GUYSTEP:
        gensecondary(DOpTypeOf(tptr) | I_STEP_BIT);
        break;
      /*}}}*/
      /*{{{  S_GUYCODE*/
      case S_GUYCODE:
        {
          treenode *operand = RightOpOf(tptr);
          int instruction = DOpTypeOf(tptr);
          operand = foldexplist(operand);  /* fold in any special ASM names */
          if (instruction & I_PRIMARY)
            /*{{{  generate a primary instruction*/
            {
              instruction &= ~I_PRIMARY;
              operand = ThisItem(operand);  /* Only one in list for a primary */
              switch (TagOf(operand))
                {
                  /*{{{  S_CONSTEXP*/
                  case S_CONSTEXP:
                    genprimary(instruction, LoValOf(operand));
                    break;
                  /*}}}*/
                  /*{{{  N_LABELDEF*/
                  case N_LABELDEF:
                    genbranch(instruction, (int)NVOffsetOf(operand));
                    break;
                  /*}}}*/
                  /*{{{  other name or ARRAYITEM*/
                  case N_DECL: case N_REPL:
                  case N_VALABBR: case N_ABBR:
                  case N_RETYPE: case N_VALRETYPE:
                  case N_PARAM: case N_VALPARAM:
                  case S_ARRAYITEM: case S_CONSTCONSTRUCTOR:
                    if (guy_not_asm)
                      {
                        if (chanaspointer && (basetype(gettype(operand)) == S_CHAN))
                          generr(GEN_GUY_NO_CHANS);
                        switch (instruction)
                          {
                            case I_LDL:  case I_LDNL:  loadelement(operand, 0, MANY_REGS);        break;
                            case I_LDLP: case I_LDNLP: loadelementpointer(operand, 0, MANY_REGS); break;
                            case I_STL:  case I_STNL:  storeinelement(operand, 0, MANY_REGS);     break;
                            default:
                              DEBUG_MSG(("got a symbolic name for a primary\n"));
                              generr_s(GEN_BAD_PRIMARY_OPERAND,
                                       WNameOf((wordnode *)LeftOpOf(tptr)));
                              break;
                          }
                      }
                    else
                      {
                        if (TagOf(operand) == S_ARRAYITEM)
                          generr_s(GEN_BAD_PRIMARY_OPERAND,
                                   WNameOf((wordnode *)LeftOpOf(tptr)));
                        genprimary(instruction, NVOffsetOf(operand) + nameoffsetof(NLexLevelOf(operand)));
                        gencomment0(WNameOf(NNameOf(operand)));
                      }
                    break;
                  /*}}}*/
                  /*{{{  error*/
                  default:
                    /*badtag(genlocn, TagOf(tptr), "tguy-primary");*/
                    if (wouldbeconst(operand))  /* must have failed to fold a special ASM name */
                      /* This will fail with a sensible error message */
                      texp(operand, MANY_REGS);
                    else
                      generr_s(GEN_BAD_PRIMARY_OPERAND,
                               WNameOf((wordnode *)LeftOpOf(tptr)));
                  /*}}}*/
                }
            }
            /*}}}*/
          else if ((instruction & I_PSEUDO_OP) &&
                   (((instruction & INST_MASK) == I_BYTE) || ((instruction & INST_MASK) == I_WORD)))
            /*{{{  generate the BYTE or WORD values*/
            {  /* these can have any number of operands */
              while (operand != NULL)
                {
                  switch(TagOf(ThisItem(operand)))
                    {
                      case S_CONSTEXP:
                        {
                          INT32 val = LoValOf(ThisItem(operand));
                          BYTE buf[4];
                          int i;
                          int len = (instruction & INST_MASK) == I_BYTE ? 1 : bytesperword;
                          for (i = 0; i < len; i++)
                            {
                              buf[i] = (BYTE)(val & 0xff);
                              val >>= 8;
                            }
                          add_code_block(len, buf);
                        }
                        break;
                      case S_STRING: case S_CONSTCONSTRUCTOR:
                        {
                          wordnode *s =
                            (wordnode *)CTValOf(ThisItem(operand));
                          add_code_block(WLengthOf(s), (BYTE *)WNameOf(s));
                        }
                        break;
                      case N_VALABBR: case N_VALRETYPE:
                        /* Must be a name of a constant array */
                        {
                          wordnode *s =
                            (wordnode *)CTValOf(DValOf(NDeclOf(ThisItem(operand))));
                          add_code_block(WLengthOf(s), (BYTE *)WNameOf(s));
                        }
                        break;
                      default:
                        badtag(genlocn, TagOf(ThisItem(operand)), "tguy-BYTE/WORD");
                    }
                  operand = NextItem(operand);
                }
            }
            /*}}}*/
          else if (instruction & I_PSEUDO_OP)
            /*{{{  generate other pseudo ops*/
            {
              treenode **operands[MAXREGS];
              int        opmodes[MAXREGS];
              int ops = setup_asm_operands(operand, operands, opmodes);
              switch (instruction & INST_MASK)
                {
                  case I_LD:
                    texpopd(opmodes[0], *operands[0], MANY_REGS);
                    break;
                  case I_LDAB:
                    tload2regs(opmodes[0], *operands[0],
                               opmodes[1], *operands[1], FALSE);
                    break;
                  case I_LDABC:
                    {
                      int loadseq, preeval1, preeval2;
                      loadseq = giveorder(opmodes[0], *operands[0],
                                          opmodes[1], *operands[1],
                                          opmodes[2], *operands[2],
                                          &preeval1, &preeval2);
                      tload3regs(opmodes[0], *operands[0],
                                 opmodes[1], *operands[1],
                                 opmodes[2], *operands[2], loadseq);
                    }
                    break;
                  case I_ST: case I_STAB: case I_STABC:
                    tstoreregs(operands, ops);
                    break;
                  case I_AJWRET:
                    genprimary (I_AJW, asmvalues[ASMNAME_WSSIZE]);
                    gensecondary (I_RET);
                    break;
                  case I_LDRETP:
                    genprimary (I_LDLP, asmvalues[ASMNAME_WSSIZE]);
                    break;
                  case I_LDLABELDIFF:
                    genlabeldiff(I_LDC, (int)NVOffsetOf(*operands[1]),
                                        (int)NVOffsetOf(*operands[0]));
                    break;
                  default:
                    badtag(genlocn, TagOf(tptr), "tguy-pseudo");
                }
            }
            /*}}}*/
          else if (instruction & I_FPU_ENTRY_BIT)
            genfpuentry(instruction);
          else
            gensecondary(instruction);
        }
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "tguy");
    }
  inside_asm = FALSE;
}
PRIVATEPARAM void tguy ( treenode *tptr )
{
  tguy_or_asm(tptr, TRUE);
}
PRIVATEPARAM void tasm ( treenode *tptr )
{
  tguy_or_asm(tptr, FALSE);
}
/*}}}*/
/*{{{  PRIVATE void tdecl_init_from_vsptr*/
PRIVATE void tdecl_init_from_vsptr(treenode *nptr)
{
  if (isinvectorspace(nptr) && (vspoffset != NVOffsetOf(nptr)))
    /* if (vspoffset == NVOffset), the variable has been overlaid onto the
       vectorspace pointer */
    {
      loadnewvsp(NVVSOffsetOf(nptr));
      storeinname(nptr, 0);
    }
}
/*}}}*/
/*{{{  PRIVATE void tdecl (nptr)*/
/*****************************************************************************
 *
 *  tdecl translates a declaration, outputting code to initialise a variable,
 *        if neccessary.
 *
 *****************************************************************************/
PRIVATE void tdecl ( treenode *nptr )
{
  switch (TagOf(nptr))
    {
      /*{{{  N_DECL*/
      case N_DECL:
        if ((NVUseCountOf(nptr) != 0) && !isplaced(nptr))
          {
            treenode *type = NTypeOf(nptr);
            tdecl_init_from_vsptr(nptr);
            switch (TagOf(type))
              {
                /*{{{  CHAN initialised to MINT*/
                case S_CHAN:
                  /* Generate code to initialise channel */
                  if (chanaspointer)
                    {
                      if (issimplechan(nptr))
                        {
                          gensecondary(I_MINT);
                          storeinname(nptr, 0);
                        }
                      else
                        {
                          gensecondary(I_MINT);
                          storeinname(nptr, 1);
                          loadnamepointer(nptr, 1);
                          storeinname(nptr, 0);
                        }
                    }
                  else
                    {
                      gensecondary(I_MINT);
                      storeinname(nptr, 0);
                    }
                  break;
                /*}}}*/
                /*{{{  BOOL BYTE short int initialised to zero*/
                case S_BOOL:
                case S_BYTE:
                  zero_local_var(nptr);
                  break;
                #if 0  /* bug 328 11/9/90 */
                case S_INT16:
                  if (targetintsize == S_INT32)
                    zero_local_var(nptr);
                  break;
                #endif
                /*}}}*/
                /*{{{  ARRAY if CHAN initialise each element to MINT*/
                case S_ARRAY:
                  if (basetype(type) == S_CHAN)
                    {
                      INT32 e = elementsin(type);
                      if (complexinitialise(type))
                        /*{{{  generate a loop to initialise the variable*/
                        {
                          BIT32 base = ZERO32,  /* Use bottom two words of workspace for */
                                count = ONE32;  /* base and count */
                          int looplab = newlab();
                          loadnamepointer(nptr, 0);             /*          ldlp name      */
                          genprimary(I_STL, base);              /*          stl  base      */
                          genprimary(I_LDC, e);                 /*          ldc  elements  */
                          genprimary(I_STL, count);             /*          stl  count     */
                          setlab(looplab);                      /* looplab:                */
                          genprimary(I_LDL, count);             /*          ldl   count     */
                          genprimary(I_ADC, -1);                /*          adc   -1        */
                          genprimary(I_STL, count);             /*          stl   count     */
                          if (chanaspointer)
                            {
                              genprimary(I_LDL, base);          /*          ldl   base      */
                              genprimary(I_LDNLP, e);           /*          ldnlp elements */
                              genprimary(I_LDL, base);          /*          ldl   base      */
                              genprimary(I_STNL, 0);            /*          stnl  0         */
                            }
                          gensecondary(I_MINT);                 /*          mint           */
                          genprimary(I_LDL, base);              /*          ldl   base      */
                          if (chanaspointer)
                            genprimary(I_STNL, e);              /*          stnl  e         */
                          else
                            genprimary(I_STNL, ZERO32);         /*          stnl  0         */
                          genprimary(I_LDL, base);              /*          ldl   base      */
                          genprimary(I_LDNLP, 1);               /*          ldnlp 1        */
                          genprimary(I_STL, base);              /*          stl   base      */
                          genprimary(I_LDL, count);             /*          ldl   count     */
                          genprimary(I_EQC, ZERO32);            /*          eqc   0         */
                          genbranch(I_CJ, looplab);             /*          cj    looplab   */
                        }
                        /*}}}*/
                      else
                        /*{{{  initialise each element individually*/
                        {
                          INT32 i, offset=0;
                          if (chanaspointer)
                            {
                              /*{{{  init pointers*/
                              for (i = 0; i < e; i++)
                                {
                                  if (ispointer(nptr))
                                    {
                                      loadnamepointer(nptr, 0);
                                      genprimary(I_LDNLP, i+e);
                                      loadnamepointer(nptr, 0);
                                      genprimary(I_STNL, i);
                                    }
                                  else
                                    {
                                      loadnamepointer(nptr, i+e);
                                      storeinname(nptr, i);
                                    }
                                }
                              /*}}}*/
                              offset = e;
                            }
                          for (i = 0; i < e; i++)
                            {
                              gensecondary(I_MINT);
                              if (ispointer(nptr))
                                {
                                  loadnamepointer(nptr, 0);
                                  genprimary(I_STNL, i+offset);
                                }
                              else
                                storeinname(nptr, i+offset);
                            }
                        }
                        /*}}}*/
                    }
                  break;
                /*}}}*/
                default:
                  break;
              }
          }
        break;
      /*}}}*/
      /*{{{  N_PARAM N_VALPARAM*/
      case N_PARAM:
      case N_VALPARAM:
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(nptr), "tdecl");
    }
}
/*}}}*/
/*{{{  PRIVATE int align_requirement()*/
PRIVATE int align_requirement(treenode *lhstype, treenode *rhstype, treenode *rhs)
{
  const int newsize = bytesinscalar(basetype(lhstype));
  const int oldsize = bytesinscalar(basetype(rhstype));
  if ((errormode & ERRORMODE_ALIGNCHECK) && (oldsize < newsize) &&
      (
       /* byte alignment going to half word alignment: */
       (newsize < bytesperword) ||
       /* short alignment going to word alignment: */
       (oldsize < bytesperword && newsize >= bytesperword)
      ))
    {
      /* newsize will be either 2, 4, or 8, because oldsize < newsize */
      const int alignsize = min(newsize, bytesperword); /* half word or word */
      if (check_aligned(rhs, alignsize))
        return 1; /* means we don't need to check alignment */
      return alignsize;
    }
  return 1;  /* align to any byte boundary */
}
/*}}}*/
/*{{{  PRIVATE void genaligncheck*/
PRIVATE void genaligncheck(int alignment)
{
  loadconstant(alignment - 1);
  gensecondary(I_AND);
  loadconstant(1);
  gensecondary(I_CSUB0);
  gencomment0("alignment check");
  checkerror();  /* added 22/6/90 by CO'N */
}
/*}}}*/
/*{{{  PUBLIC void tspecification (tptr)*/
/* Generate code for a specification (ie. initialise channel, Boolean,
....
*/
PUBLIC void tspecification ( treenode *tptr )
{
  treenode *nptr = DNameOf(tptr);
  genlocn = LocnOf(tptr);
  if (debugoutput && need_locate(TagOf(tptr)) && !separatelycompiled(nptr))
    genlocate(tptr);
  switch (TagOf(tptr))
    {
      /*{{{  S_VALABBR S_ABBR S_VALRETYPE S_RETYPE*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
        {
          int am = abbrevmode(tptr);
          treenode *rhs     = DValOf(tptr);
          treenode *lhstype = NTypeOf(nptr);
          treenode *rhstype = gettype(rhs);
          tpreexp(rhs);
          if (TagOf(tptr) == S_VALRETYPE || TagOf(tptr) == S_RETYPE)
            {
              treenode *type = lhstype;
              /*{{{  look for open dimensions*/
              {
                INT32 scalarsize = bytesinscalar(basetype(type));
                INT32 lsize = scalarsize;
                treenode *opendimension = NULL;
              
                while (TagOf(type) == S_ARRAY)
                  /*{{{  look for an open dimension, calculate product of known dimensions*/
                  {
                    if (ARDimOf(type) == (-1))
                      opendimension = ARDimLengthOf(type);
                    else
                      lsize *= ARDimOf(type);
                    type = ARTypeOf(type);
                  }
                  /*}}}*/
                if (opendimension != NULL)
                  /*{{{  handle the open dimension*/
                  {
                    INT32 rsize = ONE32;
                    /*{{{  calculate rsize*/
                    {
                      treenode *rt;
                      for (rt = rhstype; TagOf(rt) == S_ARRAY; rt = ARTypeOf(rt))
                        if (ARDimOf(rt) != (-1))
                          rsize *= ARDimOf(rt);
                      rsize *= bytesin(rt);
                    }
                    /*}}}*/
                    if (rsize % lsize == 0)
                      /*{{{  don't need to check, just calculate open dimension*/
                      {
                        if (TagOf(opendimension) == T_TEMP)
                          {
                            treenode *runknown;
                            int old = switch_to_temp_workspace();
                            /*{{{  runknown := tree representing bytes in rhs / lsize*/
                            runknown = unknowndimsof(rhstype);
                            {
                              const INT32 scale = rsize / lsize;
                              if (scale != 1)
                                runknown = newdopnode(S_TIMES, 0, runknown,
                                             newconstexpnode(S_CONSTEXP, 0, dummyexp_p,
                                                      ZERO32, scale), S_INT);
                            }
                            /*}}}*/
                            switch_to_prev_workspace(old);
                            texp(runknown, MANY_REGS);
                            /* check if the open dimension could overflow */
                            if (RANGECHECKING &&
                              (scalarsize * lsize <= bytesperword))
                              {
                                gensecondary(I_MINT);
                                gensecondary(I_CSUB0);
                              }
                            storeinname(opendimension, 0);
                            SetTag(opendimension, T_PREEVALTEMP);
                          }
                      }
                      /*}}}*/
                    else
                      /*{{{  check and calculate open dimension*/
                      {
                        treenode *runknown;
                        int old = switch_to_temp_workspace();
                        /*{{{  runknown := tree representing bytes in rhs*/
                        runknown = unknowndimsof(rhstype);
                        if (rsize != 1)
                          /*{{{  ruknown := runknown * rsize*/
                          runknown = newdopnode(S_TIMES, 0, runknown,
                                       newconstexpnode(S_CONSTEXP, 0, dummyexp_p,
                                                       ZERO32, rsize), S_INT);
                          /*}}}*/
                        /*}}}*/
                        switch_to_prev_workspace(old);
                        if (RANGECHECKING)
                          /*{{{  check rhs size and lhs size match*/
                          {
                            texp(runknown, MANY_REGS);
                            loadconstant(lsize);
                            gensecondary(I_REM);
                            loadconstant(ONE32);
                            gensecondary(I_CSUB0);
                          }
                          /*}}}*/
                        if (TagOf(opendimension) == T_TEMP)
                          /*{{{  calculate the open dimension*/
                          {
                            texp(runknown, MANY_REGS);
                            loadconstant(lsize);
                            gensecondary(I_DIV);
                            /* check if the open dimension could overflow */
                            if (RANGECHECKING &&
                              (scalarsize * lsize <= bytesperword))
                              {
                                gensecondary(I_MINT);
                                gensecondary(I_CSUB0);
                              }
                            storeinname(opendimension, 0);
                            SetTag(opendimension, T_PREEVALTEMP);
                          }
                          /*}}}*/
                      }
                      /*}}}*/
                  }
                  /*}}}*/
              }
              /*}}}*/
            }
          else
            tcheckdimensions(lhstype, rhstype);
      
          if (NVUseCountOf(nptr) != 0)
            /*{{{  generate the abbreviation*/
            {
              switch (am)
                {
                  /*{{{  AM_CONST AM_ISRHS*/
                  case AM_CONST:
                  case AM_ISRHS: break;
                  /*}}}*/
                  /*{{{  AM_PTR*/
                  case AM_PTR:
                    loadelementpointer(rhs, 0, MANY_REGS);
                    storeinname(nptr, 0);
                    /*{{{  check source is correctly aligned where necessary*/
                    {
                      int alignment = align_requirement(lhstype, rhstype, rhs);
                      if (alignment != 1)
                        {
                          loadelementpointer(nptr, 0, MANY_REGS);
                          genaligncheck(alignment);
                        }
                    }
                    /*}}}*/
                    /* we check the error flag here, so that we won't */
                    /* duplicate any check which was done in genaligncheck */
                    /* no problem about doing it after the store, cos */
                    /* there couldn't have been anything useful there before */
                    checkerror(); /* added 22/6/90 by CO'N */
                    break;
                  /*}}}*/
                  /*{{{  AM_VAL*/
                  case AM_VAL:
                    {
                  #if 1  /* alignment checks for VAL RETYPE */
                      int alignment = align_requirement(lhstype, rhstype, rhs);
                      if (TagOf(tptr) == S_VALRETYPE && alignment != 1 && isaddressable(rhs))
                        {
                          /* Special case the alignment requirements */

                          /* If we've got to here, the lhs is an INT or INT16 */
                          /* Eg VAL INT x RETYPES [a FROM b FOR c] : */

                          /* if rhs is an expression, it can't be misaligned */
                          /* so if rhs is not addressable, it can't be misaligned! */

                          /* Use the location itself to save the address in while */
                          /* we check for alignment */
                          loadelementpointer(rhs, 0, MANY_REGS);
                          /* we DON'T check the error flag here, so that we won't */
                          /* duplicate any check which was done in genaligncheck */
                          /* no problem about doing it after the store, cos */
                          /* there couldn't have been anything useful there before */
                          storeinname(nptr, 0);
                          loadelement(nptr, 0, MANY_REGS);
                          genaligncheck(alignment); /* this will check the error flag */
                          loadelement(nptr, 0, MANY_REGS); /* pointer to source */
                          if (alignment == bytesperword)
                            {
                              genprimary(I_LDNL, 0);
                              storeinname(nptr, 0);
                            }
                          else /* it must be smaller than a word */
                            {
                              if (alignment == 1) /* bug 328 11/9/90 */
                                zero_local_var(nptr);
                              loadelementpointer(nptr, 0, MANY_REGS); /* pointer to dest */
                              loadconstant(alignment);     /* Size of data */
                              gensecondary(I_MOVE);
                            }
                        }
                      else
                  #endif
                        {
                        if (TagOf(tptr) == S_VALRETYPE)
                          {
                            /* Initialise lhs if necessary */
                            int t = TagOf(lhstype);
                            if (istargetbytesize(t) /*|| isshortint(t)*/) /* bug 328 11/9/90 */
                              zero_local_var(nptr);
                            /* Pretend it's an abbreviation while we initialise it */
                            SetNType(nptr, rhstype);
                          }
                        tdecl_init_from_vsptr(nptr);
                        tsimpleassign(typeof(nptr), P_EXP, nptr, P_EXP, rhs, MANY_REGS);
                      
                        SetNType(nptr, lhstype); /* Give the name it's original type back */
                        }
                    }
                    break;
                  /*}}}*/
                }
            }
            /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  S_DECL*/
      case S_DECL:
        /* Declare each of the names in a declaration list */
        {
          treenode *t = DNameOf(tptr);
          if (TagOf(t) == S_LIST)
            while (!EndOfList(t))
              {
                tdecl(ThisItem(t));
                t = NextItem(t);
              }
          else
            tdecl (t);
        }
        break;
      /*}}}*/
      /*{{{  S_TPROTDEF S_SPROTDEF S_SFUNCDEF S_LFUNCDEF S_PROCDEF place  ignore*/
      case S_TPROTDEF:
      case S_SPROTDEF:
      case S_SFUNCDEF:
      case S_LFUNCDEF:
      case S_PROCDEF:
      case S_PLACE:
      case S_VSPLACE:
      case S_WSPLACE:
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "tspecification");
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *tspecs  (treenode *tptr)*/
PUBLIC treenode *tspecs ( treenode *tptr )
{
  while (isspecification(tptr))
    {
      tspecification(tptr);
      tptr = DBodyOf(tptr);
    }
  return tptr;
}
/*}}}*/
/*{{{  PUBLIC void tpreexp(tptr)*/
/*****************************************************************************
 *
 *  tpreexp generates code which has to be pulled out in front of an
 *          expression.
 *          At the moment this is segment base and length checking.
 *          Also generates the left-hand sides of eval nodes.
 *
 *****************************************************************************/
PUBLIC void tpreexp ( treenode *tptr )
{
  while (tptr != NULL)
    switch(TagOf(tptr))
      {
        default:
          badtag(genlocn, TagOf(tptr), "tpreexp");
          break;
        /*{{{  expression*/
        /*{{{  monadics conversions   break*/
        case S_NEG:case S_BITNOT: case S_UMINUS:
        case S_NOT: case S_SIZE: case S_EXACT: case S_TRUNC: case S_ROUND:
        case S_ADDRESSOF:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  dyadics                break*/
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
        case S_BITAND: case S_BITOR: case S_XOR:
        case S_LSHIFT: case S_RSHIFT:
        case S_PLUS: case S_MINUS: case S_TIMES:
        case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE: case S_AFTER:
        case S_CSUB0: case S_CCNT1:
          tpreexp(LeftOpOf(tptr));
          tptr = RightOpOf(tptr);
          break;
        case S_AND: case S_OR:
          /* Can't go into the right-hand side yet, as it may not be evaluated */
        case S_COLON2:
          /* Can't go into the right-hand side yet, as it may require the left-hand
             side to have been inputted first.  Right-hand side must be done
             explicitly in tinputitem/toutputitem */
          tptr = LeftOpOf(tptr);
          break;
        case S_EVAL:
          if (TagOf(LeftOpOf(tptr)) != S_DUMMYEXP)
            {
              tpreexp(LeftOpOf(tptr));
              texp(LeftOpOf(tptr), MANY_REGS);
              checkerror ();
            }
          tptr = RightOpOf(tptr);
          break;
        /*}}}*/
        /*{{{  specification ... valof      return*/
        case S_ABBR:     case S_VALABBR:
        case S_RETYPE:   case S_VALRETYPE:
        case S_DECL:
        case S_PROCDEF:  case S_SFUNCDEF:  case S_LFUNCDEF:
        case S_TPROTDEF: case S_SPROTDEF:
        case S_VALOF:
        case S_PLACE:    case S_WSPLACE:   case S_VSPLACE:
          return;
        /*}}}*/
        /*{{{  constructor            break*/
        case S_CONSTRUCTOR:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  instance               break*/
        case S_FINSTANCE:
          tptr = IParamListOf(tptr);
          break;
        /*}}}*/
        case S_ELSIZE:
        case S_SEGSTART:
        case S_CONSTEXP:
        case S_DUMMYEXP:
        case S_STRING:
        case S_CONSTCONSTRUCTOR:
          return;
        /*}}}*/
        /*{{{  element*/
        /*{{{  ARRAYITEM              break*/
        case S_ARRAYITEM:
        case S_ARRAYSUB:
          {
            treenode *exp = ASExpOf(tptr);
            tpreexp(ASBaseOf(tptr));
            tpreexp(exp);
            if (RANGECHECKING && (TagOf(tptr) == S_ARRAYITEM) &&
                (basetype(gettype(tptr)) == S_TIMER) &&
                (exp != NULL) && !isconst(exp) )
              {   /* Bug 288 22/5/90 */
                /* exp should always be TIMES index 0, so we can
                   avoid the multiply by: */
                if ((TagOf(exp) == S_TIMES) && isconst(RightOpOf(exp)))
                  texp(LeftOpOf(exp), MANY_REGS);
                else
                  texp(exp, MANY_REGS);
              }
          }
          return;
        /*}}}*/
        /*{{{  SEGMENT SEGMENTITEM          return*/
        case S_SEGMENT:
        case S_SEGMENTITEM:
          {
            treenode *startexp  = SStartExpOf(tptr),
                     *lengthexp = SLengthExpOf(tptr),
                     *checkexp  = SCheckExpOf(tptr);
        
            tpreexp(SNameOf(tptr));  /* Check nested segments first */
            tpreexp(startexp);
            tpreexp(lengthexp);
        
            simplify(P_EXP, startexp);
            simplify(P_EXP, lengthexp);
        
            if (checkexp != NULL)
              texp(checkexp, MANY_REGS);
          }
          return;
        /*}}}*/
        /*{{{  TEMP                   break*/
        case T_TEMP:
          tptr = NDeclOf(tptr);
          break;
        /*}}}*/
        /*{{{  name*/
        case N_ABBR: case N_VALABBR:
        case N_RETYPE: case N_VALRETYPE:
        case N_PARAM: case N_VALPARAM:
        case N_DECL: case N_REPL:
        case T_PREEVALTEMP: case T_REGTEMP:
        case N_LABELDEF :
          return;
        /*}}}*/
        /*{{{  backend names*/
        case S_PARAM_STATICLINK:
        case S_PARAM_VSP:
        case S_FNFORMALRESULT:
        case S_FNACTUALRESULT:
        case S_HIDDEN_PARAM:
          return;
        /*}}}*/
        /*}}}*/
        /*{{{  list                   break*/
        case S_LIST:
          tpreexp(ThisItem(tptr));
          tptr = NextItem(tptr);
          break;
        /*}}}*/
      }
}
/*}}}*/
/*{{{  PUBLIC void tstop (address)*/
PUBLIC void tstop ( treenode *address )
{
  if (debugoutput)
    genlocate(address);
  if (errormode & ERRORMODE_STOP_IS_SETERR)
    gensecondary(I_SETERR);
  if (errormode & ERRORMODE_STOP_IS_STOPP)
    gensecondary (I_STOPP);
  markdeadcode();
}
/*}}}*/
/*{{{  PUBLIC void trepl (tptr, tbody, p1, p2)*/
/*****************************************************************************
 *
 *  trepl generates code for the replicator node tptr:
 *        the function param tbody is called to generate code for the
 *        body of the replicator.
 *
 *****************************************************************************/
/* p1 and p2 are Parameters to the call of tbody */
PUBLIC void trepl ( treenode *tptr , void (*tbody )(), BIT32 p1 , BIT32 p2 )
  {
    int looplab = newlab(),
        endlab = newlab();
    treenode *replname = ReplCNameOf(tptr);
    int constlength = FALSE;
    if (isconst(ReplCLengthExpOf(tptr)))
      /*{{{  return if zero replicator, else constlength = TRUE*/
      {
        if (LoValOf(ReplCLengthExpOf(tptr)) == ZERO32)
          return;
        else
          constlength = TRUE;
      }
      /*}}}*/
    /*{{{  generate the code*/
    texp(ReplCStartExpOf(tptr), MANY_REGS); /*          start                */
    storeinname(replname, REPL_BASE);       /*          stl   i              */
    texp(ReplCLengthExpOf(tptr), MANY_REGS);/*          count                */
    storeinname(replname, REPL_COUNT);      /*          stl   i + 1          */
    if (!constlength)
      /*{{{  check the replicator is valid*/
      {
        loadname(replname, REPL_COUNT);     /*          ldl   i + 1          */
        if (errormode & ERRORMODE_REPLCHECK)
          /*{{{  check the replicator is > 0*/
          {
            gensecondary(I_MINT);           /*          mint ( = mostpos + 1)*/
            gensecondary(I_CSUB0);          /*          csub0                */
            checkerror();
          }
          /*}}}*/
        genbranch (I_CJ, endlab);           /*          cj    endlab         */
      }
      /*}}}*/
    setlab(looplab);                        /* looplab:                      */
    genstartblock();
    (*tbody)(ReplCBodyOf(tptr), p1, p2);    /*          body                 */
    loadnamepointer(replname, REPL_BASE);   /*          ldlp  i              */
    genlabeldiff(I_LDC, endlab, looplab);   /*          ldc endlab - looplab */
    gensecondary(I_LEND);                   /*          lend                 */
    setlab(endlab);                         /* endlab:                       */
    /*}}}*/
  }
/*}}}*/
/*{{{  PRIVATE void tsetpar(parcount, joinlab)*/
/*****************************************************************************
 *
 *  tsetpar generates the start up code for a PAR which saves the PAR count
 *          in workspace slot 1, and the join address in workspace slot 0.
 *
 *****************************************************************************/

/* Number of parallel processes */
/* Join address */
PRIVATE void tsetpar ( INT32 parcount , int joinlab )
  {
    int l = newlab();
    genprimary (I_LDC, parcount);
    genprimary (I_STL, 1);
    gencomment0("parcount");
    genlabeldiff (I_LDC, joinlab, l);
    gensecondary (I_LDPI);
    setlab (l);
    genprimary (I_STL, 0);
    gencomment0("joinlab");
  }
/*}}}*/
/*{{{  PRIVATE void tsubpar*/
PRIVATE void tsubpar(treenode *proclist, int start)
{
  /* walk the process list for processes 2, 3, ...*/
  int branch = 1; /* used by source_output code */
  BIT32 parsize = SpDatasizeOf(ThisItem(proclist));
  proclist = NextItem(proclist);
  while (!EndOfList(proclist))
    {
      treenode *pprocess = ThisItem(proclist);
      BIT32 thisbranchwsp = SpMaxwspOf(pprocess);
      BIT32 thisbranchsize = SpDatasizeOf(pprocess);
      BIT32 thisbranchadjust = parsize + thisbranchwsp;

      if (start)
        /*{{{  start a process*/
        {
          int l = newlab(), pstartlab = newlab();
          genlabeldiff (I_LDC, pstartlab, l);
          genprimary (I_LDLP, -thisbranchadjust);
          gensecondary (I_STARTP);
          setlab (l);
          SetSpLabel(pprocess, pstartlab);
        }
        /*}}}*/
      else
        {
          adjustworkspace(thisbranchadjust);
          /*{{{  generate body*/
          setlab (SpLabelOf(pprocess));
          tprocess (SpBodyOf(pprocess));
          /*{{{  source output*/
          if (source_output)
          {
            branch++;
            so_endofpar(branch, EndOfList(NextItem(proclist)));
          }
          /*}}}*/
          genprimary (I_LDLP, thisbranchadjust);
          gencomment0("joinlab");
          gensecondary (I_ENDP);
          /*}}}*/
          adjustworkspace(-thisbranchadjust);
        }

      parsize += thisbranchsize;
      proclist = NextItem(proclist);
    }
}
/*}}}*/
/*{{{  PRIVATEPARAM void tpar (tptr, paritems)               ** global for 3L bug*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tpar generates the code for a PAR process, tptr.
 *       'paritems' contains the number of processes to be run in parallel.
 *
 *****************************************************************************/
/*}}}*/
PRIVATEPARAM void tpar ( treenode *tptr , int paritems )
{
  if (paritems > 1)
    tsubpar(tptr, TRUE); /* startoff each process */
  /*{{{  generate process 1*/
  {
    treenode *firstitem = ThisItem(tptr);
    BIT32 thisbranchwsp = SpMaxwspOf(firstitem);
    genprimary(I_AJW, -thisbranchwsp);
    adjustworkspace(thisbranchwsp);
    tprocess(SpBodyOf(firstitem));
    /*{{{  source output*/
    if (source_output)
      so_endofpar(1, (paritems == 1));
    /*}}}*/
    genprimary(I_LDLP, thisbranchwsp);
    gencomment0("joinlab");
    gensecondary(I_ENDP);
    adjustworkspace(-thisbranchwsp);
  }
  /*}}}*/
  if (paritems > 1)
    tsubpar(tptr, FALSE); /* generate their bodies */
}
/*}}}*/
/*{{{  void treplpar (tptr, proclab, rcptr)     ** global for 3L bug*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  treplpar sets up the workspace for a replicated process
 *           It assumes that wsp2 contains a pointer to the first special
 *           slot of the replicated workspace, wsp3 contains a pointer to
 *           the vector space.
 *           'proclab' labels the first instruction of the repl. code.
 *
 *****************************************************************************/
/*}}}*/

/* Pointer to the whole replicated construct tree */
PRIVATEPARAM void treplpar ( treenode *tptr , int proclab , treenode *rcptr )
{
  int l = newlab();
  BIT32 thisbranchwsp = SpMaxwspOf(tptr);
  BIT32 thisbranchsize = SpDatasizeOf(tptr);
  treenode *replname = ReplCNameOf(rcptr);
  int rpspecialslots = MIN_REPLPAR_SPECIALS;
  BIT32 vectorspace = SpVSUsageOf(tptr);
  /*{{{  if (vectorspace)*/
  if (vectorspace != ZERO32)
    {
      rpspecialslots = rpspecialslots + 1;
      genprimary(I_LDL, REPLPAR_VS_TEMP);  /* ldl   vstemp              */
      gencomment0("vstemp");
      genprimary(I_LDL, REPLPAR_WS_TEMP);  /* ldl   wstemp              */
      gencomment0("wstemp");
      genprimary(I_STNL, REPLPAR_VSP);     /* stnl  rpvsp               */
      gencomment0("rpvsp");
      genprimary(I_LDL, REPLPAR_VS_TEMP);  /* ldl   vstemp              */
      gencomment0("vstemp");
      genprimary(I_LDNLP, vectorspace);    /* ldnlp vs for repl.process */
      genprimary(I_STL, REPLPAR_VS_TEMP);  /* stl   vstemp              */
      gencomment0("vstemp");
    }
  /*}}}*/
  /*{{{  insert repl static link*/
  genprimary(I_LDLP, ZERO32);             /*     ldlp   0                   */
  genprimary(I_LDL, REPLPAR_WS_TEMP);     /*     ldl    wstemp              */
  gencomment0("wstemp");
  genprimary(I_STNL, REPLPAR_STATICLINK); /*     stnl   rpstaticlink        */
  gencomment0("rpstatic");
  /*}}}*/
  /*{{{  insert replicator value*/
  loadname(replname, REPL_BASE);       /*        ldl    i                   */
  genprimary(I_LDL, REPLPAR_WS_TEMP); /*         ldl    wstemp              */
  gencomment0("wstemp");
  genprimary(I_STNL, REPLPAR_REPLICATOR); /*     stnl   rpreplicator        */
  gencomment0("rprepl");
  /*}}}*/
  /*{{{  start process*/
  genlabeldiff(I_LDC, proclab, l);    /*         ldc    proclab - l         */
  genprimary(I_LDL, REPLPAR_WS_TEMP); /*         ldl    wstemp              */
  gencomment0("wstemp");
  genprimary(I_LDNLP, rpspecialslots - thisbranchwsp);
                                      /*         ldnlp  rpspecials-replwsp  */
  gensecondary(I_STARTP);             /*         startp                     */
  setlab(l);                          /* l:                                 */
  /*}}}*/
  /*{{{  update wsp temporary*/
  genprimary(I_LDL, REPLPAR_WS_TEMP); /*         ldl    wstemp              */
  gencomment0("wstemp");
  genprimary(I_LDNLP, -thisbranchsize); /*       ldnlp  -ds                 */
  genprimary(I_STL, REPLPAR_WS_TEMP); /*         stl    wstemp              */
  gencomment0("wstemp");
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE void tchoice(tptr, trueguard, endlabel)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tchoice generates code for a choice node (ie. guard followed by body).
 *          'tptr' is the choice node, 'trueguard' is a var parameter which
 *          we set to TRUE if we find a 'TRUE' guard.
 *          'endlabel' is the label which marks the end of the whole IF.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tchoice ( treenode *tptr , int *trueguard , int endlabel )
{
  tptr = tspecs(tptr);
  switch (TagOf(tptr))
    {
      /*{{{  S_IF S_REPLIF*/
      case S_IF:
      case S_REPLIF:
        tif(tptr, trueguard, endlabel);
        break;
      /*}}}*/
      /*{{{  S_CHOICE*/
      case S_CHOICE:
        /*{{{  generate the choice*/
        {
          /*{{{  debug output*/
          if (debugoutput)
            genlocate(tptr);
          /*}}}*/
          if (isskipbody(CondBodyOf(tptr)))
            /*{{{  if condition, jump to endlabel, else fall through*/
            {
              if (istrueguard(CondGuardOf(tptr)))
                *trueguard = TRUE;  /* A TRUE guard is always the last guard */
              else if (isfalseguard(CondGuardOf(tptr))) /* bug 307 28/8/90 */
                ; /* skip */
              else
                tguard(CondGuardOf(tptr), FALSE, endlabel);
            }
            /*}}}*/
          else
            {
              int nextchoice = newlab();
              if (istrueguard(CondGuardOf(tptr)))
              /* if we have a TRUE guard we don't need to generate a STOP after the
                 IF   */
                *trueguard = TRUE;
              else
                {
                  tpreexp(CondGuardOf(tptr));
                  tguard(CondGuardOf(tptr), TRUE, nextchoice);
                }
              tprocess(CondBodyOf(tptr));
              genjump(endlabel);
              setlab(nextchoice);
            }
        }
        /*}}}*/
        break;
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "tchoice");
        break;
    }
}
/*}}}*/
/*{{{  PRIVATE void tif(...)*/
#ifndef MALC_IF
/*{{{  PRIVATE void tif(tptr, trueguard, endlabel)*/
/*{{{  words*/
/*****************************************************************************
 *
 *  tif generates code for an IF process or an IF guard.
 *      tptr is the process or guard, trueguard is set to TRUE if a 'TRUE'
 *      guard is found.
 *      N.B. IF processes need a STOP generated if they don't have a 'TRUE'
 *           guard.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tif ( treenode *tptr , int *trueguard , int endlabel )
{
  if (TagOf(tptr) == S_REPLIF)
    /*{{{  generate a replicated IF*/
    {
      /*{{{  debug output*/
      if (debugoutput)
        genlocate(tptr);
      /*}}}*/
      tpreexp(ReplCStartExpOf(tptr));
      tpreexp(ReplCLengthExpOf(tptr));
      trepl(tptr, tchoice, (BIT32)trueguard, endlabel);
    }
    /*}}}*/
  else
    /*{{{  generate an ordinary IF*/
    {
      treenode *choicelist = CBodyOf(tptr);
    
      while (!EndOfList(choicelist))
        /*{{{  generate a choice*/
        {
          tchoice(ThisItem(choicelist), trueguard, endlabel);
          choicelist = NextItem(choicelist);
        }
        /*}}}*/
    }
    /*}}}*/
}
/*}}}*/
#else
/*{{{  words*/
/*****************************************************************************
 *
 *  tif generates code for an IF process or an IF guard.
 *      tptr is the process or guard, trueguard is set to TRUE if a 'TRUE'
 *      guard is found.
 *      N.B. IF processes need a STOP generated if they don't have a 'TRUE'
 *           guard.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tif ( treenode *tptr , int *trueguard , int endlabel )
{
  if (TagOf(tptr) == S_REPLIF)
    /*{{{  generate a replicated IF*/
    {
      /*{{{  debug output*/
      if (debugoutput)
        genlocate(tptr);
      /*}}}*/
      tpreexp(ReplCStartExpOf(tptr));
      tpreexp(ReplCLengthExpOf(tptr));
      trepl(tptr, tchoice, (BIT32)trueguard, endlabel);
    }
    /*}}}*/
  else
    /*{{{  generate an ordinary IF*/
    {
      treenode *choicelist = CBodyOf(tptr);
      int nchoices = 0;
      int *choicelabs;
      int endbodies;
      while (!EndOfList(choicelist))
        {nchoices++; choicelist = NextItem(choicelist);}
      /* make sure that we don't try to memalloc zero bytes */
      choicelabs = (int *)memalloc(nchoices * sizeof(int) +1);
      /*{{{  generate guards*/
      choicelist = CBodyOf(tptr);
      nchoices = 0;
      while (!EndOfList(choicelist))
        /*{{{  */
        {
          treenode *guard = ThisItem(choicelist);
          if (isspecification(guard))
            tchoice(guard, trueguard, endlabel);
          else
            switch (TagOf(guard))
              {
                /*{{{  S_IF S_REPLIF*/
                case S_IF: case S_REPLIF:
                  tif(guard, trueguard, endlabel);
                  break;
                /*}}}*/
                case S_CHOICE:
                  /*{{{  generate the choice*/
                  {
                    int nextchoice;
                    /*{{{  debug output*/
                    if (debugoutput)
                      genlocate(guard);
                    /*}}}*/
                    if (isskipbody(CondBodyOf(guard)))
                      nextchoice = endlabel;
                    else
                      /*{{{  allocate new label*/
                      {
                        nextchoice = newlab();
                        choicelabs[nchoices] = nextchoice;
                        nchoices++;
                      }
                      /*}}}*/
                    if (istrueguard(CondGuardOf(guard)))
                      { genjump(nextchoice); *trueguard = TRUE; }
                    else
                      {
                        tpreexp(CondGuardOf(guard));
                        tguard(CondGuardOf(guard), FALSE, nextchoice);
                      }
                  }
                  /*}}}*/
                  break;
                default:
                  badtag(genlocn, TagOf(guard), "tchoice");
                  break;
              }
          choicelist = NextItem(choicelist);
        }
        /*}}}*/
      /*}}}*/
      endbodies = newlab();
      genjump(endbodies);
      /*{{{  generate bodies*/
      choicelist = CBodyOf(tptr);
      nchoices = 0;
      while (!EndOfList(choicelist))
        /*{{{  */
        {
          treenode *guard = ThisItem(choicelist);
          if (!isspecification(guard) &&
            TagOf(guard) != S_IF && TagOf(guard) != S_REPLIF)
            /*{{{  generate the choice*/
            {
              if (!isskipbody(CondBodyOf(guard)))
                {
                  setlab(choicelabs[nchoices++]);
                  tprocess(CondBodyOf(guard));
                  genjump(endlabel);
                }
            }
            /*}}}*/
          choicelist = NextItem(choicelist);
        }
        /*}}}*/
      /*}}}*/
      setlab(endbodies);
      memfree(choicelabs);
      /*
      while (!EndOfList(choicelist))
        {
          tchoice(ThisItem(choicelist), trueguard, endlabel);
          choicelist = NextItem(choicelist);
        }
      */
    }
    /*}}}*/
}
#endif
/*}}}*/

/*{{{  PRIVATE void tconsttable (tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tconsttable generates the constant table tptr
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tconsttable ( treenode *tptr, treenode *type_tptr, char *description)
  {
    wordnode *w = (wordnode *)(CTValOf(tptr));
    int alignment;
    DEBUG_MSG(("tconsttable\n"));
    /*{{{  set up alignment*/
    #if 0
    /* bug 1129 28/1/91 - we MUST word align everything, so that
       any constant array is known to be word aligned.
       This permits any array to be passed to KERNEL.RUN, for instance.
    */
    /* bug 1015 12/10/90 - we have to align word length constants, because
       moveopd expects to be able to optimise them to use ldnl and stnl
    */
    /* It appears that this code causes heap corruption. God knows why.
       Since I want to beta-release this bloody compiler today, I'm
       disabling it.
       RESULT: we always align all objects to a word boundary.
       CON 12/10/90
    */
    /* bug TS/1016 - 29/10/90 attempting to re-enable this to see what
       happens
    */
    {
      treenode *type = gettype(type_tptr);
      if (bytesin(type) == bytesperword)
        alignment = bytesperword;
      else
        alignment = min(bytesinscalar(basetype(type)), bytesperword);
    }
    #else
      type_tptr = type_tptr; /* stop unused variable warning */
      alignment = bytesperword;
    #endif
    /*}}}*/

    {
      const int l = newlab();
      SetCTLabel(tptr, l);
      setsectionlab(l);
    }

    if (description != NULL) gencomment0(description);
    add_code_block(WLengthOf(w), (BYTE *)WNameOf(w));

    if (alignment > 1)
  #if 0
    /* Doing these two separately can mean that we actually insert more than
       bytesperword bytes of alignment code.
       Hence we merge them together.
       CON - 14/2/91
    */
      {
        /* make sure that this block is a multiple of `alignment' long */
        genpadding(get_padlen(WlengthOf(w), alignment));

        /* make sure previous block was aligned */
        alignendofsection(alignment);
      }
  #else
      {
        const int this_align = get_padlen(WLengthOf(w), alignment);
        const int  end_align = endofsection_padlen(alignment);
        DEBUG_MSG(("tconsttable: this_align:%d, end_align:%d\n", this_align, end_align));
      /*genpadding((end_align + this_align) % alignment);*/
        genpadding((end_align + this_align) & (alignment-1));
      }
  #endif

    compress_code();

    /* bug 1158 - add all constant tables onto a chain, so that we can use
       it to prevent duplicates */
    SetCTNext(tptr, globaltablechain);
    globaltablechain = tptr;
  }
/*}}}*/
/*{{{  PUBLIC void tprocess (tptr)*/
/* Generate code for the process represented by tptr */
PUBLIC void tprocess ( treenode *tptr )
{
  while (tptr != NULL)
    {
      genlocn = LocnOf(tptr);
      tptr = tspecs(tptr);
      if (debugoutput && need_locate(TagOf(tptr)))
        genlocate(tptr);
      switch (TagOf(tptr))
        /*{{{  cases*/
        {
          /*{{{  S_SKIP                 return*/
          case S_SKIP:
            return;
          /*}}}*/
          /*{{{  S_STOP                 return*/
          case S_STOP:
            tstop (tptr);
            return;
          /*}}}*/
          /*{{{  S_SEQ                  return*/
          case S_SEQ:
            {
              treenode *sptr = CBodyOf(tptr);
              while (!EndOfList(sptr))
                {
                  tprocess (ThisItem(sptr));
                  sptr = NextItem(sptr);
                }
              return;
            }
          /*}}}*/
          /*{{{  S_REPLSEQ              return*/
          case S_REPLSEQ:
            tpreexp(ReplCStartExpOf(tptr));
            tpreexp(ReplCLengthExpOf(tptr));
            trepl(tptr, tprocess, ZERO32, ZERO32);
            return;
          /*}}}*/
          /*{{{  S_PAR                  return*/
          case S_PAR:
            {
              treenode *t = CBodyOf(tptr);
              int parcount = listitems (t);
              if (parcount != 0)
                {
                  int joinlab = newlab();
          
                  tsetpar(parcount, joinlab);
                  tpar (t, parcount);   /* Generate code for each of the processes */
          
                  setlab (joinlab);
                }
              /* else (parcount == 0) */
              return;
            }
          /*}}}*/
          /*{{{  S_PRIPAR               return*/
          case S_PRIPAR:
            if (code_style_flags & CODE_STYLE_ALT_PRI_PAR)
            { /* New way to do PRI PAR using an ALT */
              /* Note that this is NECESSARY on a H1 L-process */
              treenode *t = CBodyOf(tptr);
              int l = newlab(), pstartlab = newlab(), joinlab = newlab();
              /*{{{  generate the processes*/
              {
                /* p is the high priority process, q is the low priority process */
                /* wp is the distance between our workspace and p's workspace,
                   wq is the distance between our workspace and q's workspace    */
                treenode *p = ThisItem(t),
                         *q = ThisItem(NextItem(t));
                INT32 wp = DS_IO + SpMaxwspOf(p), /* Need DS_IO here cos of ALT CO'N */
                      wq = DS_IO + SpDatasizeOf(p) + SpMaxwspOf(q);
                /*{{{  set up the channel to ALT on */
                gensecondary(I_MINT);                     /*           mint                */
                genprimary(I_STL, ONE32);                 /*           stl chan            */
                gencomment0("chan");
                                        /* channel uses workspace location 1 */
                                        /* workspace location 0 is hit by the ALT */
                /*}}}*/
                /*{{{  set up and run high priority process*/
                genlabeldiff(I_LDC, pstartlab, l);        /*           ldc   pstartlab - l */
                gensecondary(I_LDPI);                     /*           ldpi                */
                setlab(l);                                /* l:                            */
                genprimary(I_STL, (-wp) - 1);             /*           stl   -wp - 1       */
                gencomment0("Iptr.s");
                if (H1L_process)
                  {
                    gensecondary(I_LDTH);                 /*           ldth                */
                    genprimary(I_LDNLP, HIGH_PRI_TRAP_OFFSET); /*      ldnlp n             */
                    genprimary(I_STL, (-wp) - 3);         /*           stl   -wp - 3       */
                  }
                genprimary(I_LDLP, -wp);                  /*           ldlp  -wp           */
                gencomment0("Hi Wptr");
                if (H1L_process)
                  genprimary(I_ADC, 2);                   /*           (set L_process bit) */
                gensecondary(I_RUNP);                     /*           runp                */
                /*}}}*/
                /*{{{  fall into low priority process*/
                genprimary(I_AJW, -wq);                   /*           ajw   -wq           */
                adjustworkspace(wq);
                tprocess(SpBodyOf(q));                    /*           Q                   */
                /*{{{  source output*/
                if (source_output)
                  so_endofpar(2, FALSE);
                /*}}}*/
                genprimary(I_AJW, wq);                    /*           ajw   +wq           */
                adjustworkspace(-wq);
                gensecondary(I_ALT);                      /*           alt                 */
                genprimary(I_LDLP, ONE32);                /*           ldlp  chan          */
                genprimary(I_LDC, ONE32); /* TRUE */      /*           ldc   TRUE          */
                gensecondary(I_ENBC);                     /*           enbc                */
                gensecondary(I_ALTWT);                    /*           altwt               */
                genjump(joinlab);                         /*           j     end           */
                /*}}}*/
                /*{{{  high priority process*/
                adjustworkspace(wp);
                setlab(pstartlab);                        /* pstartlab:                    */
                tprocess(SpBodyOf(p));                    /*           P                   */
                /*{{{  source output*/
                if (source_output)
                  so_endofpar(1, TRUE);
                /*}}}*/
                /* This output 'triggers' the ALT, but is never executed */
                genprimary(I_LDLP, ZERO32);               /*           ldlp  any data      */
                genprimary(I_LDLP, wp + ONE32);           /*           ldlp  chan          */
                genprimary(I_LDC, ONE32);                 /*           ldc   any len       */
                gensecondary(I_OUT);                      /*           out                 */
                adjustworkspace(-wp);
                /*}}}*/
              }
              /*}}}*/
              setlab(joinlab);
            }
            else
            {  /* Traditional way to do PRI PAR */
              treenode *t = CBodyOf(tptr);
              int l = newlab(), pstartlab = newlab(), joinlab = newlab();
              tsetpar(2, joinlab);
              /*{{{  generate the processes*/
              {
                /* p is the high priority process, q is the low priority process */
                /* wp is the distance between our workspace and p's workspace,
                   wq is the distance between our workspace and q's workspace    */
                treenode *p = ThisItem(t),
                         *q = ThisItem(NextItem(t));
                INT32 wp = /* DS_MIN + */ SpMaxwspOf(p), /* Don't need DS_MIN here - CO'N */
                      wq = /* DS_MIN + */ SpDatasizeOf(p) + SpMaxwspOf(q);
                /*{{{  set up and run high priority process*/
                genlabeldiff(I_LDC, pstartlab, l);        /*           ldc   pstartlab - l */
                gensecondary(I_LDPI);                     /*           ldpi                */
                setlab(l);                                /* l:                            */
                genprimary(I_STL, (-wp) - 1);             /*           stl   -wp - 1       */
                gencomment0("Iptr.s");
                genprimary(I_LDLP, -wp);                  /*           ldlp  -wp           */
                gencomment0("Hi Wptr");
                gensecondary(I_RUNP);                     /*           runp                */
                /*}}}*/
                /*{{{  fall into low priority process*/
                genprimary(I_AJW, -wq);                   /*           ajw   -wq           */
                adjustworkspace(wq);
                tprocess(SpBodyOf(q));                    /*           Q                   */
                /*{{{  source output*/
                if (source_output)
                  so_endofpar(2, FALSE);
                /*}}}*/
                genprimary(I_LDLP, wq);                   /*           ldlp  wq            */
                gencomment0("joinlab");
                gensecondary(I_ENDP);                     /*           endp                */
                adjustworkspace(-wq);
                /*}}}*/
                /*{{{  high priority process*/
                adjustworkspace(wp);
                setlab(pstartlab);                        /* pstartlab:                    */
                tprocess(SpBodyOf(p));                    /*           P                   */
                                                          /* -- Come down to low priority  */
                genprimary(I_LDLP, ZERO32);               /*           ldlp  0             */
                genprimary(I_ADC, ONE32);                 /*           adc   1             */
                gensecondary(I_RUNP);                     /*           runp                */
                gensecondary(I_STOPP);                    /*           stopp               */
                /*{{{  source output*/
                if (source_output)
                  so_endofpar(1, TRUE);
                /*}}}*/
                genprimary(I_LDLP, wp);                   /*           ldlp  wp            */
                gencomment0("joinlab");
                gensecondary(I_ENDP);                     /*           endp                */
                adjustworkspace(-wp);
                /*}}}*/
              }
              /*}}}*/
              setlab(joinlab);
            }
            return;
          /*}}}*/
          /*{{{  S_REPLPAR              return*/
          case S_REPLPAR:
            {
              /* Number of replicated processes */
              INT32 replcount = LoValOf(ReplCLengthExpOf(tptr));
              treenode *replbody = ReplCBodyOf(tptr);
              BIT32 thisbranchwsp = SpMaxwspOf(replbody);
              int vectorspace = (SpVSUsageOf(replbody) != ZERO32);
              int replparslots = MIN_REPLPAR_SPECIALS + vectorspace;
          
              int joinlab = newlab(),
                  proclab = newlab();
              if (replcount == 0) return;
              /*{{{  set up repl PAR*/
              tsetpar(replcount + 1, joinlab);     /*     ... set PAR join & count   */
              genprimary (I_LDLP, (-(DS_MIN + replparslots)));
              genprimary (I_STL, REPLPAR_WS_TEMP); /*     stl    wstemp              */
              gencomment0("wstemp");
              /*{{{  if (vectorspace)*/
              if (vectorspace)
                {
                  loadnewvsp(SpNestedVSOf(replbody)); /*  ldptr  freevectorspace     */
                  genprimary(I_STL, REPLPAR_VS_TEMP); /*  stl    vstemp              */
                  gencomment0("vstemp");
                }
              /*}}}*/
              /*}}}*/
              /*{{{  preprocess the replicator start expression*/
              tpreexp(ReplCStartExpOf(tptr));
              /* tpreexp(ReplCLengthExpOf(tptr));  must be constant */
              /*}}}*/
                                                      /*    ... generate startp's      */
              trepl(tptr, treplpar, (BIT32)proclab, (BIT32)tptr);
              /*{{{  finish repl PAR*/
              genprimary (I_LDLP, 0);               /*     ldlp  0                   */
              gencomment0("joinlab");
              gensecondary(I_ENDP);                 /*     endp                      */
              /*}}}*/
              /*{{{  generate code of replicated process*/
              {
                int savedconstptr = constptr;
                BIT32 savedvspoffset = vspoffset;
                INT32 saved_asmvalues[ASMNAMES_COUNT];
                int   saved_asmvalids[ASMNAMES_COUNT];
                int i;
        
                setlab(proclab);                 /* proclab:                           */
                /*{{{  set environment for replicated process*/
                for (i = 0; i < ASMNAMES_COUNT; i++)
                  {
                    saved_asmvalues[i] = asmvalues[i];
                    saved_asmvalids[i] = asmvalids[i];
                  }
                lexlevel++;
                setsloffset(lexlevel,
                            (thisbranchwsp - replparslots + REPLPAR_STATICLINK) | REPL_FLAG);
                setadjust(lexlevel, 0);
                /*asmvalids[ASMNAME_WSSIZE] = ASMNAME_VALID;*/ /* already TRUE */
                asmvalues[ASMNAME_WSSIZE] = thisbranchwsp;
                asmvalids[ASMNAME_STATIC] = ASMNAME_VALID; /* always a static link */
                asmvalues[ASMNAME_STATIC] = thisbranchwsp - replparslots + REPLPAR_STATICLINK;
                /* Set vector space offset and usage */
                vspoffset = thisbranchwsp - replparslots + REPLPAR_VSP;
                asmvalids[ASMNAME_VSPTR] = (vectorspace ? ASMNAME_VALID : ASMNAME_ERROR);
                asmvalues[ASMNAME_VSPTR] = vspoffset;
                
                /* Alter replicator lexical level and workspace position */
                {
                  treenode *replnptr = ReplCNameOf(tptr);
                  SetNLexLevel(replnptr, lexlevel);   /* Move lex level into repl. body */
                  SetNVOffset(replnptr, thisbranchwsp - replparslots + REPLPAR_REPLICATOR);
                }
                /*}}}*/
                /*{{{  generate body of replicated process*/
                /*{{{  initialise constant pointer if necessary*/
                {
                  constptr = SpCPOffsetOf(replbody);
                  if (constptr != CONSTANTPOINTER_NOT_USED)
                    /*{{{  set up the scalar constant pointer*/
                    {
                      int lab = newlab();
                      genlabeldiff(I_LDC, scalarconstlab, lab);
                      gensecondary(I_LDPI);
                      setlab(lab);
                      genprimary(I_STL, constptr + nameoffsetof(lexlevel));
                    }
                    /*}}}*/
                }
                /*}}}*/
                                                  /*          P                         */
                tprocess(SpBodyOf(replbody));
                        /*}}}*/
                /*{{{  source output*/
                if (source_output)
                  so_endofpar(1, TRUE);
                /*}}}*/
                loadreplreturnlink();            /*          ldl   staticlink          */
                gensecondary(I_ENDP);            /*          endp                      */
                /*{{{  restore environment*/
                lexlevel--;
                constptr = savedconstptr;
                vspoffset = savedvspoffset;
                /* Replicator variable goes out of scope so we don't bother to restore
                   its real lexical level and workspace position. */
                for (i = 0; i < ASMNAMES_COUNT; i++)
                  {
                    asmvalues[i] = saved_asmvalues[i];
                    asmvalids[i] = saved_asmvalids[i];
                  }
                /*}}}*/
              }
              /*}}}*/
              setlab(joinlab);
            }
            return;
          /*}}}*/
          /*{{{  S_WHILE                return*/
          case S_WHILE:
            if (!isfalseguard(CondGuardOf(tptr))) /* WHILE FALSE is thrown away */
              /*{{{  generate code for the WHILE*/
              {
                int startlab = newlab();
                treenode *guard = CondGuardOf(tptr),
                         *body = CondBodyOf(tptr);
              
                setlab(startlab);
                genstartblock();
                if (istrueguard(guard))
                  /*{{{  generate WHILE TRUE*/
                  {
                    tprocess(body);
                    /*{{{  source output*/
                    if (source_output)
                      so_endofwhile();
                    /*}}}*/
                    genjump(startlab);
                  }
                  /*}}}*/
                else
                  /*{{{  generate WHILE guard  body*/
                  {
                    int endlab = newlab();
                    tpreexp(guard);
                    tguard(guard, TRUE, endlab);
                    tprocess(body);
                    /*{{{  source output*/
                    if (source_output)
                      so_endofwhile();
                    /*}}}*/
                    genjump(startlab);
                    setlab(endlab);
                  }
                  /*}}}*/
              }
              /*}}}*/
            return;
          /*}}}*/
          /*{{{  S_IF S_REPLIF          return*/
          case S_IF:
          case S_REPLIF:
            {
              int endlabel = newlab();
              int trueguard = FALSE;
              tif(tptr, &trueguard, endlabel);
              if (NEED_ERRORS && (!trueguard))
              {
                /*{{{  source output*/
                if (source_output)
                  so_stop();
                /*}}}*/
                tstop(tptr);
              }
              setlab(endlabel);
              genstartblock();
              return;
            }
          /*}}}*/
          /*{{{  S_ALT S_REPLALT S_PRIALT S_PRIREPLALT return*/
          case S_ALT: case S_PRIALT:
          case S_REPLALT: case S_PRIREPLALT:
            talt(tptr);
            return;
          /*}}}*/
          /*{{{  S_OUTPUT               return*/
          case S_OUTPUT:
            toutput(tptr);
            return;
          /*}}}*/
          /*{{{  S_INPUT S_DELAYED_INPUT S_CASE_INPUT S_TAGGED_INPUT return*/
          case S_INPUT:
          case S_DELAYED_INPUT:
          case S_CASE_INPUT:
          case S_TAGGED_INPUT:
            tinput(tptr);
            return;
          /*}}}*/
          /*{{{  S_ASS                  return*/
          case S_ASS:
            tpreexp(RHSOf(tptr));
            tpreexp(LHSOf(tptr));
            tassign(LHSOf(tptr), RHSOf(tptr));
            return;
          /*}}}*/
          /*{{{  S_PINSTANCE            return*/
          case S_PINSTANCE:
            tpreexp(IParamListOf(tptr));
            if (TagOf(INameOf(tptr)) == N_PREDEFPROC)
              tpredef(tptr, NULL);
            else
              tinstance(tptr);
            return;
          /*}}}*/
          /*{{{  S_CASE                 return*/
          case S_CASE:
            tcase(tptr);
            return;
          /*}}}*/
          /*{{{  S_VALOF                         break*/
          case S_VALOF:
            tptr = VLBodyOf(tptr);
            break;
          /*}}}*/
          /*{{{  S_PLACE S_WSPLACE S_VSPLACE     break*/
          case S_PLACE:
          case S_WSPLACE:
          case S_VSPLACE:
            tptr = DBodyOf(tptr);
            break;
          /*}}}*/
          /*{{{  S_GUY, S_ASM                  return*/
          case S_GUY:
            walklist(tguy, CBodyOf(tptr));
            return;
          case S_ASM:
            walklist(tasm, CBodyOf(tptr));
            return;
          /*}}}*/
          default:
            badtag(genlocn, TagOf(tptr), "tprocess");
        }
        /*}}}*/
    }
}
/*}}}*/
/*{{{  PRIVATE void troutine(tptr)*/
/* Generate code for the procedure/function represented by tptr */
PRIVATE void troutine ( treenode *tptr )
{
  int t = TagOf(tptr);
  treenode *nptr =  DNameOf(tptr);
  BIT32 wssize = NPMaxwspOf(nptr);
  treenode *body = DValOf(tptr);
  int scalarconstants = FALSE;
  BIT32 vsoffset;
  BIT32 sloffset = -1;
  int oldlexlevel = lexlevel;

  DEBUG_MSG(("troutine for PROC/FUNCTION %s\n", WNameOf(NNameOf(nptr)) ));

  if (separatelycompiled(nptr) || inline(nptr) ||
      (!NUsedOf(nptr) && (NLexLevelOf(nptr) != 0)))
    {
    #if 0  /* #SC is no longer supported */
      if ((TagOf(nptr) == N_SCPROCDEF || TagOf(nptr) == N_SCFUNCDEF) &&
             debugoutput)
       /* generate an addressfix record for a procedure or function which is
          defined in an SC */
       genaddressfix(nptr, NSCEntryOffsetOf(nptr));
    #endif
      return;
    }

  /*{{{  handle lexical level and workspace position*/
  {
    lexlevel = NLexLevelOf(nptr) + 1; /* Lexical level of body of PROC */
    /*{{{  set static link offset*/
    {
      treenode *fparams = NParamListOf(nptr);
      BIT32 fpoffset = wssize + INS_EXTRA;
      vsoffset = -1;
      while (!EndOfList(fparams))
        {
          switch (TagOf(ThisItem(fparams)))
            /*{{{  tag*/
            {
              case N_PARAM:
              case N_VALPARAM:         if (basetype(gettype(ThisItem(fparams))) != S_TIMER)
                                         fpoffset++;
                                       break;
              case S_HIDDEN_PARAM:
              case S_FNFORMALRESULT:   fpoffset++; break;
              case S_PARAM_STATICLINK: sloffset = fpoffset; fpoffset++; break;
              case S_PARAM_VSP:        vsoffset = fpoffset; fpoffset++; break;
              default:                 badtag(genlocn, TagOf(ThisItem(fparams)),
                                              "troutine");
            }
            /*}}}*/
          fparams = NextItem(fparams);
        }
      setsloffset(lexlevel, sloffset);
    }
    /*}}}*/
    setadjust(lexlevel, 0);
  }
  /*}}}*/

  /*{{{  output nested routines (including const tables in val abbrevs)*/
  tnestedroutines(body);
  /*}}}*/
  /*{{{  output constants*/
  /* Scalar constants (long integers, reals, etc.) are output together in a
     table first of all, so after code reversal they come out last,
     string literals and constant arrays are output as separate blocks
     before the routine body, so after code reversal they come out
     after the routine body. */
  /* bug 1158 - we rely on the strings being done after the scalars,
     because now we collapse the chain of strings on pass 1,
     because the same field is used to keep track of ALL strings
     which have been generated. CON 14/2/91
  */
  {
    int pass;
    int displayed_msg = FALSE;
    for (pass = 0; pass < 2; pass++)
    /*{{{  generate either scalar constant table, or other tables */
    {
      /* Pass 0 is scalar constants; pass 1 is strings and constructors */
      int posn = 0;
      treenode *cchain = NPConstTablesOf(nptr);
      treenode *cptr   = cchain;
      while (cptr != NULL)
        {
          if (TagOf(cptr) == S_CONSTEXP)
            /*{{{  generate a scalar constant*/
            {
              if (pass == 0)
                {
                  treenode *matchptr = constantmatch(cptr, cchain);
                  if (matchptr != NULL)
                    SetCEOffset(cptr, CEOffsetOf(matchptr));
                  else
                    {
                      if (!scalarconstants)
                        {
                          if (diagnostics && !scalarconstants)
                            fprintf(outfile, "Constant table for routine %s\n",
                                             WNameOf(NNameOf(nptr)));
                          scalarconstlab = newlab();
                          setsectionlab(scalarconstlab);
                          scalarconstants = TRUE;
                        }
                      SetCEOffset(cptr, posn);
                      posn += genconstant(cptr);
                    }
                }
              cptr = CENextOf(cptr);
            }
            /*}}}*/
          else  /* S_STRING or S_CONSTCONSTRUCTOR */
            {
              treenode *next_cptr = CTNextOf(cptr);
              if (pass == 1)
                {
                  /* bug 1158 14/2/91 - we now 'merge' all copies of similar
                     constant arrays, even across procedures.
                  */
                  treenode *matchptr = constantmatch(cptr, /*cchain*/ globaltablechain);
                  if (matchptr == NULL)
                    {
                      if (diagnostics && !displayed_msg)
                        {
                          fprintf(outfile, "Array constants for routine %s\n",
                                            WNameOf(NNameOf(nptr)));
                          displayed_msg = TRUE;
                        }
                      tconsttable(cptr, cptr, NULL);
                      /* this modifies the CTNextOf field */
                    }
                  else
                    SetCTLabel(cptr, CTLabelOf(matchptr));
                }
              cptr = next_cptr;
            }
        }
      if ((pass == 0) && scalarconstants)
        {
          alignendofsection(bytesperword);
          compress_code();
        }
    }
    /*}}}*/
  }
  /*}}}*/
  /*{{{  debugging*/
  if (debugoutput)
    genaddrfix(nptr, -1); /* `-1' means 'here' */
  /*}}}*/

  vspoffset = vsoffset;
  /*{{{  procedure entry*/
  {
    int i;
    for (i = 0; i < ASMNAMES_COUNT; i++)
      asmvalids[i] = ASMNAME_ERROR;
    asmvalues[ASMNAME_WSSIZE] = wssize;
    asmvalids[ASMNAME_WSSIZE] = ASMNAME_VALID;
    if (sloffset != -1)
      {
        asmvalues[ASMNAME_STATIC] = sloffset;
        asmvalids[ASMNAME_STATIC] = ASMNAME_VALID;
      }
    if (vspoffset != -1)
      {
        asmvalues[ASMNAME_VSPTR] = vspoffset;
        asmvalids[ASMNAME_VSPTR] = ASMNAME_VALID;
      }
  }

  /* Procedure entry - adjust workspace */
  SetNPLabel(nptr, (INT32)newlab());
  setsectionlab((int)NPLabelOf(nptr));
  if (assembly_output && !source_output)
    {
      gencomment0((t == S_PROCDEF) ? "PROC" : "FUNCTION");
      fprintf(outfile, " %s, lexlevel: %d, WS: %ld, VS: %ld",
              WNameOf(NNameOf(nptr)),
              lexlevel-1, NPDatasizeOf(nptr), NPVSUsageOf(nptr));
    }

  /* N.B. Can't declare the entry point until the section label has been set */
  /*{{{  declare the entry point if neccessary*/
  if ((lexlevel == initlexlevel + 1)
      /*&& ((compilemode == COMP_SC) || (compilemode == COMP_LIB) ||
          (compilemode == COMP_PROGRAM))*/    )
    add_entry_point(nptr);
  /*}}}*/

  if (debugoutput) genlocate((treenode *)(((char *)nptr)+1)); /* mark the ajw */
  if (wssize != 0)
  {
  #if 0
    /*{{{  debugging*/
    if (debugoutput)
      genlibrpatch();
    /*}}}*/
  #endif /* 0 */
    genprimary(I_AJW, -wssize);
  }
  /* if nested repl has scalar constants, but none are used by the outer proc,
     then scalarconstants will be TRUE, but no slot allocated */
  if (scalarconstants && (NPCPOffsetOf(nptr) != CONSTANTPOINTER_NOT_USED))
    /*{{{  set up the scalar constant pointer*/
    {
      int lab = newlab();
      if (debugoutput && wssize != 0)
        genlocate((treenode *)(((char *)nptr)+2)); /* mark the start of preamble after ajw*/
      genlabeldiff(I_LDC, scalarconstlab, lab);
      gensecondary(I_LDPI);
      setlab(lab);
      constptr = NPCPOffsetOf(nptr);
      genprimary(I_STL, constptr /* + nameofsetof(lexlevel)*/); /* will always be 0 here */
    }
    /*}}}*/
  if (NLexLevelOf(nptr) == 0)
    genstartblock();  /* we could have got here via a jump */
  /*}}}*/
  /*{{{  translate body*/
  if (t == S_PROCDEF)
    tprocess(body);
  else
    /*{{{  function body*/
    {
      /*{{{  translate the valof*/
      body = tspecs(body);
      tprocess(VLBodyOf(body));
      {
        treenode *resultlist = VLResultListOf(body);
        struct { int opdmode; treenode *opd; } regresults[MAXREGS];
        int nregresults = 0;
        /*{{{  debug output*/
        if (debugoutput)             /* locate info for RESULT line */
          genlocate(resultlist);
        /*}}}*/
        tpreexp(resultlist);
        if
          /*{{{  special case a real-valued single result on an fp processor*/
          (fpinline &&
               listitems(resultlist) == 1 &&
               isreal(typeof(ThisItem(resultlist))))
            tfpexp(ThisItem(resultlist), MANY_REGS, MANY_REGS);
          /*}}}*/
        else
          /*{{{  load the results*/
          {
            treenode *destlist = firstresultof(FnParamsOf(NTypeOf(nptr)));
            while (!EndOfList(resultlist))
              {
                treenode *thisresult = ThisItem(resultlist);
                int type = typeof(thisresult);
                if ((nregresults < MAXREGS) && fitsinregister(type))
                  /*{{{  load result into a register later*/
                  {
                    regresults[nregresults].opd = thisresult;
                    regresults[nregresults].opdmode = P_EXP;
                    nregresults++;
                  }
                  /*}}}*/
                else
                  /*{{{  assign result through a pointer parameter*/
                  {
                    tsimpleassign(type, P_EXP, ThisItem(destlist),
                                        P_EXP, thisresult, MANY_REGS);
                    destlist = nextresultof(destlist);
                  }
                  /*}}}*/
                resultlist = NextItem(resultlist);
              }
            /*{{{  load the register results*/
            /*{{{  preevaluate non-addressable real-valued results on an fp processor*/
            if (fpinline)
              {
                int i;
                for (i = 0; i < nregresults; i++)
                  {
                    treenode *exp = regresults[i].opd;
                    int mode = regresults[i].opdmode;
                    if (preeval(mode, exp)  && needtemptoload(mode, NDeclOf(exp)))
                      regresults[i].opdmode = simplify(mode, exp);
                  }
              }
            /*}}}*/
            switch (nregresults)
              {
                case 0: break;
                case 1: texpopd(regresults[0].opdmode, regresults[0].opd, MANY_REGS);
                        break;
                case 2: tload2regs(regresults[1].opdmode, regresults[1].opd,
                                   regresults[0].opdmode, regresults[0].opd, FALSE);
                        break;
                case 3:
                        /*{{{  tload3regs*/
                        {
                          int preeval_e2, preeval_e3;
                          /* We only do this call so that we have a loadseq parameter for
                             tload3regs, ideally we should make the binder save loadseq
                             in the tree. */
                          int loadseq = giveorder(regresults[2].opdmode, regresults[2].opd,
                                                  regresults[1].opdmode, regresults[1].opd,
                                                  regresults[0].opdmode, regresults[0].opd,
                                                  &preeval_e2, &preeval_e3);
                          tload3regs(regresults[2].opdmode, regresults[2].opd,
                                     regresults[1].opdmode, regresults[1].opd,
                                     regresults[0].opdmode, regresults[0].opd, loadseq);
                        }
                        /*}}}*/
                        break;
              }
            /*}}}*/
          }
          /*}}}*/
      }
      /*}}}*/
    }
    /*}}}*/
  /*}}}*/

  /*{{{  procedure exit*/
  /* Procedure exit - adjust workspace */
  /*{{{  source output*/
  if (source_output)
    so_endofproc();
  /*}}}*/
  genprimary(I_AJW, wssize);             /* ajw 0 will be ignored by coder */
  gensecondary(I_RET);
  /*}}}*/

  compress_code();
  /*{{{  restore lexical level*/
  lexlevel = oldlexlevel;
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE void tnestedroutines(tptr)*/
/*****************************************************************************
 *
 *  tnestedroutines walks the tree 'tptr' generating any nested routines or
 *                  constant tables.
 *
 *****************************************************************************/
PRIVATE void tnestedroutines ( treenode *tptr )
{
  DEBUG_MSG(("tnestedroutines\n"));
  while (tptr != NULL)
    switch(TagOf(tptr))
      /*{{{  cases*/
      {
        default:
          return;
        /*{{{  specification*/
        /*{{{  routine specification*/
        case S_PROCDEF:
        case S_SFUNCDEF:
        case S_LFUNCDEF:
          {
            treenode *saved_alt_var = replaltvar; /* bug 1027 22/10/90 */
            replaltvar = NULL; /* incase this PROC is before an ALT guard */
            troutine(tptr);
            replaltvar = saved_alt_var;
            tptr = DBodyOf(tptr);
          }
          break;
        /*}}}*/
        /*{{{  S_VALABBR, S_VALRETYPE - possible constant table*/
        /* N.B. Constant tables in val abbreviations are treated as nested routines
           in order to keep their offsets as short as possible.
           Constant tables in expressions, eg. writes("hello") are linked together
           and the head of the list is stored in the routine definition node, they
           can then be generated just before the body of the routine. */
        case S_VALABBR:
        case S_VALRETYPE:
          {
            treenode *t = consttableof(tptr);
            if (t != NULL)
              {
                treenode *nptr = DNameOf(tptr);
                genlocn = LocnOf(tptr);
                DEBUG_MSG(("tnestedroutines: found a VALABBR with a constant table, usecount is %d\n",
                           NVUseCountOf(nptr) ));
                if (NVUseCountOf(nptr) != 0)
                  {
                    /* bug 1158 - we now merge together tables with the same
                       values */
                  #if 0 /* original code */
                    /*{{{  debugging*/
                    if (debugoutput)
                      genaddrfix(nptr);
                    /*}}}*/
                    tconsttable(t, (TagOf(tptr) == S_VALRETYPE) ? nptr : t,
                                WNameOf(NNameOf(nptr)));
                  #else
                    treenode *matchptr = constantmatch(t, globaltablechain);
                    if (matchptr == NULL)
                      {
                        if (debugoutput)
                          genaddrfix(nptr, -1); /* `-1' means `here' */
                        tconsttable(t, (TagOf(tptr) == S_VALRETYPE) ? nptr : t,
                                    WNameOf(NNameOf(nptr)));
                      }
                    else
                      {
                        if (debugoutput)
                          genaddrfix(nptr, CTLabelOf(matchptr));
                        SetCTLabel(t, CTLabelOf(matchptr));
                      }
                  #endif
                  }
              }
            else
              tnestedroutines(DValOf(tptr));
            tptr = DBodyOf(tptr);
            break;
          }
        /*}}}*/
        /*{{{  other specification*/
        case S_ABBR:
        case S_RETYPE:
        case S_DECL:
        case S_TPROTDEF:
        case S_SPROTDEF:
          if (DValOf(tptr) != NULL)
            tnestedroutines(DValOf(tptr));
          tptr = DBodyOf(tptr);
          break;
        /*}}}*/
        /*}}}*/
        /*{{{  SEQ IF*/
        case S_SEQ:
        case S_IF:
          tptr = CBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  REPLSEQ REPLIF*/
        case S_REPLSEQ:
        case S_REPLIF:
          tnestedroutines(ReplCStartExpOf(tptr));
          tnestedroutines(ReplCLengthExpOf(tptr));
          tptr = ReplCBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  ALTs*/
        case S_ALT:
        case S_PRIALT:
          if (replaltvar == NULL) /* an outermost ALT - bug 1027 22/10/90 */
            {
              replaltvar = CTempOf(tptr);
              replaltlevel = 0;
              tnestedroutines(CBodyOf(tptr));
              replaltvar = NULL; /* no longer inside an ALT */
              return;
            }
          tptr = CBodyOf(tptr);
          break;
        case S_REPLALT:
        case S_PRIREPLALT:
          { /* all this modified to update info of replicator name, incase
               any nested procedures read it - bug 1027 22/10/90 */
            treenode *replname = ReplCNameOf(tptr);
            INT32 old_offset = NVOffsetOf(replname);
            INT32 replaltvaluesbase;
            int outermost_alt = (replaltvar == NULL);
            tnestedroutines(ReplCStartExpOf(tptr));
            tnestedroutines(ReplCLengthExpOf(tptr));
            if (outermost_alt)
              {
                replaltvar = ReplCTempOf(tptr);
                replaltlevel = 0;
              }
            /* note that the following two calls to 'nameoffsetof' should both
               return the same values ( == nameoffsetof(lexlevel) ),
               but they are there for safety */
            replaltvaluesbase = NVOffsetOf(replaltvar)
                                + nameoffsetof(NLexLevelOf(replaltvar));
            SetNVOffset(replname, replaltvaluesbase + replaltlevel
                                  - nameoffsetof(NLexLevelOf(replname)));
            replaltlevel++;
            tnestedroutines(ReplCBodyOf(tptr));
            replaltlevel--;
            SetNVOffset(replname, old_offset);
            if (outermost_alt)
              replaltvar = NULL;
          }
          return;
        /*}}}*/
        /*{{{  ALTERNATIVE*/
        case S_ALTERNATIVE:
          { /* modified 22/10/90 for bug 1027 */
            treenode *saved_var = replaltvar;
            int saved_level     = replaltlevel;
            replaltvar = NULL; /* no longer inside an ALT */
            tnestedroutines(AltGuardOf(tptr));
            tnestedroutines(AltInputOf(tptr));
            tnestedroutines(AltBodyOf(tptr));
            replaltvar   = saved_var;
            replaltlevel = saved_level;
          }
          return;
        /*}}}*/
        /*{{{  PAR PRIPAR*/
        case S_PAR: case S_PRIPAR:
          {
            /* 22/10/90 noticed that this didn't allow for the PRI PAR via ALT, so added it: */
            BIT32 parsize = ((TagOf(tptr) == S_PRIPAR) && (code_style_flags & CODE_STYLE_ALT_PRI_PAR)) ?
                            DS_IO : ZERO32;
            treenode *proclist = CBodyOf(tptr);
            while (!EndOfList(proclist))
              {
                treenode *pprocess     = ThisItem(proclist);
                BIT32 thisbranchwsp    = SpMaxwspOf(pprocess);
                BIT32 thisbranchsize   = SpDatasizeOf(pprocess);
                BIT32 thisbranchadjust = parsize + thisbranchwsp;
        
                adjustworkspace(thisbranchadjust);  /* changed bug 1028 23/10/90 */
                tnestedroutines(SpBodyOf(pprocess));
                adjustworkspace(-thisbranchadjust); /* changed bug 1028 23/10/90 */
                parsize += thisbranchsize;
                proclist = NextItem(proclist);
              }
          }
          return;
        /*}}}*/
        /*{{{  REPLPAR*/
        case S_REPLPAR:
          tnestedroutines(ReplCStartExpOf(tptr));
          tnestedroutines(ReplCLengthExpOf(tptr));
          /*{{{  search repl body*/
          {
            treenode *replbody = ReplCBodyOf(tptr);
            BIT32 thisbranchwsp = SpMaxwspOf(replbody);
            int replparslots = MIN_REPLPAR_SPECIALS + (SpVSUsageOf(replbody) != 0);
            treenode *replnptr = ReplCNameOf(tptr);
            INT32 old_offset = NVOffsetOf(replnptr);

            /*{{{  handle lexical level and workspace position*/
            lexlevel++;
            setsloffset(lexlevel,
                       (thisbranchwsp - replparslots + REPLPAR_STATICLINK) | REPL_FLAG);
            setadjust(lexlevel, 0);

            SetNLexLevel(replnptr, lexlevel); /* bug 1026 19/10/90 */
            SetNVOffset(replnptr, thisbranchwsp - replparslots + REPLPAR_REPLICATOR);
            /*}}}*/
          
            tnestedroutines(SpBodyOf(replbody));
          
            /*{{{  restore lexical level*/
            lexlevel--;

            SetNLexLevel(replnptr, lexlevel); /* bug 1026 19/10/90 */
            SetNVOffset(replnptr, old_offset);
            /*}}}*/
          }
          /*}}}*/
          return;
        /*}}}*/
        /*{{{  WHILE CHOICE*/
        case S_WHILE:
        case S_CHOICE:
          tnestedroutines(CondGuardOf(tptr));
          tptr = CondBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  SELECTION*/
        case S_SELECTION:
          tptr = CondBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  VARIANT*/
        case S_VARIANT:
          tnestedroutines(VRTaggedListOf(tptr));
          tptr = VRBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  LIST*/
        case S_LIST:
          tnestedroutines(ThisItem(tptr));
          tptr = NextItem(tptr);
          break;
        /*}}}*/
        /*{{{  configuration*/
        /*{{{  PLACE WSPLACE VSPLACE*/
        case S_PLACE:
        case S_WSPLACE:
        case S_VSPLACE:
          tptr = DBodyOf(tptr);
          break;
        /*}}}*/
        /*{{{  PROCESSOR*/
        case S_PROCESSOR:
          tptr = ProcessorBodyOf(tptr);
          break;
        /*}}}*/
        /*}}}*/
        /*{{{  instance*/
        /*{{{  PINSTANCE FINSTANCE*/
        case S_PINSTANCE:
        case S_FINSTANCE:
          tnestedroutines(IParamListOf(tptr));
          return;
        /*}}}*/
        /*}}}*/
        /*{{{  action*/
        /*{{{  ASS OUTPUT INPUT TAGGED_INPUT DELAYED_INPUT CASE CASEINPUT*/
        case S_ASS:
        case S_OUTPUT:
        case S_INPUT:
        case S_TAGGED_INPUT:
        case S_DELAYED_INPUT:
        case S_CASE:
        case S_CASE_INPUT:
          tnestedroutines(LHSOf(tptr));
          tptr = RHSOf(tptr);
          break;
        /*}}}*/
        /*}}}*/
        /*{{{  monadic*/
        case S_NEG:
        case S_BITNOT:
        case S_UMINUS:
        case S_NOT:
        case S_SIZE:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  conversion*/
        case S_EXACT:
        case S_ROUND:
        case S_TRUNC:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  dyadic*/
        case S_AND: case S_OR:
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
        case S_BITAND: case S_BITOR: case S_XOR:
        case S_LSHIFT: case S_RSHIFT:
        case S_PLUS: case S_MINUS: case S_TIMES:
        case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
        case S_AFTER:
        case S_COLON2:
          tnestedroutines(LeftOpOf(tptr));
          tptr = RightOpOf(tptr);
          break;
        /*}}}*/
        /*{{{  constructor*/
        case S_CONSTRUCTOR:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  valof*/
        case S_VALOF:
          tnestedroutines(VLBodyOf(tptr));
          tptr = VLResultListOf(tptr);
          break;
        /*}}}*/
        /*{{{  subscript*/
        case S_ARRAYSUB:
        case S_ARRAYITEM:
          tnestedroutines(ASBaseOf(tptr));
          tptr = ASExpOf(tptr);
          break;
        /*}}}*/
        /*{{{  segment*/
        case S_SEGMENTITEM:
        case S_SEGMENT:
          tnestedroutines(SNameOf(tptr));
          tnestedroutines(SStartExpOf(tptr));
          tptr = SLengthExpOf(tptr);
          break;
        /*}}}*/
        /*{{{  temporary*/
        case T_TEMP:
        case T_PREEVALTEMP:
          tptr = NDeclOf(tptr);
          break;
        /*}}}*/
      }
      /*}}}*/
}
/*}}}*/
/*}}}*/
/*{{{  PUBLIC void tmain(tptr)*/
/* Generate code for main body */
PUBLIC void tmain ( treenode *tptr )
{
  /*{{{  source output*/
  if (source_output)
    init_source_code_output();
  /*}}}*/
  lexlevel = initlexlevel;
  /*{{{  declare nested SC entry points*/
  /*apply_to_sc_entries(declare_sc_entries);*/
  /*}}}*/
  /*{{{  generate library call stubs*/
  genlibstubs();
  /*}}}*/
  tnestedroutines(tptr);
  /*{{{  source output*/
  /* if (source_output)
    end_source_code_output();  */
  /*}}}*/
  alignwholemodule();  /* align to word length */
  write_object_file();
}
/*}}}*/
/*{{{  PUBLIC void beinit (int l)*/
PUBLIC void beinit ( int l )  /* Can call this instead of bereinit */
{
  if (diagnostics)
    fputs("Initialising backend\n", outfile);
  initlexlevel = l;
  insidealtguard = FALSE;
  initlabels();
  caseinit();
  initalloc();
  setadjust(0, 0);
  initcode();
  initbind();
  globaltablechain = NULL;
  if (trueguard == NULL)
    trueguard = newconstant(ONE32);
  if (tempname_p == NULL)
    tempname_p = newwordnode(S_NAME, tempname, strlen(tempname), NULL);
  inside_asm = FALSE;
}
/*}}}*/
/*}}}*/
