###############################################################################
# Makefile for the build of all of the occam2 toolset user, compiler and
# configurer libraries.
#
# NOTE: Not all of the dependencies amongst the libraries and library sources
# are expressed in the makefiles that are called by this makefile, which
# means that they are not makefiles in the normal sense, and that if any
# one source file changes, anywhere, anyhow, then EVERYTHING should be
# rebuilt, for only then can one be sure of the resultant libraries.
#
# It is assumed that oc, ilibr, ilink and preocc are already built and on
# the PATH environment variable.
#
# It is assumed that this make file is invoked from the directory
# .../build/libs/occ/tp, which is assumed to be on ISEARCH.
#
# The directory structure below tp is assumed.
#
# If the target passed in is "all" ( or if no target is passed in, since all
# is the first target in this makefile ) then the occam2 libraries are built,
# and various associated text files are copied to .../build/libs/occ/tp.
# Also done is that the sources of some of the libraries are
# copied/preprocessed into a set of directories under
# .../libs/occ/tp/$(DESTINATION).  These are the sources that are to go out
# with the non-source release.  The directory DESTINATION and those below
# it are created from within this makefile.
#
# If the target is "test" then a short test is run to check that all that
# is in the built libraries is what is expected to be there.
#
# For more assumptions see SW-0116 ( Software build specification for the
# TCOFF toolset ), SW-0137 ( The Software product build system ), and
# SW-0200 ( Distribution Tree for occam Toolset ).
#
#
#                            8-Jan-91 SRHuggins
#
#                    This makefile is set up for UNIX.
#
###############################################################################


# DESTINATION is for the copying of the sources for the non-source release.
DESTINATION=rel


# the following macros are UNIX specific
PARENT=..
SWITCH=-
CHDIR=cd
COPY=cp
CONCATENATE=cat
INTO=>
DEL=rm $(SWITCH)f
MOVE=mv
RENAME=mv
ECHO=echo
MKDIR=mkdir


TIDYUP=$(DEL) *.??h ; \
	$(DEL) *.??x ; \
	$(DEL) *.t2 ; \
	$(DEL) *.ta ; \
	$(DEL) *.t8 ; \
	$(DEL) *.lib


# occam preprocessing tool
PREPROCESSOR=preocc
PREOPT=$(SWITCH)d OCCAM


#
# Assume that a file called 'all' does not exist in the directory
# that the make which is using this makefile is running in
#
all:
#
	@ ( $(ECHO) $(SWITCH)n "ISEARCH is " ; \
	    $(ECHO) $(ISEARCH) )
#
#
#                   The occam2 toolset libraries
#
# *************************************************************************
# **********  The order in which the libraries are made MATTERS  **********
# *************************************************************************
#
#
# occamutl, occam2.lib, occama.lib and occam8.lib
	( $(CHDIR) compiler ; \
	  $(MAKE) $(SWITCH)f occamutl ; \
	  $(MAKE) $(SWITCH)f occam2 ; \
	  $(MAKE) $(SWITCH)f occama ; \
	  $(MAKE) $(SWITCH)f occam8 ; \
	  $(MOVE) occamutl.lib $(PARENT) ; \
	  $(MOVE) occamutl.t? $(PARENT) ; \
	  $(MOVE) occam2.lib $(PARENT) ; \
	  $(MOVE) occama.lib $(PARENT) ; \
	  $(MOVE) occam8.lib $(PARENT) ; \
	  $(COPY) occam2.lnk $(PARENT) ; \
	  $(COPY) occama.lnk $(PARENT) ; \
	  $(COPY) occam8.lnk $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# virtual.lib, debug.lib, and then the occam configurer library
# occonfio.lib; this latter cannot be built before the former two.
	( $(CHDIR) vdebug ; \
	  $(MAKE) $(SWITCH)f vdebug ; \
	  $(MAKE) $(SWITCH)f occonfio ; \
	  $(MOVE) occonfio.lib $(PARENT) ; \
	  $(MOVE) virtual.lib $(PARENT) ; \
	  $(MOVE) debug.lib $(PARENT) ; \
	  $(MOVE) virtual.t? $(PARENT) ; \
	  $(MOVE) debug.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# convert.lib
	( $(CHDIR) convert ; \
	  $(MAKE) $(SWITCH)f convert ; \
	  $(MOVE) convert.lib $(PARENT) ; \
	  $(MOVE) convert.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# hostio.lib
	( $(CHDIR) hostio ; \
	  $(MAKE) $(SWITCH)f hostio ; \
	  $(MOVE) hostio.lib $(PARENT) ; \
	  $(COPY) hostio.inc $(PARENT) ; \
	  $(COPY) hostio.liu $(PARENT) ; \
	  $(MOVE) hostio.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# msdos.lib
	( $(CHDIR) msdos ; \
	  $(MAKE) $(SWITCH)f msdos ; \
	  $(MOVE) msdos.lib $(PARENT) ; \
	  $(COPY) msdos.inc $(PARENT) ; \
	  $(MOVE) msdos.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# string.lib
	( $(CHDIR) string ; \
	  $(MAKE) $(SWITCH)f string ; \
	  $(MOVE) string.lib $(PARENT) ; \
	  $(COPY) string.liu $(PARENT) ; \
	  $(MOVE) string.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# streamio.lib
	( $(CHDIR) streamio ; \
	  $(MAKE) $(SWITCH)f streamio ; \
	  $(MOVE) streamio.lib $(PARENT) ; \
	  $(COPY) streamio.inc $(PARENT) ; \
	  $(COPY) streamio.liu $(PARENT) ; \
	  $(MOVE) streamio.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# dblmath.lib, snglmath.lib, tbmaths.lib
	( $(CHDIR) maths ; \
	  $(MAKE) $(SWITCH)f dblmath ; \
	  $(MAKE) $(SWITCH)f snglmath ; \
	  $(MAKE) $(SWITCH)f tbmaths ; \
	  $(MOVE) dblmath.lib $(PARENT) ; \
	  $(MOVE) dblmath.t? $(PARENT) ; \
	  $(MOVE) snglmath.lib $(PARENT) ; \
	  $(MOVE) snglmath.t? $(PARENT) ; \
	  $(MOVE) tbmaths.lib $(PARENT) ; \
	  $(COPY) mathvals.inc $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# crc.lib
	( $(CHDIR) crc ; \
	  $(MAKE) $(SWITCH)f crc ; \
	  $(MOVE) crc.lib $(PARENT) ; \
	  $(MOVE) crc.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# xlink.lib
	( $(CHDIR) xlink ; \
	  $(MAKE) $(SWITCH)f xlink ; \
	  $(MOVE) xlink.lib $(PARENT) ; \
	  $(MOVE) xlink.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# streamco.lib ( for TDS support )
	( $(CHDIR) streamco ; \
	  $(MAKE) $(SWITCH)f streamco ; \
	  $(MOVE) streamco.lib $(PARENT) ; \
	  $(COPY) streamco.liu $(PARENT) ; \
	  $(MOVE) streamco.t? $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) )
#
#
# transputer hardware include files
	( $(CHDIR) include ; \
	  $(COPY) linkaddr.inc $(PARENT) ; \
	  $(COPY) ticks.inc $(PARENT) ; \
	  $(CHDIR) $(PARENT) )
#
#
#
###############################################################################
#
# The following copies/preprocesses the sources that will go out with
# the non-source release of the occam 2 toolset.
#
# This is in a make file even though the commands executed actually form
# what could be done by a shell script.
#
#
# The library sources which are copied ( some with preprocessing ) are:
#			convert.lib
#			hostio.lib
#			maths.lib
#			streamio.lib
#			string.lib
#			msdos.lib
#                       streamco.lib
# These library sources are given away with the toolset to demonstrate the
# sort of things that occam can do, and so that users can build their own
# versions of libraries.
#
#
# Those library sources which are NOT copied are:
#		compiler libraries    ( occam2.lib, occama.lib, occam8.lib
#					occamutl.lib and virtual.lib )
#		crc.lib,	      due to use of ASM
#		xlink.lib,	      due to use of ASM
#		debug.lib,	      due to use of ASM and low level stuff
#
###############################################################################
#
# Underneath DESTINATION will be made subdirectories for each of the
# relevant libraries.
#
#
# The files which are not copied/preprocessed are ones which are of no
# concern to the user - library/concatenation make files; special sources
# for idebug and the C concatenations; .liu files which will
# already be in the release with the library binaries; library build files.
#
#
# Clear out the destination directories of whatever was there previously
# and then reconstruct fresh directories:
#
	( $(DEL) $(SWITCH)rf $(DESTINATION) ; \
	  $(MKDIR) $(DESTINATION) ; \
	  $(MKDIR) $(DESTINATION)/convert ; \
	  $(MKDIR) $(DESTINATION)/hostio ; \
	  $(MKDIR) $(DESTINATION)/maths ; \
	  $(MKDIR) $(DESTINATION)/streamio ; \
	  $(MKDIR) $(DESTINATION)/string ; \
	  $(MKDIR) $(DESTINATION)/msdos ; \
	  $(MKDIR) $(DESTINATION)/streamco )
#
#
#
	( $(CHDIR) convert ; \
	  $(COPY) boltostr.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex16t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex16ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex32t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex32ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex64t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hex64ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) hextostr.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) i64strt2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) i64strta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) int16t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) int16ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) int32t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) int32ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) inttostr.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) r32strt2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) r32strta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) r64strt2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) r64strta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) stri64t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) stri64ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strr32t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strr32ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strr64t2.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strr64ta.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strtobol.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strtohex.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(COPY) strtoint.occ $(PARENT)/$(DESTINATION)/convert ; \
	  $(CHDIR) $(PARENT) )
#
#
# Note that only exit.occ needs preprocessor treatment.
	( $(CHDIR) hostio ; \
	  $(COPY) hostio.inc $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) ask.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) buffer.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) close.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) command.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) core.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) echoline.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) eof.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) exists.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(PREPROCESSOR) exit.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/hostio/exit.occ ; \
	  $(COPY) ferror.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) flush.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) fwstring.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) getenv.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) getkey.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) gets.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) mux.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) open.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) opentemp.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) ovbuffer.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) ovmux.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) ovprimux.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) packet.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) parse.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) pollkey.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) popen.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) primux.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) puts.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) readline.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) reaint.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rehint.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rehint32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rehint64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) reint.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) reint32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) reint64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) remove.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rename.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rereal32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) rereal64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) seek.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) soread.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) sowrite.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) spread.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) spwrite.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) system.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) tell.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) time.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) times.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) version.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) whint.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) whint32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) whint64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wint.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wint32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wint64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wreal32.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wreal64.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(COPY) wstring.occ $(PARENT)/$(DESTINATION)/hostio ; \
	  $(CHDIR) $(PARENT) )
#
#
#
	( $(CHDIR) maths ; \
	  $(PREPROCESSOR) fdiv.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/fdiv.occ ; \
	  $(PREPROCESSOR) incexp.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/incexp.occ ; \
	  $(PREPROCESSOR) fix.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/fix.occ ; \
	  $(PREPROCESSOR) reflot.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/reflot.occ ; \
	  $(PREPROCESSOR) normal64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/normal64.occ ; \
	  $(PREPROCESSOR) fmul64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/fmul64.occ ; \
	  $(PREPROCESSOR) fdiv64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/fdiv64.occ ; \
	  $(PREPROCESSOR) incexp64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/incexp64.occ ; \
	  $(PREPROCESSOR) fixshf64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/fixshf64.occ ; \
	  $(PREPROCESSOR) reflot64.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/reflot64.occ ; \
	  $(PREPROCESSOR) alogfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/alogfx.occ ; \
	  $(PREPROCESSOR) expfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/expfx.occ ; \
	  $(PREPROCESSOR) powfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/powfx.occ ; \
	  $(PREPROCESSOR) sinfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/sinfx.occ ; \
	  $(PREPROCESSOR) cosfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/cosfx.occ ; \
	  $(PREPROCESSOR) tanfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/tanfx.occ ; \
	  $(PREPROCESSOR) asinfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/asinfx.occ ; \
	  $(PREPROCESSOR) acosfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/acosfx.occ ; \
	  $(PREPROCESSOR) atanfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/atanfx.occ ; \
	  $(PREPROCESSOR) hyperfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/hyperfx.occ ; \
	  $(PREPROCESSOR) ranfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/ranfx.occ ; \
	  $(PREPROCESSOR) dalogfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dalogfx.occ ; \
	  $(PREPROCESSOR) dexpfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dexpfx.occ ; \
	  $(PREPROCESSOR) dpowfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dpowfx.occ ; \
	  $(PREPROCESSOR) dsinfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dsinfx.occ ; \
	  $(PREPROCESSOR) dcosfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dcosfx.occ ; \
	  $(PREPROCESSOR) dtanfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dtanfx.occ ; \
	  $(PREPROCESSOR) dasncsfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dasncsfx.occ ; \
	  $(PREPROCESSOR) datanfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/datanfx.occ ; \
	  $(PREPROCESSOR) dhyperfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dhyperfx.occ ; \
	  $(PREPROCESSOR) dranfx.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dranfx.occ ; \
	  $(PREPROCESSOR) alogfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/alogfl.occ ; \
	  $(PREPROCESSOR) expfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/expfl.occ ; \
	  $(PREPROCESSOR) powfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/powfl.occ ; \
	  $(PREPROCESSOR) sinfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/sinfl.occ ; \
	  $(PREPROCESSOR) cosfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/cosfl.occ ; \
	  $(PREPROCESSOR) tanfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/tanfl.occ ; \
	  $(PREPROCESSOR) asinfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/asinfl.occ ; \
	  $(PREPROCESSOR) acosfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/acosfl.occ ; \
	  $(PREPROCESSOR) atanfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/atanfl.occ ; \
	  $(PREPROCESSOR) hyperfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/hyperfl.occ ; \
	  $(PREPROCESSOR) ranfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/ranfl.occ ; \
	  $(PREPROCESSOR) dalogfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dalogfl.occ ; \
	  $(PREPROCESSOR) dexpfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dexpfl.occ ; \
	  $(PREPROCESSOR) dpowfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dpowfl.occ ; \
	  $(PREPROCESSOR) dsinfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dsinfl.occ ; \
	  $(PREPROCESSOR) dcosfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dcosfl.occ ; \
	  $(PREPROCESSOR) dtanfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dtanfl.occ ; \
	  $(PREPROCESSOR) dasinfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dasinfl.occ ; \
	  $(PREPROCESSOR) dacosfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dacosfl.occ ; \
	  $(PREPROCESSOR) datanfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/datanfl.occ ; \
	  $(PREPROCESSOR) dhyperfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dhyperfl.occ ; \
	  $(PREPROCESSOR) dranfl.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/dranfl.occ ; \
	  $(PREPROCESSOR) alogflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/alogflt2.occ ; \
	  $(PREPROCESSOR) expflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/expflt2.occ ; \
	  $(PREPROCESSOR) powflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/powflt2.occ ; \
	  $(PREPROCESSOR) sinflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/sinflt2.occ ; \
	  $(PREPROCESSOR) cosflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/cosflt2.occ ; \
	  $(PREPROCESSOR) tanflt2.occ $(PREOPT) $(SWITCH)o $(PARENT)/$(DESTINATION)/maths/tanflt2.occ ; \
	  $(COPY) mathhdr.inc $(PARENT)/$(DESTINATION)/maths ; \
	  $(COPY) t4fhdr.inc $(PARENT)/$(DESTINATION)/maths ; \
	  $(CHDIR) $(PARENT) )
#
#
#
	( $(CHDIR) streamio ; \
	  $(COPY) streamio.inc $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) keyscr.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) keysink.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) kfile.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) kkbd.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) kstdin.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrcont.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrcopy.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrfan.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrmux.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrsink.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) scrtfarr.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) sfile.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) srchar.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) srint.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) srint64.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) srreal32.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) srreal64.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) sstdout.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) swint.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) swint64.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) swreal32.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) swreal64.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) swsimple.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) toansi.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(COPY) totvi.occ $(PARENT)/$(DESTINATION)/streamio ; \
	  $(CHDIR) $(PARENT) )
#
#
#
	( $(CHDIR) string ; \
	  $(COPY) string0.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(COPY) string1.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(COPY) string2.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(COPY) string3.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(COPY) string4.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(COPY) string5.occ $(PARENT)/$(DESTINATION)/string ; \
	  $(CHDIR) $(PARENT) )
#
#
#
	( $(CHDIR) msdos ; \
	  $(COPY) msdos.inc $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos0.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos1.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos2.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos3.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos4.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(COPY) msdos5.occ $(PARENT)/$(DESTINATION)/msdos ; \
	  $(CHDIR) $(PARENT) )
#
#
#
	( $(CHDIR) streamco ; \
	  $(COPY) basicr.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) basicw.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) control.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) echo.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) echo64.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) ecreal.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) inter.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) readn.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(COPY) writen.occ $(PARENT)/$(DESTINATION)/streamco ; \
	  $(CHDIR) $(PARENT) )
#
#
#                **  end of commands for target 'all' **
#
#
###############################################################################
#
#                               tests
#
test:
#
# occexist.tst tests that the contents, in terms of entry points, error modes
# and transputer types, of the occam libraries are correct, and it checks
# that the correct .lnk, .inc and .liu files have been copied to where they
# should go
	( $(CHDIR) TESTS ; \
	  occexist.tst ; \
	  $(CHDIR) $(PARENT) )
#
#
#                           la fin
