###############################################################################
# Makefile for the build of those FORTRAN concatenations that come from
# occam source common to the occam toolset and the FORTRAN one.
#
#
# NOTE: Not all of the dependencies amongst the libraries and library sources
# are expressed in the makefiles that are called by this makefile, which
# means that they are not makefiles in the normal sense, and that if any
# one source file changes, anywhere, anyhow, then EVERYTHING should be
# rebuilt, for only then can one be sure of the resultant libraries.
#
# It is assumed that oc, ilibr and preocc are already built and on
# the PATH environment variable.
#
# It is assumed that this make file is invoked from the directory
# .../build/libs/occ/tp, which is assumed to be on ISEARCH.
#
# The directory structure below tp is assumed.
#
# If the target passed in is "all" ( or if no target is passed in, since all
# is the first target in this makefile ) then the FORTRAN concatenations are
# built, and are copied to .../build/libs/occ/tp.
#
# If the target is "test" then a short test is run to check that all that
# is in the concatenations is what is expected to be there.
#
# For more assumptions see SW-0116 ( Software build specification for the
# TCOFF toolset ), SW-0137 ( The Software product build system ),
# SW-0200 ( Distribution Tree for occam Toolset ), and SW-0217 ( Software
# build specification for the FORTRAN toolset ).
#
#
#                            12-Feb-91 SRHuggins
#
#                    This makefile is set up for UNIX.
#
###############################################################################
#
# The following seven names form the default names for the output files.
# These names can be over-ridden by defining the macros
# on the command line when invoking make using this makefile.
# One must beware of name clashing.
# OCCFORT, FIXED and FLOATING are #USEd by occam specifically for FORTRAN
OCCFORT=occfort.lib
FIXED=fixed.lib
FLOATING=floating.lib
CATOUT8=occfort8.cat
CATOUTA=occforta.cat
FIO8=fvhost8.cat
FIOA=fvhosta.cat


TEMPEXTENSION=ftn

FVDEBUGA=fvdebuga.$(TEMPEXTENSION)

FVDEBUG8=fvdebug8.$(TEMPEXTENSION)


FOCCAMAX=foccamax.$(TEMPEXTENSION)

FOCCAM8X=foccam8x.$(TEMPEXTENSION)


SMATHST8=smatht8.$(TEMPEXTENSION)

DMATHST8=dmatht8.$(TEMPEXTENSION)

SD_MATHS_TA_TB=sdmaths.$(TEMPEXTENSION)

SNGL_FLOATINGTA=sflta.$(TEMPEXTENSION)

DBL_FLOATINGTA=dflta.$(TEMPEXTENSION)

FIXEDT8=fixedt8.$(TEMPEXTENSION)


CONCATSA=$(FVDEBUGA) $(FOCCAMAX) $(SD_MATHS_TA_TB)

CONCATS8=$(FVDEBUG8) $(FOCCAM8X) $(SMATHST8) $(DMATHST8)


# the following macros are UNIX specific
PARENT=..
SWITCH=-
CHDIR=cd
COPY=cp
CONCATENATE=cat
INTO=>
DEL=rm $(SWITCH)f
MOVE=mv
RENAME=mv
ECHO=echo
MKDIR=mkdir

LIBRARIAN=ilibr
LIBOPT=

TIDYUP=$(DEL) *.$(TEMPEXTENSION) ; \
	$(DEL) *.??x ; \
	$(DEL) *.ta ; \
	$(DEL) *.t8 ; \
	$(DEL) *.lib

#
# Assume that a file called 'all' does not exist in the directory
# that the make which is using this makefile is running in
#
all:
#
	@( $(ECHO) $(SWITCH)n "PATH is " ; \
	   $(ECHO) $(PATH) )
#
	@( $(ECHO) $(SWITCH)n "ISEARCH is " ; \
	   $(ECHO) $(ISEARCH) )
#
#    The FORTRAN concatenations from occam source common with occam toolset.
#
#
	( \
# \
# the debug and virtual routines \
# \
	  $(CHDIR) vdebug ; \
	  $(MAKE) $(SWITCH)f fvdebug OUTNAMEA=$(FVDEBUGA) OUTNAME8=$(FVDEBUG8) ; \
	  $(MOVE) virtual.lib $(PARENT) ; \
	  $(MOVE) $(FVDEBUGA) $(PARENT) ; \
	  $(MOVE) $(FVDEBUG8) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# \
# occam compiler library routines \
# \
	  $(CHDIR) compiler ; \
	  $(MAKE) $(SWITCH)f driverfa OUTNAME=$(FOCCAMAX) ; \
	  $(MAKE) $(SWITCH)f occlibf8 OUTNAME=$(FOCCAM8X) ; \
	  $(MOVE) occama.lib $(PARENT) ; \
	  $(MOVE) occam8.lib $(PARENT) ; \
	  $(MOVE) $(FOCCAMAX) $(PARENT) ; \
	  $(MOVE) $(FOCCAM8X) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# \
# occam maths routines \
# \
	  $(CHDIR) maths ; \
	  $(MAKE) $(SWITCH)f smathffl OUTNAMEA=$(SNGL_FLOATINGTA) OUTNAME8=$(SMATHST8) ; \
	  $(MAKE) $(SWITCH)f dmathffl OUTNAMEA=$(DBL_FLOATINGTA) OUTNAME8=$(DMATHST8) ; \
	  $(MAKE) $(SWITCH)f mathffx OUTNAMEA=$(SD_MATHS_TA_TB) OUTNAME8=$(FIXEDT8) ; \
	  $(MOVE) $(SNGL_FLOATINGTA) $(PARENT) ; \
	  $(MOVE) $(DBL_FLOATINGTA) $(PARENT) ; \
	  $(MOVE) $(SMATHST8) $(PARENT) ; \
	  $(MOVE) $(DMATHST8) $(PARENT) ; \
	  $(MOVE) $(SD_MATHS_TA_TB) $(PARENT) ; \
	  $(MOVE) $(FIXEDT8) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# \
# now to concatenate the lot together by processor class \
# \
	  $(CONCATENATE) $(CONCATSA) $(INTO) $(CATOUTA) ; \
	  $(CONCATENATE) $(CONCATS8) $(INTO) $(CATOUT8) ; \
# \
# \
# \
# now for the small concatenations; this is where virtual.lib is required \
# \
	  $(CHDIR) hostio ; \
	  $(MAKE) $(SWITCH)f fio OUTNAMEA=$(FIOA) OUTNAME8=$(FIO8) ; \
	  $(MOVE) $(FIOA) $(PARENT) ; \
	  $(MOVE) $(FIO8) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# \
# now remove transitory concatenations and temporary libraries that were built \
# and construct the supplementary mathematics libraries \
# \
	  $(DEL) *.lib ; \
	  $(LIBRARIAN) $(SNGL_FLOATINGTA) $(DBL_FLOATINGTA) $(LIBOPT) $(SWITCH)o $(FLOATING) ; \
	  $(LIBRARIAN) $(FIXEDT8) $(LIBOPT) $(SWITCH)o $(FIXED) ; \
	  $(LIBRARIAN) $(CATOUTA) $(CATOUT8) $(LIBOPT) $(SWITCH)o $(OCCFORT) ; \
	  $(DEL) *.$(TEMPEXTENSION) ; \
	)
#
#
#                    End of the FORTRAN concatenations
#
#
#
###############################################################################
#
#                               tests
#
test:
#
# fexist.tst tests that the contents, in terms of entry points, error modes
# and transputer types, of the FORTRAN concatenations are correct
#
	( $(CHDIR) TESTS ; \
	  fexist.tst ; \
	  $(CHDIR) $(PARENT) )
#
#
#                           la fin
