###############################################################################
# Makefile for the build of all of the C concatenations ( the parts of the C
# toolset libraries that come from occam sources that are ( almost if not )
# common to both toolsets ).
#
#
# NOTE: Not all of the dependencies amongst the libraries and library sources
# are expressed in the makefiles that are called by this makefile, which
# means that they are not makefiles in the normal sense, and that if any
# one source file changes, anywhere, anyhow, then EVERYTHING should be
# rebuilt, for only then can one be sure of the resultant libraries.
#
# It is assumed that oc, ilibr and preocc are already built and on
# the PATH environment variable.
#
# It is assumed that this make file is invoked from the directory
# .../build/libs/occ/tp, which is assumed to be on ISEARCH.
#
# The directory structure below tp is assumed.
#
# If the target passed in is "all" ( or if no target is passed in, since all
# is the first target in this makefile ) then the C concatenations are built,
# and are copied to .../build/libs/occ/tp.
#
# If the target is "test" then a short test is run to check that all that
# is in the concatenations is what is expected to be there.
#
# For more assumptions see SW-0116 ( Software build specification for the
# TCOFF toolset ), SW-0137 ( The Software product build system ), and
# SW-0200 ( Distribution Tree for occam Toolset ).
#
#
#                           21-Nov-90 SRHuggins
#
#                    This makefile is set up for UNIX.
#
###############################################################################
#
# The following ten names form the default names for the C output files
# ( concatenations ).  These names can be over-ridden by defining the macros
# on the command line when invoking make using this makefile.
# One must beware of name clashing between what the C concatenations build
# produces and what the occam libraries build produces.
CATOUT2=occam2.cc2
CATOUTB=occamb.ccb
CATOUT8=occam8.cc8
CATOUTA=occama.cca
CVDEBUG2=virtual2.cc2
CVDEBUGA=virtuala.cca
CVDEBUG8=virtual8.cc8
CIO2=vhost2.cc2
CIOA=vhosta.cca
CIO8=vhost8.cc8


CVDEBUG2.CAT=cvdebug2.cat
CVDEBUGA.CAT=cvdebuga.cat
CVDEBUG8.CAT=cvdebug8.cat
CIO2.CAT=cio2.cat
CIOA.CAT=cioa.cat
CIO8.CAT=cio8.cat


CONCATS2= occam2x.cat smathc2x.cat dmathc2x.cat cxlink2.cat

CONCATSA= occamax.cat smathcax.cat dmathcax.cat cxlinka.cat

CONCATSB= occambx.cat ctbmaths.cat

CONCATS8= occam8x.cat smathc8x.cat dmathc8x.cat cxlink8.cat


# the following macros are UNIX specific
PARENT=..
SWITCH=-
CHDIR=cd
COPY=cp
CONCATENATE=cat
INTO=>
DEL=rm $(SWITCH)f
MOVE=mv
RENAME=mv
ECHO=echo
MKDIR=mkdir


TIDYUP=$(DEL) *.??h ; \
	$(DEL) *.??x ; \
	$(DEL) *.t2 ; \
	$(DEL) *.ta ; \
	$(DEL) *.t8 ; \
	$(DEL) *.lib

#
# Assume that a file called 'all' does not exist in the directory
# that the make which is using this makefile is running in
#
all:
#
	@ ( $(ECHO) $(SWITCH)n "ISEARCH is " ; \
	    $(ECHO) $(ISEARCH) )
#
#
#                      The C concatenations
#
# occam compiler library routines first of all
	( $(CHDIR) compiler ; \
	  $(MAKE) $(SWITCH)f occlibc2 OUTNAME=occam2x.cat ; \
	  $(MAKE) $(SWITCH)f driverca OUTNAMEA=occamax.cat OUTNAMEB=occambx.cat ; \
	  $(MAKE) $(SWITCH)f occlibc8 OUTNAME=occam8x.cat ; \
	  $(MOVE) occam2x.cat $(PARENT) ; \
	  $(MOVE) occamax.cat $(PARENT) ; \
	  $(MOVE) occambx.cat $(PARENT) ; \
	  $(MOVE) occam8x.cat $(PARENT) ; \
	  $(MOVE) occam2.lib $(PARENT) ; \
	  $(MOVE) occama.lib $(PARENT) ; \
	  $(MOVE) occam8.lib $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# now for the maths routines \
	  $(CHDIR) maths ; \
	  $(MAKE) $(SWITCH)f smathc OUTNAME2=smathc2x.cat OUTNAMEA=smathcax.cat OUTNAME8=smathc8x.cat ; \
	  $(MAKE) $(SWITCH)f dmathc OUTNAME2=dmathc2x.cat OUTNAMEA=dmathcax.cat OUTNAME8=dmathc8x.cat ; \
	  $(MAKE) $(SWITCH)f ctbmaths OUTNAME=ctbmaths.cat ; \
	  $(MOVE) smathc2x.cat $(PARENT) ; \
	  $(MOVE) smathcax.cat $(PARENT) ; \
	  $(MOVE) smathc8x.cat $(PARENT) ; \
	  $(MOVE) dmathc2x.cat $(PARENT) ; \
	  $(MOVE) dmathcax.cat $(PARENT) ; \
	  $(MOVE) dmathc8x.cat $(PARENT) ; \
	  $(MOVE) ctbmaths.cat $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# now for the debug and virtual routines \
	  $(CHDIR) vdebug ; \
	  $(MAKE) $(SWITCH)f cvdebug OUTNAME2=$(CVDEBUG2.CAT) OUTNAMEA=$(CVDEBUGA.CAT) OUTNAME8=$(CVDEBUG8.CAT) ; \
	  $(MOVE) virtual.lib $(PARENT) ; \
	  $(MOVE) $(CVDEBUG2.CAT) $(PARENT) ; \
	  $(MOVE) $(CVDEBUGA.CAT) $(PARENT) ; \
	  $(MOVE) $(CVDEBUG8.CAT) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# now for the xlink routines \
	  $(CHDIR) xlink ; \
	  $(MAKE) $(SWITCH)f cxlink OUTNAME2=cxlink2.cat OUTNAMEA=cxlinka.cat OUTNAME8=cxlink8.cat ; \
	  $(MOVE) cxlink2.cat $(PARENT) ; \
	  $(MOVE) cxlinka.cat $(PARENT) ; \
	  $(MOVE) cxlink8.cat $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# now to concatenate the lot together by processor class \
	  $(CONCATENATE) $(CONCATS2) $(INTO) $(CATOUT2) ; \
	  $(CONCATENATE) $(CONCATSA) $(INTO) $(CATOUTA) ; \
	  $(CONCATENATE) $(CONCATSB) $(INTO) $(CATOUTB) ; \
	  $(CONCATENATE) $(CONCATS8) $(INTO) $(CATOUT8) ; \
# now allow for renaming \
	  $(RENAME) $(CVDEBUG2.CAT) $(CVDEBUG2) ; \
	  $(RENAME) $(CVDEBUGA.CAT) $(CVDEBUGA) ; \
	  $(RENAME) $(CVDEBUG8.CAT) $(CVDEBUG8) ; \
# \
# now for the small concatenations \
# this is where virtual.lib is required \
# \
	  $(CHDIR) hostio ; \
	  $(MAKE) $(SWITCH)f cio OUTNAME2=$(CIO2.CAT) OUTNAMEA=$(CIOA.CAT) OUTNAME8=$(CIO8.CAT) ; \
	  $(MOVE) $(CIO2.CAT) $(PARENT) ; \
	  $(MOVE) $(CIOA.CAT) $(PARENT) ; \
	  $(MOVE) $(CIO8.CAT) $(PARENT) ; \
	  $(TIDYUP) ; \
	  $(CHDIR) $(PARENT) ; \
# now allow for renaming \
	  $(RENAME) $(CIO2.CAT) $(CIO2) ; \
	  $(RENAME) $(CIOA.CAT) $(CIOA) ; \
	  $(RENAME) $(CIO8.CAT) $(CIO8) ; \
# get rid of libraries that were ONLY relevant for the C catenations build \
# and also renamed .cat's \
	  $(DEL) *.lib ; \
	  $(DEL) *.cat ; \
	)
#
#                   End of the C concatenations
#
#
#
###############################################################################
#
#                               tests
#
test:
#
# cexist.tst tests that the contents, in terms of entry points, error modes
# and transputer types, of the C concatenations are correct
#
	( $(CHDIR) TESTS ; \
	  cexist.tst ; \
	  $(CHDIR) $(PARENT) )
#
#
#                           la fin
